<?php $this->load->view('layout/slider'); ?>

<!-- Our Feature Service-->
<section class="ulockd-divider bgc-whitef5">
    <div class="container">
        <div class="row">
            <div class="col-xxs-12 col-xs-6 col-sm-6 col-md-4">
                <div class="icon-box bgc-white icon-left">
                    <div class="icon"><span class="flaticon-delivery text-thm2"></span></div>
                    <div class="details">
                        <h3><?php echo $this->lang->line('24_7_support'); ?></h3>
                        <?php if ($this->session->userdata('site_lang') == 'bengali') { ?>
                            <p class="text-justify"><?php echo isset($this->sections->bn_support) && !empty($this->sections->bn_support) ? word_limiter($this->sections->bn_support, 100) : ''; ?></p>
                        <?php } else { ?>
                            <p class="text-justify"><?php echo isset($this->sections->support) && !empty($this->sections->support) ? word_limiter($this->sections->support, 100) : ''; ?></p>
                        <?php } ?>
                    </div>
                </div>
            </div>
            <div class="col-xxs-12 col-xs-6 col-sm-6 col-md-4">
                <div class="icon-box bgc-white icon-left">
                    <div class="icon"><span class="flaticon-medical-11 text-thm2"></span></div>
                    <div class="details">
                        <h3><?php echo $this->lang->line('expert_doctor'); ?></h3>
                        <?php if ($this->session->userdata('site_lang') == 'bengali') { ?>
                            <p class="text-justify"><?php echo isset($this->sections->bn_expert_doctor) && !empty($this->sections->bn_expert_doctor) ? word_limiter($this->sections->bn_expert_doctor, 100) : ''; ?></p>
                        <?php } else { ?>
                            <p class="text-justify"><?php echo isset($this->sections->expert_doctor) && !empty($this->sections->expert_doctor) ? word_limiter($this->sections->expert_doctor, 100) : ''; ?></p>
                        <?php } ?>
                    </div>
                </div>
            </div>
            <div class="col-xxs-12 col-xs-6 col-sm-6 col-md-4">
                <div class="icon-box bgc-white icon-left">
                    <div class="icon"><span class="flaticon-circle text-thm2"></span></div>
                    <div class="details">
                        <h3><?php echo $this->lang->line('online_payment'); ?></h3>
                        <?php if ($this->session->userdata('site_lang') == 'bengali') { ?>
                            <p class="text-justify"><?php echo isset($this->sections->bn_online_payment) && !empty($this->sections->bn_online_payment) ? word_limiter($this->sections->bn_online_payment, 100) : ''; ?></p>
                        <?php } else { ?>
                            <p class="text-justify"><?php echo isset($this->sections->online_payment) && !empty($this->sections->online_payment) ? word_limiter($this->sections->online_payment, 100) : ''; ?></p>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Our About -->
<section class="service-two">
    <div class="container">
        <div class="row">
            <div class="col-md-6">
                <div class="about-box">
                    <div class="ab-thumb">
                        <?php if ($this->global_setting->video_thumbnail) { ?>
                            <img style="height: 360px;" class="img-responsive img-whp" src="<?php echo UPLOAD_PATH; ?>logo/<?php echo $this->global_setting->video_thumbnail; ?>" alt="<?php echo $this->global_setting->brand_title; ?>" title="<?php echo $this->global_setting->brand_title; ?>">
                        <?php } else { ?>
                            <img style="height: 360px;" class="img-responsive img-whp" src="<?php echo IMG_URL; ?>video.jpg" alt="video">
                        <?php } ?>
                        <div class="diamond">
                            <a class="mfp-iframe mfp-youtube" href="<?php echo $this->global_setting->video_url; ?>" title="<?php echo $this->global_setting->brand_title; ?>"><span class="fa fa-play ulockd-bgthm"></span></a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="about-box">
                    <h2 class="title-bottom ulockd-mrgn120 ulockd-mrgn620"><?php echo $this->lang->line('about_us'); ?></h2>
                    <?php if ($this->session->userdata('site_lang') == 'bengali') { ?>
                        <p class="text-justify"><?php echo isset($this->sections->bn_about) && !empty($this->sections->bn_about) ? word_limiter($this->sections->bn_about, 100) : ''; ?></p>
                    <?php } else { ?>
                        <p class="text-justify"><?php echo isset($this->sections->about) && !empty($this->sections->about) ? word_limiter($this->sections->about, 100) : ''; ?></p>
                    <?php } ?>
                    <a href="<?php echo site_url('services'); ?>" class="btn btn-lg ulockd-btn-thm2 ulockd-mrgn1215"><?php echo $this->lang->line('our'); ?> <?php echo $this->lang->line('service'); ?></a>
                    <a href="<?php echo site_url('contact'); ?>" class="btn btn-lg ulockd-btn-blue ulockd-mrgn1215"><?php echo $this->lang->line('contact_us'); ?></a>
                </div>
            </div>
        </div>
    </div>
</section>

<?php if (isset($services) && !empty($services)) { ?>
    <!-- Our Service -->
    <section class="our-services bgc-whitef5">
        <div class="container">
            <div class="row">
                <div class="col-md-6 col-md-offset-3 text-center">
                    <div class="ulockd-main-title">
                        <h2 class="mt-separator text-uppercase"><?php echo $this->lang->line('our'); ?> <span class="text-thm2"><?php echo $this->lang->line('service'); ?></span></h2>
                        <?php if ($this->session->userdata('site_lang') == 'bengali') { ?>
                            <p class="text-justify"><?php echo isset($this->sections->bn_service) && !empty($this->sections->bn_service) ? $this->sections->bn_service : ''; ?></p>
                        <?php } else { ?>
                            <p class="text-justify"><?php echo isset($this->sections->service) && !empty($this->sections->service) ? $this->sections->service : ''; ?></p>
                        <?php } ?>
                    </div>
                </div>
            </div>
            <div class="row">
                <?php foreach ($services as $obj) { ?>
                    <div class="col-xxs-12 col-xs-6 col-sm-6 col-md-4">
                        <div class="icon-box style2 text-center" style="min-height: 330px;">
                            <div class="icon">
                                <span class="<?php echo $obj->icon ?? 'fa fa-server'; ?> text-thm2"></span>
                            </div>
                            <div class="details">
                                <?php if ($this->session->userdata('site_lang') == 'bengali') { ?>
                                    <h3><?php echo word_limiter($obj->bn_title, 5); ?></h3>
                                <?php } else { ?>
                                    <h3><?php echo word_limiter($obj->title, 5); ?></h3>
                                <?php } ?>
                                <?php if ($this->session->userdata('site_lang') == 'bengali') { ?>
                                    <p class="text-justify"><?php echo strip_tags(word_limiter($obj->bn_description, 15)); ?></p>
                                <?php } else { ?>
                                    <p class="text-justify"><?php echo strip_tags(word_limiter($obj->description, 15)); ?></p>
                                <?php } ?>
                                <a href="<?php echo site_url('service/' . $obj->id . '/' . get_slug($obj->title)); ?>" class="btn btn-default ulockd-btn-thm2"><?php echo $this->lang->line('read_more'); ?></a>
                            </div>
                        </div>
                    </div>
                <?php } ?>
            </div>
        </div>
    </section>
<?php } ?>

<!-- subscriber form -->
<section class="ulockd-divider ulockd-bgthm">
    <div class="container">
        <div class="row">
            <div class="col-sm-6 col-md-12 text-center">
                <form action="#" method="post">
                    <div class="subscriber-form subscribe">
                        <h1 class="color-white"><?php echo $this->lang->line('subscribe_message'); ?></h1>
                        <h4><?php echo $this->lang->line('subscribe_sub_message'); ?></h4>
                        <input type="email" id="email" name="email" value="<?php echo isset($_POST['email']) && !empty($_POST['email']) ? $_POST['email'] : ''; ?>" placeholder="<?php echo $this->lang->line('email'); ?>" required>
                        <button type="submit"><?php echo $this->lang->line('subscribe'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</section>

<?php if (isset($why_choose_us) && !empty($why_choose_us)) { ?>
    <!-- why_choose_us -->
    <section class="divider-half ulockd-pad650 bgc-snowshade">
        <div class="container">
            <div class="row">
                <div class="col-xs-12 col-sm-6 col-md-5">
                    <div class="row">
                        <div class="col-md-12">
                            <h2 class="ulockd-mrgn120"><?php echo $this->lang->line('why_choose_us'); ?></h2>
                            <?php if ($this->session->userdata('site_lang') == 'bengali') { ?>
                                <p class="lead"><?php echo isset($this->sections->bn_why_choose_us) && !empty($this->sections->bn_why_choose_us) ? $this->sections->bn_why_choose_us : ''; ?></p>
                            <?php } else { ?>
                                <p class="lead"><?php echo isset($this->sections->why_choose_us) && !empty($this->sections->why_choose_us) ? $this->sections->why_choose_us : ''; ?></p>
                            <?php } ?>
                        </div>
                        <?php foreach ($why_choose_us as $obj) { ?>
                            <div class="col-xxs-12 col-xs-6 col-sm-12">
                                <div class="icon_box text-left tac-smd">
                                    <div class="icon pull-left fn-smd">
                                        <span class="<?php echo $obj->icon ?? 'fa fa-info'; ?> text-thm2"></span>
                                    </div>
                                    <div class="ib_details">
                                        <h4><?php echo $this->session->userdata('site_lang') == 'bengali' ? $obj->bn_title : $obj->title; ?></h4>
                                        <p><?php echo $this->session->userdata('site_lang') == 'bengali' ? $obj->bn_description : $obj->description; ?></p>
                                    </div>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php } ?>

<?php if (isset($departments) && !empty($departments)) { ?>
    <!-- Our Department -->
    <section class="our-department">
        <div class="container">
            <div class="row">
                <div class="col-md-6 col-md-offset-3 text-center">
                    <div class="ulockd-main-title">
                        <h2 class="mt-separator text-uppercase"><?php echo $this->lang->line('our'); ?> <span class="text-thm2"><?php echo $this->lang->line('department'); ?></span></h2>
                        <?php if ($this->session->userdata('site_lang') == 'bengali') { ?>
                            <p class="text-justify"><?php echo isset($this->sections->bn_department) && !empty($this->sections->bn_department) ? $this->sections->bn_department : ''; ?></p>
                        <?php } else { ?>
                            <p class="text-justify"><?php echo isset($this->sections->department) && !empty($this->sections->department) ? $this->sections->department : ''; ?></p>
                        <?php } ?>
                    </div>
                </div>
            </div>
            <div class="row">
                <?php foreach ($departments as $obj) { ?>
                    <div class="col-xxs-12 col-xs-6 col-sm-6 col-md-4">
                        <a href="<?php echo site_url('department/doctor/' . $obj->id); ?>">
                            <figure class="department_box imghvr-shutter-out-vert">
                                <?php if ($obj->image) { ?>
                                    <img style="height: 230px; width:100%;" class="img-responsive" src="<?php echo UPLOAD_PATH; ?>department-image/<?php echo $obj->image; ?>" alt="<?php echo $this->session->userdata('site_lang') == 'bengali' ? $obj->bn_name : $obj->name; ?>" />
                                <?php } else { ?>
                                    <img style="height: 230px; width:100%;" class="img-responsive" src="<?php echo IMG_URL; ?>department.jpg" alt="department">
                                <?php } ?>
                                <figcaption>
                                    <?php if ($this->session->userdata('site_lang') == 'bengali') { ?>
                                        <h4 class="ulockd-mrgn120"><?php echo $obj->bn_name; ?></h4>
                                    <?php } else { ?>
                                        <h4 class="ulockd-mrgn120"><?php echo $obj->name; ?></h4>
                                    <?php } ?>
                                    <?php if ($this->session->userdata('site_lang') == 'bengali') { ?>
                                        <p class="text-justify"><?php echo strip_tags(word_limiter($obj->bn_description, 15)); ?></p>
                                    <?php } else { ?>
                                        <p class="text-justify"><?php echo strip_tags(word_limiter($obj->description, 15)); ?></p>
                                    <?php } ?>
                                </figcaption>
                            </figure>
                        </a>
                    </div>
                <?php } ?>
            </div>
        </div>
    </section>
<?php } ?>

<!-- Our Funfact -->
<section class="ulockd-divider ulockd-bgthm">
    <div class="container">
        <div class="row">
            <div class="col-xxs-12 col-xs-6 col-sm-6 col-md-3">
                <div class="ulockd-ffact-one text-center">
                    <span class="flaticon-group"></span>
                    <p class="color-white"><?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('doctor'); ?></p>
                    <div class="timer color-white">
                        <?php echo $this->web->count_all('employees', array('commission_type' => 'mbbs')); ?>
                    </div>
                </div>
            </div>
            <div class="col-xxs-12 col-xs-6 col-sm-6 col-md-3">
                <div class="ulockd-ffact-one text-center">
                    <span class="flaticon-doctor"></span>
                    <p class="color-white"><?php echo $this->lang->line('happy'); ?> <?php echo $this->lang->line('patient'); ?></p>
                    <div class="timer color-white">
                        <?php echo $this->web->count_all('patients', array('status' => '1')); ?>
                    </div>
                </div>
            </div>
            <div class="col-xxs-12 col-xs-6 col-sm-6 col-md-3">
                <div class="ulockd-ffact-one text-center">
                    <span class="flaticon-circle"></span>
                    <p class="color-white"><?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('service'); ?></p>
                    <div class="timer color-white">
                        <?php echo $this->web->count_all('diagnostic_tests', array('status' => '1')); ?>
                    </div>
                </div>
            </div>
            <div class="col-xxs-12 col-xs-6 col-sm-6 col-md-3">
                <div class="ulockd-ffact-one text-center">
                    <span class="flaticon-multiple-users-silhouette"></span>
                    <p class="color-white"><?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('employee'); ?></p>
                    <div class="timer color-white">
                        <?php echo $this->web->count_all('employees', array('commission_type' => 'emp')); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php if (isset($doctors) && !empty($doctors)) { ?>
    <!-- Our Doctor -->
    <section class="team bgc-snowshade">
        <div class="container">
            <div class="row">
                <div class="col-md-6 col-md-offset-3 text-center">
                    <div class="ulockd-main-title">
                        <h2 class="mt-separator text-uppercase"><?php echo $this->lang->line('our'); ?> <?php echo $this->lang->line('expert'); ?> <span class="text-thm2"><?php echo $this->lang->line('doctor'); ?></span></h2>
                        <?php if ($this->session->userdata('site_lang') == 'bengali') { ?>
                            <p class="text-justify"><?php echo isset($this->sections->bn_doctor) && !empty($this->sections->bn_doctor) ? $this->sections->bn_doctor : ''; ?></p>
                        <?php } else { ?>
                            <p class="text-justify"><?php echo isset($this->sections->doctor) && !empty($this->sections->doctor) ? $this->sections->doctor : ''; ?></p>
                        <?php } ?>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-8">
                    <div class="two-grid-slider">
                        <?php foreach ($doctors as $obj) { ?>
                            <div class="item">
                                <div class="team-grid text-left">
                                    <div class="thumb">
                                        <?php if ($obj->photo) { ?>
                                            <img style="height: 260px; width:100%;" class="img-responsive img-whp" src="<?php echo UPLOAD_PATH; ?>employee-photo/<?php echo $obj->photo; ?>" alt="<?php echo $this->session->userdata('site_lang') == 'bengali' ? $obj->bn_name : $obj->name; ?>" />
                                        <?php } elseif ($obj->gender == 'male') { ?>
                                            <img style="height: 260px; width:100%;" class="img-responsive img-whp" src="<?php echo IMG_URL; ?>doctor-male.png" alt="male">
                                        <?php } else { ?>
                                            <img style="height: 260px; width:100%;" class="img-responsive img-whp" src="<?php echo IMG_URL; ?>doctor-female.png" alt="female">
                                        <?php } ?>
                                    </div>
                                    <div class="details">
                                        <h4 class="text-thm2"><?php echo $this->session->userdata('site_lang') == 'bengali' ? $obj->bn_name : $obj->name; ?></h4>
                                        <h5><?php echo $obj->specialist; ?></h5>
                                        <p class="text-justify"><?php echo word_limiter($obj->about, 30); ?></p>
                                        <a class="btn btn-md ulockd-btn-thm2" href="<?php echo site_url('doctor/' . $obj->id); ?>"><?php echo $this->lang->line('read_more'); ?> <i class="fa fa-angle-double-right"></i> </a>
                                    </div>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="booking_form_style1 text-center">
                        <!-- Appointment Form Sart-->
                        <form class="appointment_form text-center" action="<?php echo site_url('appointment'); ?>" method="post">
                            <div class="row">
                                <div class="col-md-12">
                                    <h3 class="text-thm2"><?php echo $this->lang->line('appointment'); ?></h3>
                                </div>
                                <div class="col-sm-12">
                                    <div class="form-group text-left">
                                        <select class="form-control" id="department_id" name="department_id" onchange="get_doctor(this.value)">
                                            <option value="0" selected><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('department'); ?></option>
                                            <?php foreach ($app_departments as $obj) { ?>
                                                <option value="<?php echo $obj->id; ?>" <?php echo isset($department_id) && $department_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $this->session->userdata('site_lang') == 'bengali' ? $obj->bn_name : $obj->name; ?></option>
                                            <?php } ?>
                                        </select>
                                        <div class="help-block with-errors"><?php echo form_error('department_id'); ?></div>
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="form-group text-left">
                                        <select class="form-control select2" id="doctor_id" name="doctor_id" required>
                                            <option value="" selected><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('doctor'); ?></option>
                                            <?php foreach ($app_doctors as $obj) { ?>
                                                <option value="<?php echo $obj->user_id; ?>" <?php echo isset($doctor_id) && $doctor_id == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $this->session->userdata('site_lang') == 'bengali' ? $obj->bn_name : $obj->name; ?></option>
                                            <?php } ?>
                                        </select>
                                        <div class="help-block with-errors"><?php echo form_error('doctor_id'); ?></div>
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="form-group text-left">
                                        <input type="text" class="form-control" name="name" id="name" value="<?php echo isset($name) ?  $name : ''; ?>" placeholder="<?php echo $this->lang->line('name'); ?>" required autocomplete="off">
                                        <div class="help-block with-errors"><?php echo form_error('name'); ?></div>
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="form-group text-left">
                                        <input type="number" min="0" maxlength="11" class="form-control" name="phone" id="phone" value="<?php echo isset($phone) ?  $phone : ''; ?>" placeholder="<?php echo $this->lang->line('phone'); ?>" required autocomplete="off">
                                        <div class="help-block with-errors"><?php echo form_error('phone'); ?></div>
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group text-left">
                                        <select class="form-control" id="gender" name="gender" required>
                                            <option value="" selected><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('gender'); ?></option>
                                            <?php $genders = get_genders(); ?>
                                            <?php foreach ($genders as $key => $value) { ?>
                                                <option value="<?php echo $key; ?>" <?php echo isset($gender) && $gender == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                            <?php } ?>
                                        </select>
                                        <div class="help-block with-errors"><?php echo form_error('gender'); ?></div>
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group text-left">
                                        <input type="text" class="form-control" name="date" id="date" value="<?php echo isset($date) ?  $date : ''; ?>" placeholder="<?php echo $this->lang->line('date'); ?>" required autocomplete="off">
                                        <div class="help-block with-errors"><?php echo form_error('date'); ?></div>
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="form-group text-left">
                                        <input type="text" class="form-control" name="address" id="address" value="<?php echo isset($address) ?  $address : ''; ?>" placeholder="<?php echo $this->lang->line('address'); ?>" required autocomplete="off">
                                        <div class="help-block with-errors"><?php echo form_error('address'); ?></div>
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="form-group text-left">
                                        <textarea class="form-control required" rows="5" id="note" name="note" placeholder="<?php echo $this->lang->line('remark'); ?>"><?php echo isset($note) ?  $note : ''; ?></textarea>
                                        <div class="help-block with-errors"><?php echo form_error('note'); ?></div>
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="form-group text-center">
                                        <button type="submit" class="btn btn-lg ulockd-btn-thm2 btn-block"><?php echo $this->lang->line('submit'); ?></button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php } ?>

<?php if (isset($testimonials) && !empty($testimonials)) { ?>
    <!-- Our Testimonials -->
    <section class="parallax bgc-overlay-white85 ulockd_bgi1" data-stellar-background-ratio="0.3">
        <div class="container">
            <div class="row">
                <div class="col-md-6 col-md-offset-3 text-center">
                    <div class="ulockd-main-title">
                        <h2 class="mt-separator text-uppercase"><?php echo $this->lang->line('our'); ?> <span class="text-thm2"><?php echo $this->lang->line('testimonial'); ?></span></h2>
                        <?php if ($this->session->userdata('site_lang') == 'bengali') { ?>
                            <p class="text-justify"><?php echo isset($this->sections->bn_testimonial) && !empty($this->sections->bn_testimonial) ? $this->sections->bn_testimonial : ''; ?></p>
                        <?php } else { ?>
                            <p class="text-justify"><?php echo isset($this->sections->testimonial) && !empty($this->sections->testimonial) ? $this->sections->testimonial : ''; ?></p>
                        <?php } ?>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="three-grid-slider">
                        <?php foreach ($testimonials as $obj) { ?>
                            <div class="item">
                                <div class="ulockd-testimonials text-center ulockd-mrgn1250 ulockd-mrgn620">
                                    <div class="testi-thumb">
                                        <?php if ($obj->image) { ?>
                                            <img class="img-responsive thumbnail" src="<?php echo UPLOAD_PATH; ?>testimonial/<?php echo $obj->image; ?>" title="<?php echo $this->session->userdata('site_lang') == 'bengali' ? $obj->bn_name : $obj->name; ?>" alt="<?php echo $this->session->userdata('site_lang') == 'bengali' ? $obj->bn_name : $obj->name; ?>">
                                        <?php } else { ?>
                                            <img class="img-responsive thumbnail" src="<?php echo IMG_URL; ?>no-image.png" alt="no-image">
                                        <?php } ?>
                                        <ul class="list-inline ulockd-mrgn1220">
                                            <?php for ($i = 0; $i <= $obj->rating; $i++) { ?>
                                                <li><i class="text-thm2 fa fa-star fz13"></i></li>
                                            <?php } ?>
                                        </ul>
                                    </div>
                                    <div class="testi-details" style="min-height: 300px;">
                                        <p class="text-justify"><?php echo $this->session->userdata('site_lang') == 'bengali' ? word_limiter($obj->bn_message, 50) : word_limiter($obj->message, 50); ?></p>
                                        <h4><?php echo $this->session->userdata('site_lang') == 'bengali' ? $obj->bn_name : $obj->name; ?> <small class="text-thm2">-<?php echo $obj->designation; ?></small></h4>
                                    </div>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php } ?>

<?php if (isset($photos) && !empty($photos)) { ?>
    <!-- Our Gallery -->
    <section class="service-two">
        <div class="container">
            <div class="row">
                <div class="col-md-8 col-md-offset-2 col-lg-6 col-lg-offset-3 text-center">
                    <div class="ulockd-main-title">
                        <h2 class="mt-separator text-uppercase"><?php echo $this->lang->line('our'); ?> <?php echo $this->lang->line('photo'); ?> <span class="text-thm2"><?php echo $this->lang->line('gallery'); ?></span></h2>
                        <?php if ($this->session->userdata('site_lang') == 'bengali') { ?>
                            <p class="text-justify"><?php echo isset($this->sections->bn_photo) && !empty($this->sections->bn_photo) ? $this->sections->bn_photo : ''; ?></p>
                        <?php } else { ?>
                            <p class="text-justify"><?php echo isset($this->sections->photo) && !empty($this->sections->photo) ? $this->sections->photo : ''; ?></p>
                        <?php } ?>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="fancybox-gallery-slider">
                        <?php foreach ($photos as $obj) { ?>
                            <div class="item">
                                <div class="gs-thumb">
                                    <?php if ($obj->image) { ?>
                                        <img style="height: 250px;" class="img-responsive img-whp" src="<?php echo UPLOAD_PATH; ?>gallery-image/<?php echo $obj->image; ?>" alt="<?php echo $this->session->userdata('site_lang') == 'bengali' ? $obj->bn_title : $obj->title; ?>" />
                                    <?php } else { ?>
                                        <img style="height: 250px;" class="img-responsive img-whp" src="<?php echo IMG_URL; ?>gallery.jpg" alt="gallery">
                                    <?php } ?>
                                    <div class="gallery-overlay">
                                        <div class="lbox-caption">
                                            <div class="lbox-details">
                                                <?php if ($obj->image) { ?>
                                                    <a class="lightbox-image" data-fancybox-group="preject" href="<?php echo UPLOAD_PATH; ?>gallery-image/<?php echo $obj->image; ?>">
                                                        <span class="fa fa-plus-square"></span>
                                                    </a>
                                                <?php } else { ?>
                                                    <a class="lightbox-image" data-fancybox-group="preject" href="<?php echo IMG_URL; ?>gallery.jpg">
                                                        <span class="fa fa-plus-square"></span>
                                                    </a>
                                                <?php } ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php } ?>

<?php if (isset($news) && !empty($news)) { ?>
    <!-- Our News -->
    <section class="ulockd-blog">
        <div class="container">
            <div class="row">
                <div class="col-md-6 col-md-offset-3 text-center">
                    <div class="ulockd-main-title">
                        <h2 class="mt-separator text-uppercase"><?php echo $this->lang->line('latest'); ?> <span class="text-thm2"><?php echo $this->lang->line('news'); ?></span></h2>
                        <?php if ($this->session->userdata('site_lang') == 'bengali') { ?>
                            <p class="text-justify"><?php echo isset($this->sections->bn_news) && !empty($this->sections->bn_news) ? $this->sections->bn_news : ''; ?></p>
                        <?php } else { ?>
                            <p class="text-justify"><?php echo isset($this->sections->news) && !empty($this->sections->news) ? $this->sections->news : ''; ?></p>
                        <?php } ?>
                    </div>
                </div>
            </div>
            <div class="row">
                <?php foreach ($news as $obj) { ?>
                    <div class="col-xxs-12 col-xs-6 col-sm-6 col-md-4">
                        <article class="blog-post" style="min-height: 530px;">
                            <div class="post-thumb">
                                <?php $image =  pathinfo($obj->attachment, PATHINFO_EXTENSION); ?>
                                <?php if ($image == 'jpg' || $image == 'jpeg' || $image == 'png' || $image == 'gif' || $image == 'bmp') { ?>
                                    <img style="height: 200px; width:100%" class="img-responsive thumbnail" src="<?php echo UPLOAD_PATH; ?>news/<?php echo $obj->attachment; ?>" title="<?php echo $obj->title; ?>" alt="<?php echo $obj->title; ?>">
                                <?php } else { ?>
                                    <img style="height: 200px; width:100%" class="img-responsive thumbnail" src="<?php echo IMG_URL; ?>news.jpg" alt="news">
                                <?php } ?>
                            </div>
                            <div class="bp-details">
                                <ul class="list-inline">
                                    <li><a href="<?php echo site_url('news/' . $obj->id . '/' . get_slug($obj->title)); ?>">
                                            <span class="fa fa-calendar"></span>
                                            <?php echo date('d F', strtotime($obj->date)); ?>
                                        </a>
                                    </li>
                                    <li><a href="<?php echo site_url('news/' . $obj->id . '/' . get_slug($obj->title)); ?>"><?php echo date('Y', strtotime($obj->date)); ?></a></li>
                                </ul>
                                <h3 class="post-title"><?php echo word_limiter($obj->title, 6); ?></h3>
                                <p class="text-justify"><?php echo strip_tags(word_limiter($obj->description, 20)); ?></p>
                                <a href="<?php echo site_url('news/' . $obj->id . '/' . get_slug($obj->title)); ?>" class="btn btn-default ulockd-btn-thm2">Read More</a>
                            </div>
                        </article>
                    </div>
                <?php } ?>
            </div>
        </div>
    </section>
<?php } ?>


<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>

<script>
    $(".select2").select2();
    $("#date").daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        minYear: 1901,
        locale: {
            format: 'YYYY/MM/DD'
        }
    });
</script>
<script>
    function get_doctor(department_id) {
        $.ajax({
            type: "POST",
            url: "<?php echo site_url('appointment_doctor'); ?>",
            data: {
                department_id: department_id
            },
            success: function(response) {
                if (response) {
                    $('#doctor_id').html(response);
                }
            }
        });
    };
</script>