<?php

defined('BASEPATH') or exit('No direct script access allowed');

class My_Controller extends CI_Controller {

    public $global_setting = array();
    public $total_beds = array();
    public $total_today_patient = array();
    public $config_path = 'application/config/custom.php';
    const TITLE = '';
    function __construct() {
        parent::__construct();

        $this->load->model('Dashboard_Model', 'dashboard', true);
        if (!logged_in_user_id()) {
            redirect('welcome');
            exit;
        }
        $this->global_setting = $this->db->get_where('global_setting', array('status' => 1))->row();

        if ($this->global_setting) {
            date_default_timezone_set($this->global_setting->time_zone);
        }

        $this->config->load('custom');
        
        header("HTTP/1.0 200 OK");
        header("HTTP/1.1 200 OK");
        header("Expires: Tue, 01 Jan 2020 00:00:00 GMT");
        header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
        header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
        header("Cache-Control: post-check=0, pre-check=0", false);
        header("Pragma: no-cache");
        clearstatcache();
        
        // Custom 
        $this->total_admitted_beds = $this->dashboard->get_total_admitted_beds() ?? 0;
        $this->total_discharged_beds = $this->dashboard->get_total_discharged_beds() ?? 0;
        $this->total_today_patient = $this->dashboard->get_today_total_patient();
        $this->data['floors'] = $this->dashboard->get_list('floors', array('status' => 1), '', '', '', 'sort_by', 'ASC');
    }

    public function update_config() {

        $data = array();

        $this->db->select('P.*, M.module_slug, O.operation_slug');
        $this->db->from('privileges AS P');
        $this->db->join('operations AS O', 'O.id = P.operation_id', 'left');
        $this->db->join('modules AS M', 'M.id = O.module_id', 'left');
        $results = $this->db->get()->result();

        foreach ($results as $obj) {
            $data[] = $obj;
        }
        if (!is_array($data) && count($data) == 0) {
            return FALSE;
        }

        @chmod($this->config_path, FILE_WRITE_MODE);

        // Is the config file writable?
        if (!is_really_writable($this->config_path)) {
            show_error($this->config_path . ' does not appear to have the proper file permissions.  Please make the file writeable.');
        }
        // Read the config file as PHP
        require $this->config_path;

        // load the file helper
        $this->CI = &get_instance();
        $this->CI->load->helper('file');

        // Read the config data as a string
        $config_file = '<?php ';

        // Do we need to add totally new items to the config file?
        if (is_array($data)) {
            foreach ($data as $key => $val) {
                $config_file .= "\n";
                $config_file .= "\$config['my_$val->module_slug']['$val->operation_slug']['$val->role_id'] = '" . $val->is_add . "|" . $val->is_edit . "|" . $val->is_view . "|" . $val->is_delete . "';";
            }
        }

        if (!$fp = fopen($this->config_path, FOPEN_WRITE_CREATE_DESTRUCTIVE)) {
            return FALSE;
        }

        flock($fp, LOCK_EX);
        fwrite($fp, $config_file, strlen($config_file));
        flock($fp, LOCK_UN);
        fclose($fp);

        @chmod($this->config_path, FILE_READ_MODE);

        return TRUE;
    }
}
