<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('accounting'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('ipd'); ?> <?php echo $this->lang->line('payment'); ?>
        </h4>
        <div class="d-flex">
            <?php echo $this->load->view('payment/top-menu'); ?>
        </div>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <?php echo form_open_multipart(site_url('accounting/payment/ipd'), array('name' => 'search', 'id' => 'search', 'class' => 'needs-validation', 'novalidate' => 'novalidate', 'method' => 'get'), ''); ?>
                    <div class="form-row">
                        <div class="col-md-4 mb-10">
                            <label for="keyword"><?php echo $this->lang->line('keyword'); ?></label>
                            <input type="text" class="form-control" name="keyword" id="keyword" value="<?php echo isset($keyword) ?  $keyword : ''; ?>" placeholder="<?php echo $this->lang->line('keyword'); ?>">
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="range"><?php echo $this->lang->line('date'); ?></label>
                            <input type="text" class="form-control" name="date" id="range" value="<?php echo isset($date) ?  $date : ''; ?>" placeholder="<?php echo $this->lang->line('date'); ?>">
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="doctor_id"><?php echo $this->lang->line('doctor'); ?></label>
                            <select class="form-control custom-select select2" name="doctor_id" id="doctor_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('doctor'); ?></option>
                                <?php foreach ($doctors as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo isset($doctor_id) && $doctor_id == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="reference_id"><?php echo $this->lang->line('reference'); ?></label>
                            <select class="form-control custom-select select2" name="reference_id" id="reference_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('reference'); ?></option>
                                <?php foreach ($references as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo isset($reference_id) && $reference_id == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="created_by"><?php echo $this->lang->line('created_by'); ?></label>
                            <select class="form-control custom-select select2" name="created_by" id="created_by">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('employee'); ?></option>
                                <?php foreach ($employees as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo isset($created_by) && $created_by == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-4 mb-10">
                            <button class="btn btn-primary mt-30" type="submit"><?php echo $this->lang->line('search'); ?></button>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>
        <?php if (isset($ipds) && !empty($ipds)) { ?>
            <!-- Assistant Report List -->
            <!-- col-lg-12 -->
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <h4 class="hk-pg-title">
                            <i class="fa fa-user"></i>
                            <?php echo $this->lang->line('ipd'); ?> <?php echo $this->lang->line('payment'); ?>
                        </h4>
                    </div>
                    <div class="card-body">
                        <div class="table-wrap">
                            <div class="table-responsive">
                                <table class="table table-sm mb-0">
                                    <thead>
                                        <tr>
                                            <th><?php echo $this->lang->line('sl_no'); ?></th>
                                            <th><?php echo $this->lang->line('invoice_no'); ?></th>
                                            <th class="w-15"><?php echo $this->lang->line('date'); ?></th>
                                            <th><?php echo $this->lang->line('patient_id'); ?></th>
                                            <th><?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('name'); ?></th>
                                            <th><?php echo $this->lang->line('doctor'); ?></th>
                                            <th><?php echo $this->lang->line('reference'); ?></th>
                                            <th><?php echo $this->lang->line('commission'); ?></th>
                                            <th><?php echo $this->lang->line('due'); ?></th>
                                            <th><?php echo $this->lang->line('payment'); ?></th>
                                            <th><?php echo $this->lang->line('status'); ?></th>
                                            <th class="w-15"><?php echo $this->lang->line('action'); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php if (isset($ipds) && !empty($ipds)) { ?>
                                            <?php foreach ($ipds as $obj) { ?>
                                                <tr>
                                                    <td><?php echo $sl_count; ?></td>
                                                    <td><?php echo $obj->custom_invoice_id; ?></td>
                                                    <td>
                                                        <?php echo date('d M, Y h:i A', strtotime($obj->bill_date)); ?>
                                                    </td>
                                                    <td><?php echo $obj->patient_unique_id; ?></td>
                                                    <td><?php echo $obj->patient_name; ?></td>
                                                    <td><?php echo $obj->doctor ?? $this->lang->line('self'); ?></td>
                                                    <td><?php echo $obj->commission_name; ?></td>
                                                    <td>
                                                        <?php echo number_format($obj->payable_commission, 0); ?>/<?php echo number_format($obj->commission_amount, 0); ?>
                                                    </td>
                                                    <td><?php echo $obj->due_amount; ?></td>
                                                    <td><?php echo $obj->payable_amount; ?></td>
                                                    <td><?php echo $obj->paid_status == 'paid' ? '<span class="badge badge-success">' . $this->lang->line('paid') . '</span>' : '<span class="badge badge-danger">' . $this->lang->line('unpaid') . '</span>'; ?></td>
                                                    <td>
                                                        <?php if (has_permission(VIEW, 'accounting', 'payment')) { ?>
                                                            <a target="_blank" title="<?php echo $this->lang->line('view'); ?>" href="<?php echo site_url('ipd/invoice/' . $obj->ipd_id . '/' . $obj->id); ?>" class="btn btn-xs btn-success">
                                                                <i class="fa fa-info"></i>
                                                            </a>
                                                        <?php } ?>
                                                        <?php if ($obj->paid_status != 'paid') { ?>
                                                            <button onclick="GetInvoiceId(<?php echo $obj->id; ?>)" type="button" class="btn btn-teal btn-xs" data-toggle="modal" data-target="#addPaymentModal">
                                                                <i class="fa fa-money"></i>
                                                            </button>
                                                        <?php } else { ?>
                                                            <button title="<?php echo $this->lang->line('print'); ?>" type="button" onclick="printBill(<?php echo $obj->payemnt_id; ?>);" class="btn btn-info btn-xs">
                                                                <i class="fa fa-print"></i>
                                                            </button>
                                                            <button title="<?php echo $this->lang->line('view'); ?> <?php echo $this->lang->line('payment'); ?>" type="button" onclick="get_view_modal(<?php echo $obj->payemnt_id; ?>);" data-toggle="modal" data-target=".viewModalCenter" class="btn btn-primary btn-xs">
                                                                <i class="fa fa-eye"></i>
                                                            </button>
                                                        <?php }  ?>
                                                    </td>
                                                </tr>
                                                <?php $sl_count++; ?>
                                            <?php } ?>
                                        <?php } else { ?>
                                            <tr class="text-center">
                                                <td colspan="12"><?php echo $this->lang->line('no_data_found'); ?></td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <!-- Card Footer -->
                    <?php if ($this->pagination->create_links()) { ?>
                        <div class="card-footer justify-content-end">
                            <?php echo $this->pagination->create_links(); ?>
                        </div>
                    <?php } ?>
                </div>
            </div>
        <?php } ?>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<!-- View Modal -->

<div class="modal fade viewModalCenter" tabindex="-1" role="dialog" aria-labelledby="viewModalCenter" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header bg-gradient-primary">
                <h5 class="modal-title text-white"><?php echo $this->lang->line('payment'); ?> <?php echo $this->lang->line('info'); ?></h5>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body modal_data bg-gradient-secondary"></div>
        </div>
    </div>
</div>

<script type="text/javascript">
    function get_view_modal(id) {
        $('.modal_data').html('<p style="padding: 20px;"><p style="padding: 20px;text-align:center;"><img src="<?php echo IMG_URL; ?>loader.gif" /></p>');
        $.ajax({
            type: "POST",
            url: "<?php echo site_url('accounting/payment/get_single_ipd_payment_view'); ?>",
            data: {
                id: id
            },
            success: function(response) {
                if (response) {
                    $('.modal_data').html(response);
                }
            }
        });
    }
</script>

<!-- Add Payment Modal -->
<div class="modal fade" id="addPaymentModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalForms" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('payment'); ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <form id="addPaymentForm" method="POST">
                <div class="modal-body">
                    <div class="form-group">
                        <label for="date"><?php echo $this->lang->line('payment'); ?> <?php echo $this->lang->line('date'); ?></label>
                        <input type="text" class="form-control" name="date" id="date" value="<?php echo isset($date) ?  $date : ''; ?>" placeholder="<?php echo $this->lang->line('payment'); ?> <?php echo $this->lang->line('date'); ?>" required>
                        <div class="valid-feedback">
                            <?php echo $this->lang->line('looks_good'); ?>
                        </div>
                        <div class="invalid-feedback">
                            <?php echo $this->lang->line('required_field'); ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="commission_amount"><?php echo $this->lang->line('ipd'); ?> <?php echo $this->lang->line('charge'); ?></label>
                                <input type="number" readonly class="form-control" id="commission_amount" name="commission_amount" placeholder="<?php echo $this->lang->line('ipd'); ?> <?php echo $this->lang->line('charge'); ?>">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="payable_amount"><?php echo $this->lang->line('payment'); ?> <?php echo $this->lang->line('amount'); ?></label>
                                <input type="number" class="form-control" name="payable_amount" id="payable_amount" value="<?php echo isset($amount) ?  $amount : ''; ?>" placeholder="<?php echo $this->lang->line('payment'); ?> <?php echo $this->lang->line('amount'); ?>" required>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text"><?php echo $this->lang->line('remark'); ?></span>
                            </div>
                            <textarea class="form-control" name="note" id="note" aria-label="<?php echo $this->lang->line('remark'); ?>"><?php echo isset($note) ?  $note : ''; ?></textarea>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <input type="hidden" id="patient_id" name="patient_id">
                    <input type="hidden" id="invoice_id" name="invoice_id">
                    <input type="hidden" id="commission_user_id" name="commission_user_id">
                    <button type="button" class="btn btn-gradient-danger" data-dismiss="modal"><?php echo $this->lang->line('cancel'); ?></button>
                    <button type="submit" class="btn btn-gradient-primary"><?php echo $this->lang->line('submit'); ?></button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>

<script>
    $("#date").daterangepicker({
        singleDatePicker: true,
        startDate: new Date(),
        showDropdowns: true,
        minYear: 1901,
        timePicker: true,
        timePicker24Hour: true,
        timePickerIncrement: 1,
        timePickerSeconds: false,
        autoUpdateInput: true,
        locale: {
            format: 'YYYY-MM-DD HH:mm',
        }
    });
</script>

<script type="text/javascript">
    function GetInvoiceId(id) {
        $.ajax({
            url: '<?php echo site_url('accounting/payment/get_single_ipd/') ?>' + id,
            dataType: 'json',
            success: function(data) {
                $('#patient_id').val(data.patient_id);
                $('#invoice_id').val(data.id);
                $('#commission_user_id').val(data.commission_user_id);
                $('#commission_amount').val(data.commission_amount);
                $('#payable_amount').val(Math.floor(data.payable_commission));
            }
        });
    }
    $(document).ready(function(e) {
        $("#addPaymentForm").on('submit', (function(e) {
            e.preventDefault();
            $.ajax({
                url: '<?php echo base_url('accounting/payment/addIpdPayment'); ?>',
                type: "POST",
                data: new FormData(this),
                dataType: 'json',
                contentType: false,
                cache: false,
                processData: false,
                success: function(data) {
                    if (data.status == "failed") {
                        var message = "";
                        $.each(data.error, function(index, value) {
                            message += value;
                        });
                        $.toast({
                            text: message,
                            position: 'top-right',
                            loaderBg: '#7a5449',
                            class: 'jq-toast-danger',
                            hideAfter: 3500,
                            stack: 6,
                            showHideTransition: 'fade'
                        });

                    } else {
                        $.toast({
                            text: data.message,
                            position: 'top-right',
                            loaderBg: '#7a5449',
                            class: 'jq-toast-primary',
                            hideAfter: 3500,
                            stack: 6,
                            showHideTransition: 'fade'
                        });
                        $("#addPaymentModal").hide();
                    }
                },
                complete: function() {
                    location.reload(true);
                }
            });
        }));
    });
</script>

<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important;
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>
<script>
    $(".select2").select2();
    $('#range').daterangepicker({
        startDate: new Date(),
        endDate: moment(),
        showDropdowns: true,
        minYear: 1901,
        locale: {
            format: 'YYYY/MM/DD',
        },
        ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Tomorrow': [moment().subtract(-1, 'days'), moment().subtract(-1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'This Year': [moment().startOf('year'), moment().endOf('year')],
            'Last Year': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')]
        }
    });
</script>

<script>
    function printBill(id) {
        $.ajax({
            url: '<?php echo site_url('accounting/payment/ipd_print'); ?>',
            type: 'POST',
            data: {
                id: id,
            },
            success: function(result) {
                $("#testdata").html(result);
                popup(result);
            }
        });
    }

    function popup(data) {
        var frame1 = $('<iframe />');
        frame1[0].name = "frame1";
        frame1.css({
            "position": "absolute",
            "top": "-1000000px"
        });
        $("body").append(frame1);
        var frameDoc = frame1[0].contentWindow ? frame1[0].contentWindow : frame1[0].contentDocument.document ? frame1[0].contentDocument.document : frame1[0].contentDocument;
        frameDoc.document.open();
        //Create a new HTML document.
        frameDoc.document.write('<html>');
        frameDoc.document.write('<head>');
        frameDoc.document.write('<title>Print Invoice</title>');

        frameDoc.document.write('</head>');
        frameDoc.document.write('<body>');
        frameDoc.document.write(data);
        frameDoc.document.write('</body>');
        frameDoc.document.write('</html>');
        frameDoc.document.close();
        setTimeout(function() {
            window.frames["frame1"].focus();
            window.frames["frame1"].print();
            frame1.remove();
            //window.location.reload(true);
        }, 500);

        return true;

    }
</script>