<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Billing_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }

    function duplicate_check_commission_phone($phone, $id = null) {
        if ($id) {
            $this->db->where_not_in('user_id', $id);
        }
        $this->db->where('phone', $phone);
        return $this->db->get('employees')->num_rows();
    }

    function duplicate_check($name, $phone, $id = null) {
        if ($id) {
            $this->db->where_not_in('user_id', $id);
        }
        $this->db->where('name', $name);
        $this->db->where('phone', $phone);
        return $this->db->get('patients')->num_rows();
    }

    public function get_patient_list($limit, $offset, $search, $count) {
        $this->db->select('P.*');
        $this->db->from('patients AS P');
        if ($search) {
            $this->db->like('P.patient_unique_id', $search);
            $this->db->or_like('P.phone', $search);
            $this->db->or_like('P.name', $search);
            $this->db->or_like('P.address', $search);
        } else {
            $this->db->where('DATE(P.created_at)', date('Y-m-d'));
        }
        $this->db->order_by('P.created_at', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    public function get_bill_list($limit, $offset, $type, $form_date, $to_date, $search, $count) {
        $this->db->select('I.*, P.patient_unique_id, P.name as patient');
        $this->db->from('invoices AS I');
        $this->db->join('patients AS P', 'P.user_id = I.patient_id', 'left');
        if ($type == 1) {
            $this->db->where('I.paid_status', 'paid');
        }
        if ($type == 2) {
            $this->db->where('I.paid_status', 'unpaid');
        }
        if ($search) {
            $this->db->like('P.patient_unique_id', $search);
            $this->db->or_like('P.name', $search, 'both');
            $this->db->or_like('P.phone', $search);
        }
        if ($form_date && $to_date) {
            $this->db->where("DATE(I.bill_date) BETWEEN '$form_date' AND '$to_date'");
        }
        $this->db->order_by('I.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    public function get_due_bill_list($limit, $offset, $form_date, $to_date, $count) {
        $this->db->select('I.*, P.name as patient, P.user_id as patient_id, P.patient_unique_id');
        $this->db->from('invoices AS I');
        $this->db->join('patients AS P', 'P.user_id = I.patient_id', 'left');
        if ($form_date && $to_date) {
            $this->db->where("DATE(I.bill_date) BETWEEN '$form_date' AND '$to_date'");
        }
        $this->db->where('I.paid_status', 'unpaid');
        $this->db->where('I.payment_status', 'complete');
        $this->db->order_by('I.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    public function get_paid_bill_list($limit, $offset, $form_date, $to_date, $count) {
        $this->db->select('I.*, P.name as patient, P.user_id as patient_id, P.patient_unique_id');
        $this->db->from('invoices AS I');
        $this->db->join('patients AS P', 'P.user_id = I.patient_id', 'left');
        if ($form_date && $to_date) {
            $this->db->where("DATE(I.bill_date) BETWEEN '$form_date' AND '$to_date'");
        }
        $this->db->where('I.paid_status', 'paid');
        $this->db->where('I.payment_status', 'complete');
        $this->db->order_by('I.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    public function get_test_search($search) {
        $this->db->select('T.*');
        $this->db->from('diagnostic_tests AS T');
        if ($search) {
            $this->db->like('T.name', $search, 'both');
            $this->db->or_like('T.code', $search, 'both');
        }
        $this->db->order_by('T.name', 'ASC');
        $this->db->limit(10);
        return $this->db->get()->result();
    }

    public function get_doctor_search($search) {
        $this->db->select('E.id, E.user_id, E.name');
        $this->db->from('employees AS E');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        if ($search) {
            $this->db->group_start();
            $this->db->like('E.name', $search, 'both');
            $this->db->or_like('E.phone', $search, 'both');
            $this->db->or_like('E.id', $search, 'both');
            $this->db->or_like('E.user_id', $search, 'both');
            $this->db->group_end();
        }
        $this->db->where('E.status', '1');
        $this->db->where('U.role_id', DOCTOR);
        $this->db->order_by('E.name', 'ASC');
        $this->db->limit(20);
        return $this->db->get()->result();
    }

    public function get_commission_search($search) {
        $this->db->select('E.*');
        $this->db->from('employees AS E');
        if ($search) {
            $this->db->group_start();
            $this->db->like('E.id', $search);
            $this->db->or_like('E.name', $search, 'both');
            $this->db->group_end();
        }
        $this->db->where('E.status', 1);
        $this->db->order_by('E.id', 'ASC');
        $this->db->limit(20);
        return $this->db->get()->result();
    }

    public function get_employee_search($search) {
        $this->db->select('E.*');
        $this->db->from('employees AS E');
        if ($search) {
            $this->db->group_start();
            $this->db->like('E.id', $search);
            $this->db->or_like('E.name', $search, 'both');
            $this->db->group_end();
        }
        $this->db->where('E.commission_type', 'emp');
        $this->db->where('E.status', 1);
        $this->db->order_by('E.id', 'ASC');
        $this->db->limit(20);
        return $this->db->get()->result();
    }

    public function get_patient_invoice($invoice_id) {
        $this->db->select('I.*, E.name as refdr, E.specialist, R.name as commission, R.phone as commission_phone, CR.name as created_by, M.name as modified_by, D.name as designation, P.name as patient, P.gender, P.age, P.phone, P.address, P.patient_unique_id, P.dob');
        $this->db->from('invoices AS I');
        $this->db->join('patients AS P', 'P.user_id = I.patient_id', 'left');
        $this->db->join('employees AS E', 'E.user_id = I.ref_dr_id', 'left');
        $this->db->join('employees AS R', 'R.user_id = I.commission_user_id', 'left');
        $this->db->join('employees AS CR', 'CR.user_id = I.created_by', 'left');
        $this->db->join('employees AS M', 'M.user_id = I.modified_by', 'left');
        $this->db->join('designations AS D', 'D.id = E.designation_id', 'left');
        $this->db->where('I.id', $invoice_id);
        return $this->db->get()->row();
    }

    public function get_ipd_patient_info($invoice_id) {
        $this->db->select('IP.*');
        $this->db->from('ipd_patients AS IP');
        $this->db->join('invoices AS I', 'I.patient_id = IP.patient_id', 'left');
        $this->db->where('I.id', $invoice_id);
        $this->db->where('IP.bed_empty', 0);
        $this->db->order_by('IP.id', 'DESC');
        return $this->db->get()->row();
    }

    public function get_patient_invoice_test($invoice_id) {
        $this->db->select('ID.*, DT.id as test_id, DT.name as test_name, DT.specimen, DT.room_no, DD.name as department');
        $this->db->from('invoice_details AS ID');
        $this->db->join('diagnostic_tests AS DT', 'DT.id = ID.investagation_id', 'left');
        $this->db->join('diagnostic_departments AS DD', 'DD.id = DT.department_id', 'left');
        $this->db->where('ID.invoice_id', $invoice_id);
        $this->db->order_by('ID.id', 'ASC');
        return $this->db->get()->result();
    }

    public function get_invoice_tube_list($invoice_id) {
        $this->db->select('IT.*, T.name as tube, DD.name as department');
        $this->db->from('invoice_tube_details AS IT');
        $this->db->join('diagnostic_tubes AS T', 'T.id = IT.tube_id', 'left');
        $this->db->join('invoice_details AS ID', 'ID.invoice_id = IT.invoice_id', 'left');
        $this->db->join('diagnostic_tests AS DT', 'DT.id = ID.investagation_id', 'left');
        $this->db->join('diagnostic_departments AS DD', 'DD.id = DT.department_id', 'left');
        $this->db->where('IT.invoice_id', $invoice_id);
        $this->db->group_by('IT.tube_id');
        $this->db->order_by('IT.id', 'ASC');
        return $this->db->get()->result();
    }

    public function get_total_department($invoice_id) {
        $this->db->select('ID.*');
        $this->db->from('invoice_details AS ID');
        $this->db->join('diagnostic_tests AS DT', 'DT.id = ID.investagation_id', 'left');
        $this->db->where('ID.invoice_id', $invoice_id);
        $this->db->group_by('DT.department_id');
        return $this->db->get()->num_rows();
    }

    public function get_patient_payment_history($invoice_id) {
        $this->db->select('IP.*, E.name as created_by');
        $this->db->from('invoice_payments AS IP');
        $this->db->join('employees AS E', 'E.user_id = IP.created_by', 'left');
        $this->db->where('IP.invoice_id ', $invoice_id);
        $this->db->order_by('IP.id', 'DESC');
        return $this->db->get()->result();
    }

    public function get_room_list($invoice_id) {
        $this->db->select('ID.*, DT.id as test_id, DT.room_no, DT.specimen');
        $this->db->from('invoice_details AS ID');
        $this->db->join('diagnostic_tests AS DT', 'DT.id = ID.investagation_id', 'left');
        $this->db->where('ID.invoice_id ', $invoice_id);
        $this->db->group_by('DT.room_no, DT.specimen');
        $this->db->order_by('DT.specimen', 'ASC');
        $this->db->order_by('DT.room_no', 'ASC');
        return $this->db->get()->result();
    }

    public function get_opd_patient_by_ref_dr($patient_id) {
        $this->db->select('OP.*, D.name as doctor');
        $this->db->from('opd_patients AS OP');
        $this->db->join('employees AS D', 'D.user_id = OP.doctor_id', 'left');
        $this->db->where('OP.patient_id', $patient_id);
        $this->db->order_by('OP.id', 'DESC');
        return $this->db->get()->row();
    }

    public function get_ipd_patient_by_ref_dr($patient_id) {
        $this->db->select('IP.*, D.name as doctor');
        $this->db->from('ipd_patients AS IP');
        $this->db->join('employees AS D', 'D.user_id = IP.doctor_id', 'left');
        $this->db->where('IP.patient_id', $patient_id);
        $this->db->where('IP.bed_empty', 0);
        $this->db->order_by('IP.id', 'DESC');
        return $this->db->get()->row();
    }

    public function get_patient_by_reference($patient_id) {
        $this->db->select('OP.*, R.name as reference, R.id as reference_id');
        $this->db->from('opd_patients AS OP');
        $this->db->join('employees AS R', 'R.user_id = OP.reference_id', 'left');
        $this->db->where('OP.patient_id ', $patient_id);
        $this->db->order_by('OP.id ', 'DESC');
        return $this->db->get()->row();
    }

    public function get_employee_list() {
        $this->db->select('E.*');
        $this->db->from('employees AS E');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('E.status', '1');
        if ($this->session->userdata('role_id') == SUPER_ADMIN) {
            $this->db->where_in('U.role_id', array(SUPER_ADMIN, ADMIN, ACCOUNTANT, RECEPTIONIST));
        } else {
            $this->db->where_in('U.role_id', array(ADMIN, ACCOUNTANT, RECEPTIONIST));
        }
        $this->db->order_by('E.id ', 'DESC');
        return $this->db->get()->result();
    }

    public function get_authorized_person_list() {
        $this->db->select('E.*, D.name as designation');
        $this->db->from('employees AS E');
        $this->db->join('designations AS D', 'D.id = E.designation_id', 'left');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('E.status', '1');
        if ($this->session->userdata('role_id') == SUPER_ADMIN) {
            $this->db->where_in('U.role_id', array(SUPER_ADMIN, ADMIN, MANAGER));
        } else {
            $this->db->where_in('U.role_id', array(ADMIN, MANAGER));
        }
        $this->db->order_by('E.id ', 'DESC');
        return $this->db->get()->result();
    }

    public function get_reference_person_list() {
        $this->db->select('E.*, D.name as designation');
        $this->db->from('employees AS E');
        $this->db->join('designations AS D', 'D.id = E.designation_id', 'left');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('E.status', '1');
        $this->db->where('E.commission_type', 'emp');
        $this->db->order_by('E.id ', 'DESC');
        return $this->db->get()->result();
    }

    public function get_single_authorized_person($user_id) {
        $this->db->select('E.*, U.role_id');
        $this->db->from('employees AS E');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('E.user_id', $user_id);
        return $this->db->get()->row();
    }
    
    public function get_reference_emp($user_id)
    {
        $this->db->select('P.reference_emp, E.user_id, E.name, E.phone');
        $this->db->from('patients AS P');
        $this->db->join('employees AS E', 'E.user_id = P.reference_emp', 'left');
        $this->db->where('P.user_id', $user_id);
        return $this->db->get()->row();
    }
}
