<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('billing'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage_billing'); ?>
        </h4>
        <div class="d-flex">
            <a href="<?php echo site_url('billing'); ?>" class="btn btn-primary btn-sm mr-10"><?php echo $this->lang->line('create'); ?> <?php echo $this->lang->line('new'); ?></a>
            <a href="<?php echo site_url('billing/bill'); ?>" class="btn btn-info btn-sm mr-10"><?php echo $this->lang->line('bill'); ?> <?php echo $this->lang->line('list'); ?></a>
            <a href="<?php echo site_url('billing/due'); ?>" class="btn btn-danger btn-sm"><?php echo $this->lang->line('due'); ?> <?php echo $this->lang->line('billing'); ?></a>
        </div>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(VIEW, 'billing', 'billing')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-bold font-30 mr-10"></i>
                            <?php echo $this->lang->line('bill'); ?> <?php echo $this->lang->line('list'); ?>
                        </h6>
                    <?php } ?>
                    <?php echo form_open_multipart(site_url('billing/paid'), array('name' => 'search', 'id' => 'search', 'class' => 'needs-validation', 'novalidate' => 'novalidate', 'method' => 'get'), ''); ?>
                    <div class="form-group">
                        <div class="input-group input-group-sm">
                            <input type="text" class="form-control" name="search" id="reportrange" value="<?php echo isset($search) ?  $search : ''; ?>" placeholder="<?php echo $this->lang->line('search'); ?>" required>
                            <div class="input-group-append">
                                <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('search'); ?></button>
                            </div>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>

                <div class="card-body">
                    <div class="table-wrap">
                        <div class="table-responsive">
                            <table class="table table-sm mb-0">
                                <thead>
                                    <tr>
                                        <th><?php echo $this->lang->line('sl_no'); ?></th>
                                        <th><?php echo $this->lang->line('bill_no'); ?></th>
                                        <th><?php echo $this->lang->line('patient_id'); ?></th>
                                        <th><?php echo $this->lang->line('name'); ?></th>
                                        <th><?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('bill'); ?></th>
                                        <th><?php echo $this->lang->line('discount'); ?></th>
                                        <th><?php echo $this->lang->line('net_payable'); ?></th>
                                        <th><?php echo $this->lang->line('paid'); ?></th>
                                        <th><?php echo $this->lang->line('date'); ?></th>
                                        <th><?php echo $this->lang->line('action'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (isset($paids) && !empty($paids)) { ?>
                                        <?php foreach ($paids as $obj) { ?>
                                            <tr>
                                                <td><?php echo $sl_count; ?></td>
                                                <td><?php echo $obj->custom_invoice_id; ?></td>
                                                <td><?php echo $obj->patient_unique_id; ?></td>
                                                <td><?php echo $obj->patient; ?></td>
                                                <td><?php echo $obj->total_bill; ?></td>
                                                <td><?php echo $obj->discount; ?></td>
                                                <td><?php echo $obj->net_payable; ?></td>
                                                <td><?php echo $obj->advanced; ?></td>
                                                <td><?php echo date('d F, Y h:i A', strtotime($obj->bill_date)); ?></td>
                                                <td>
                                                    <?php if (has_permission(VIEW, 'billing', 'billing')) { ?>
                                                        <a href="<?php echo site_url('billing/invoice/' . $obj->id); ?>" class="btn btn-xs btn-primary"><i class="fa fa-eye"></i> <?php echo $this->lang->line('invoice'); ?></a>
                                                    <?php } ?>
                                                </td>
                                            </tr>
                                            <?php $sl_count++; ?>
                                        <?php } ?>
                                    <?php } else { ?>
                                        <tr class="text-center">
                                            <td colspan="10"><?php echo $this->lang->line('no_data_found'); ?></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <?php if ($this->pagination->create_links()) { ?>
                    <div class="card-footer justify-content-end">
                        <?php echo $this->pagination->create_links(); ?>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>
<script>
    var start = moment().subtract(29, 'days');
    var end = moment();

    $('#reportrange').daterangepicker({
        startDate: start,
        endDate: end,
        startDate: new Date(),
        showDropdowns: true,
        minYear: 1901,
        autoUpdateInput: true,
        locale: {
            format: 'YYYY/MM/DD',
        },
        autoApply: true,
        ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Tomorrow': [moment().subtract(-1, 'days'), moment().subtract(-1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
        }
    });
</script>