<!DOCTYPE html>
<html>

<head>
    <title>Print Invoice</title>

    <style>
        body {
            font-family: Arial, Helvetica, sans-serif;
            font-size: 14px;
        }

        .page {
            width: 65%;
            margin: 0 auto;
        }

        @page {
            size: A4;
            margin: 0;
        }

        @media print {

            html,
            body {
                font-family: Arial, Helvetica, sans-serif;
            }

            .page {
                width: 65%;
                margin: 0 auto;
                border: initial;
                border-radius: initial;
                min-height: initial;
                box-shadow: initial;
                background: initial;
                page-break-after: always;
            }
        }

        .patient_copy {
            page-break-after: always;
            display: block;
            margin-top: 30px;
        }

        .diagnostic_copy {
            display: block;
            margin-top: 10px;
            page-break-after: always;
        }
        .diagnostic_copy2 {
            display: block;
            margin-top: 30px;
        }

        .title {
            font-size: 14px;
            font-weight: bold;
            text-transform: uppercase;
            text-align: left
        }

        .paid {
            width: 25%;
            margin: 30px auto 0 auto;
            text-align: center;
            font-size: 25px;
            font-weight: bold;
            background: #eee;
            border: 1px solid #000;
            padding: 3px 10px;
            font-family: monospace;
            text-transform: uppercase;
            letter-spacing: 5px;
            border-radius: 3px;
        }

        .table {
            font-size: 14px;
            width: 100%;
            border-collapse: collapse;
        }

        .patient_table {
            width: 100%;
            text-align: left;
            border-collapse: collapse;
            margin-top: 15px;
        }

        .patient_table tbody td {
            color: #000;
            padding: 2px;
            vertical-align: top;
            border: 1px solid #eee;
        }

        /* test_table */
        .test_table {
            margin-top: 10px;
            width: 100%;
            text-align: left;
            border-collapse: collapse;
            border: 1px solid #eee;
        }

        .test_table tbody td {
            color: #000;
            padding: 0px 4px;
            vertical-align: top;
            border-top: 1px solid #eee;
            font-size:13px;
        }

        /*  payment_info*/
        .payment_table {
            font-size: 14px;
            width: 100%;
            text-align: left;
        }

        .payment_table tbody td {
            vertical-align: top;
            border: 0;
        }
        center{
            margin-bottom:15px;
        }
    </style>
</head>

<body>
    <div class="page">
        <div class="diagnostic_copy">
            <table class="table">
                <tr>
                    <td rowspan="3" width="20%">
                        <?php if($this->global_setting->brand_logo){ ?>
                            <img width="80" valign="middle" align="center" src="<?php echo UPLOAD_PATH; ?>logo/<?php echo $this->global_setting->brand_logo; ?>">
                        <?php } else { ?>
                            <img width="80" valign="middle" align="center" src="<?php echo IMG_URL; ?>logo.png">
                        <?php } ?>
                    </td>
                    <td width="80%" align="center"><h1 style="margin: 0px; padding:0; font-size: 36px;"><?php echo $this->global_setting->brand_title; ?></h1></td>
                </tr>
                <tr>
                    <td align="center"><p style="margin: 0px; padding: 0; font-size: 14px;"><?php echo $this->global_setting->address; ?></p></td>
                </tr>
                <tr>
                     <td align="center"><p style="margin: 0; font-size: 14px;">Phone: <?php echo $this->global_setting->phone; ?></p></td>
                </tr>
            </table>
            <table class="table" style="margin-top:30px; margin-bottom:10px">
                <tr>
                    <td width="25%" align="left">Office Copy</td>
                    <td width="25%" align="center">MONEY RECIPT</td>
                    <td width="50%" align="right">Print Time :</b> <?php echo date('d M, Y h:ia'); ?></td>
                </tr>
            </table> 
            <!-- Patient Info Start-->
            <table class="table patient_table">
                <tr>
                    <td style="width: 34%;">
                        <span>Patient ID :</span>
                        <span style="text-transform: uppercase; font-weight: bold;"><?php echo $patient->patient_unique_id; ?></span>
                    </td>
                    <td style="width: 26%;">
                        <span>Reg No:</span>
                        <?php echo isset($ipd_patient) && !empty($ipd_patient->registration_no) ? $ipd_patient->registration_no : ''; ?>
                    </td>
                    <td style="width: 40%;">
                        <span>Bill No :</span>
                        <span><?php echo $patient->custom_invoice_id; ?></span>
                    </td>
                </tr>
                <tr>
                    <td colspan="2">
                        <span>Name :</span>
                        <span style="text-transform: uppercase; font-weight: bold;"><?php echo $patient->patient; ?></span>
                    </td>
                    <td>
                        <span>Date :</span>
                        <span><?php echo date('d/m/Y h:i A', strtotime($patient->bill_date)); ?></span>
                    </td>
                </tr>
                <tr>
                    <td>
                        <span>Age :</span>
                        <span style="text-transform: uppercase; font-weight: bold;"><?php echo get_age($patient->dob); ?></span>
                    </td>
                    <td>
                        <span>Gender :</span>
                        <span style="text-transform: capitalize; font-weight: bold;"><?php echo $this->lang->line($patient->gender); ?></span>
                    </td>
                    <td>
                        <span>Contact No :</span>
                        <span style="text-transform: uppercase; font-weight: bold;"><?php echo $patient->phone; ?></span>
                    </td>
                </tr>
                <tr>
                    <td colspan="3">
                        <span>Doctor Name :</span>
                        <span style="font-size:12px; text-transform: uppercase; font-weight: bold;">
                            <?php
                            if ($patient->self == 1) {
                                echo 'Self';
                            } elseif ($patient->ref_dr_id == NULL) {
                                echo $patient->ref_dr_name;
                            } else {
                                echo $patient->refdr . ', ' . $patient->specialist;
                            }
                            ?>
                        </span>
                    </td>
                </tr>
                <tr>
                    <td colspan="3">
                        <span>Reference Name :</span>
                        <span style="font-size:12px; text-transform: uppercase;">
                            <?php
                            if ($invoice->commission_user_id) {
                                echo $patient->commission;
                            }
                            ?>
                        </span>
                    </td>
                </tr>
            </table>
            <!-- Patient Info End-->

            <?php if (isset($tests) & !empty($tests)) { ?>
                <table class="test_table">
                    <tbody>
                        <tr>
                            <td width="15%" align="left"><b>SL. No</b></td>
                            <td width="55%" align="left"><b>Test Name</b></td>
                            <td width="30%" align="right"><b>Price (Tk.)</b></td>
                        </tr>
                        <?php $count = 1; ?>
                        <?php foreach ($tests as $obj) { ?>
                            <tr>
                                <td width="15%" align="left"><?php echo $count++; ?></td>
                                <td width="55%" align="left"><?php echo $obj->test_name; ?></td>
                                <td width="30%" align="right"><?php echo $obj->total_rate; ?></td>
                            </tr>
                        <?php } ?>
                        
                        <?php foreach ($tubes as $obj) { ?>
                            <tr>
                                <td width="15%" align="left"><?php echo $count++; ?></td>
                                <td width="55%" align="left"><?php echo $obj->tube; ?></td>
                                <td width="30%" align="right"><?php echo $obj->total_rate; ?></td>
                            </tr>
                        <?php } ?>

                        <tr>
                            <td colspan="3">
                                <table class="table">
                                    <tr>
                                        <td width="58%" style="border: 0;">
                                            <div class="paid" style="margin-bottom: 0; padding-bottom: 0;">
                                                <?php if ($patient->paid_status == 'paid') {
                                                    echo 'Paid';
                                                } else {
                                                    echo 'Due';
                                                } ?>
                                            </div>
                                            <p style="text-align: center; margin-bottom: 20px;"><b>In Word:</b> <span style="font-size: 12px;"><?php echo $this->numbertowords->convert_number($invoice->advanced); ?> Taka Only.</span></p>
                                        </td>
                                        <td width="42%" style="border: 0;">
                                            <table class="table">
                                                <tr>
                                                    <td style="border: 0;text-align: left;">Total</td>
                                                    <td style="border: 0;text-align: right;"><?php echo $invoice->total_bill; ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="border-top: 1px dashed #ccc;text-align: left;">Discount</td>
                                                    <td style="border-top: 1px dashed #ccc;text-align: right;"><?php echo number_format($invoice->discount, 2); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="border-top: 1px dashed #ccc;text-align: left;">Payable</td>
                                                    <td style="border-top: 1px dashed #ccc;text-align: right;"><?php echo $invoice->net_payable; ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="border-top: 1px dashed #ccc;text-align: left;">Paid</td>
                                                    <td style="border-top: 1px dashed #ccc;text-align: right;"><?php echo $invoice->advanced; ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="border-top: 1px dashed #ccc;text-align: left;">Due</td>
                                                    <td style="border-top: 1px dashed #ccc;text-align: right;"><?php echo $invoice->due_amount; ?></td>
                                                </tr>
                                            </table>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                    </tbody>
                </table>
            <?php } ?>
            <?php if ($invoice->note != NULL) { ?>
                <p style="margin-top:10px;">
                    <b>Remark: </b>
                    <?php echo $invoice->note; ?>
                </p>
            <?php } ?>
            <p style="margin-top:10px; font-size: 13px; font-weight: bold;">
                <span>ROOM:</span>
                <span style="font-size: 12px; text-transform: uppercase;">
                    <?php $str = ""; foreach ($rooms as $room) {
                        if($room->specimen == 'blood'){
                             $str .= 'Blood Collection' . ' : ' . $room->room_no . ', ';
                        }else{
                             $str .= $room->specimen . ' : ' . $room->room_no . ', ';
                        }
                    } echo rtrim($str, ', '); ?>
                </span>
            </p>
            <p style="margin-top:10px;">
                <span style="font-size: 14px; font-weight: bold;">Delivery Time:</span>
            </p>
            <p style="margin-top:10px;">
                <span style="font-size: 14px; font-weight: bold;">Prepared By:</span>
                <?php echo $patient->created_by; ?>
            </p>
        </div>
    </div>
</body>

</html>