<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Laboratorist_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }

    public function get_laboratorist_list($limit, $offset, $search, $count) {
        $this->db->select('DL.*, D.name as department');
        $this->db->from('diagnostic_laboratorists AS DL');
        $this->db->join('diagnostic_departments AS D', 'D.id = DL.department_id', 'left');
        if ($search) {
            $this->db->like('DL.name', $search, 'both');
            $this->db->or_like('D.name', $search, 'both');
        }
        $this->db->group_by('DL.department_id');
        $this->db->order_by('DL.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }
}
