<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Ultrasonography_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }

    public function get_doctor_list() {
        $this->db->select('D.*');
        $this->db->from('employees AS D');
        $this->db->join('users AS U', 'U.id = D.user_id', 'left');
        $this->db->where('U.role_id', DOCTOR);
        $this->db->where('D.status', 1);
        $this->db->order_by('D.id', 'ASC');
        return $this->db->get()->result();
    }

    public function get_ultrasonography_list($limit, $offset, $search, $count) {
        $this->db->select('UT.*, E.name as doctor, D.name as department, G.name as group, T.name as test_name');
        $this->db->from('ultrasonography_templates AS UT');
        $this->db->join('employees AS E', 'E.user_id = UT.doctor_id', 'left');
        $this->db->join('diagnostic_departments AS D', 'D.id = UT.department_id', 'left');
        $this->db->join('diagnostic_groups AS G', 'G.id = UT.group_id', 'left');
        $this->db->join('diagnostic_tests AS T', 'T.id = UT.test_id', 'left');
        if ($search) {
            $this->db->like('UT.name', $search, 'both');
            $this->db->or_like('E.name', $search, 'both');
            $this->db->or_like('D.name', $search, 'both');
            $this->db->or_like('G.name', $search, 'both');
            $this->db->or_like('T.name', $search, 'both');
        }
        $this->db->order_by('UT.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    public function get_single_ultrasonography($id) {
        $this->db->select('UT.*, E.name as doctor, D.name as department, G.name as group, T.name as test_name');
        $this->db->from('ultrasonography_templates AS UT');
        $this->db->join('employees AS E', 'E.user_id = UT.doctor_id', 'left');
        $this->db->join('diagnostic_departments AS D', 'D.id = UT.department_id', 'left');
        $this->db->join('diagnostic_groups AS G', 'G.id = UT.group_id', 'left');
        $this->db->join('diagnostic_tests AS T', 'T.id = UT.test_id', 'left');
        $this->db->where('UT.id', $id);
        return $this->db->get()->row();
    }
}
