<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('ultrasonography'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage_ultrasonography'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <?php $this->load->view('diagnostic/left-side'); ?>
        <!-- col-xl-8 -->
        <div class="col-lg-9">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(EDIT, 'diagnostic', 'ultrasonography')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-flask font-30 mr-10"></i>
                            <?php echo $this->lang->line('edit'); ?> <?php echo $this->lang->line('ultrasonography'); ?>
                        </h6>
                    <?php } ?>
                    <?php if (has_permission(VIEW, 'diagnostic', 'ultrasonography')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('diagnostic/ultrasonography'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-list font-12 mr-5"></i>
                                <?php echo $this->lang->line('ultrasonography'); ?> <?php echo $this->lang->line('list'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>

                <?php echo form_open_multipart(site_url('diagnostic/ultrasonography/edit/' . $ultrasonography->id), array('name' => 'edit', 'id' => 'edit', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                <div class="card-body">
                    <div class="form-row">
                        <div class="col-md-4 mb-10">
                            <label for="department_id"><?php echo $this->lang->line('department'); ?> <?php echo $this->lang->line('name'); ?></label>
                            <select class="form-control custom-select" name="department_id" id="department_id" required onchange="get_test(this.value)">
                                <option value="" selected><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($departments as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($ultrasonography->department_id) && $ultrasonography->department_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="group_id"><?php echo $this->lang->line('group'); ?> <?php echo $this->lang->line('name'); ?></label>
                            <select class="form-control custom-select" name="group_id" id="group_id">
                                <option value="" selected><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($groups as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($ultrasonography->group_id) && $ultrasonography->group_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="test_id"><?php echo $this->lang->line('test'); ?> <?php echo $this->lang->line('name'); ?></label>
                            <select class="form-control custom-select select2" name="test_id" id="test_id" required>
                                <option value="" selected><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($tests as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($ultrasonography->test_id) && $ultrasonography->test_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="doctor_id"><?php echo $this->lang->line('doctor'); ?> <?php echo $this->lang->line('name'); ?></label>
                            <select class="form-control custom-select" name="doctor_id" id="doctor_id" required>
                                <option value="" selected><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($doctors as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo isset($ultrasonography->doctor_id) && $ultrasonography->doctor_id == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="doctor_id" class="form-text text-muted">
                                <?php echo form_error('doctor_id'); ?>
                            </small>
                        </div>
                        <div class="col-md-6 mb-10">
                            <label for="name"><?php echo $this->lang->line('name'); ?></label>
                            <input type="text" class="form-control" name="name" id="name" value="<?php echo isset($ultrasonography->name) ?  $ultrasonography->name : ''; ?>" placeholder="<?php echo $this->lang->line('name'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="name" class="form-text text-muted">
                                <?php echo form_error('name'); ?>
                            </small>
                        </div>
                        <div class="col-md-2 mt-40">
                            <div class="custom-control custom-checkbox checkbox-cyan">
                                <input type="checkbox" class="custom-control-input" name="status" id="status" value="1" checked>
                                <label class="custom-control-label" for="status"><?php echo $this->lang->line('status'); ?></label>
                            </div>
                        </div>
                        <div class="col-md-12 mt-10 mb-10">
                            <label for="template"><?php echo $this->lang->line('template'); ?></label>
                            <div class="tinymce-wrap">
                                <textarea class="tinymce" name="template" id="template" placeholder="<?php echo $this->lang->line('template'); ?>"><?php echo isset($ultrasonography->template) ?  $ultrasonography->template : ''; ?></textarea>
                            </div>
                        </div>

                    </div>
                </div>
                <!-- Card Footer -->
                <div class="card-footer pt-0">
                    <div class="button-list">
                        <input type="hidden" name="id" value="<?php echo $ultrasonography->id; ?>">
                        <a class="btn btn-gradient-danger" href="<?php echo site_url('diagnostic/ultrasonography'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                        <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('update'); ?></button>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<!-- Tinymce JavaScript -->
<script src="<?php echo VENDOR_URL; ?>tinymce/tinymce.min.js"></script>
<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important;
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>

<script>
    $(".select2").select2();
    $(function() {
        "use strict";
        tinymce.init({
            selector: '.tinymce',
            height: 300,
            plugins: [
                'advlist autolink lists link image charmap print preview anchor',
                'searchreplace visualblocks code fullscreen',
                'insertdatetime media table contextmenu paste code'
            ],
            toolbar: 'insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image',

        });
    });
</script>

<script>
    function get_test(department_id) {
        $.ajax({
            type: "POST",
            url: "<?php echo site_url('ajax/get_department_by_diagnostic_test'); ?>",
            data: {
                department_id: department_id
            },
            async: false,
            success: function(response) {
                if (response) {
                    $('#test_id').html(response);
                }
            }
        });
    };
</script>

<script>
    $('#department_id').on("change", function(){
        $.ajax({
            type: "POST",
            url: "<?php echo site_url('ajax/get_department_by_diagnostic_group'); ?>",
            data: {
                department_id:  $('#department_id').val()
            },
            async: false,
            success: function(response) {
                if (response) {
                    $('#group_id').html(response);
                }
            }
        });
    });
</script>