<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Assistant_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }

    public function get_assistant_list($limit, $offset, $search, $count) {
        $this->db->select('A.*, D.name AS department, DE.name AS designation, R.name as role, U.role_id');
        $this->db->from('assistants AS A');
        $this->db->join('departments AS D', 'D.id = A.department_id', 'left');
        $this->db->join('designations AS DE', 'DE.id = A.designation_id', 'left');
        $this->db->join('users AS U', 'U.id = A.user_id', 'left');
        $this->db->join('roles AS R', 'R.id = U.role_id', 'left');
        if ($this->session->userdata('role_id') == ADMIN) {
            $this->db->where('U.role_id !=', 1);
        }
        if ($search) {
            $this->db->group_start();
            $this->db->like('A.phone', $search);
            $this->db->or_like('A.name', $search, 'both');
            $this->db->or_like('A.bn_name', $search, 'both');
            $this->db->or_like('A.specialist', $search, 'both');
            $this->db->or_like('A.gender', $search);
            $this->db->or_like('A.religion', $search);
            $this->db->or_like('A.blood_group', $search);
            $this->db->or_like('A.marital_status', $search);
            $this->db->or_like('A.present_address', $search);
            $this->db->or_like('A.permanent_address', $search);
            $this->db->or_like('D.name', $search, 'both');
            $this->db->or_like('DE.name', $search, 'both');
            $this->db->group_end();
        }
        $this->db->order_by('A.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    public function get_single_assistant($user_id) {
        $this->db->select('A.*, D.name AS department, DE.name AS designation, U.username, U.temp_password, U.device_id, U.sbiz_id, U.role_id, C.name as created_by, M.name as modified_by');
        $this->db->from('assistants AS A');
        $this->db->join('departments AS D', 'D.id = A.department_id', 'left');
        $this->db->join('designations AS DE', 'DE.id = A.designation_id', 'left');
        $this->db->join('users AS U', 'U.id = A.user_id', 'left');
        $this->db->join('roles AS R', 'R.id = U.role_id', 'left');
        $this->db->join('employees AS C', 'C.user_id = A.created_by', 'left');
        $this->db->join('employees AS M', 'M.user_id = A.modified_by', 'left');
        if ($this->session->userdata('role_id') == ADMIN) {
            $this->db->where('U.role_id !=', 1);
        }
        $this->db->where('A.user_id', $user_id);
        return $this->db->get()->row();
    }

    function duplicate_check($username, $id = null) {
        if ($id) {
            $this->db->where_not_in('id', $id);
        }
        $this->db->where('username', $username);
        return $this->db->get('users')->num_rows();
    }
}
