<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('charge'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage_charge'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <?php $this->load->view('doctor/left-side'); ?>
        <!-- col-lg-9 -->
        <div class="col-lg-9">
            <div class="card">

                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(ADD, 'doctor', 'charge')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-money font-30 mr-10"></i>
                            <?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('charge'); ?>
                        </h6>
                    <?php } ?>
                    <?php if (has_permission(VIEW, 'doctor', 'charge')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('doctor/charge'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-list font-12 mr-5"></i>
                                <?php echo $this->lang->line('charge'); ?> <?php echo $this->lang->line('list'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>

                <?php echo form_open_multipart(site_url('doctor/charge/add'), array('name' => 'add', 'id' => 'add', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                <div class="card-body">
                    <div class="form-row">
                        <div class="col-md-4 mb-10">
                            <label for="doctor_id"><?php echo $this->lang->line('doctor'); ?> <?php echo $this->lang->line('name'); ?></label>
                            <select class="form-control custom-select select2" name="doctor_id" id="doctor_id" required>
                                <option value="" selected><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($doctors as $obj) { ?>
                                <?php if(!$obj->doctor_id){ ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo isset($doctor_id) && $doctor_id == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="doctor_id" class="form-text text-muted">
                                <?php echo form_error('doctor_id'); ?>
                            </small>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="ipd_charge"><?php echo $this->lang->line('ipd'); ?> <?php echo $this->lang->line('charge'); ?></label>
                            <input type="number" class="form-control" name="ipd_charge" id="ipd_charge" value="<?php echo isset($ipd_charge) ?  $ipd_charge : ''; ?>" placeholder="<?php echo $this->lang->line('ipd'); ?> <?php echo $this->lang->line('charge'); ?>">
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="ot_charge"><?php echo $this->lang->line('ot'); ?> <?php echo $this->lang->line('charge'); ?></label>
                            <input type="number" class="form-control" name="ot_charge" id="ot_charge" value="<?php echo isset($ot_charge) ?  $ot_charge : ''; ?>" placeholder="<?php echo $this->lang->line('ot'); ?> <?php echo $this->lang->line('charge'); ?>">
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="first_fee"><?php echo $this->lang->line('first_fee'); ?></label>
                            <input type="number" class="form-control" name="first_fee" id="first_fee" value="<?php echo isset($first_fee) ?  $first_fee : ''; ?>" placeholder="<?php echo $this->lang->line('first_fee'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="first_fee" class="form-text text-muted">
                                <?php echo form_error('first_fee'); ?>
                            </small>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="second_fee"><?php echo $this->lang->line('second_fee'); ?></label>
                            <input type="number" class="form-control" name="second_fee" id="second_fee" value="<?php echo isset($second_fee) ?  $second_fee : ''; ?>" placeholder="<?php echo $this->lang->line('second_fee'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="second_fee" class="form-text text-muted">
                                <?php echo form_error('second_fee'); ?>
                            </small>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="hospital_commission"><?php echo $this->lang->line('hospital'); ?> <?php echo $this->lang->line('commission'); ?></label>
                            <input type="number" class="form-control" name="hospital_commission" id="hospital_commission" value="<?php echo isset($hospital_commission) ?  $hospital_commission : ''; ?>" placeholder="<?php echo $this->lang->line('hospital'); ?> <?php echo $this->lang->line('commission'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="first_fee_day"><?php echo $this->lang->line('first_fee_day'); ?></label>
                            <input type="number" class="form-control" name="first_fee_day" id="first_fee_day" value="<?php echo isset($first_fee_day) ?  $first_fee_day : '90'; ?>" placeholder="<?php echo $this->lang->line('first_fee_day'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="first_fee_day" class="form-text text-muted">
                                <?php echo form_error('first_fee_day'); ?>
                            </small>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="serial_no"><?php echo $this->lang->line('serial_no'); ?></label>
                            <input type="number" class="form-control" name="serial_no" id="serial_no" value="<?php echo isset($serial_no) ?  $serial_no : 30; ?>" placeholder="<?php echo $this->lang->line('serial_no'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="sort_by"><?php echo $this->lang->line('sort_by'); ?></label>
                            <input type="number" class="form-control" name="sort_by" id="sort_by" value="<?php echo isset($sort_by) ?  $sort_by : ''; ?>" placeholder="<?php echo $this->lang->line('sort_by'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-2 mt-40">
                            <div class="custom-control custom-checkbox checkbox-cyan">
                                <input type="checkbox" class="custom-control-input" name="is_opd" id="is_opd" value="1">
                                <label class="custom-control-label" for="is_opd"><?php echo $this->lang->line('is_opd'); ?></label>
                            </div>
                        </div>
                        <div class="col-md-1 mt-40">
                            <div class="custom-control custom-checkbox checkbox-cyan">
                                <input type="checkbox" class="custom-control-input" name="status" id="status" value="1" checked>
                                <label class="custom-control-label" for="status"><?php echo $this->lang->line('status'); ?></label>
                            </div>
                        </div>
                        <div class="col-md-12 mt-10 mb-10">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('charge'); ?> <?php echo $this->lang->line('note'); ?></span>
                                </div>
                                <textarea class="form-control" name="note" id="note" aria-label="<?php echo $this->lang->line('charge'); ?> <?php echo $this->lang->line('note'); ?>"><?php echo isset($note) ?  $note : ''; ?></textarea>
                                <div class="valid-feedback">
                                    <?php echo $this->lang->line('looks_good'); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <div class="card-footer pt-0">
                    <div class="button-list">
                        <a class="btn btn-gradient-danger" href="<?php echo site_url('doctor/charge'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                        <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('submit'); ?></button>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->


<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>


<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>
<script>
    $(".select2").select2();
</script>