<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('frontend'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Row -->
    <div class="row">
        <!-- col-xl-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(ADD, 'frontend', 'frontend')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-desktop font-30 mr-10"></i>
                            <?php echo $this->lang->line('manage'); ?> <?php echo $this->lang->line('about'); ?>
                        </h6>
                    <?php } ?>
                </div>

                <?php echo form_open_multipart(site_url('frontend/about'), array('name' => 'add', 'id' => 'add', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                <div class="card-body">
                    <div class="form-row">
                        <div class="col-md-6 mt-10 mb-10">
                            <label for="about"><?php echo $this->lang->line('about'); ?></label>
                            <textarea rows="5" class="form-control" name="about" id="about" placeholder="<?php echo $this->lang->line('about'); ?>"><?php echo isset($about->about) ?  $about->about : ''; ?></textarea>
                        </div>
                        <div class="col-md-6 mt-10 mb-10">
                            <label for="bn_about"><?php echo $this->lang->line('bangla'); ?> <?php echo $this->lang->line('about'); ?></label>
                            <textarea rows="5" class="form-control" name="bn_about" id="bn_about" placeholder="<?php echo $this->lang->line('bangla'); ?> <?php echo $this->lang->line('about'); ?>"><?php echo isset($about->bn_about) ?  $about->bn_about : ''; ?></textarea>
                        </div>
                        <div class="col-md-6 mt-10 mb-10">
                            <label for="why_choose_us"><?php echo $this->lang->line('why_choose_us'); ?></label>
                            <textarea rows="5" class="form-control" name="why_choose_us" id="why_choose_us" placeholder="<?php echo $this->lang->line('why_choose_us'); ?>"><?php echo isset($about->why_choose_us) ?  $about->why_choose_us : ''; ?></textarea>
                        </div>
                        <div class="col-md-6 mt-10 mb-10">
                            <label for="bn_why_choose_us"><?php echo $this->lang->line('bangla'); ?> <?php echo $this->lang->line('why_choose_us'); ?></label>
                            <textarea rows="5" class="form-control" name="bn_why_choose_us" id="bn_why_choose_us" placeholder="<?php echo $this->lang->line('bangla'); ?> <?php echo $this->lang->line('why_choose_us'); ?>"><?php echo isset($about->bn_why_choose_us) ?  $about->bn_why_choose_us : ''; ?></textarea>
                        </div>
                        <div class="col-md-6 mt-10 mb-10">
                            <label for="service"><?php echo $this->lang->line('service'); ?></label>
                            <textarea rows="5" class="form-control" name="service" id="service" placeholder="<?php echo $this->lang->line('service'); ?>"><?php echo isset($about->service) ?  $about->service : ''; ?></textarea>
                        </div>
                        <div class="col-md-6 mt-10 mb-10">
                            <label for="bn_testimonial"><?php echo $this->lang->line('bangla'); ?> <?php echo $this->lang->line('service'); ?></label>
                            <textarea rows="5" class="form-control" name="bn_service" id="bn_service" placeholder="<?php echo $this->lang->line('bangla'); ?> <?php echo $this->lang->line('service'); ?>"><?php echo isset($about->bn_service) ?  $about->bn_service : ''; ?></textarea>
                        </div>
                        <div class="col-md-6 mt-10 mb-10">
                            <label for="testimonial"><?php echo $this->lang->line('testimonial'); ?></label>
                            <textarea rows="5" class="form-control" name="testimonial" id="testimonial" placeholder="<?php echo $this->lang->line('testimonial'); ?>"><?php echo isset($about->testimonial) ?  $about->testimonial : ''; ?></textarea>
                        </div>
                        <div class="col-md-6 mt-10 mb-10">
                            <label for="bn_testimonial"><?php echo $this->lang->line('bangla'); ?> <?php echo $this->lang->line('testimonial'); ?></label>
                            <textarea rows="5" class="form-control" name="bn_testimonial" id="bn_testimonial" placeholder="<?php echo $this->lang->line('bangla'); ?> <?php echo $this->lang->line('testimonial'); ?>"><?php echo isset($about->bn_testimonial) ?  $about->bn_testimonial : ''; ?></textarea>
                        </div>
                        <div class="col-md-6 mt-10 mb-10">
                            <label for="appointment"><?php echo $this->lang->line('appointment'); ?></label>
                            <textarea rows="5" class="form-control" name="appointment" id="appointment" placeholder="<?php echo $this->lang->line('appointment'); ?>"><?php echo isset($about->appointment) ?  $about->appointment : ''; ?></textarea>
                        </div>
                        <div class="col-md-6 mt-10 mb-10">
                            <label for="bn_appointment"><?php echo $this->lang->line('bangla'); ?> <?php echo $this->lang->line('appointment'); ?></label>
                            <textarea rows="5" class="form-control" name="bn_appointment" id="bn_appointment" placeholder="<?php echo $this->lang->line('bangla'); ?> <?php echo $this->lang->line('appointment'); ?>"><?php echo isset($about->bn_appointment) ?  $about->bn_appointment : ''; ?></textarea>
                        </div>
                        <div class="col-md-6 mt-10 mb-10">
                            <label for="contact"><?php echo $this->lang->line('contact'); ?></label>
                            <textarea rows="5" class="form-control" name="contact" id="contact" placeholder="<?php echo $this->lang->line('contact'); ?>"><?php echo isset($about->contact) ?  $about->contact : ''; ?></textarea>
                        </div>
                        <div class="col-md-6 mt-10 mb-10">
                            <label for="bn_contact"><?php echo $this->lang->line('bangla'); ?> <?php echo $this->lang->line('contact'); ?></label>
                            <textarea rows="5" class="form-control" name="bn_contact" id="bn_contact" placeholder="<?php echo $this->lang->line('bangla'); ?> <?php echo $this->lang->line('contact'); ?>"><?php echo isset($about->bn_contact) ?  $about->bn_contact : ''; ?></textarea>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <div class="card-footer pt-0">
                    <div class="button-list">
                        <a class="btn btn-gradient-danger" href="<?php echo site_url('frontend'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                        <button class="btn btn-gradient-primary" type="submit"><?php echo isset($about) & !empty($about) ? $this->lang->line('update') : $this->lang->line('submit'); ?></button>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->