<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('manage_appointment'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage_appointment'); ?>
        </h4>

        <!-- Patient Search -->
        <?php echo form_open_multipart(site_url('frontoffice/appointment/patient'), array('name' => 'patient', 'id' => 'patient', 'class' => 'needs-validation', 'novalidate' => 'novalidate', 'method' => 'get'), ''); ?>
        <div class="form-group">
            <div class="input-group">
                <input type="text" class="form-control" name="patient" id="get_phone" value="<?php echo isset($patient) ?  $patient : ''; ?>" placeholder="<?php echo $this->lang->line('search'); ?>" required autocomplete="off">
                <div class="input-group-append">
                    <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('search'); ?></button>
                </div>
            </div>
        </div>
        <?php echo form_close(); ?>
        <div class="d-flex">
            <?php if (has_permission(ADD, 'frontoffice', 'appointment')) { ?>
                <button type="button" class="btn btn-primary btn-sm mr-15" onclick="getPhone();" data-toggle="modal" data-target="#addAppointmentModal">
                    <i class="fa fa-plus font-12 mr-5"></i>
                    <?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('appointment'); ?>
                </button>
            <?php } ?>
        </div>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <!-- col-xl-8 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(VIEW, 'frontoffice', 'appointment')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-user font-30 mr-10"></i>
                            <?php echo $this->lang->line('appointment'); ?> <?php echo $this->lang->line('list'); ?>
                        </h6>
                    <?php } ?>

                    <?php echo form_open_multipart(site_url('frontoffice/appointment'), array('name' => 'search', 'id' => 'search', 'class' => 'form-inline needs-validation', 'novalidate' => 'novalidate', 'method' => 'get'), ''); ?>
                    <div class="form-group mr-10">
                        <input type="text" class="form-control" name="keyword" id="keyword" value="<?php echo isset($keyword) ?  $keyword : ''; ?>" placeholder="<?php echo $this->lang->line('keyword'); ?>" autocomplete="off">
                    </div>
                    <div class="form-group mr-10">
                        <input type="text" class="form-control" name="date" id="search_date" value="<?php echo isset($date) ?  $date : ''; ?>" placeholder="<?php echo $this->lang->line('date'); ?>" autocomplete="off">
                    </div>
                    <div class="form-group mr-10">
                        <select class="form-control custom-select select2" name="doctor_id" id="doctor_id">
                            <option value="" selected><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('doctor'); ?></option>
                            <?php foreach ($doctors as $obj) { ?>
                                <option value="<?php echo $obj->user_id; ?>" <?php echo isset($doctor_id) && $doctor_id == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                            <?php } ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <button class="btn btn-primary ml-10 float-right" type="submit"><?php echo $this->lang->line('search'); ?></button>
                    </div>
                    <?php echo form_close(); ?>
                </div>
                <?php if (isset($patients) && !empty($patients)) { ?>
                    <div class="card-body">
                        <div class="table-wrap">
                            <div class="table-responsive">
                                <table class="table table-sm mb-0">
                                    <thead>
                                        <tr>
                                            <th><?php echo $this->lang->line('sl_no'); ?></th>
                                            <th><?php echo $this->lang->line('patient_id'); ?></th>
                                            <th><?php echo $this->lang->line('name'); ?></th>
                                            <th><?php echo $this->lang->line('phone'); ?></th>
                                            <th><?php echo $this->lang->line('gender'); ?></th>
                                            <th><?php echo $this->lang->line('guardian_name'); ?></th>
                                            <th><?php echo $this->lang->line('address'); ?></th>
                                            <th><?php echo $this->lang->line('action'); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($patients as $obj) { ?>
                                            <tr>
                                                <td><?php echo $sl_count; ?></td>
                                                <td><?php echo $obj->patient_unique_id; ?></td>
                                                <td><?php echo $obj->name; ?></td>
                                                <td><?php echo $obj->phone; ?></td>
                                                <td><?php echo $obj->gender ? $this->lang->line($obj->gender) : ''; ?></td>
                                                <td><?php echo $obj->guardian_name; ?></td>
                                                <td><?php echo $obj->address; ?></td>
                                                <td>
                                                    <button type="button" onclick="addAppointment('<?php echo $obj->user_id; ?>')" data-toggle="modal" data-target="#addAppointmentModal" class="btn btn-primary btn-xs">
                                                        <i class="fa fa-plus"></i> <?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('appointment'); ?>
                                                    </button>
                                                </td>
                                            </tr>
                                            <?php $sl_count++; ?>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <!-- Card Footer -->
                    <?php if ($this->pagination->create_links()) { ?>
                        <div class="card-footer justify-content-end">
                            <?php echo $this->pagination->create_links(); ?>
                        </div>
                    <?php } ?>
                <?php } ?>


                <?php if (isset($appointments) && !empty($appointments)) { ?>
                    <div class="card-body">
                        <div class="table-wrap">
                            <div class="table-responsive">
                                <table class="table table-sm mb-0">
                                    <thead>
                                        <tr>
                                            <th><?php echo $this->lang->line('sl_no'); ?></th>
                                            <th><?php echo $this->lang->line('appointment_no'); ?></th>
                                            <th><?php echo $this->lang->line('date'); ?></th>
                                            <th><?php echo $this->lang->line('name'); ?></th>
                                            <th><?php echo $this->lang->line('phone'); ?></th>
                                            <th><?php echo $this->lang->line('doctor'); ?></th>
                                            <th><?php echo $this->lang->line('reference'); ?></th>
                                            <th><?php echo $this->lang->line('status'); ?></th>
                                            <th width="13%"><?php echo $this->lang->line('action'); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($appointments as $obj) { ?>
                                            <tr>
                                                <td><?php echo $sl_count; ?></td>
                                                <td><?php echo $obj->appointment_no; ?></td>
                                                <td><?php echo date('d F, Y', strtotime($obj->date)); ?></td>
                                                <td><?php echo $obj->name; ?></td>
                                                <td><?php echo $obj->phone; ?></td>
                                                <td><?php echo $obj->doctor; ?></td>
                                                <td><?php echo $obj->reference; ?></td>
                                                <td>
                                                    <?php if ($obj->appointment_status == 0) { ?>
                                                        <span class="badge badge-info"><?php echo $this->lang->line('pending'); ?></span>
                                                    <?php } elseif ($obj->appointment_status == 1) { ?>
                                                        <span class="badge badge-success"><?php echo $this->lang->line('approved'); ?></span>
                                                    <?php } else { ?>
                                                        <span class="badge badge-danger"><?php echo $this->lang->line('cancel'); ?></span>
                                                    <?php } ?>

                                                    <?php if (has_permission(ADD, 'frontoffice', 'opd')) { ?>
                                                        <?php if ($obj->patient_id > 0 && $obj->is_opd == 0) { ?>
                                                            <a class="btn btn-warning btn-xs" href="<?php echo site_url('frontoffice/appointment/move/' . $obj->patient_id . '?app_id=' . $obj->id); ?>">
                                                                <i class="fa fa-share-alt-square"></i>
                                                                <?php echo $this->lang->line('move_to'); ?> <?php echo $this->lang->line('opd'); ?>
                                                            </a>
                                                        <?php } else { ?>
                                                            <?php if ($obj->is_opd == 0) { ?>
                                                                <a class="btn btn-warning btn-xs" href="<?php echo site_url('frontoffice/appointment/addPatient/' . $obj->id); ?>">
                                                                    <i class="fa fa-share-alt-square"></i>
                                                                    <?php echo $this->lang->line('move_to'); ?> <?php echo $this->lang->line('opd'); ?>
                                                                </a>
                                                            <?php } ?>
                                                        <?php } ?>
                                                    <?php } ?>
                                                </td>
                                                <td>
                                                    <?php if (has_permission(VIEW, 'frontoffice', 'appointment_sms')) { ?>
                                                        <button type="button" onclick="send_sms(<?php echo $obj->id; ?>);" class="btn btn-warning btn-xs">
                                                            <i class="fa fa-envelope-o"></i>
                                                        </button>
                                                    <?php } ?>
                                                    <?php if (has_permission(VIEW, 'frontoffice', 'appointment')) { ?>
                                                        <button type="button" onclick="get_view_modal(<?php echo $obj->id; ?>);" data-toggle="modal" data-target=".viewModalCenter" class="btn btn-primary btn-xs">
                                                            <i class="fa fa-eye"></i>
                                                        </button>
                                                    <?php } ?>
                                                    <?php if (has_permission(EDIT, 'frontoffice', 'appointment')) { ?>
                                                        <button type="button" onclick="editAppointment('<?php echo $obj->id; ?>')" data-toggle="modal" data-target="#editAppointmentModal" class="btn btn-info btn-xs">
                                                            <i class="fa fa-pencil"></i>
                                                        </button>
                                                    <?php } ?>
                                                    <?php if (has_permission(DELETE, 'frontoffice', 'appointment')) { ?>
                                                        <a class="btn btn-danger btn-xs" href="<?php echo site_url('frontoffice/appointment/delete/' . $obj->id); ?>" onclick="javascript: return confirm('<?php echo $this->lang->line('confirm_alert'); ?>');"> <i class="fa fa-trash"></i> </a>
                                                    <?php } ?>
                                                </td>
                                            </tr>
                                            <?php $sl_count++; ?>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <!-- Card Footer -->
                    <?php if ($this->pagination->create_links()) { ?>
                        <div class="card-footer justify-content-end">
                            <?php echo $this->pagination->create_links(); ?>
                        </div>
                    <?php } ?>
                <?php } ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<?php echo $this->load->view('frontoffice/appointment/appointmentModal'); ?>
<?php echo $this->load->view('frontoffice/appointment/addEmployeeModal'); ?>


<div class="modal fade viewModalCenter" tabindex="-1" role="dialog" aria-labelledby="viewModalCenter" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header bg-gradient-primary">
                <h5 class="modal-title text-white"><?php echo $this->lang->line('appointment'); ?> <?php echo $this->lang->line('info'); ?></h5>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body modal_data bg-gradient-secondary"></div>
        </div>
    </div>
</div>

<script type="text/javascript">
    function get_view_modal(id) {
        $('.modal_data').html('<p style="padding: 20px;"><p style="padding: 20px;text-align:center;"><img src="<?php echo IMG_URL; ?>loader.gif" /></p>');
        $.ajax({
            type: "POST",
            url: "<?php echo site_url('frontoffice/appointment/get_single_appointment'); ?>",
            data: {
                id: id
            },
            success: function(response) {
                if (response) {
                    $('.modal_data').html(response);
                }
            }
        });
    }
</script>

<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.js"></script>
<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>
<script>
    $(".select2").select2();

    $("#search_date, #add_date").daterangepicker({
        startDate: new Date(),
        minYear: 1901,
        showDropdowns: true,
        singleDatePicker: true,
        locale: {
            format: 'YYYY-MM-DD'
        }
    });

    $("#edit_date").daterangepicker({
        autoUpdateInput: false,
        startDate: false,
        minYear: 1901,
        showDropdowns: true,
        singleDatePicker: true,
        locale: {
            format: 'YYYY-MM-DD'
        }
    });
    $("#edit_date").on('apply.daterangepicker', function(ev, picker) {
        $(this).val(picker.startDate.format('YYYY-MM-DD'));
    });

    function send_sms(id) {
        $.confirm({
            title: 'Send SMS!',
            content: 'Are you sure to send SMS?',
            type: 'red',
            typeAnimated: true,
            buttons: {
                tryAgain: {
                    text: 'Yes',
                    btnClass: 'btn-red',
                    action: function() {
                        $.ajax({
                            url: "<?php echo site_url('frontoffice/appointment/appointment_sms'); ?>/" + id,
                            method: 'get'
                        });
                        $.alert('SMS Sent Successfully!');
                    }
                },
                close: function() {}
            }
        });
    }
</script>