<!-- Container -->
<div class="container mt-20">
    <!-- Row -->
    <div class="row">
        <!-- col-xl-12 -->
        <div class="col-lg-12">
            <div class="card mb-0">
                <div class="card-header pt-8 pb-8 d-flex justify-content-between">
                    <?php if (has_permission(VIEW, 'frontoffice', 'appointment')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-user font-30 mr-10"></i>
                            <?php echo $this->lang->line('create'); ?> <?php echo $this->lang->line('opd'); ?> <?php echo $this->lang->line('bill'); ?>
                        </h6>
                    <?php } ?>

                    <div class="align-items-center">
                        <?php if (has_permission(ADD, 'hrm', 'employee')) { ?>
                            <button type="button" data-toggle="modal" data-target="#addEmployeeModal" class="btn btn-xs btn-info">
                                <i class="fa fa-user font-12 mr-5"></i>
                                <?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('commission'); ?>
                            </button>
                        <?php } ?>
                        <?php if (has_permission(VIEW, 'frontoffice', 'appointment')) { ?>
                            <a href="<?php echo site_url('frontoffice/appointment'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-list font-12 mr-5"></i>
                                <?php echo $this->lang->line('appointment'); ?> <?php echo $this->lang->line('list'); ?>
                            </a>
                        <?php } ?>
                    </div>
                </div>

                <div class="card-body pt-0">
                    <!-- Patient Information Start-->
                    <div class="table-wrap">
                        <div class="table-responsive">
                            <table class="table table-sm table-bordered mt-0">
                                <thead>
                                    <tr>
                                        <th colspan="6" class="text-center bg-light text-ligh font-weight-700 text-uppercase">
                                            <?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('info'); ?>
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td><?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('name'); ?></td>
                                        <td><?php echo $patient->name; ?></td>
                                        <td><?php echo $this->lang->line('patient_id'); ?></td>
                                        <td><?php echo $patient->patient_unique_id; ?></td>
                                        <td><?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('age'); ?></td>
                                        <td><?php echo get_age($patient->dob); ?></td>
                                    </tr>
                                    <tr>
                                        <td><?php echo $this->lang->line('phone'); ?></td>
                                        <td><?php echo $patient->phone; ?></td>
                                        <td><?php echo $this->lang->line('gender'); ?></td>
                                        <td><?php echo $patient->gender ? $this->lang->line($patient->gender) : ''; ?></td>
                                        <td><?php echo $this->lang->line('blood_group'); ?></td>
                                        <td><?php echo $patient->blood_group ? $this->lang->line($patient->blood_group) : ''; ?></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!-- Patient Information End-->

                    <?php echo form_open_multipart(site_url('frontoffice/appointment/addOpdPatient'), array('name' => 'addOpdPatientForm', 'id' => 'addOpdPatientForm', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                    <input type="hidden" name="patient_id" value="<?php echo $patient->user_id; ?>">
                    <input type="hidden" name="payment_method" value="cash">
                    <input type="hidden" name="serial_no" id="serial_no" value="<?php echo $appointment->serial_no; ?>">
                    <input type="hidden" name="appointment_id" id="appointment_id" value="<?php echo $appointment->id; ?>">
                    <input type="hidden" name="hospital_commission" id="hospital_commission" value="0">
                    <!-- Form Row Start -->
                    <div class="row">
                        <div class="col-md-7">
                            <div class="form-row pt-5 pl-5 pr-5" style="background-color: #b2e6fa;">
                                <div class="col-md-3 mb-10">
                                    <label for="appointment_date"><?php echo $this->lang->line('appointment'); ?> <?php echo $this->lang->line('date'); ?></label>
                                    <input type="text" readonly class="form-control form-control-sm" name="appointment_date" id="appointment_date" value="<?php echo isset($appointment->date) ?  $appointment->date : ''; ?>" placeholder="<?php echo $this->lang->line('appointment'); ?> <?php echo $this->lang->line('date'); ?>" required>
                                </div>
                                <div class="col-md-3 mb-10">
                                    <label for="height"><?php echo $this->lang->line('height'); ?></label>
                                    <input type="text" class="form-control form-control-sm" name="height" id="height" value="<?php echo isset($height) ?  $height : ''; ?>" placeholder="<?php echo $this->lang->line('height'); ?>" autocomplete="off">
                                </div>
                                <div class="col-md-3 mb-10">
                                    <label for="weight"><?php echo $this->lang->line('weight'); ?></label>
                                    <input type="text" class="form-control form-control-sm" name="weight" id="weight" value="<?php echo isset($weight) ?  $weight : ''; ?>" placeholder="<?php echo $this->lang->line('weight'); ?>" autocomplete="off">
                                </div>
                                <div class="col-md-3 mb-10">
                                    <label for="bp"><?php echo $this->lang->line('bp'); ?></label>
                                    <input type="text" class="form-control form-control-sm" name="bp" id="bp" value="<?php echo isset($bp) ?  $bp : ''; ?>" placeholder="<?php echo $this->lang->line('bp'); ?>" autocomplete="off">
                                </div>
                                <div class="col-md-6 mb-10">
                                    <label for="symptoms"><?php echo $this->lang->line('symptoms'); ?></label>
                                    <input type="text" class="form-control form-control-sm" name="symptoms" id="symptoms" value="<?php echo isset($symptoms) ?  $symptoms : ''; ?>" placeholder="<?php echo $this->lang->line('symptoms'); ?>" autocomplete="off">
                                </div>
                                <div class="col-md-6 mb-10">
                                    <label for="case"><?php echo $this->lang->line('case'); ?></label>
                                    <input type="text" class="form-control form-control-sm" name="case" id="case" value="<?php echo isset($case) ?  $case : ''; ?>" placeholder="<?php echo $this->lang->line('case'); ?>" autocomplete="off">
                                </div>
                                <div class="col-md-12 mt-10 mb-10">
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"><?php echo $this->lang->line('remark'); ?></span>
                                        </div>
                                        <textarea class="form-control form-control-sm" name="note" id="note" aria-label="<?php echo $this->lang->line('remark'); ?>"><?php echo isset($note) ?  $note : ''; ?></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- col-md-7 -->

                        <div class="col-md-5">
                            <div class="form-row pt-5 pl-5 pr-5" style="background-color: #b2e6fa;">
                                <div class="col-md-12 mb-10">
                                    <label for="reference_id"><?php echo $this->lang->line('doctor'); ?> :
                                        <span class="text-red font-16 font-weight-bold w-100">
                                            <?php echo $doctor->name ?? ''; ?>
                                        </span>
                                    </label>
                                    <input type="hidden" name="doctor_id" value="<?php echo $doctor->user_id ?? ''; ?>">
                                </div>
                                <div class="col-md-12 mb-10">
                                    <label for="reference_person"><?php echo $this->lang->line('employee'); ?></label>
                                    <select class="form-control form-control-sm custom-select select2" name="reference_person" id="reference_person">
                                        <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('employee'); ?></option>
                                        <?php foreach ($reference_persons as $obj) { ?>
                                            <option value="<?php echo $obj->user_id; ?>" <?php echo isset($reference_person) && $reference_person == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                        <?php } ?>
                                    </select>
                                </div>
                                <div class="col-md-6 mb-10">
                                    <label for="casualty"><?php echo $this->lang->line('casualty'); ?></label>
                                    <select class="form-control form-control-sm custom-select" name="casualty" id="casualty">
                                        <option value="0" <?php echo isset($casualty) && $casualty == 0 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('no'); ?></option>
                                        <option value="1" <?php echo isset($casualty) && $casualty == 1 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('yes'); ?></option>
                                    </select>
                                </div>
                                <div class="col-md-6 mb-10">
                                    <label for="old_patient"><?php echo $this->lang->line('patient'); ?></label>
                                    <select readonly="readonly" class="form-control form-control-sm" name="old_patient" id="old_patient" required="" onchange="get_doctor_charge(this.value)">
                                        <option value="" selected><?php echo $this->lang->line('select'); ?></option>
                                        <option value="0" <?php echo isset($old_patient) && $old_patient == 0 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('first_time'); ?></option>
                                        <option value="1" <?php echo isset($old_patient) && $old_patient == 1 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('second_time'); ?></option>
                                    </select>
                                </div>
                                <div class="col-md-6 mb-10">
                                    <label for="doctor_charge"><?php echo $this->lang->line('charge'); ?></label>
                                    <input type="number" readonly class="form-control form-control-sm" name="doctor_charge" id="doctor_charge" value="<?php echo isset($doctor_charge) ?  $doctor_charge : ''; ?>" placeholder="<?php echo $this->lang->line('doctor'); ?> <?php echo $this->lang->line('charge'); ?>">
                                </div>
                                <div class="col-md-6 mb-10">
                                    <label for="discount"><?php echo $this->lang->line('discount'); ?></label>
                                    <input type="number" class="form-control form-control-sm" name="discount" id="discount" value="<?php echo isset($discount) ?  $discount : ''; ?>" placeholder="<?php echo $this->lang->line('discount'); ?>" autocomplete="off">
                                </div>
                                <div class="col-md-12 mb-10">
                                    <label for="reference_id"><?php echo $this->lang->line('reference'); ?> :
                                        <span class="text-red font-16 font-weight-bold w-100">
                                            <?php echo $reference->name ?? ''; ?>
                                        </span>
                                    </label>
                                    <input type="hidden" name="reference_id" value="<?php echo $reference->user_id ?? ''; ?>">
                                </div>
                            </div>
                            <div class="button-list">
                                <a class="btn btn-gradient-danger mt-5 float-left" href="<?php echo site_url('frontoffice/appointment'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                                <button id="saveNprintBtn" class="btn btn-gradient-primary mt-5 float-right" type="button"><?php echo $this->lang->line('save_and_print'); ?></button>
                            </div>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->


<!-- Add Employee Modal-->
<div class="modal fade" id="addEmployeeModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalForms" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('commission'); ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <form id="addEmployeeForm" enctype="multipart/form-data" method="POST" action="<?php echo site_url('frontoffice/appointment/addemployee'); ?>">
                <div class="modal-body">
                    <div class="form-row">
                        <div class="col-md-6 mb-10">
                            <label for="name"><?php echo $this->lang->line('name'); ?> <span class="required">*</span></label>
                            <input type="text" class="form-control" name="name" id="name" value="<?php echo isset($name) ?  $name : ''; ?>" placeholder="<?php echo $this->lang->line('name'); ?>" required autocomplete="off">
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="phone"><?php echo $this->lang->line('phone'); ?> <span class="required">*</span></label>
                            <input type="text" class="form-control" name="phone" id="phone" value="<?php echo isset($phone) ?  $phone : ''; ?>" placeholder="<?php echo $this->lang->line('phone'); ?>" required autocomplete="off">
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="commission_type"><?php echo $this->lang->line('commission'); ?> <?php echo $this->lang->line('type'); ?> <span class="required">*</span></label>
                            <select class="form-control custom-select" name="commission_type" id="commission_type" required>
                                <option value="vd"><?php echo $this->lang->line('vd'); ?></option>
                                <option value="mbbs"><?php echo $this->lang->line('mbbs'); ?></option>
                                <option value="emp"><?php echo $this->lang->line('emp'); ?></option>
                                <option value="corporate"><?php echo $this->lang->line('corporate'); ?></option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="modal-footer pt-0">
                    <div class="button-list">
                        <input type="hidden" name="role_id" value="<?php echo VD; ?>">
                        <button type="button" class="btn btn-gradient-danger" data-dismiss="modal"><?php echo $this->lang->line('cancel'); ?></button>
                        <button class="btn btn-gradient-primary" type="submit" id="submit"><?php echo $this->lang->line('submit'); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Add Employee Modal -->
<script type="text/javascript">
    $(document).ready(function(e) {
        $("#addEmployeeForm").on('submit', (function(e) {
            e.preventDefault();
            $.ajax({
                url: '<?php echo base_url('frontoffice/appointment/addemployee'); ?>',
                type: "POST",
                data: new FormData(this),
                dataType: 'json',
                contentType: false,
                cache: false,
                processData: false,
                success: function(data) {
                    if (data.status == "failed") {
                        var message = "";
                        $.each(data.error, function(index, value) {
                            message += value;
                        });
                        $.toast({
                            text: message,
                            position: 'top-right',
                            loaderBg: '#7a5449',
                            class: 'jq-toast-danger',
                            hideAfter: 3500,
                            stack: 6,
                            showHideTransition: 'fade'
                        });
                    } else {
                        $.toast({
                            text: data.message,
                            position: 'top-right',
                            loaderBg: '#7a5449',
                            class: 'jq-toast-primary',
                            hideAfter: 3500,
                            stack: 6,
                            showHideTransition: 'fade'
                        });
                        location.reload();
                    }
                }
            });
        }));
    });
</script>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.js"></script>

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>
<script>
    $('.select2').select2();
</script>
<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>

<script type="text/javascript">
    $('#doctor_id').on("change", function() {
        $('#old_patient').val('');
        $('#doctor_charge').val('0');
        $('#discount').val('0');
        $('#hospital_commission').val('0');
    });

    function get_doctor_charge(old_patient) {
        var doc_id = $('#doctor_id').val();
        if (doc_id > 0) {
            var doctor_id = doc_id;
        } else {
            var doctor_id = <?php echo $appointment->doctor_id > 0 ? $appointment->doctor_id : 0; ?>
        }
        $.ajax({
            type: "POST",
            url: "<?php echo site_url('frontoffice/appointment/get_doctor_charge'); ?>",
            data: {
                user_id: doctor_id,
                old_patient: old_patient,
            },
            dataType: 'json',
            success: function(response) {
                if (response) {
                    $('#doctor_charge').val(response.charge);
                    if (response.hospital_commission > 0) {
                        $('#discount').val('');
                        document.getElementById("discount").disabled = false;
                    } else {
                        document.getElementById("discount").disabled = true;
                        $('#discount').val('');
                    }
                    $('#hospital_commission').val(response.hospital_commission);
                } else {
                    $('#doctor_charge').val('0');
                    $('#discount').val('0');
                    $('#hospital_commission').val('0');
                }
            }
        });
    }
</script>


<!-- Add OPD Patient -->
<script>
    // Print With Save
    $(document).ready(function(e) {
        $("#saveNprintBtn").on('click', (function(e) {
            if ($("#discount").val() > Math.floor($("#hospital_commission").val())) {
                $.confirm({
                    title: 'Warning! Attention Please!!!',
                    content: 'Discount amount is not more than ' + Math.floor($("#hospital_commission").val()),
                    type: 'red',
                    typeAnimated: true,
                    buttons: {
                        close: function() {}
                    }
                });
            } else {
                $("#saveNprintBtn").attr('disabled', true);
                var form = $(this).parents('form').attr('id');
                var str = $("#" + form).serializeArray();
                var postData = new FormData();
                $.each(str, function(i, val) {
                    postData.append(val.name, val.value);
                });
                $.ajax({
                    url: '<?php echo base_url(); ?>frontoffice/appointment/addOpdPatient',
                    type: "POST",
                    data: postData,
                    dataType: 'json',
                    contentType: false,
                    cache: false,
                    processData: false,
                    success: function(data) {
                        if (data.status == "failed") {
                            var message = "";
                            $.each(data.error, function(index, value) {
                                message += value;
                            });
                            $.toast({
                                text: message,
                                position: 'top-right',
                                loaderBg: '#7a5449',
                                class: 'jq-toast-danger',
                                hideAfter: 3500,
                                stack: 6,
                                showHideTransition: 'fade'
                            });
                        } else {
                            $.toast({
                                text: data.message,
                                position: 'top-right',
                                loaderBg: '#7a5449',
                                class: 'jq-toast-success',
                                hideAfter: 3500,
                                stack: 6,
                                showHideTransition: 'fade'
                            });
                            printBill(data.user_id, data.opd_id, data.appointment_id);
                        }
                        $("#saveNprintBtn").attr('disabled', false);
                    }
                });
            }
        }));
    });

    function printBill(patient_id, opd_id, appointment_id) {
        var base_url = '<?php echo base_url() ?>';
        $.ajax({
            url: base_url + 'frontoffice/appointment/get_patient_visit_bill',
            type: 'POST',
            data: {
                patient_id: patient_id,
                opd_id: opd_id,
                appointment_id: appointment_id
            },
            success: function(result) {
                $("#testdata").html(result);
                popup(result);
            }
        });
    }

    function popup(data) {
        var base_url = '<?php echo base_url() ?>';
        var frame1 = $('<iframe />');
        frame1[0].name = "frame1";
        frame1.css({
            "position": "absolute",
            "top": "-1000000px"
        });
        $("body").append(frame1);
        var frameDoc = frame1[0].contentWindow ? frame1[0].contentWindow : frame1[0].contentDocument.document ? frame1[0].contentDocument.document : frame1[0].contentDocument;
        frameDoc.document.open();
        //Create a new HTML document.
        frameDoc.document.write('<html>');
        frameDoc.document.write('<head>');
        frameDoc.document.write('<title>Invoice</title>');

        frameDoc.document.write('</head>');
        frameDoc.document.write('<body>');
        frameDoc.document.write(data);
        frameDoc.document.write('</body>');
        frameDoc.document.write('</html>');
        frameDoc.document.close();
        setTimeout(function() {
            window.frames["frame1"].focus();
            window.frames["frame1"].print();
            frame1.remove();
            window.location.href = "<?php echo site_url('frontoffice/appointment'); ?>";
        }, 500);

        return true;

    }
</script>