<div class="table-wrap">
	<div class="table-responsive">
		<table class="table table-sm text-white">
			<tbody>
				<tr>
					<td><?php echo $this->lang->line('name'); ?></td>
					<td><?php echo $appointment->name; ?></td>
					<td><?php echo $this->lang->line('phone'); ?></td>
					<td><?php echo $appointment->phone; ?></td>
				</tr>
				<tr>
					<td><?php echo $this->lang->line('appointment_no'); ?></td>
					<td><?php echo $appointment->appointment_no; ?></td>
					<td><?php echo $this->lang->line('appointment'); ?> <?php echo $this->lang->line('date'); ?></td>
					<td><?php echo date($this->global_setting->date_format, strtotime($appointment->date)); ?></td>
				</tr>
				<tr>
					<td><?php echo $this->lang->line('doctor'); ?></td>
					<td><?php echo $appointment->doctor; ?></td>
					<td><?php echo $this->lang->line('reference'); ?></td>
					<td><?php echo $appointment->reference; ?></td>
				</tr>
				<tr>
					<td><?php echo $this->lang->line('gender'); ?></td>
					<td><?php echo $appointment->gender?$this->lang->line($appointment->gender):''; ?></td>
					<td><?php echo $this->lang->line('address'); ?></td>
					<td><?php echo $appointment->address; ?></td>
				</tr>
				<tr>
					<td><?php echo $this->lang->line('appointment'); ?> <?php echo $this->lang->line('status'); ?></td>
					<td>
						<?php if ($appointment->appointment_status == 0) { ?>
						<span class="badge badge-info"><?php echo $this->lang->line('pending'); ?></span>
						<?php } elseif ($appointment->appointment_status == 1) { ?>
						<span class="badge badge-success"><?php echo $this->lang->line('approved'); ?></span>
						<?php } else { ?>
						<span class="badge badge-danger"><?php echo $this->lang->line('cancel'); ?></span>
						<?php } ?>
					</td>
					<td><?php echo $this->lang->line('source'); ?></td>
					<td><?php echo $appointment->source == '1' ? $this->lang->line('online') : $this->lang->line('offline'); ?></td>
				</tr>
				<tr>
					<td><?php echo $this->lang->line('opd'); ?></td>
					<td><?php echo $appointment->is_opd ? $this->lang->line('yes') : $this->lang->line('no'); ?></td>
					<td><?php echo $this->lang->line('ipd'); ?></td>
					<td><?php echo $appointment->is_ipd ? $this->lang->line('yes') : $this->lang->line('no'); ?></td>
				</tr>
				<tr>
					<td><?php echo $this->lang->line('remark'); ?></td>
					<td colspan="3"><?php echo $appointment->note; ?></td>
				</tr>
				<tr>
					<td><?php echo $this->lang->line('created_by'); ?></td>
					<td><?php echo $appointment->created_by; ?></td>
					<td><?php echo $this->lang->line('date'); ?></td>
					<td><?php echo date('d F, Y h:i A', strtotime($appointment->created_at)); ?></td>
				</tr>
				<?php if ($this->session->userdata('role_id') == SUPER_ADMIN || !empty(custom_permission('modified_by'))) { ?>
    				<tr>
    					<td><?php echo $this->lang->line('modified_by'); ?></td>
    					<td><?php echo $appointment->modified_by; ?></td>
    					<td><?php echo $this->lang->line('date'); ?></td>
    					<td><?php echo $appointment->modified_by ? date('d F, Y h:i A', strtotime($appointment->modified_at)) : ''; ?>
    					</td>
    				</tr>
				<?php } ?>
			</tbody>
		</table>
	</div>
</div>