<!DOCTYPE html>
<html>

<head>
    <title>Print Visit Bill</title>

    <style>
        body {
            font-family: Arial, Helvetica, sans-serif;
            font-size: 14px;
        }

        .page {
            width: 65%;
            margin: 0 auto;
        }

        @page {
            size: A4;
            margin: 0;
        }

        @media print {

            html,
            body {
                font-family: Arial, Helvetica, sans-serif;
            }

            .page {
                width: 65%;
                margin: 0 auto;
                border: initial;
                border-radius: initial;
                min-height: initial;
                box-shadow: initial;
                background: initial;
            }
        }

        .patient_info {
            display: block;
            margin-top: 30px;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
        }

        .patient_table {
            width: 100%;
        }

        .patient_table tbody td {
            color: #000;
            padding: 3px 2px;
            vertical-align: middle;
            border: 1px solid #333;
            font-size: 15px;
        }

        .title {
            font-size: 15px;
            text-align: left;
            font-weight: bold;
            text-transform: uppercase;
        }

        .flowup {
            width: 90%;
            font-size: 14px;
            font-weight: bold;
            border: 1px solid #333;
            padding: 5px;
            font-family: monospace;
            text-transform: uppercase;
            letter-spacing: 2px;
            border-radius: 3px;
            text-align: center;
            margin: 3px auto;
        }

        .font-size {
            font-size: 13px;
        }

        /* Service Tabl */
        .service_table {
            width: 100%;
            margin-top: 30px;
        }

        .service_table thead th {
            color: #000;
            padding: 3px;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 15px;
        }

        .service_table tbody td {
            color: #000;
            padding: 3px;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 14px;
        }

        .border {
            border-top: 1px dashed #000;
            border-bottom: 0;
            border-right: 0;
            border-left: 0;
        }

        .paid {
            width: 25%;
            margin: 10px auto 0 auto;
            text-align: center;
            font-size: 25px;
            font-weight: bold;
            background: #eee;
            border: 1px solid #000;
            padding: 3px 10px;
            font-family: monospace;
            text-transform: uppercase;
            letter-spacing: 5px;
            border-radius: 3px;
        }

        p {
            text-align: center;
        }
    </style>
</head>

<body>
    <div class="page">
        <center>
            <h1 style="margin: 0px; font-size: 36px;"><?php echo $this->global_setting->brand_title; ?></h1>
            <p style="margin-bottom: 2px; font-size: 14px;"><?php echo $this->global_setting->address; ?></p>
            <p style="margin: 0; font-size: 14px; font-weight: bold;">Phone: <?php echo $this->global_setting->phone; ?></p>
        </center>
        <div class="patient_info">
            <table class="table" style="margin-bottom:10px">
                <tr>
                    <td width="30%" align="left">
                        <div class="title">Patient Copy</div>
                    </td>
                    <td width="70%" align="right">
                        <b>Print Time :</b> <?php echo date('d M, Y h:ia'); ?>
                    </td>
                </tr>
            </table>
            <!-- Patient Info Start-->
            <table class="table patient_table">
                <tr>
                    <td colspan="2"><b>Name:<span class="font-size" style="text-transform: uppercase;"><?php echo $patient->name; ?></b> </span></td>
                    <td width="34%"><b>App No:</b> <span class="font-size"><?php echo $patient->appointment_no; ?></span></td>
                </tr>
                <tr>
                    <td><b>Age:</b> <span class="font-size"><?php echo get_age($patient->dob); ?></span></td>
                    <td rowspan="2" width="35%">
                        <div class="flowup">
                            <?php if ($patient->old_patient) {
                                echo 'SECOND FOLLOWUP';
                            } else {
                                echo 'FIRST FOLLOWUP';
                            } ?>
                        </div>
                    </td>
                    <td><span class="font-size"><?php echo date('d/m/Y', strtotime($patient->appointment_date)); ?></span></td>
                </tr>
                <tr>
                    <td><b>Patient ID:</b> <span class="font-size"><?php echo $patient->patient_unique_id; ?></span></td>
                    <td width="31%"><b>Serial No:</b> <span class="font-size"><?php echo $patient->serial_no; ?></span></td>
                </tr>
                <tr>
                    <td colspan="2"><b>Bill No:<b> <span class="font-size"><?php echo $patient->custom_invoice_id; ?></span></td>
                    <td><b>Date:</b> <span class="font-size"><?php echo date('d/m/Y h:i A', strtotime($patient->created_at)); ?></span></td>
                </tr>
                <tr>
                    <td colspan="2"><b>Address:</b> <span class="font-size"><?php echo $patient->address; ?></span></td>
                    <td><b>Mobile:</b> <span class="font-size"><?php echo $patient->phone; ?></span></td>
                    
                </tr>
                <tr>
                    <td><b>Gender:</b> <span class="font-size"><?php echo $patient->gender ? $this->lang->line($patient->gender) : ''; ?></span></td>
                    <td><b>Weight:</b> <span class="font-size"><?php echo $patient->weight; ?></span></td>
                    <td><b>BP:</b> <span class="font-size"><?php echo $patient->bp; ?></span></td>
                </tr>
                <tr>
                    <td colspan="3">Reference Name: <?php echo $patient->reference_id ? $patient->reference : ''; ?></td>
                </tr>
                <tr>
                    <td colspan="3"><b>Doctor Name:</b> <span style="text-transform: uppercase; font-size: 14px; font-weight: bold; line-height: 22px;"><?php echo $patient->doctor; ?>, <?php echo $patient->specialist; ?></span></td>
                </tr>
            </table>
            <!-- Patient Info End-->

            <!-- Service Table -->
            <table class="table service_table">
                <thead>
                    <tr>
                        <th width="15%">SL. No</th>
                        <th width="70%">Service Name</th>
                        <th width="15%">Amount</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>01</td>
                        <td>OPD Consultation Fee</td>
                        <td><b><?php echo $patient->doctor_charge; ?></b></td>
                    </tr>
                    <tr>
                        <td colspan="3" style="padding: 0;">
                            <table class="table">
                                <tbody>
                                    <tr>
                                        <td width="65%" rowspan="5" style="border-top: 0;border-bottom: 0; border-left: 0;border-right: 0;">
                                            <div class="paid">
                                                Paid
                                            </div>
                                            <p><b>In Word:</b> <?php echo $this->numbertowords->convert_number($patient->doctor_charge - $patient->discount); ?> Taka Only.</p>
                                        </td>
                                        <td width="20%" style="border-top: 0;border-bottom: 0;"><b>Total</b></td>
                                        <td width="15%" style="border-top: 0;border-bottom: 0; border-left: 0;border-right: 0;"><b><?php echo number_format($patient->doctor_charge, 2); ?></b></td>
                                    </tr>
                                    <tr>
                                        <td style="border-right: 0;"><b>Discount</b></td>
                                        <td style="border-right: 0;"><b><?php echo number_format($patient->discount, 2); ?></b></td>
                                    </tr>
                                    <tr>
                                        <td style="border-right: 0;"><b>Payable</b></td>
                                        <td style="border-right: 0;"><b><?php echo number_format($patient->doctor_charge - $patient->discount, 2); ?></b></td>
                                    </tr>
                                    <tr>
                                        <td style="border-bottom: 0; border-right: 0;"><b>Due</b></td>
                                        <td style="border-bottom: 0; border-right: 0;"><b>0.00</b></td>
                                    </tr>
                                </tbody>
                            </table>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
        <?php if ($patient->note != NULL) { ?>
            <p style="text-align: left; margin-top: 20px;">
                <b>Remark:</b>
                <?php echo $patient->note; ?>
            </p>
        <?php } ?>
        <p style="text-align: left; margin-top: 50px;">
            <b>Prepared By:</b>
            <?php echo $patient->create_by; ?>
        </p>
    </div>
</body>

</html>