<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('visitor'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage_visitor'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <?php $this->load->view('frontoffice/left-side'); ?>
        <!-- col-xl-8 -->
        <div class="col-lg-9">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(ADD, 'frontoffice', 'visitor')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-user font-30 mr-10"></i>
                            <?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('visitor'); ?>
                        </h6>
                    <?php } ?>
                    <?php if (has_permission(VIEW, 'frontoffice', 'visitor')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('frontoffice/visitor'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-list font-12 mr-5"></i>
                                <?php echo $this->lang->line('visitor'); ?> <?php echo $this->lang->line('list'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>

                <?php echo form_open_multipart(site_url('frontoffice/visitor/add'), array('name' => 'add', 'id' => 'add', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                <div class="card-body">
                    <div class="form-row">
                        <div class="col-md-4 mb-10">
                            <label for="purpose_id"><?php echo $this->lang->line('visitor'); ?> <?php echo $this->lang->line('purpose'); ?></label>
                            <select class="form-control custom-select" name="purpose_id" id="purpose_id" required>
                                <option selected><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($visitor_purposes as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($purpose_id) && $purpose_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="name"><?php echo $this->lang->line('visitor'); ?> <?php echo $this->lang->line('name'); ?></label>
                            <input type="text" class="form-control" name="name" id="name" value="<?php echo isset($name) ?  $name : ''; ?>" placeholder="<?php echo $this->lang->line('visitor'); ?> <?php echo $this->lang->line('name'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="phone"><?php echo $this->lang->line('phone'); ?></label>
                            <input type="number" class="form-control" name="phone" id="phone" value="<?php echo isset($phone) ?  $phone : ''; ?>" placeholder="<?php echo $this->lang->line('phone'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="email"><?php echo $this->lang->line('email'); ?></label>
                            <input type="email" class="form-control" name="email" id="email" value="<?php echo isset($email) ?  $email : ''; ?>" placeholder="<?php echo $this->lang->line('email'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="id_card"><?php echo $this->lang->line('id'); ?> <?php echo $this->lang->line('card'); ?></label>
                            <input type="text" class="form-control" name="id_card" id="id_card" value="<?php echo isset($id_card) ?  $id_card : ''; ?>" placeholder="<?php echo $this->lang->line('id'); ?> <?php echo $this->lang->line('card'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="no_of_people"><?php echo $this->lang->line('no_of_people'); ?></label>
                            <input type="text" class="form-control" name="no_of_people" id="no_of_people" value="<?php echo isset($no_of_people) ?  $no_of_people : ''; ?>" placeholder="<?php echo $this->lang->line('no_of_people'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="date"><?php echo $this->lang->line('date'); ?></label>
                            <input type="text" class="form-control" name="date" id="date" value="<?php echo isset($date) ?  $date : ''; ?>" placeholder="<?php echo $this->lang->line('date'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="in_time"><?php echo $this->lang->line('in_time'); ?></label>
                            <div class="bootstrap-timepicker">
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text" id="in_time">
                                                <i class="fa fa-clock-o"></i>
                                            </span>
                                        </div>
                                        <input type="text" class="form-control timepicker" name="in_time" id="in_time" value="<?php echo isset($in_time) ?  $in_time : ''; ?>" placeholder="<?php echo $this->lang->line('in_time'); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="out_time"><?php echo $this->lang->line('out_time'); ?></label>
                            <div class="bootstrap-timepicker">
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text" id="out_time">
                                                <i class="fa fa-clock-o"></i>
                                            </span>
                                        </div>
                                        <input type="text" class="form-control timepicker" name="out_time" id="out_time" value="<?php echo isset($out_time) ?  $out_time : ''; ?>" placeholder="<?php echo $this->lang->line('out_time'); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 mb-10">
                            <label for="attachment"><?php echo $this->lang->line('attachment'); ?></label>
                            <div class="fileinput fileinput-new input-group" data-provides="fileinput">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('upload'); ?></span>
                                </div>
                                <div class="form-control text-truncate" data-trigger="fileinput"><i class="glyphicon glyphicon-file fileinput-exists"></i> <span class="fileinput-filename"></span></div>
                                <span class="input-group-append">
                                    <span class=" btn btn-primary btn-file"><span class="fileinput-new">Select file</span><span class="fileinput-exists">Change</span>
                                        <input type="file" name="attachment">
                                    </span>
                                    <a href="#" class="btn btn-secondary fileinput-exists" data-dismiss="fileinput">Remove</a>
                                </span>
                            </div>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-12 mt-10 mb-10">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('note'); ?></span>
                                </div>
                                <textarea class="form-control" name="note" id="note" aria-label="<?php echo $this->lang->line('note'); ?>"><?php echo isset($note) ?  $note : ''; ?></textarea>
                                <div class="valid-feedback">
                                    <?php echo $this->lang->line('looks_good'); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <div class="card-footer pt-0">
                    <div class="button-list">
                        <a class="btn btn-gradient-danger" href="<?php echo site_url('frontoffice/visitor'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                        <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('submit'); ?></button>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>

<!-- Time Picker -->
<link rel="stylesheet" href="<?php echo VENDOR_URL; ?>timepicker/bootstrap-timepicker.min.css">
<script src="<?php echo VENDOR_URL; ?>timepicker/bootstrap-timepicker.min.js"></script>

<script>
    $("#date").daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        minYear: 1901,
        locale: {
            format: 'YYYY/MM/DD'
        }
    });

    /* Time picker*/
    $(".timepicker").timepicker({
        showSeconds: false,
        showMeridian: true,
        showInputs: true,
        disableFocus: false,
        disableMousewheel: true,
        locale: moment.locale('bn')
    });
</script>