<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Frontoffice_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }
    public function get_visitor_purpose_list($limit, $offset, $search, $count) {
        $this->db->select('VP.*');
        $this->db->from('visitor_purposes AS VP');
        if ($search) {
            $this->db->like('VP.name', $search, 'both');
            $this->db->or_like('VP.bn_name', $search, 'both');
        }
        $this->db->order_by('VP.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    function duplicate_check($name, $id = null) {
        if ($id) {
            $this->db->where_not_in('id', $id);
        }
        $this->db->where('name', $name);
        return $this->db->get('visitor_purposes')->num_rows();
    }

    public function get_complaint_type_list($limit, $offset, $search, $count) {
        $this->db->select('CT.*');
        $this->db->from('complaint_types AS CT');
        if ($search) {
            $this->db->like('CT.name', $search, 'both');
            $this->db->or_like('CT.bn_name', $search, 'both');
        }
        $this->db->order_by('CT.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    function duplicate_check_complaint_type($name, $id = null) {
        if ($id) {
            $this->db->where_not_in('id', $id);
        }
        $this->db->where('name', $name);
        return $this->db->get('complaint_types')->num_rows();
    }

    public function get_source_list($limit, $offset, $search, $count) {
        $this->db->select('S.*');
        $this->db->from('sources AS S');
        if ($search) {
            $this->db->like('S.name', $search, 'both');
            $this->db->or_like('S.bn_name', $search, 'both');
        }
        $this->db->order_by('S.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    function duplicate_check_source($name, $id = null) {
        if ($id) {
            $this->db->where_not_in('id', $id);
        }
        $this->db->where('name', $name);
        return $this->db->get('sources')->num_rows();
    }
}
