<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Bill.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Bill
 * @description     : Manage IPD Bill Chart.
 * @author          : South Bangla IT Zone Team
 * @url             : http://hms.sbitzone.com
 * @support         : rabibd.it@gmail.com
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class Bill extends MY_Controller {

    public $data = array();

    function __construct() {
        parent::__construct();
        $this->load->model('Bill_Model', 'bill', true);
        $this->load->model('Ipd_Model', 'ipd', true);
    }

    /*****************Function index**********************************
     * @type            : Function
     * @function name   : index
     * @description     : Load "Billing List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */

    public function index($ipd_id) {

        check_permission(VIEW);

        $this->data['patient'] = $this->ipd->get_single_ipd_patient($ipd_id);
        $this->data['total_investigation_due'] = $this->ipd->get_total_investigation_due($this->data['patient']->patient_id);
        $this->data['total_pharmacy_due'] = $this->ipd->get_total_pharmacy_due($this->data['patient']->patient_id);
        $this->data['total_ipd_advanced'] = $this->ipd->get_total_ipd_advaced($ipd_id, $this->data['patient']->patient_id);


        // Advanced 
        $advance = $this->ipd->get_patient_total_advance($ipd_id, $this->data['patient']->patient_id);

        $bed = $this->ipd->get_patient_bed_list($ipd_id, $this->data['patient']->patient_id);
        $bed_amounts = [];
        foreach ($bed as $item) {
            if ($item->discharged == 1) {
                if (date('H:i:s', strtotime($item->to_date)) < '11:59:00') {
                    $from_date = new DateTime(substr($item->from_date, 0, 10));
                    $to_date = $item->to_date ? new DateTime(substr($item->to_date, 0, 10)) : new DateTime(date('Y-m-d'));
                    $interval = $to_date->diff($from_date, true)->days + 1;
                    $interval = ($interval - 1);
                    $amount = abs((float) $item->price) * abs($interval);
                } else {
                    $from_date = new DateTime(substr($item->from_date, 0, 10));
                    $to_date = $item->to_date ? new DateTime(substr($item->to_date, 0, 10)) : new DateTime(date('Y-m-d'));
                    $interval = $to_date->diff($from_date, true)->days + 1;
                    $amount = abs((float) $item->price) * abs($interval);
                }
            } else {
                $from_date = new DateTime(substr($item->from_date, 0, 10));
                $to_date = $item->to_date ? new DateTime(substr($item->to_date, 0, 10)) : new DateTime(date('Y-m-d'));
                $interval = $to_date->diff($from_date, true)->days + 1;
                $amount = abs((float) $item->price) * abs($interval);
            }
            array_push($bed_amounts, [
                'type' => '',
                'dates' => $from_date->format('M d, Y h:iA') . '-' . $to_date->format('M d, Y h:iA'),
                'price' => $item->price + 0,
                'name' => $item->bed_group . ' - ' . $item->name,
                'qty' => $interval,
                'amount' => $amount + 0
            ]);
        }

        $surgeon = $this->ipd->get_patient_surgeon_list($ipd_id, $this->data['patient']->patient_id);
        $surgeon_amounts = [];
        foreach ($surgeon as $item) {
            array_push($surgeon_amounts, [
                'type' => 'Surgeon',
                'dates' => date('M d, Y', strtotime($item->date)),
                'price' => $item->charge + 0,
                'name' => $item->surgeon,
                'qty' => 1,
                'amount' => $item->charge + 0
            ]);
        }

        $anesthesia = $this->ipd->get_patient_anesthesia_list($ipd_id, $this->data['patient']->patient_id);
        $anesthesia_amounts = [];
        foreach ($anesthesia as $item) {
            array_push($anesthesia_amounts, [
                'type' => 'Anesthesia',
                'dates' => date('M d, Y', strtotime($item->date)),
                'price' => $item->charge + 0,
                'name' => $item->anesthesia,
                'qty' => 1,
                'amount' => $item->charge + 0
            ]);
        }



        $assistant = $this->ipd->get_patient_assistant_list($ipd_id, $this->data['patient']->patient_id);
        $assistant_amounts = [];
        foreach ($assistant as $item) {
            array_push($assistant_amounts, [
                'type' => 'Assistant',
                'dates' => date('M d, Y', strtotime($item->date)),
                'price' => $item->charge + 0,
                'name' => $item->assistant,
                'qty' => 1,
                'amount' => $item->charge + 0
            ]);
        }


        $consultant = $this->ipd->get_patient_consultant_list($ipd_id, $this->data['patient']->patient_id);
        $consultant_amounts = [];
        foreach ($consultant as $item) {
            array_push($consultant_amounts, [
                'type' => 'Consultant',
                'dates' => date('M d, Y', strtotime($item->dates)),
                'price' => round($item->rate) + 0,
                'name' => $item->consultant,
                'qty' => $item->qty,
                'amount' => round($item->amount) + 0
            ]);
        }


        $charge = $this->ipd->get_patient_charge_list($ipd_id, $this->data['patient']->patient_id);
        $charge_amounts = [];
        foreach ($charge as $item) {
            array_push($charge_amounts, [
                'type' => '',
                'dates' => date('M d, Y', strtotime($item->dates)),
                'price' => round($item->rate) + 0,
                'name' => $item->charge_name,
                'qty' => $item->qty,
                'amount' => round($item->amount) + 0
            ]);
        }


        $this->data['list'] = TRUE;
        $this->data['total_advanced'] = $advance;
        $this->data['bed_amounts'] = $bed_amounts;
        $this->data['surgeon_amounts'] = $surgeon_amounts;
        $this->data['anesthesia_amounts'] = $anesthesia_amounts;
        $this->data['assistant_amounts'] = $assistant_amounts;
        $this->data['consultant_amounts'] = $consultant_amounts;
        $this->data['charge_amounts'] = $charge_amounts;

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('billing') . ' ' . $this->lang->line('list') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('bill/index', $this->data);
    }

    /*****************Function print**********************************
     * @type            : Function
     * @function name   : print
     * @description     : Load "IPD Draft Bill Print" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */

    public function print() {

        $ipd_id = $this->input->post('ipd_id');

        $this->data['patient'] = $this->ipd->get_single_ipd_patient($ipd_id);
        $this->data['investigation_due'] = $this->bill->get_patient_investigation_due($ipd_id, $this->data['patient']->patient_id);

        // Advanced 
        $advance = $this->ipd->get_patient_total_advance($ipd_id, $this->data['patient']->patient_id);

        $bed = $this->ipd->get_patient_bed_list($ipd_id, $this->data['patient']->patient_id);
        $bed_amounts = [];
        foreach ($bed as $item) {
            if ($item->discharged == 1) {
                if (date('H:i:s', strtotime($item->to_date)) < '11:59:00') {
                    $from_date = new DateTime(substr($item->from_date, 0, 10));
                    $to_date = $item->to_date ? new DateTime(substr($item->to_date, 0, 10)) : new DateTime(date('Y-m-d'));
                    $interval = $to_date->diff($from_date, true)->days + 1;
                    $interval = ($interval - 1);
                    $amount = abs((float) $item->price) * abs($interval);
                } else {
                    $from_date = new DateTime(substr($item->from_date, 0, 10));
                    $to_date = $item->to_date ? new DateTime(substr($item->to_date, 0, 10)) : new DateTime(date('Y-m-d'));
                    $interval = $to_date->diff($from_date, true)->days + 1;
                    $amount = abs((float) $item->price) * abs($interval);
                }
            } else {
                $from_date = new DateTime(substr($item->from_date, 0, 10));
                $to_date = $item->to_date ? new DateTime(substr($item->to_date, 0, 10)) : new DateTime(date('Y-m-d'));
                $interval = $to_date->diff($from_date, true)->days + 1;
                $amount = abs((float) $item->price) * abs($interval);
            }
            array_push($bed_amounts, [
                'type' => '',
                'dates' => $from_date->format('M d, Y h:iA') . '-' . $to_date->format('M d, Y h:iA'),
                'price' => $item->price + 0,
                'name' => $item->bed_group . ' - ' . $item->name,
                'qty' => $interval,
                'amount' => $amount + 0
            ]);
        }

        $surgeon = $this->ipd->get_patient_surgeon_list($ipd_id, $this->data['patient']->patient_id);
        $surgeon_amounts = [];
        foreach ($surgeon as $item) {
            array_push($surgeon_amounts, [
                'type' => 'Surgeon',
                'dates' => date('M d, Y', strtotime($item->date)),
                'price' => $item->charge + 0,
                'name' => $item->surgeon,
                'qty' => 1,
                'amount' => $item->charge + 0
            ]);
        }

        $anesthesia = $this->ipd->get_patient_anesthesia_list($ipd_id, $this->data['patient']->patient_id);
        $anesthesia_amounts = [];
        foreach ($anesthesia as $item) {
            array_push($anesthesia_amounts, [
                'type' => 'Anesthesia',
                'dates' => date('M d, Y', strtotime($item->date)),
                'price' => $item->charge + 0,
                'name' => $item->anesthesia,
                'qty' => 1,
                'amount' => $item->charge + 0
            ]);
        }



        $assistant = $this->ipd->get_patient_assistant_list($ipd_id, $this->data['patient']->patient_id);
        $assistant_amounts = [];
        foreach ($assistant as $item) {
            array_push($assistant_amounts, [
                'type' => 'Assistant',
                'dates' => date('M d, Y', strtotime($item->date)),
                'price' => $item->charge + 0,
                'name' => $item->assistant,
                'qty' => 1,
                'amount' => $item->charge + 0
            ]);
        }


        $consultant = $this->ipd->get_patient_consultant_list($ipd_id, $this->data['patient']->patient_id);
        $consultant_amounts = [];
        foreach ($consultant as $item) {
            array_push($consultant_amounts, [
                'type' => 'Consultant',
                'dates' => date('M d, Y', strtotime($item->dates)),
                'price' => round($item->rate) + 0,
                'name' => $item->consultant,
                'qty' => $item->qty,
                'amount' => round($item->amount) + 0
            ]);
        }


        $charge = $this->ipd->get_patient_charge_list($ipd_id, $this->data['patient']->patient_id);
        $charge_amounts = [];
        foreach ($charge as $item) {
            array_push($charge_amounts, [
                'type' => '',
                'dates' => date('M d, Y', strtotime($item->dates)),
                'price' => round($item->rate) + 0,
                'name' => $item->charge_name,
                'qty' => $item->qty,
                'amount' => round($item->amount) + 0
            ]);
        }

        $this->data['list'] = TRUE;
        $this->data['total_advanced'] = $advance;
        $this->data['bed_amounts'] = $bed_amounts;
        $this->data['surgeon_amounts'] = $surgeon_amounts;
        $this->data['anesthesia_amounts'] = $anesthesia_amounts;
        $this->data['assistant_amounts'] = $assistant_amounts;
        $this->data['consultant_amounts'] = $consultant_amounts;
        $this->data['charge_amounts'] = $charge_amounts;
        $this->load->library('Numbertowords');
        $this->load->view('ipd/bill/print', $this->data);
    }
}
