<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Bill_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }

    public function get_patient_investigation_due($ipd_id, $patient_id) {
        $this->db->select('SUM(I.due_amount) as total_due_amount');
        $this->db->from('invoices AS I');
        $this->db->join('patients AS P', 'P.user_id = I.patient_id', 'left');
        $this->db->join('ipd_patients AS IP', 'IP.patient_id = I.patient_id', 'left');
        $this->db->where('IP.id', $ipd_id);
        $this->db->where('IP.patient_id', $patient_id);
        $this->db->where('I.paid_status', 'unpaid');
        $this->db->where('I.payment_status', 'complete');
        return $this->db->get()->row();
    }
}
