<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('ipd'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Row -->
    <div class="row">
        <!-- col-xl-12 -->
        <div class="col-lg-12">
            <div class="card mb-0">
                <div class="card-header pt-8 pb-8 d-flex justify-content-between">
                    <?php if (has_permission(VIEW, 'ipd', 'ipd')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-user font-30 mr-10"></i>
                            <?php echo $this->lang->line('admission'); ?> <?php echo $this->lang->line('patient'); ?>
                        </h6>
                    <?php } ?>

                    <div class="align-items-center">
                        <?php if (has_permission(VIEW, 'ipd', 'ipd')) { ?>
                            <a href="<?php echo site_url('ipd/admitted'); ?>" class="btn btn-xs btn-success">
                                <i class="fa fa-users font-12 mr-5"></i>
                                <?php echo $this->lang->line('admitted'); ?> <?php echo $this->lang->line('patient'); ?>
                            </a>
                        <?php } ?>
                        <?php if (has_permission(VIEW, 'ipd', 'ipd')) { ?>
                            <a href="<?php echo site_url('ipd/discharge'); ?>" class="btn btn-xs btn-orange">
                                <i class="fa fa-user-md font-12 mr-5"></i>
                                <?php echo $this->lang->line('discharge'); ?> <?php echo $this->lang->line('patient'); ?>
                            </a>
                        <?php } ?>
                        <?php if (has_permission(ADD, 'ipd', 'ipd')) { ?>
                            <a href="<?php echo site_url('ipd/new'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-plus font-12 mr-5"></i>
                                <?php echo $this->lang->line('new'); ?> <?php echo $this->lang->line('patient'); ?>
                            </a>
                        <?php } ?>
                        <?php if (has_permission(ADD, 'ipd', 'ipd')) { ?>
                            <a href="<?php echo site_url('ipd/existing'); ?>" class="btn btn-xs btn-info">
                                <i class="fa fa-users font-12 mr-5"></i>
                                <?php echo $this->lang->line('existing'); ?> <?php echo $this->lang->line('patient'); ?>
                            </a>
                        <?php } ?>
                    </div>
                </div>

                <div class="card-body pt-0">
                    <!-- Patient Information Start-->
                    <div class="table-wrap">
                        <div class="table-responsive">
                            <table class="table table-sm table-bordered table-info mt-0">
                                <thead>
                                    <tr>
                                        <th colspan="5" class="text-center bg-primary text-white font-weight-700 text-uppercase">
                                            <?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('info'); ?>
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>
                                            <span class="font-weight-bold"><?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('name'); ?>:</span>
                                            <?php echo $patient->name; ?>
                                        </td>
                                        <td>
                                            <span class="font-weight-bold"><?php echo $this->lang->line('patient_id'); ?> :</span>
                                            <?php echo $patient->patient_unique_id; ?>
                                        </td>
                                        <td>
                                            <span class="font-weight-bold"><?php echo $this->lang->line('gender'); ?> :</span>
                                            <?php echo $patient->gender ? $this->lang->line($patient->gender) : ''; ?>
                                        </td>
                                        <td>
                                            <span class="font-weight-bold"><?php echo $this->lang->line('age'); ?>: </span>
                                            <?php echo get_age($patient->dob); ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <span class="font-weight-bold"><?php echo $this->lang->line('phone'); ?>:</span>
                                            <?php echo $patient->phone; ?>
                                        </td>
                                        <td>
                                            <span class="font-weight-bold"><?php echo $this->lang->line('address'); ?> :</span>
                                            <?php echo $patient->address; ?>
                                        </td>
                                        <td>
                                            <span class="font-weight-bold"><?php echo $this->lang->line('blood_group'); ?> :</span>
                                            <?php echo $patient->blood_group ? $this->lang->line($patient->blood_group) : ''; ?>
                                        </td>
                                        <td>
                                            <span class="font-weight-bold"><?php echo $this->lang->line('marital_status'); ?> :</span>
                                            <?php echo $patient->marital_status ? $this->lang->line($patient->marital_status) : ''; ?>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!-- Patient Information End-->

                    <?php echo form_open_multipart(site_url('ipd/admission/' . $patient->user_id), array('name' => 'add', 'id' => 'add', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>

                    <div class="form-row">
                        <div class="col-md-3 mb-10">
                            <label for="name"><?php echo $this->lang->line('name'); ?> <span class="required">*</span></label>
                            <input type="text" class="form-control" name="name" id="name" value="<?php echo isset($patient->name) ?  $patient->name : ''; ?>" placeholder="<?php echo $this->lang->line('name'); ?>" required autocomplete="off">
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="name" class="form-text text-muted">
                                <?php echo form_error('name'); ?>
                            </small>
                        </div>
                        <div class="col-md-1 mb-10">
                            <label for="gender"><?php echo $this->lang->line('gender'); ?> <span class="required">*</span></label>
                            <select class="form-control custom-select" name="gender" id="gender" required>
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php $genders = get_genders(); ?>
                                <?php foreach ($genders as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($patient->gender) && $patient->gender == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                <?php } ?>
                            </select>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="gender" class="form-text text-muted">
                                <?php echo form_error('gender'); ?>
                            </small>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="phone"><?php echo $this->lang->line('phone'); ?> <span class="required">*</span></label>
                            <input type="number" class="form-control" name="phone" id="phone" value="<?php echo isset($patient->phone) ?  $patient->phone : ''; ?>" placeholder="<?php echo $this->lang->line('phone'); ?>" autocomplete="off">
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="phone" class="form-text text-muted">
                                <?php echo form_error('phone'); ?>
                            </small>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="marital_status"><?php echo $this->lang->line('marital_status'); ?></label>
                            <select class="form-control custom-select" name="marital_status" id="marital_status">
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php $marital_status = get_marital_status(); ?>
                                <?php foreach ($marital_status as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($patient->marital_status) && $patient->marital_status == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="guardian_name"><?php echo $this->lang->line('guardian_name'); ?></label>
                            <input type="text" class="form-control" name="guardian_name" id="guardian_name" value="<?php echo isset($patient->guardian_name) ?  $patient->guardian_name : ''; ?>" placeholder="<?php echo $this->lang->line('guardian_name'); ?>" autocomplete="off">
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="address"><?php echo $this->lang->line('address'); ?></label>
                            <input type="text" class="form-control" name="address" id="address" value="<?php echo isset($patient->address) ?  $patient->address : ''; ?>" placeholder="<?php echo $this->lang->line('address'); ?>" autocomplete="off">
                        </div>
                        <div class="col-md-5 mb-10">
                            <label for="doctor_id"><?php echo $this->lang->line('ref_by'); ?></label>
                            <select class="form-control custom-select select2" name="doctor_id" id="doctor_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($doctors as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo isset($doctor_id) && $doctor_id == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-5 mb-10">
                            <label for="reference_id"><?php echo $this->lang->line('reference'); ?></label>
                            <select class="form-control custom-select select2" name="reference_id" id="reference_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($references as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo isset($reference_id) && $reference_id == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="admission_date"><?php echo $this->lang->line('admission'); ?> <?php echo $this->lang->line('date'); ?> <span class="required">*</span></label>
                            <input type="text" class="form-control" name="admission_date" id="admission_date" value="<?php echo isset($admission_date) ?  $admission_date : ''; ?>" placeholder="<?php echo $this->lang->line('admission'); ?> <?php echo $this->lang->line('date'); ?>" required>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="bed_group_id"><?php echo $this->lang->line('admitted'); ?> <?php echo $this->lang->line('ward'); ?> <span class="required">*</span></label>
                            <select class="form-control custom-select select2" name="bed_group_id" id="bed_group_id" required onchange="get_bed(this.value)">
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($bed_groups as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($bed_group_id) && $bed_group_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->floor_name; ?>]</option>
                                <?php } ?>
                            </select>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="bed_group_id" class="form-text text-muted">
                                <?php echo form_error('bed_group_id'); ?>
                            </small>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="bed_id"><?php echo $this->lang->line('bed'); ?> <?php echo $this->lang->line('number'); ?> <span class="required">*</span></label>
                            <select class="form-control custom-select select2" name="bed_id" id="bed_id" required>
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($beds as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($bed_id) && $bed_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="bed_id" class="form-text text-muted">
                                <?php echo form_error('bed_id'); ?>
                            </small>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="contract_person"><?php echo $this->lang->line('contract'); ?> <?php echo $this->lang->line('person'); ?></label>
                            <select class="form-control custom-select select2" name="contract_person" id="contract_person">
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($contracts as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo isset($contract_person) && $contract_person == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="contract_amount"><?php echo $this->lang->line('contract'); ?> <?php echo $this->lang->line('amount'); ?></label>
                            <input type="number" class="form-control" name="contract_amount" id="contract_amount" value="<?php echo isset($contract_amount) ?  $contract_amount : ''; ?>" placeholder="<?php echo $this->lang->line('contract'); ?> <?php echo $this->lang->line('amount'); ?>" autocomplete="off">
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="contract_day"><?php echo $this->lang->line('contract'); ?> <?php echo $this->lang->line('day'); ?></label>
                            <input type="number" min="0" class="form-control" name="contract_day" id="contract_day" value="<?php echo isset($contract_day) ?  $contract_day : ''; ?>" placeholder="<?php echo $this->lang->line('contract'); ?> <?php echo $this->lang->line('day'); ?>">
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="medicine"><?php echo $this->lang->line('medicine'); ?></label>
                            <select class="form-control custom-select" name="medicine" id="medicine">
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php $medicines = get_ipd_medicine(); ?>
                                <?php foreach ($medicines as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($medicine) && $medicine == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="oxygen">Oxygen/Nebulizer</label>
                            <select class="form-control custom-select" name="oxygen" id="oxygen">
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php $oxygens = get_ipd_oxygen(); ?>
                                <?php foreach ($oxygens as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($oxygen) && $oxygen == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="disease"><?php echo $this->lang->line('disease'); ?></label>
                            <select class="form-control custom-select" name="disease" id="disease">
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php $diseases = get_ipd_disease(); ?>
                                <?php foreach ($diseases as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($disease) && $disease == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="case"><?php echo $this->lang->line('case'); ?></label>
                            <input type="text" class="form-control" name="case" id="case" value="<?php echo isset($case) ?  $case : ''; ?>" placeholder="<?php echo $this->lang->line('case'); ?>" autocomplete="off">
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="pulse"><?php echo $this->lang->line('pulse'); ?></label>
                            <input type="text" class="form-control" name="pulse" id="pulse" value="<?php echo isset($pulse) ?  $pulse : ''; ?>" placeholder="<?php echo $this->lang->line('pulse'); ?>" autocomplete="off">
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="bp"><?php echo $this->lang->line('bp'); ?></label>
                            <input type="text" class="form-control" name="bp" id="bp" value="<?php echo isset($bp) ?  $bp : ''; ?>" placeholder="<?php echo $this->lang->line('bp'); ?>" autocomplete="off">
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="temp"><?php echo $this->lang->line('temp'); ?></label>
                            <input type="text" class="form-control" name="temp" id="temp" value="<?php echo isset($temp) ?  $temp : ''; ?>" placeholder="<?php echo $this->lang->line('temp'); ?>" autocomplete="off">
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="height"><?php echo $this->lang->line('height'); ?></label>
                            <input type="text" class="form-control" name="height" id="height" value="<?php echo isset($height) ?  $height : ''; ?>" placeholder="<?php echo $this->lang->line('height'); ?>" autocomplete="off">
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="weight"><?php echo $this->lang->line('weight'); ?></label>
                            <input type="text" class="form-control" name="weight" id="weight" value="<?php echo isset($weight) ?  $weight : ''; ?>" placeholder="<?php echo $this->lang->line('weight'); ?>" autocomplete="off">
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="casualty"><?php echo $this->lang->line('casualty'); ?></label>
                            <select class="form-control custom-select" name="casualty" id="casualty">
                                <option value="0" <?php echo isset($casualty) && $casualty == 0 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('no'); ?></option>
                                <option value="1" <?php echo isset($casualty) && $casualty == 1 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('yes'); ?></option>
                            </select>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="symptoms"><?php echo $this->lang->line('symptoms'); ?></label>
                            <input type="text" class="form-control" name="symptoms" id="symptoms" value="<?php echo isset($symptoms) ?  $symptoms : ''; ?>" placeholder="<?php echo $this->lang->line('symptoms'); ?>" autocomplete="off">
                        </div>
                        
                        <div class="col-md-6 mb-10">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('history'); ?></span>
                                </div>
                                <textarea class="form-control" name="patient_history" id="patient_history" aria-label="<?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('history'); ?>"><?php echo isset($present_address) ?  $present_address : ''; ?></textarea>
                            </div>
                        </div>
                        <div class="col-md-6 mb-10">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('operation'); ?> <?php echo $this->lang->line('note'); ?></span>
                                </div>
                                <textarea class="form-control" name="operation_note" id="operation_note" aria-label="<?php echo $this->lang->line('operation'); ?> <?php echo $this->lang->line('note'); ?>"><?php echo isset($present_address) ?  $present_address : ''; ?></textarea>
                            </div>
                        </div>
                        <div class="col-md-12 mb-10">
                            <label for="remark"><?php echo $this->lang->line('remark'); ?></label>
                            <input type="text" class="form-control" name="remark" id="remark" value="<?php echo isset($remark) ?  $remark : ''; ?>" placeholder="<?php echo $this->lang->line('remark'); ?>" autocomplete="off">
                        </div>
                        <div class="col-md-12 mb-10">
                            <div class="button-list">
                                <input type="hidden" name="patient_id" value="<?php echo $patient->user_id; ?>">
                                <a class="btn btn-gradient-danger" href="<?php echo site_url('ipd/admitted'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                                <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('submit'); ?></button>
                            </div>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important;
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>
<script>
    $(".select2").select2();
    $('#admission_date').daterangepicker({
        singleDatePicker: true,
        startDate: new Date(),
        showDropdowns: true,
        minYear: 1901,
        timePicker: true,
        timePicker24Hour: true,
        timePickerIncrement: 1,
        timePickerSeconds: false,
        autoUpdateInput: true,
        autoApply: true,
        locale: {
            format: 'YYYY-MM-DD HH:mm',
        }
    });
</script>

<script>
    function get_bed(bed_group_id) {
        $.ajax({
            type: "POST",
            url: "<?php echo site_url('ajax/get_bed_group_by_bed'); ?>",
            data: {
                bed_group_id: bed_group_id
            },
            async: false,
            success: function(response) {
                if (response) {
                    $('#bed_id').html(response);
                }
            }
        });
    };
</script>