<!DOCTYPE html>
<html>

<head>
    <title>Print Invoice</title>

    <style>
        body {
            font-family: monospace;
            font-size: 14px;
        }

        .page {
            width: 70%;
            margin: 0 auto;
        }

        @page {
            size: A4;
            margin: 0;
        }

        @media print {

            html,
            body {
                font-family: Arial, Helvetica, sans-serif;
            }

            .page {
                width: 70%;
                margin: 40 auto;
                border: initial;
                border-radius: initial;
                min-height: initial;
                box-shadow: initial;
                background: initial;
                page-break-after: always;
            }
        }

        .patient_copy {
            page-break-after: always;
            display: block;
            margin-top: 0px;
        }

        .diagnostic_copy {
            display: block;
            margin-top: 100px;
        }

        .title {
            width: 30%;
            font-size: 14px;
            font-weight: bold;
            border: 1px solid #333;
            padding: 5px;
            font-family: monospace;
            text-transform: uppercase;
            letter-spacing: 2px;
            border-radius: 3px;
            text-align: center;
            margin: 3px auto;
        }

        .paid {
            width: 25%;
            margin: 30px auto 0 auto;
            text-align: center;
            font-size: 25px;
            font-weight: bold;
            background: #eee;
            border: 1px solid #000;
            padding: 3px 10px;
            font-family: monospace;
            text-transform: uppercase;
            letter-spacing: 5px;
            border-radius: 3px;
        }

        .table {
            font-size: 14px;
            width: 100%;
            border-collapse: collapse;
        }

        .patient_table {
            width: 100%;
            text-align: left;
            border-collapse: collapse;
            margin-top: 15px;
        }

        .patient_table tbody td {
            color: #000;
            padding: 2px;
            vertical-align: top;
            border: 2px solid #000;
        }

        /* test_table */
        .test_table {
            margin-top: 10px;
            width: 100%;
            text-align: left;
            border-collapse: collapse;
            border: 1px solid #000;
        }

        .test_table tbody td {
            color: #000;
            padding: 0px 4px;
            vertical-align: top;
            border-top: 1px solid #000;
        }

        /*  payment_info*/
        .payment_table {
            font-size: 14px;
            width: 100%;
            text-align: left;
        }

        .payment_table tbody td {
            vertical-align: top;
            border: 0;
        }

        .table_sign {
            width: 100%;
            margin-top: 100px;
        }

        .table_less {
            width: 100%;
            margin-top: 20px;
        }
    </style>
</head>

<body>
    <div class="page">
        <table class="table">
            <tr>
                <td rowspan="3" width="10%">
                    <?php if ($this->global_setting->brand_logo) { ?>
                        <img width="80" valign="middle" align="center" src="<?php echo UPLOAD_PATH; ?>logo/<?php echo $this->global_setting->brand_logo; ?>">
                    <?php } else { ?>
                        <img width="80" valign="middle" align="center" src="<?php echo IMG_URL; ?>logo.png">
                    <?php } ?>
                </td>
                <td width="90%" align="center">
                    <h1 style="margin: 0px; padding:0; font-size: 36px;"><?php echo $this->global_setting->brand_title; ?></h1>
                </td>
            </tr>
            <tr>
                <td align="center">
                    <p style="margin: 0px; padding: 0; font-size: 14px;"><?php echo $this->global_setting->address; ?></p>
                </td>
            </tr>
            <tr>
                <td align="center">
                    <p style="margin: 0; font-size: 14px;">Phone: <?php echo $this->global_setting->phone; ?></p>
                </td>
            </tr>
        </table>
        <table class="table">
            <tr>
                <td width="10%">&nbsp;</td>
                <td class="" width="90%" align="center" font-weight: "bold">Indoor Patient Bill</td>
            </tr>
        </table>
        <div class="patient_copy">
            <!-- Patient Info Start-->
            <table class="table patient_table">
                <tr>
                    <td style="width: 35%;">
                        <span>Reg No :</span>
                        <span style="text-transform: uppercase; font-weight: bold;"><?php echo $patient->registration_no; ?></span>
                    </td>
                    <td style="width: 23%;" rowspan="2">
                        <img src="<?php echo site_url('ipd/set_barcode/' . $patient->patient_unique_id); ?>" alt="" height="30" width="100%">
                    </td>
                    <td style="width: 42%;">
                        <span>Invoice ID :</span>
                        <span><?php echo $invoice->custom_invoice_id; ?></span>
                    </td>
                </tr>
                <tr>
                    <td style="width: 35%;">
                        <span>Patient ID :</span>
                        <span style="text-transform: uppercase; font-weight: bold;"><?php echo $patient->patient_unique_id; ?></span>
                    </td>
                    <td style="width: 42%;">
                        <span>Bill Date :</span>
                        <span><?php echo date('d/m/Y h:i A', strtotime($invoice->bill_date)); ?></span>
                    </td>
                </tr>
                <tr>
                    <td colspan="2">
                        <span>Name :</span>
                        <span style="text-transform: uppercase; font-weight: bold;"><?php echo $patient->patient_name; ?></span>
                    </td>
                    <td>
                        <span>Print Date :</span>
                        <span><?php echo date('d/m/Y h:i A'); ?></span>
                    </td>
                </tr>
                <tr>
                    <td>
                        <span>Age :</span>
                        <span style="text-transform: uppercase; font-weight: bold;"><?php echo $patient->dob != NULL ? floor((time() - strtotime($patient->dob)) / 31556926) : ''; ?>Y</span>
                    </td>
                    <td>
                        <span>Gender :</span>
                        <span style="text-transform: capitalize; font-weight: bold;"><?php echo $patient->gender ? $this->lang->line($patient->gender) : ''; ?></span>
                    </td>
                    <td>
                        <span>Contact No :</span>
                        <span style="text-transform: uppercase; font-weight: bold;"><?php echo $patient->phone; ?></span>
                    </td>
                </tr>
                <tr>
                    <td colspan="3">
                        <span>Ref. By :</span>
                        <span style="font-size:12px; text-transform: uppercase; font-weight: bold;">
                            <?php echo $patient->doctor ? $patient->doctor . ', ' . $patient->specialist : ''; ?>
                        </span>
                    </td>
                </tr>
            </table>
            <!-- Patient Info End-->
            <table class="table patient_table" style="margin: 0;">
                <tbody>
                    <tr>
                        <td style="border-top: 0;" width="50%">
                            <span>Admission Date :</span>
                            <?php echo date('d/m/Y h:ia', strtotime($patient->admission_date)); ?>
                        </td>
                        <td style="border-top: 0;" width="50%">
                            <span>Discharge Date :</span>
                            <?php echo $patient->discharged == 1 ? date('d/m/Y h:ia', strtotime($patient->discharged_date)) : ''; ?>
                        </td>
                    </tr>
                </tbody>
            </table>

            <?php if (isset($invoices) & !empty($invoices)) { ?>
                <table class="test_table">
                    <tbody>
                        <tr>
                            <td width="15%" align="left"><b>SL. No</b></td>
                            <td width="55%" align="left"><b>Service Name</b></td>
                            <td width="5%" align="right"><b>Qty</b></td>
                            <td width="25%" align="right"><b>Amount</b></td>
                        </tr>
                        <?php $count = 1; ?>
                        <?php foreach ($invoices as $obj) { ?>
                            <tr>
                                <td align="left"><?php echo $count++; ?></td>
                                <td align="left"><?php echo $obj->name; ?></td>
                                <td align="left"><?php echo $obj->qty; ?></td>
                                <td align="right"><?php echo $obj->total_rate; ?></td>
                            </tr>
                        <?php } ?>

                        <tr>
                            <td colspan="4">
                                <table class="table">
                                    <tr>
                                        <td width="62%" style="border: 0;">
                                            <div class="paid" style="margin-bottom: 0; padding-bottom: 0;">
                                                <?php if ($invoice->paid_status == 'paid') {
                                                    echo 'Paid';
                                                } else {
                                                    echo 'Due';
                                                } ?>
                                            </div>
                                            <p style="text-align: center; margin-bottom: 20px;"><b>In Word:</b> <span style="font-size: 12px;"><?php echo $this->numbertowords->convert_number($invoice->advanced); ?> Taka Only.</span></p>
                                        </td>
                                        <td width="38%" style="border: 0;">
                                            <table class="table">
                                                <tr>
                                                    <td style="border: 0;text-align: left;">Item Total Tk.</td>
                                                    <td style="border: 0;text-align: right;"><?php echo $invoice->total_bill; ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="border-top: 1px dashed #ccc;text-align: left;">(-)Discount Tk.</td>
                                                    <td style="border-top: 1px dashed #ccc;text-align: right;"><?php echo number_format($invoice->discount, 2); ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="border-top: 1px dashed #ccc;text-align: left;">Net Payable Tk.</td>
                                                    <td style="border-top: 1px dashed #ccc;text-align: right;"><?php echo $invoice->net_payable; ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="border-top: 1px dashed #ccc;text-align: left;">Advance Tk.</td>
                                                    <td style="border-top: 1px dashed #ccc;text-align: right;"><?php echo $invoice->advanced; ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="border-top: 1px dashed #ccc;text-align: left;">Due Tk.</td>
                                                    <td style="border-top: 1px dashed #ccc;text-align: right;"><?php echo $invoice->due_amount; ?></td>
                                                </tr>
                                            </table>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                    </tbody>
                </table>
            <?php } ?>
            <?php if ($invoice->note != NULL) { ?>
                <p style="margin-top:20px;">
                    <b>Remark: </b>
                    <?php echo $invoice->note; ?>
                </p>
            <?php } ?>
            <p style="margin-top: 15px;">
                <span style="font-size: 14px; font-weight: bold;">Prepar By:</span>
                <?php echo $created_by->name; ?>
            </p>
            <table class="table_sign">
                <tr>
                    <td width="40%" align="left">Investigation Due:</td>
                    <td width="30%" align="center">Pharmacy Due:</td>
                    <td width="30%" align="right">Signature</td>
                </tr>
            </table>
            <table class="table_less">
                <tr>
                    <td width="45%" align="left">Investigation Less:</td>
                    <td width="55%" align="left">Pharmacy Less:</td>
                </tr>
            </table>
        </div>
    </div>
</body>

</html>