<!-- col-lg-12 -->
<div class="col-lg-12">
    <div class="card">
        <div class="card-header d-flex justify-content-between">
            <?php if (has_permission(VIEW, 'ipd', 'ipd')) { ?>
                <h6 class="card-header d-flex align-items-center">
                    <i class="fa fa-user font-30 mr-10"></i>
                    <?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('info'); ?>
                </h6>
            <?php } ?>
            <?php $bed_empty = $this->ipd->get_single('ipd_beds', array('ipd_id' => $patient->id, 'patient_id' => $patient->patient_id, 'discharged' => 1)); ?>
            <div class="align-items-center">
                <?php if (isset($bed_empty) && $bed_empty) { ?>
                    <?php if (has_permission(ADD, 'ipd', 'ipd')) { ?>
                        <a class="btn btn-xs btn-danger" href="<?php echo site_url('ipd/create/' . $patient->id); ?>">
                            <i class="fa fa-money"></i>
                            <?php echo $this->lang->line('bill'); ?>
                        </a>
                    <?php } ?>
                <?php } else { ?>
                    <?php if ($patient->discharged == 0) { ?>
                        <?php if (has_permission(ADD, 'ipd', 'ipd')) { ?>
                            <button type="button" onclick="dischargePatient('<?php echo $patient->id; ?>')" class="btn btn-xs btn-danger" data-toggle="modal" data-target="#dischargePatientModal">
                                <i class="fa fa-hospital-o"></i>
                                <?php echo $this->lang->line('discharge'); ?>
                            </button>
                        <?php } ?>
                    <?php } ?>
                <?php } ?>
                <?php if (has_permission(ADD, 'ipd', 'ipd')) { ?>
                    <a href="<?php echo site_url('ipd/admitted'); ?>" class="btn btn-xs btn-success">
                        <i class="fa fa-plus font-12 mr-5"></i>
                        <?php echo $this->lang->line('admitted'); ?> <?php echo $this->lang->line('patient'); ?>
                    </a>
                <?php } ?>
                <?php if (has_permission(VIEW, 'ipd', 'ipd')) { ?>
                    <a href="<?php echo site_url('ipd/discharge'); ?>" class="btn btn-xs btn-danger">
                        <i class="fa fa-ban font-12 mr-5"></i>
                        <?php echo $this->lang->line('discharged'); ?> <?php echo $this->lang->line('patient'); ?>
                    </a>
                <?php } ?>
                <?php if (has_permission(VIEW, 'ipd', 'bill')) { ?>
                    <a href="<?php echo site_url('ipd/bill'); ?>" class="btn btn-xs btn-primary">
                        <i class="fa fa-list font-12 mr-5"></i>
                        <?php echo $this->lang->line('billing'); ?> <?php echo $this->lang->line('list'); ?>
                    </a>
                <?php } ?>
            </div>
        </div>
        <div class="card-body pt-0 pb-0">
            <!-- Patient Information Start-->
            <div class="table-wrap">
                <div class="table-responsive">
                    <table class="table table-sm">
                        <tbody>
                            <tr>
                                <td>
                                    <span class="font-weight-bold"><?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('name'); ?>:</span>
                                    <span class="font-weight-bold text-red"><?php echo $patient->patient_name; ?></span>
                                </td>
                                <td>
                                    <span class="font-weight-bold"><?php echo $this->lang->line('patient_id'); ?></span>
                                    <span class="font-weight-bold text-red"><?php echo $patient->patient_unique_id; ?></span>
                                </td>
                                <td>
                                    <span class="font-weight-bold"><?php echo $this->lang->line('registration_no'); ?> :</span>
                                    <span class="font-weight-bold text-red"><?php echo $patient->registration_no; ?></span>
                                </td>
                                <td>
                                    <span class="font-weight-bold"><?php echo $this->lang->line('admission_id'); ?> :</span>
                                    <span class="font-weight-bold text-red"><?php echo $patient->ipd_no; ?></span>
                                </td>
                                <td>
                                    <span class="font-weight-bold"><?php echo $this->lang->line('age'); ?>: </span>
                                    <span class="font-weight-bold text-red">
                                        <?php echo get_age($patient->dob); ?>
                                    </span>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <span class="font-weight-bold"><?php echo $this->lang->line('gender'); ?> :</span>
                                    <span class="font-weight-bold text-red"><?php echo $patient->gender ? $this->lang->line($patient->gender) : ''; ?></span>
                                </td>
                                <td>
                                    <span class="font-weight-bold"><?php echo $this->lang->line('guardian'); ?>:</span>
                                    <span class="font-weight-bold text-red"><?php echo $patient->guardian_name; ?></span>
                                </td>
                                <td>
                                    <span class="font-weight-bold"><?php echo $this->lang->line('phone'); ?>:</span>
                                    <span class="font-weight-bold text-red"><?php echo $patient->phone; ?></span>
                                </td>
                                <td>
                                    <span class="font-weight-bold"><?php echo $this->lang->line('address'); ?>:</span>
                                    <span class="font-weight-bold text-red"><?php echo $patient->address; ?></span>
                                </td>
                                <td>
                                    <span class="font-weight-bold"><?php echo $this->lang->line('admission'); ?> :</span>
                                    <span class="font-weight-bold text-red">
                                        <?php echo date('d M, Y h:i A', strtotime($patient->admission_date)); ?>
                                    </span>
                                </td>
                            </tr>
                            <tr>
                                <td colspan="3">
                                    <span class="font-weight-bold"><?php echo $this->lang->line('ref_by'); ?> :</span>
                                    <span class="font-weight-bold text-red">
                                        <?php
                                        if ($patient->doctor_id > 0 && !empty($patient->doctor_id)) {
                                            echo $patient->doctor . ', ' . $patient->specialist;
                                        } else {
                                            echo $this->lang->line('self');
                                        } ?>
                                    </span>
                                </td>
                                <td>
                                    <span class="font-weight-bold"><?php echo $this->lang->line('admission'); ?> <?php echo $this->lang->line('ward'); ?> :</span>
                                    <span class="font-weight-bold text-red"><?php echo $patient->ward_name; ?></span>
                                </td>
                                <td>
                                    <span class="font-weight-bold"><?php echo $this->lang->line('admission'); ?> <?php echo $this->lang->line('bed'); ?> :</span>
                                    <span class="font-weight-bold text-red">
                                        <i class="fa fa-bed"></i>
                                        <?php echo $patient->bed; ?> - <?php echo $patient->floor; ?>
                                    </span>
                                </td>
                            </tr>
                            <tr>
                                <td colspan="2">
                                    <span class="font-weight-bold"><?php echo $this->lang->line('reference'); ?> :</span>
                                    <span class="font-weight-bold text-red"><?php echo $patient->reference; ?></span>
                                    </span>
                                </td>
                                <td colspan="2">
                                    <span class="font-weight-bold"><?php echo $this->lang->line('contract'); ?> <?php echo $this->lang->line('person'); ?> :</span>
                                    <span class="font-weight-bold text-red"><?php echo $patient->contract_person; ?></span>
                                </td>
                                <td>
                                    <span class="font-weight-bold"><?php echo $this->lang->line('contract'); ?> <?php echo $this->lang->line('amount'); ?> :</span>
                                    <span class="font-weight-bold text-red"><?php echo $patient->contract_amount; ?></span>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <span class="font-weight-bold"><?php echo $this->lang->line('disease'); ?>:</span>
                                    <span class="font-weight-bold text-red"><?php echo $this->lang->line($patient->disease); ?></span>
                                </td>
                                <td>
                                    <span class="font-weight-bold"><?php echo $this->lang->line('case'); ?>:</span>
                                    <span class="font-weight-bold text-red"><?php echo $patient->case; ?></span>
                                </td>
                                <td colspan="2">
                                    <span class="font-weight-bold"><?php echo $this->lang->line('remark'); ?>:</span>
                                    <span class="font-weight-bold text-red"><?php echo $patient->remark; ?></span>
                                </td>
                                <td>
                                    <span class="font-weight-bold"><?php echo $this->lang->line('created_by'); ?>:</span>
                                    <span class="font-weight-bold text-red"><?php echo $patient->created_by; ?></span>
                                </td>
                            </tr>
                            <tr>
                                <td colspan="2">
                                    <span class="font-weight-bold text-uppercase"><?php echo $this->lang->line('investigation'); ?> <?php echo $this->lang->line('bill'); ?> <?php echo $this->lang->line('due'); ?>:</span>
                                    <span class="font-weight-bold text-red"><?php echo $total_investigation_due ?? 0; ?></span>
                                </td>
                                <td colspan="2">
                                    <span class="font-weight-bold text-uppercase"><?php echo $this->lang->line('pharmacy'); ?> <?php echo $this->lang->line('bill'); ?> <?php echo $this->lang->line('due'); ?>:</span>
                                    <span class="font-weight-bold text-red"><?php echo $total_pharmacy_due ?? 0; ?></span>
                                </td>
                                <td>
                                    <span class="font-weight-bold text-uppercase"><?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('ipd'); ?> <?php echo $this->lang->line('advanced'); ?>:</span>
                                    <span class="font-weight-bold text-red"><?php echo $total_ipd_advanced ?? 0; ?></span>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
            <!-- Patient Information End-->
        </div>
        <div class="card-footer pt-0">
            <div class="button-list">

                <?php if (has_permission(VIEW, 'ipd', 'bed')) { ?>
                    <a class="<?php echo $this->router->fetch_class() == 'bed' ? 'btn btn-gradient-success' : 'btn btn-gradient-primary'; ?>" href="<?php echo site_url('ipd/bed/index/' . $patient->id); ?>">
                        <i class="fa fa-bed"></i>
                        <?php echo $this->lang->line('bed'); ?>
                    </a>
                <?php } ?>

                <?php if (has_permission(VIEW, 'ipd', 'surgeon')) { ?>
                    <a class="<?php echo $this->router->fetch_class() == 'surgeon' ? 'btn btn-gradient-success' : 'btn btn-gradient-primary'; ?>" href="<?php echo site_url('ipd/surgeon/index/' . $patient->id); ?>">
                        <i class="fa fa-user-md"></i>
                        <?php echo $this->lang->line('surgeon'); ?>
                    </a>
                <?php } ?>

                <?php if (has_permission(VIEW, 'ipd', 'anesthesia')) { ?>
                    <a class="<?php echo $this->router->fetch_class() == 'anesthesia' ? 'btn btn-gradient-success' : 'btn btn-gradient-primary'; ?>" href="<?php echo site_url('ipd/anesthesia/index/' . $patient->id); ?>">
                        <i class="fa fa-user-md"></i>
                        <?php echo $this->lang->line('anesthesia'); ?>
                    </a>
                <?php } ?>

                <?php if (has_permission(VIEW, 'ipd', 'assistant')) { ?>
                    <a class="<?php echo $this->router->fetch_class() == 'assistant' ? 'btn btn-gradient-success' : 'btn btn-gradient-primary'; ?>" href="<?php echo site_url('ipd/assistant/index/' . $patient->id); ?>">
                        <i class="fa fa-user-md"></i>
                        <?php echo $this->lang->line('assistant'); ?>
                    </a>
                <?php } ?>

                <?php if (has_permission(VIEW, 'ipd', 'consultant')) { ?>
                    <a class="<?php echo $this->router->fetch_class() == 'consultant' ? 'btn btn-gradient-success' : 'btn btn-gradient-primary'; ?>" href="<?php echo site_url('ipd/consultant/index/' . $patient->id); ?>">
                        <i class="fa fa-user-md"></i>
                        <?php echo $this->lang->line('consultant'); ?>
                    </a>
                <?php } ?>

                <?php if (has_permission(VIEW, 'ipd', 'charge')) { ?>
                    <a class="<?php echo $this->router->fetch_class() == 'charge' ? 'btn btn-gradient-success' : 'btn btn-gradient-primary'; ?>" href="<?php echo site_url('ipd/charge/index/' . $patient->id); ?>">
                        <i class="fa fa-money"></i>
                        <?php echo $this->lang->line('charge'); ?>
                    </a>
                <?php } ?>

                <a class="<?php echo $this->router->fetch_class() == 'payment' ? 'btn btn-gradient-success' : 'btn btn-gradient-primary'; ?>" href="<?php echo site_url('ipd/payment/index/' . $patient->id); ?>">
                    <i class="fa fa-usd"></i>
                    <?php echo $this->lang->line('payment'); ?>
                </a>

                <a class="<?php echo $this->router->fetch_class() == 'bill' ? 'btn btn-gradient-success' : 'btn btn-gradient-primary'; ?>" href="<?php echo site_url('ipd/bill/index/' . $patient->id); ?>">
                    <i class="fa fa-file-text-o"></i>
                    <?php echo $this->lang->line('bill'); ?>
                </a>

                <?php if (has_permission(VIEW, 'ipd', 'medicine')) { ?>
                    <a class="<?php echo $this->router->fetch_class() == 'medicine' ? 'btn btn-gradient-success' : 'btn btn-gradient-primary'; ?>" href="<?php echo site_url('ipd/medicine/index/' . $patient->id); ?>">
                        <i class="fa fa-medkit"></i>
                        <?php echo $this->lang->line('medicine'); ?>
                    </a>
                <?php } ?>

                <?php if (has_permission(VIEW, 'ipd', 'pulsebp')) { ?>
                    <a class="<?php echo $this->router->fetch_class() == 'pulsebp' ? 'btn btn-gradient-success' : 'btn btn-gradient-primary'; ?>" href="<?php echo site_url('ipd/pulsebp/index/' . $patient->id); ?>">
                        <i class="fa fa-heartbeat"></i>
                        <?php echo $this->lang->line('pulse_bp'); ?>
                    </a>
                <?php } ?>

                <?php if (has_permission(VIEW, 'ipd', 'followup')) { ?>
                    <a class="<?php echo $this->router->fetch_class() == 'followup' ? 'btn btn-gradient-success' : 'btn btn-gradient-primary'; ?>" href="<?php echo site_url('ipd/followup/index/' . $patient->id); ?>">
                        <i class="fa fa-share-square-o"></i>
                        <?php echo $this->lang->line('follow_up'); ?>
                    </a>
                <?php } ?>

                <?php if (has_permission(VIEW, 'ipd', 'diagnosis')) { ?>
                    <a class="<?php echo $this->router->fetch_class() == 'diagnosis' ? 'btn btn-gradient-success' : 'btn btn-gradient-primary'; ?>" href="<?php echo site_url('ipd/diagnosis/index/' . $patient->id); ?>">
                        <i class="fa fa-stethoscope"></i>
                        <?php echo $this->lang->line('diagnosis'); ?>
                    </a>
                <?php } ?>

                <?php if (has_permission(VIEW, 'ipd', 'timeline')) { ?>
                    <a class="<?php echo $this->router->fetch_class() == 'timeline' ? 'btn btn-gradient-success' : 'btn btn-gradient-primary'; ?>" href="<?php echo site_url('ipd/timeline/index/' . $patient->id); ?>">
                        <i class="fa fa-history"></i>
                        <?php echo $this->lang->line('timeline'); ?>
                    </a>
                <?php } ?>
                <?php if (has_permission(VIEW, 'ipd', 'prescription')) { ?>
                    <a class="<?php echo $this->router->fetch_class() == 'prescription' ? 'btn btn-gradient-success' : 'btn btn-gradient-primary'; ?>" href="<?php echo site_url('ipd/prescription/index/' . $patient->id); ?>">
                        <i class="fa fa-file-text"></i>
                        <?php echo $this->lang->line('prescription'); ?>
                    </a>
                <?php } ?>
            </div>
        </div>
    </div>
</div>


<!-- Add Discharge Patient Modal-->
<div class="modal fade" id="dischargePatientModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalForms" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('discharge'); ?> <?php echo $this->lang->line('patient'); ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <form id="dischargePatientForm" enctype="multipart/form-data" method="POST" action="<?php echo site_url('ipd/dischargePatient'); ?>">
                <div class="modal-body">
                    <div class="form-row">
                        <div class="col-md-6 mb-10">
                            <label for="to_date"><?php echo $this->lang->line('date'); ?></label>
                            <input type="text" class="form-control" name="to_date" id="to_date" value="<?php echo isset($to_date) ?  $to_date : ''; ?>" placeholder="<?php echo $this->lang->line('date'); ?>" required>
                        </div>
                        <div class="col-md-6 mb-10">
                            <label for="note"><?php echo $this->lang->line('remark'); ?></label>
                            <input type="text" class="form-control" name="note" id="note" value="<?php echo isset($note) ?  $note : ''; ?>" placeholder="<?php echo $this->lang->line('remark'); ?>">
                        </div>
                    </div>
                </div>
                <div class="modal-footer pt-0">
                    <div class="button-list">
                        <input type="hidden" name="id" id="ipd_id">
                        <input type="hidden" name="patient_id" id="patient_id">
                        <input type="hidden" name="bed_group_id" id="bed_group_id">
                        <input type="hidden" name="bed_id" id="bed_id">
                        <button type="button" class="btn btn-gradient-danger" data-dismiss="modal"><?php echo $this->lang->line('cancel'); ?></button>
                        <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('submit'); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
    function dischargePatient(id) {
        $.ajax({
            url: '<?php echo site_url('ipd/get_single_ipd/') ?>' + id,
            dataType: 'json',
            success: function(data) {
                $('#ipd_id').val(data.id);
                $('#patient_id').val(data.patient_id);
                $('#bed_group_id').val(data.bed_group_id);
                $('#bed_id').val(data.bed_id);
            }
        });
    }
</script>


<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>

<script>
    $('#to_date').daterangepicker({
        singleDatePicker: true,
        startDate: new Date(),
        showDropdowns: true,
        minYear: 1901,
        timePicker: true,
        timePicker24Hour: true,
        timePickerIncrement: 1,
        timePickerSeconds: false,
        autoUpdateInput: true,
        autoApply: true,
        locale: {
            format: 'YYYY-MM-DD HH:mm',
        }
    });
</script>