<!DOCTYPE html>
<html>

<head>
    <title>IPD</title>
    <style>
        body {
            font-family: "Time New Roman";
            font-size: 13px;
        }

        .page {
            width: 100%;
            margin: 0 auto;
        }

        .main_body {
            margin-top: 10px;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
        }

        .title {
            width: 50%;
            font-size: 14px;
            font-weight: bold;
            border: 1px solid #333;
            padding: 5px;
            font-family: monospace;
            text-transform: uppercase;
            letter-spacing: 2px;
            border-radius: 3px;
            text-align: center;
            margin: 3px auto;
        }

        .patient_info {
            margin-bottom: 10px;
        }

        .patient_info tbody td {
            padding: 4px 4px;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 14px;
        }

        .hospital_info {
            margin-bottom: 10px;
        }

        .hospital_info tbody td {
            padding: 4px 4px;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 14px;
        }

        .bed_info {
            margin-bottom: 10px;
        }

        .bed_info tbody td {
            padding: 4px 4px;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 14px;
        }

        .nurse_info {
            margin-bottom: 10px;
        }

        .nurse_info tbody td {
            padding: 4px 4px;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 14px;
        }

        .history {
            margin-top: 20px;
        }

        .button {
            border: 1px solid #000;
            border-radius: 5px;
            padding: 5px;
            font-size: 15px;
            display: inline-block;
            margin: 5px;
        }

        .signature_info {
            margin-top: 60px;
        }
    </style>
</head>

<body>
    <div class="page">
        <div class="main_body">
            <table class="table">
                <tr>
                    <td rowspan="3" width="10%">
                        <?php if ($this->global_setting->brand_logo) { ?>
                            <img width="80" valign="middle" align="center" src="<?php echo UPLOAD_PATH; ?>logo/<?php echo $this->global_setting->brand_logo; ?>">
                        <?php } else { ?>
                            <img width="80" valign="middle" align="center" src="<?php echo IMG_URL; ?>logo.png">
                        <?php } ?>
                    </td>
                    <td width="90%" align="center">
                        <h1 style="margin: 0px; padding:0; font-size: 36px;"><?php echo $this->global_setting->brand_title; ?></h1>
                    </td>
                </tr>
                <tr>
                    <td align="center">
                        <p style="margin: 0px; padding: 0; font-size: 14px;"><?php echo $this->global_setting->address; ?></p>
                    </td>
                </tr>
                <tr>
                    <td align="center">
                        <p style="margin: 0; font-size: 14px;">Phone: <?php echo $this->global_setting->phone; ?></p>
                    </td>
                </tr>
            </table>
            <table class="table">
                <tr>
                    <td width="10%">&nbsp;</td>
                    <td class="" width="90%" align="center" font-weight: "bold">Patient Admission Form</td>
                </tr>
            </table>
            <table class="table patient_info">
                <tbody>
                    <tr>
                        <td width="20%"><b>Patient Name</b></td>
                        <td width="25%"><?php echo $patient->patient_name; ?></td>
                        <td width="15%"><b>Age</b></td>
                        <td width="20%"><?php echo get_age($patient->dob); ?></td>
                        <td width="10%"><b>Gender</b></td>
                        <td width="15%"><?php echo $patient->gender ? $this->lang->line($patient->gender) : ''; ?></td>
                    </tr>
                    <tr>
                        <td><b>Guardian Name</b></td>
                        <td><?php echo $patient->guardian_name; ?></td>
                        <td><b>Marital Status</b></td>
                        <td colspan="3"><?php echo $patient->marital_status ? $this->lang->line($patient->marital_status) : ''; ?></td>
                    </tr>
                    <tr>
                        <td><b>Address</b></td>
                        <td><?php echo $patient->address; ?></td>
                        <td><b>Mobile</b></td>
                        <td colspan="3"><?php echo $patient->phone; ?></td>
                    </tr>
                </tbody>
            </table>

            <!-- Patient Info -->
            <table class="table">
                <tbody>
                    <tr>
                        <td width="75%">
                            <table class="table hospital_info">
                                <tbody>
                                    <tr>
                                        <td width="24%"><b>Patient ID</b></td>
                                        <td width="26%"><?php echo $patient->patient_unique_id; ?></td>
                                        <td width="24%"><b>IPD Reg.</b></td>
                                        <td width="26%"><?php echo $patient->registration_no; ?></td>
                                    </tr>
                                    <tr>
                                        <td><b>Date Of Admission</b></td>
                                        <td>
                                            <?php echo $patient->admission_date ? date('d/m/Y h:ia', strtotime($patient->admission_date)) : ''; ?>
                                        </td>
                                        <td><b>Date of Discharge</b></td>
                                        <td></td>
                                    </tr>
                                    <tr>
                                        <td><b>Disease</b></td>
                                        <td><?php echo $this->lang->line($patient->disease); ?></td>
                                        <td><b>Case</b></td>
                                        <td><?php echo $patient->case; ?></td>
                                    </tr>
                                    <tr>
                                        <td width="24%"><b>Refd. By</b></td>
                                        <td colspan="3" style="font-size: 12px;">
                                            <?php
                                            if ($patient->doctor_id > 0 && !empty($patient->doctor_id)) {
                                                echo $patient->doctor . ', ' . $patient->specialist;
                                            } else {
                                                echo $this->lang->line('self');
                                            } ?>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </td>
                        <td width="1%"></td>
                        <!-- Right Table -->
                        <td width="24%">
                            <table class="table bed_info">
                                <tbody>
                                    <tr>
                                        <td width="70%"><b>Bed/Cabin No</b></td>
                                        <td width="30%"><b>Signature</b></td>
                                    </tr>
                                    <tr>
                                        <td><?php echo $patient->bed; ?></td>
                                        <td>&nbsp;</td>
                                    </tr>
                                    <tr>
                                        <td>&nbsp;</td>
                                        <td>&nbsp;</td>
                                    </tr>
                                    <tr>
                                        <td>&nbsp;</td>
                                        <td>&nbsp;</td>
                                    </tr>
                                </tbody>
                            </table>
                        </td>
                    </tr>
                </tbody>
            </table>

            <!-- Particular Table -->

            <!-- <table class="table nurse_info">
                <tbody>
                    <tr>
                        <td width="40%"><b>Particular</b></td>
                        <td width="20%"><b>Time</b></td>
                        <td width="40%"><b>Name of duty nurse</b></td>
                    </tr>
                    <tr>
                        <td>Time of patient received</td>
                        <td></td>
                        <td></td>
                    </tr>
                    <tr>
                        <td>Time of treatment starting</td>
                        <td></td>
                        <td></td>
                    </tr>
                </tbody>
            </table> -->

            <table class="table nurse_info">
                <tbody>
                    <tr>
                        <td width="25%">Contract Days</td>
                        <td width="25%"><?php echo $patient->contract_day > 0 ? $patient->contract_day : ''; ?></td>
                        <td width="25%">All Medicine</td>
                        <td width="25%"><?php echo $patient->medicine != null ? $this->lang->line($patient->medicine) : ''; ?></td>
                    </tr>
                    <tr>
                        <td>Contract Amount</td>
                        <td><?php echo $patient->contract_amount > 0 ? $patient->contract_amount : ''; ?></td>
                        <td>Oxygen/Nebulizer</td>
                        <td><?php echo $patient->medicine != null ? $this->lang->line($patient->oxygen) : ''; ?></td>
                    </tr>
                    <tr>
                        <td>Advanced Amount</td>
                        <td><?php echo get_ipd_advanced_amount($patient->id, $patient->patient_id); ?></td>
                        <td>Bed Rent Each Day</td>
                        <td><?php echo $patient->bed_price; ?></td>
                    </tr>
                    <tr>
                        <td>Number of Extra Attendant</td>
                        <td></td>
                        <td>Service Charge Each Day</td>
                        <td></td>
                    </tr>
                    <tr>
                        <td>Reference</td>
                        <td colspan="3">
                            <?php echo $patient->reference_id ? $patient->reference : '' ?>
                            - <?php echo $patient->reference_id ? $patient->reference_phone : '' ?>
                        </td>
                    </tr>
                </tbody>
            </table>

            <table>
                <tbody>
                    <td>
                        <b>Time of Receiving Patient </b>
                    </td>
                    <td>
                        <span style="display: block; width: 200px; height: 30px; border: 1px solid #000;">&nbsp;</span>
                    </td>
                </tbody>
            </table>

            <!-- History of the patient -->
            <table class="table history" style="margin-top: 5">
                <tbody>
                    <tr style="border: 1px solid #000; border-radius: 5px;">
                        <td valign="top" style="height: 110px;">
                            <b class="button">History of the patient</b>
                            <p style="text-align: justify; padding: 5px; margin: 0;">
                                <?php echo $patient->patient_history; ?>
                            </p>
                        </td>
                    </tr>
                    <tr style="height: 10px;">
                        <td>&nbsp;</td>
                    </tr>
                    <tr style="border: 1px solid #000; border-radius: 5px;">
                        <td valign="top" style="height: 300px;">
                            <b class="button">Operation Note/Conservative Treatment</b>
                            <p style="text-align: justify; padding: 5px; margin: 0;">
                                <?php echo $patient->operation_note; ?>
                            </p>
                        </td>
                    </tr>
                </tbody>
            </table>

            <table class="table signature_info">
                <tbody>
                    <tr>
                        <td width="80%">
                            <b>Prepared by: </b> <?php echo $patient->created_by; ?>
                        </td>
                        <td width="20%">
                            <b>Signature</b>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</body>

</html>