<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item" aria-current="page"><?php echo $this->lang->line('message'); ?></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('opd'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('opd_patient'); ?> <?php echo $this->lang->line('sms'); ?>
        </h4>
        <div class="d-flex">
            <?php if (has_permission(VIEW, 'message', 'ipd')) { ?>
                <a href="<?php echo site_url('message/ipd'); ?>" class="btn btn-primary btn-sm mr-10">
                    <i class="fa fa-bed"></i>
                    <?php echo $this->lang->line('send'); ?> <?php echo $this->lang->line('ipd'); ?>
                </a>
            <?php } ?>

            <?php if (has_permission(VIEW, 'message', 'employee')) { ?>
                <a href="<?php echo site_url('message/employee'); ?>" class="btn btn-success btn-sm mr-10">
                    <i class="fa fa-users"></i>
                    <?php echo $this->lang->line('send'); ?> <?php echo $this->lang->line('employee'); ?>
                </a>
            <?php } ?>

            <?php if (has_permission(VIEW, 'message', 'doctor')) { ?>
                <a href="<?php echo site_url('message/doctor'); ?>" class="btn btn-info btn-sm mr-10">
                    <i class="fa fa-user-md"></i>
                    <?php echo $this->lang->line('send'); ?> <?php echo $this->lang->line('doctor'); ?>
                </a>
            <?php } ?>

            <?php if (has_permission(VIEW, 'message', 'vd')) { ?>
                <a href="<?php echo site_url('message/vd'); ?>" class="btn btn-warning btn-sm mr-10">
                    <i class="fa fa-user-md"></i>
                    <?php echo $this->lang->line('send'); ?> <?php echo $this->lang->line('vd'); ?>
                </a>
            <?php } ?>

            <?php if (has_permission(VIEW, 'message', 'patient')) { ?>
                <a href="<?php echo site_url('message/patient'); ?>" class="btn btn-pink btn-sm mr-10">
                    <i class="fa fa-user"></i>
                    <?php echo $this->lang->line('send'); ?> <?php echo $this->lang->line('patient'); ?>
                </a>
            <?php } ?>
        </div>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <?php echo form_open_multipart(site_url('message/opd/add'), array('name' => 'search', 'id' => 'search', 'method' => 'get'), ''); ?>
                    <div class="form-row">
                        <div class="col-md-2 mb-10">
                            <label for="type"><?php echo $this->lang->line('type'); ?></label>
                            <select class="form-control custom-select select2" name="type" id="type">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('all'); ?></option>
                                <option value="1" <?php echo isset($type) && $type == 1 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('complete'); ?></option>
                                <option value="2" <?php echo isset($type) && $type == 2 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('rejected'); ?></option>
                                <option value="3" <?php echo isset($type) && $type == 3 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('reference'); ?></option>
                                <option value="4" <?php echo isset($type) && $type == 4 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('no_reference'); ?></option>
                            </select>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="date"><?php echo $this->lang->line('date'); ?></label>
                            <input type="text" class="form-control" name="date" id="range" value="<?php echo isset($date) ?  $date : ''; ?>" placeholder="<?php echo $this->lang->line('date'); ?>" required>
                            <small id="date" class="form-text text-muted">
                                <?php echo form_error('date'); ?>
                            </small>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="doctor_id"><?php echo $this->lang->line('doctor'); ?></label>
                            <select class="form-control custom-select select2" name="doctor_id" id="doctor_id" required>
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('doctor'); ?></option>
                                <?php foreach ($doctors as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo isset($doctor_id) && $doctor_id == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                <?php } ?>
                            </select>
                            <small id="doctor_id" class="form-text text-muted">
                                <?php echo form_error('doctor_id'); ?>
                            </small>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="reference_id"><?php echo $this->lang->line('reference'); ?></label>
                            <select class="form-control custom-select select2" name="reference_id" id="reference_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('reference'); ?></option>
                                <?php foreach ($references as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo isset($reference_id) && $reference_id == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-1">
                            <button class="btn btn-gradient-primary mt-35" type="submit"><?php echo $this->lang->line('search'); ?></button>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>

        <?php if ($_GET && $this->input->get('date') && $this->input->get('doctor_id')) { ?>
            <!-- col-lg-12 -->
            <div class="col-lg-12">
                <?php echo form_open_multipart(site_url('message/opd/send'), array('name' => 'add', 'id' => 'add', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                <div class="row">
                    <div class="col-md-8">
                        <div class="card">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <?php if (has_permission(VIEW, 'message', 'opd')) { ?>
                                    <h6 class="card-header d-flex align-items-center">
                                        <i class="fa fa-user-md font-30 mr-10"></i>
                                        <?php echo $this->lang->line('opd_patient'); ?> <?php echo $this->lang->line('list'); ?>
                                    </h6>
                                <?php } ?>
                                <h6>
                                    Doctor: <small><?php echo $doctor->name; ?></small>
                                </h6>
                            </div>
                            <div class="card-body p-0">
                                <div class="table-wrap">
                                    <div class="table-responsive">
                                        <table class="table table-sm table-striped mb-0">
                                            <thead>
                                                <tr>
                                                    <th><?php echo $this->lang->line('sl_no'); ?></th>
                                                    <th><?php echo $this->lang->line('name'); ?></th>
                                                    <th><?php echo $this->lang->line('phone'); ?></th>
                                                    <th><?php echo $this->lang->line('reference'); ?></th>
                                                    <th><?php echo $this->lang->line('last'); ?> <?php echo $this->lang->line('visit'); ?></th>
                                                    <th>
                                                        <div class="custom-control custom-checkbox checkbox-success">
                                                            <input type="checkbox" class="custom-control-input" id="fn_check" value="1" checked />
                                                            <label class="custom-control-label" for="fn_check"><?php echo $this->lang->line('check_all'); ?></label>
                                                        </div>
                                                    </th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $sl = 1;
                                                if (isset($opd_patients) && !empty($opd_patients)) { ?>
                                                    <?php foreach ($opd_patients as $obj) { ?>
                                                        <tr>
                                                            <td><?php echo $sl++; ?></td>
                                                            <td>
                                                                <div class="d-flex justify-content-left align-items-center">
                                                                    <div class="avatar avatar-sm mr-10">
                                                                        <?php if ($obj->photo) { ?>
                                                                            <img src="<?php echo UPLOAD_PATH; ?>patient-photo/<?php echo $obj->photo; ?>" alt="user" class="avatar-img rounded-circle">
                                                                        <?php } elseif ($obj->gender == 'male') { ?>
                                                                            <img src="<?php echo IMG_URL; ?>male.png" alt="male" class="avatar-img rounded-circle">
                                                                        <?php } else { ?>
                                                                            <img src="<?php echo IMG_URL; ?>female.png" alt="female" class="avatar-img rounded-circle">
                                                                        <?php }  ?>
                                                                    </div>
                                                                    <div class="d-flex flex-column">
                                                                        <a target="_blank" href="<?php echo site_url('opd/profile/' . $obj->patient_id); ?>" class="text-primary">
                                                                            <span class="fw-bold"><?php echo $obj->patient_name; ?></span>
                                                                        </a>
                                                                        <small class="text-muted"><?php echo $obj->patient_unique_id; ?></small>
                                                                    </div>
                                                                </div>
                                                            </td>
                                                            <td><?php echo $obj->phone; ?></td>
                                                            <td><?php echo $obj->reference; ?></td>
                                                            <td><?php echo date('d M, Y', strtotime($obj->last_visit)); ?></td>
                                                            <td>
                                                                <input type="hidden" value="<?php echo $obj->phone; ?>" name="phone[<?php echo $obj->patient_id; ?>]" />
                                                                <div class="custom-control custom-checkbox">
                                                                    <input type="checkbox" class="custom-control-input fn_check" name="patients[]" id="check_<?php echo $obj->patient_id; ?>" value="<?php echo $obj->patient_id; ?>" checked />
                                                                    <label class="custom-control-label" for="check_<?php echo $obj->patient_id; ?>">Send</label>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                    <?php } ?>
                                                <?php } else { ?>
                                                    <tr class="text-center">
                                                        <td colspan="6"><?php echo $this->lang->line('no_data_found'); ?></td>
                                                    </tr>
                                                <?php } ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Right Side -->
                    <div class="col-md-4">
                        <div class="card">
                            <div class="card-body">
                                <div class="form-group">
                                    <label for="address">Message</label>
                                    <textarea rows="6" class="form-control" name="body" id="body"></textarea>
                                    <div class="valid-feedback">
                                        <?php echo $this->lang->line('looks_good'); ?>
                                    </div>
                                    <small id="body" class="form-text text-muted">
                                        <?php echo form_error('body'); ?>
                                    </small>
                                </div>
                                <div class="mt-10">
                                    <span class="fw-bold text-danger">Tags:</span> [name], [phone], [email], [gender], [address], [patient_unique_id]
                                </div>
                            </div>
                            <!-- Card Footer -->
                            <div class="card-footer pt-0 justify-content-end">
                                <div class="button-list">
                                    <a class="btn btn-gradient-danger" href="<?php echo site_url('message/opd/add'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                                    <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('send'); ?></button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        <?php } ?>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->


<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important;
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>
<script>
    $('#fn_check').click(function() {
        if ($(this).is(':checked')) {
            $(".fn_check").prop("checked", true);
        } else {
            $(".fn_check").prop("checked", false);
        }
    });

    $(".select2").select2();
    $('#range').daterangepicker({
        startDate: new Date(),
        endDate: moment(),
        showDropdowns: true,
        minYear: 1901,
        locale: {
            format: 'YYYY/MM/DD',
        },
        ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Tomorrow': [moment().subtract(-1, 'days'), moment().subtract(-1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'This Year': [moment().startOf('year'), moment().endOf('year')],
            'Last Year': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')]
        }
    });
</script>