<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item" aria-current="page"><?php echo $this->lang->line('message'); ?></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('send'); ?> <?php echo $this->lang->line('sms'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('send'); ?> <?php echo $this->lang->line('sms'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(ADD, 'message', 'sms')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-envelope-o font-30 mr-10"></i>
                            <?php echo $this->lang->line('send'); ?> <?php echo $this->lang->line('sms'); ?>
                        </h6>
                    <?php } ?>
                    <?php if (has_permission(VIEW, 'message', 'sms')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('message/sms'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-list font-12 mr-5"></i>
                                <?php echo $this->lang->line('sms'); ?> <?php echo $this->lang->line('list'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>

                <?php echo form_open_multipart(site_url('message/sms/add'), array('name' => 'add', 'id' => 'add', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                <div class="card-body">
                    <div class="form-row">
                        <div class="col-md-5 mb-10">
                            <label for="role_id"><?php echo $this->lang->line('receiver'); ?> <?php echo $this->lang->line('type'); ?></label>
                            <select class="form-control custom-select" name="role_id" id="role_id" required>
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('type'); ?></option>
                                <?php foreach ($roles as $obj) { ?>
                                    <?php if ($this->session->userdata('role_id') != SUPER_ADMIN) { ?>
                                        <?php if (in_array($obj->id, array(SUPER_ADMIN))) {
                                            continue;
                                        } ?>
                                    <?php } ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($role_id) && $role_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>
                        <div class="col-md-7 mb-10">
                            <label for="receiver_id"><?php echo $this->lang->line('receiver'); ?></label>
                            <select class="form-control custom-select select2" name="receiver_id" id="receiver_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('receiver'); ?></option>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-12 mt-10 mb-10">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('message'); ?></span>
                                </div>
                                <textarea rows="6" class="form-control" required name="body" id="body" onKeyDown="limitText(this.value);" onKeyUp="limitText(this.value);" aria-label="<?php echo $this->lang->line('message'); ?>"><?php echo isset($message) ?  $message : ''; ?></textarea>
                                <div class="valid-feedback">
                                    <?php echo $this->lang->line('looks_good'); ?>
                                </div>
                            </div>
                            <div class="help-block w-100 text_count">
                                Text Count: 0
                            </div>
                        </div>
                        <div id="tags" class="col-md-12 mt-10 mb-10 d-none">
                          <span class="fw-bold text-danger">Tags:</span>  [name], [phone], [email], [designation], [gender], [present_address], [patient_unique_id], [address]
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <div class="card-footer pt-0">
                    <div class="button-list">
                        <a class="btn btn-gradient-danger" href="<?php echo site_url('message/sms'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                        <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('submit'); ?></button>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important;
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>
<script type="text/javascript">
    $(".select2").select2();

    function get_user_by_role(role_id) {
        $.ajax({
            type: "POST",
            url: "<?php echo site_url('ajax/get_user_by_role'); ?>",
            data: {
                role_id: role_id
            },
            async: false,
            success: function(response) {
                if (response) {
                    $('#receiver_id').html(response);
                    $('#tags').removeClass('d-none');
                }
            }
        });
    }

    function limitText(text) {
        $('.text_count').text('Text Count:' + (text.length));
    }
</script>