<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Opd_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }

    public function get_doctor_list() {
        $this->db->select('C.*, E.*');
        $this->db->from('doctor_charges AS C');
        $this->db->join('employees AS E', 'E.user_id = C.doctor_id', 'left');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('U.role_id', DOCTOR);
        $this->db->where('E.status', 1);
        $this->db->order_by('E.id', 'ASC');
        return $this->db->get()->result();
    }

    public function get_employee_list() {
        $this->db->select('E.*');
        $this->db->from('employees AS E');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('E.status', '1');
        if ($this->session->userdata('role_id') == SUPER_ADMIN) {
            $this->db->where_in('U.role_id', array(SUPER_ADMIN, ADMIN, ACCOUNTANT, RECEPTIONIST));
        } else {
            $this->db->where_in('U.role_id', array(ADMIN, ACCOUNTANT, RECEPTIONIST));
        }
        $this->db->order_by('E.id ', 'DESC');
        return $this->db->get()->result();
    }


    public function get_opd_patient_list($limit, $offset, $collection_type, $keyword, $form_date, $to_date, $doctor_id, $reference_id, $created_by, $count) {
        $this->db->select('OP.*, MAX(OP.appointment_date) as last_visit, P.patient_unique_id, P.name as patient_name, P.phone, P.address, P.gender, P.photo, D.name as doctor, R.name as reference');
        $this->db->from('opd_patients AS OP');
        $this->db->join('patients AS P', 'P.user_id = OP.patient_id', 'left');
        $this->db->join('users AS U', 'U.id = P.user_id', 'left');
        $this->db->join('employees AS D', 'D.user_id = OP.doctor_id', 'left');
        $this->db->join('employees AS R', 'R.user_id = OP.reference_id', 'left');
        if ($collection_type == 1) {
            $this->db->where('OP.payment_status', 'complete');
        }
        if ($collection_type == 2) {
            $this->db->where('OP.payment_status', 'rejected');
        }
        if ($collection_type == 3) {
            $this->db->where('OP.reference_id >', 0);
        }
        if ($collection_type == 4) {
            $this->db->group_start();
            $this->db->where('Op.reference_id', 0);
            $this->db->or_where('OP.reference_id', NULL);
            $this->db->or_where('OP.reference_id', '');
            $this->db->group_end();
        }
        if ($keyword) {
            $this->db->like('P.patient_unique_id', $keyword);
            $this->db->or_like('P.phone', $keyword);
            $this->db->or_like('P.name', $keyword, 'both');
        }
        if ($form_date && $to_date) {
            $this->db->where("DATE(OP.created_at) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($doctor_id) {
            $this->db->where('OP.doctor_id', $doctor_id);
        }
        if ($reference_id) {
            $this->db->where('OP.reference_id', $reference_id);
        }
        if ($created_by) {
            $this->db->where('OP.created_by', $created_by);
        }
        $this->db->where('OP.payment_status', 'complete');
        $this->db->order_by('OP.created_at', 'DESC');
        $this->db->group_by('OP.patient_id');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    public function get_single_patient($user_id) {
        $this->db->select('P.*');
        $this->db->from('patients AS P');
        $this->db->join('users AS U', 'U.id = P.user_id', 'left');
        $this->db->join('roles AS R', 'R.id = U.role_id', 'left');
        $this->db->where('P.user_id', $user_id);
        return $this->db->get()->row();
    }

    public function get_opd_patient_details($limit, $offset, $patient_id, $search, $count) {
        $this->db->select('OP.*, D.name as doctor, R.name as reference');
        $this->db->from('opd_patients AS OP');
        $this->db->join('patients AS P', 'P.user_id = OP.patient_id', 'left');
        $this->db->join('employees AS D', 'D.user_id = OP.doctor_id', 'left');
        $this->db->join('employees AS R', 'R.user_id = OP.reference_id', 'left');
        if ($search) {
            $this->db->group_start();
            $this->db->like('P.patient_unique_id', $search);
            $this->db->or_like('P.phone', $search);
            $this->db->or_like('P.name', $search, 'both');
            $this->db->or_like('OP.custom_invoice_id', $search, 'both');
            $this->db->group_end();
        }
        $this->db->where('OP.patient_id', $patient_id);
        $this->db->order_by('OP.created_at', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    public function get_single_opd_visit_details($opd_id) {
        $this->db->select('OP.*, P.name as patient_name, P.patient_unique_id, P.phone, D.name as doctor, R.name as reference, C.name as created_by, M.name as modified_by');
        $this->db->from('opd_patients AS OP');
        $this->db->join('patients AS P', 'P.user_id = OP.patient_id', 'left');
        $this->db->join('employees AS D', 'D.user_id = OP.doctor_id', 'left');
        $this->db->join('employees AS R', 'R.user_id = OP.reference_id', 'left');
        $this->db->join('employees AS C', 'C.user_id = OP.created_by', 'left');
        $this->db->join('employees AS M', 'M.user_id = OP.modified_by', 'left');
        $this->db->where('OP.id', $opd_id);
        return $this->db->get()->row();
    }

    public function get_patient_visit_bill($patient_id, $opt_id) {
        $this->db->select('P.*, OP.*, C.name as reference,  E.name as doctor, E.specialist, D.name as designation, PC.name as create_by, AP.appointment_no');
        $this->db->from('patients AS P');
        $this->db->join('opd_patients AS OP', 'OP.patient_id = P.user_id', 'left');
        $this->db->join('appointments AS AP', 'AP.id = OP.appointment_id', 'left');
        $this->db->join('employees AS E', 'E.user_id = OP.doctor_id', 'left');
        $this->db->join('employees AS PC', 'PC.user_id = OP.created_by', 'left');
        $this->db->join('designations AS D', 'D.id = E.designation_id', 'left');
        $this->db->join('users AS U', 'U.id = P.user_id', 'left');
        $this->db->join('roles AS R', 'R.id = U.role_id', 'left');
        $this->db->join('employees AS C', 'C.user_id = AP.reference_id', 'left');
        $this->db->where('P.user_id', $patient_id);
        $this->db->where('OP.id', $opt_id);
        return $this->db->get()->row();
    }

    public function get_patient_details($user_id) {
        $this->db->select('P.*');
        $this->db->from('patients AS P');
        $this->db->join('users AS U', 'U.id = P.user_id', 'left');
        $this->db->join('roles AS R', 'R.id = U.role_id', 'left');
        $this->db->where('P.user_id', $user_id);
        return $this->db->get()->row();
    }

    public function get_doctor_charges($doctor_id) {
        $this->db->select('DC.*');
        $this->db->from('doctor_charges AS DC');
        $this->db->where('DC.doctor_id', $doctor_id);
        return $this->db->get()->row();
    }

    public function get_old_patient_list($doctor_id, $patient_id) {
        $this->db->select('OP.*');
        $this->db->from('opd_patients AS OP');
        $this->db->where('OP.doctor_id', $doctor_id);
        $this->db->where('OP.patient_id', $patient_id);
        $this->db->order_by('OP.id', 'DESC');
        return $this->db->get()->row();
    }

    function duplicate_check($name, $phone, $id = null) {
        if ($id) {
            $this->db->where_not_in('user_id', $id);
        }
        $this->db->where('name', $name);
        $this->db->where('phone', $phone);
        return $this->db->get('patients')->num_rows();
    }

    function count_patient_all_invoices($patient_id) {
        $this->db->select('I.*');
        $this->db->from('invoices AS I');
        $this->db->where('I.patient_id', $patient_id);
        $this->db->where('I.payment_status', 'complete');
        return $this->db->get()->result();
    }

    function count_patient_all_investigations($invoice_id) {
        $this->db->select('ID.*');
        $this->db->from('invoice_details AS ID');
        $this->db->join('invoices AS I', 'I.id = ID.invoice_id', 'left');
        $this->db->where('ID.invoice_id', $invoice_id);
        $this->db->where('I.payment_status', 'complete');
        return $this->db->get()->num_rows();
    }
}
