<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Patient_Model extends MY_Model
{

    function __construct()
    {
        parent::__construct();
    }
    public function get_patient_list($limit, $offset, $search, $form_date, $to_date, $patient_category, $reference_emp, $count)
    {
        $this->db->select('P.id, P.user_id, P.reference_emp, P.patient_category, P.patient_unique_id, P.name, P.phone, P.gender, P.address, P.status, P.created_at, R.name as reference_emp');
        $this->db->from('patients AS P');
        $this->db->join('employees AS R', 'R.user_id = P.reference_emp', 'left');
        if ($search) {
            $this->db->like('P.phone', $search);
            $this->db->or_like('P.patient_unique_id', $search);
            $this->db->or_like('P.name', $search);
            $this->db->or_like('P.bn_name', $search);
            $this->db->or_like('P.gender', $search);
            $this->db->or_like('P.religion', $search);
            $this->db->or_like('P.blood_group', $search);
            $this->db->or_like('P.marital_status', $search);
            $this->db->or_like('P.address', $search);
        }
        if ($form_date && $to_date) {
            $this->db->where("DATE(P.created_at) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($patient_category) {
            $this->db->where('P.patient_category', $patient_category);
        }
        if ($reference_emp) {
            $this->db->where('P.reference_emp', $reference_emp);
        }
        $this->db->order_by('P.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    public function get_single_patient($user_id)
    {
        $this->db->select('P.*, U.username, U.temp_password, U.device_id, U.sbiz_id, U.role_id, U.status, C.name as created_by, M.name as modified_by');
        $this->db->from('patients AS P');
        $this->db->join('users AS U', 'U.id = P.user_id', 'left');
        $this->db->join('roles AS R', 'R.id = U.role_id', 'left');
        $this->db->join('employees AS C', 'C.user_id = P.created_by', 'left');
        $this->db->join('employees AS M', 'M.user_id = P.modified_by', 'left');
        $this->db->where('P.user_id', $user_id);
        return $this->db->get()->row();
    }

    function duplicate_check($name, $phone, $id = null)
    {
        if ($id) {
            $this->db->where_not_in('user_id', $id);
        }
        $this->db->where('name', $name);
        $this->db->where('phone', $phone);
        return $this->db->get('patients')->num_rows();
    }

    public function get_employee_list()
    {
        $this->db->select('E.*');
        $this->db->from('employees AS E');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('E.status', '1');
        if ($this->session->userdata('role_id') == SUPER_ADMIN) {
            $this->db->where_in('U.role_id', array(SUPER_ADMIN, ADMIN, ACCOUNTANT, RECEPTIONIST));
        } else {
            $this->db->where_in('U.role_id', array(ADMIN, ACCOUNTANT, RECEPTIONIST, PATHOLOGIST, RADIOLOGIST, NURSE, STAFF, MARKETING, PHARMACIST, MANAGER));
        }
        $this->db->order_by('E.id ', 'DESC');
        return $this->db->get()->result();
    }
}
