<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('patient'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage_patient'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <?php echo form_open_multipart(site_url('patient'), array('name' => 'search', 'id' => 'search', 'class' => 'needs-validation', 'novalidate' => 'novalidate', 'method' => 'get'), ''); ?>
                    <div class="form-row">
                        <div class="col-md-2 mb-10">
                            <label for="patient_category"><?php echo $this->lang->line('category'); ?></label>
                            <select class="form-control custom-select" name="patient_category" id="patient_category">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> Category</option>
                                <?php $patient_categorys = get_patient_category(); ?>
                                <?php foreach ($patient_categorys as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($patient_category) && $patient_category == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="keyword"><?php echo $this->lang->line('keyword'); ?></label>
                            <input type="text" class="form-control" name="keyword" id="keyword" value="<?php echo isset($keyword) ?  $keyword : ''; ?>" placeholder="<?php echo $this->lang->line('keyword'); ?>">
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="date"><?php echo $this->lang->line('date'); ?></label>
                            <input type="text" class="form-control" name="date" id="range" value="<?php echo isset($date) ?  $date : ''; ?>" placeholder="<?php echo $this->lang->line('date'); ?>">
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="reference_emp"><?php echo $this->lang->line('employee'); ?></label>
                            <select class="form-control custom-select select2" name="reference_emp" id="reference_emp">
                                <option value="" selected><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('employee'); ?></option>
                                <?php foreach ($reference_employees as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo isset($reference_emp) && $reference_emp === $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-1">
                            <button class="btn btn-gradient-primary mt-35" type="submit"><?php echo $this->lang->line('search'); ?></button>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>
        
        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(VIEW, 'patient', 'patient')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-user-circle-o font-30 mr-10"></i>
                            <?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('list'); ?>
                        </h6>
                    <?php } ?>
                    <!--<?php echo form_open_multipart(site_url('patient'), array('name' => 'search', 'id' => 'search', 'class' => 'needs-validation form-inline', 'novalidate' => 'novalidate', 'method' => 'get'), ''); ?>-->
                    <!--<div class="form-group mr-2">-->
                    <!--    <div class="input-group input-group-sm">-->
                    <!--        <select class="form-control custom-select" name="patient_category" id="patient_category">-->
                    <!--            <option selected value=""><?php echo $this->lang->line('select'); ?> Category</option>-->
                    <!--            <?php $patient_categorys = get_patient_category(); ?>-->
                    <!--            <?php foreach ($patient_categorys as $key => $value) { ?>-->
                    <!--                <option value="<?php echo $key; ?>" <?php echo isset($patient_category) && $patient_category == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>-->
                    <!--            <?php } ?>-->
                    <!--        </select>-->
                    <!--    </div>-->
                    <!--</div>-->
                    <!--<div class="form-group mr-2">-->
                    <!--    <div class="input-group input-group-sm">-->
                    <!--        <select class="form-control custom-select select2" name="reference_emp" id="reference_emp">-->
                    <!--            <option value="" selected><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('employee'); ?></option>-->
                    <!--            <?php foreach ($reference_employees as $obj) { ?>-->
                    <!--                <option value="<?php echo $obj->user_id; ?>" <?php echo isset($reference_emp) && $reference_emp === $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>-->
                    <!--            <?php } ?>-->
                    <!--        </select>-->
                    <!--    </div>-->
                    <!--</div>-->
                    <!--<div class="form-group">-->
                    <!--    <div class="input-group input-group-sm">-->
                    <!--        <input type="text" class="form-control" name="search" id="search" value="<?php echo isset($search) ?  $search : ''; ?>" placeholder="<?php echo $this->lang->line('search'); ?>">-->
                    <!--        <div class="input-group-append">-->
                    <!--            <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('search'); ?></button>-->
                    <!--        </div>-->
                    <!--    </div>-->
                    <!--</div>-->
                    <!--<?php echo form_close(); ?>-->
                    <?php if (has_permission(ADD, 'patient', 'patient')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('patient/add'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-plus font-12 mr-5"></i>
                                <?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('patient'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>
                <div class="card-body">
                    <div class="table-wrap">
                        <div class="table-responsive">
                            <table class="table table-sm mb-0">
                                <thead>
                                    <tr>
                                        <th><?php echo $this->lang->line('sl_no'); ?></th>
                                        <th><?php echo $this->lang->line('patient_id'); ?></th>
                                        <th><?php echo $this->lang->line('name'); ?></th>
                                        <th>Category</th>
                                        <th><?php echo $this->lang->line('reference'); ?></th>
                                        <th><?php echo $this->lang->line('gender'); ?></th>
                                        <th><?php echo $this->lang->line('phone'); ?></th>
                                        <th><?php echo $this->lang->line('address'); ?></th>
                                        <th><?php echo $this->lang->line('created'); ?></th>
                                        <th class="w-15"><?php echo $this->lang->line('action'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (isset($patients) && !empty($patients)) { ?>
                                        <?php foreach ($patients as $obj) { ?>
                                            <tr>
                                                <td><?php echo $sl_count; ?></td>
                                                <td><?php echo $obj->patient_unique_id; ?></td>
                                                <td><?php echo $obj->name; ?></td>
                                                <td><?php echo $obj->patient_category; ?></td>
                                                <td><?php echo $obj->reference_emp; ?></td>
                                                <td><?php echo $obj->gender ? $this->lang->line($obj->gender) : ''; ?></td>
                                                <td><?php echo $obj->phone; ?></td>
                                                <td><?php echo $obj->address; ?></td>
                                                <td><?php echo date('M d, Y h:ia', strtotime($obj->created_at)); ?></td>
                                                <td>
                                                    <?php if (has_permission(VIEW, 'patient', 'patient')) { ?>
                                                        <button class="btn btn-xs btn-info mr-5" type="button" onclick="get_view_modal(<?php echo $obj->user_id; ?>);" data-toggle="modal" data-target=".viewModalCenter"><i class="fa fa-eye"></i></button>
                                                    <?php } ?>
                                                    <?php if (has_permission(EDIT, 'patient', 'patient')) { ?>
                                                        <a class="btn btn-xs btn-success mr-5" href="<?php echo site_url('patient/edit/' . $obj->user_id); ?>"><i class="fa fa-pencil-square-o"></i></a>
                                                    <?php } ?>
                                                    <?php if (has_permission(DELETE, 'patient', 'patient')) { ?>
                                                        <a class="btn btn-danger btn-xs" href="<?php echo site_url('patient/delete/' . $obj->id); ?>" onclick="javascript: return confirm('<?php echo $this->lang->line('confirm_alert'); ?>');"> <i class="fa fa-trash"></i> </a>
                                                    <?php } ?>
                                                </td>
                                            </tr>
                                            <?php $sl_count++; ?>
                                        <?php } ?>
                                    <?php } else { ?>
                                        <tr class="text-center">
                                            <td colspan="10"><?php echo $this->lang->line('no_data_found'); ?></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <?php if ($this->pagination->create_links()) { ?>
                    <div class="card-footer justify-content-end">
                        <?php echo $this->pagination->create_links(); ?>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->


<div class="modal fade viewModalCenter" tabindex="-1" role="dialog" aria-labelledby="viewModalCenter" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header bg-gradient-primary">
                <h5 class="modal-title text-white"><?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('info'); ?></h5>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body modal_data bg-gradient-secondary"></div>
        </div>
    </div>
</div>

<script type="text/javascript">
    function get_view_modal(user_id) {
        $('.modal_data').html('<p style="padding: 20px;"><p style="padding: 20px;text-align:center;"><img src="<?php echo IMG_URL; ?>loader.gif" /></p>');
        $.ajax({
            type: "POST",
            url: "<?php echo site_url('patient/get_single_patient'); ?>",
            data: {
                user_id: user_id
            },
            success: function(response) {
                if (response) {
                    $('.modal_data').html(response);
                }
            }
        });
    }
</script>

<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<script>
    $(".select2").select2();
    $('#range').daterangepicker({
        startDate: new Date(),
        endDate: moment(),
        showDropdowns: true,
        minYear: 1901,
        locale: {
            format: 'YYYY/MM/DD',
        },
        ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Tomorrow': [moment().subtract(-1, 'days'), moment().subtract(-1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'This Year': [moment().startOf('year'), moment().endOf('year')],
            'Last Year': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')]
        }
    });
</script>

<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>