<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('report'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('pharmacy'); ?> <?php echo $this->lang->line('report'); ?>
        </h4>
        <div class="align-items-center">
            <?php if (has_permission(VIEW, 'pharmacy', 'purchase')) { ?>
                <a href="<?php echo site_url('pharmacy/purchase'); ?>" class="btn btn-xs btn-info">
                    <i class="fa fa-cart-plus font-12 mr-5"></i>
                    <?php echo $this->lang->line('purchase'); ?>
                </a>
            <?php } ?>
            <?php if (has_permission(VIEW, 'pharmacy', 'stock')) { ?>
                <a href="<?php echo site_url('pharmacy/stock'); ?>" class="btn btn-xs btn-success">
                    <i class="fa fa-bar-chart font-12 mr-5"></i>
                    <?php echo $this->lang->line('stock'); ?>
                </a>
            <?php } ?>
            <?php if (has_permission(VIEW, 'pharmacy', 'sale')) { ?>
                <a href="<?php echo site_url('pharmacy/sale'); ?>" class="btn btn-xs btn-danger">
                    <i class="fa fa-balance-scale font-12 mr-5"></i>
                    <?php echo $this->lang->line('sale'); ?>
                </a>
            <?php } ?>
        </div>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <?php if (has_permission(VIEW, 'pharmacy', 'report')) { ?>
            <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 mb-30">
                <div class="card text-white bg-gradient-primary">
                    <div class="card-header font-weight-bold font-18">
                        <i class="fa fa-money"></i>
                        <?php echo $this->lang->line('collection'); ?> <?php echo $this->lang->line('bill'); ?>
                    </div>
                    <div class="card-body text-center" style="min-height: 100px;">
                        <a href="<?php echo site_url('pharmacy/report/collection'); ?>" class="btn btn-success">
                            <?php echo $this->lang->line('view'); ?> <?php echo $this->lang->line('collection'); ?>
                        </a>
                    </div>
                </div>
            </div>
        <?php } ?>

        <?php if (has_permission(VIEW, 'pharmacy', 'report')) { ?>
            <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 mb-30">
                <div class="card text-white bg-gradient-space">
                    <div class="card-header font-weight-bold font-18">
                        <i class="fa fa-exchange"></i>
                        <?php echo $this->lang->line('due'); ?> <?php echo $this->lang->line('bill'); ?>
                    </div>
                    <div class="card-body text-center" style="min-height: 100px;">
                        <a href="<?php echo site_url('pharmacy/report/due'); ?>" class="btn btn-success">
                            <?php echo $this->lang->line('view'); ?> <?php echo $this->lang->line('due'); ?>
                        </a>
                    </div>
                </div>
            </div>
        <?php } ?>

        <?php if (has_permission(VIEW, 'pharmacy', 'report')) { ?>
            <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 mb-30">
                <div class="card text-white bg-gradient-streaks">
                    <div class="card-header font-weight-bold font-18">
                        <i class="fa fa-ban"></i>
                        <?php echo $this->lang->line('rejected'); ?> <?php echo $this->lang->line('bill'); ?>
                    </div>
                    <div class="card-body text-center" style="min-height: 100px;">
                        <a href="<?php echo site_url('pharmacy/report/rejected'); ?>" class="btn btn-success">
                            <?php echo $this->lang->line('view'); ?> <?php echo $this->lang->line('rejected'); ?>
                        </a>
                    </div>
                </div>
            </div>
        <?php } ?>

        <?php if (has_permission(VIEW, 'pharmacy', 'report')) { ?>
            <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 mb-30">
                <div class="card text-white bg-gradient-bunting">
                    <div class="card-header font-weight-bold font-18">
                        <i class="fa fa-money"></i>
                        <?php echo $this->lang->line('income'); ?> <?php echo $this->lang->line('bill'); ?>
                    </div>
                    <div class="card-body text-center" style="min-height: 100px;">
                        <a href="<?php echo site_url('pharmacy/report/income'); ?>" class="btn btn-success">
                            <?php echo $this->lang->line('view'); ?> <?php echo $this->lang->line('income'); ?>
                        </a>
                    </div>
                </div>
            </div>
        <?php } ?>

        <?php if (has_permission(VIEW, 'pharmacy', 'report')) { ?>
            <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 mb-30">
                <div class="card text-white bg-gradient-dusk">
                    <div class="card-header font-weight-bold font-18">
                        <i class="fa fa-tasks"></i>
                        <?php echo $this->lang->line('collection'); ?> <?php echo $this->lang->line('statement'); ?>
                    </div>
                    <div class="card-body text-center" style="min-height: 100px;">
                        <a href="<?php echo site_url('pharmacy/report/statement'); ?>" class="btn btn-success">
                            <?php echo $this->lang->line('view'); ?> <?php echo $this->lang->line('statement'); ?>
                        </a>
                    </div>
                </div>
            </div>
        <?php } ?>

        <?php if (has_permission(VIEW, 'pharmacy', 'report')) { ?>
            <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 mb-30">
                <div class="card text-white bg-gradient-warbler">
                    <div class="card-header font-weight-bold font-18">
                        <i class="fa fa-balance-scale"></i>
                        <?php echo $this->lang->line('sales'); ?> <?php echo $this->lang->line('statement'); ?>
                    </div>
                    <div class="card-body text-center" style="min-height: 100px;">
                        <a href="<?php echo site_url('pharmacy/report/sales'); ?>" class="btn btn-success">
                            <?php echo $this->lang->line('view'); ?> <?php echo $this->lang->line('sales'); ?>
                        </a>
                    </div>
                </div>
            </div>
        <?php } ?>

        <?php if (has_permission(VIEW, 'pharmacy', 'report')) { ?>
            <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 mb-30">
                <div class="card text-white bg-gradient-success">
                    <div class="card-header font-weight-bold font-18">
                        <i class="fa fa-cart-plus"></i>
                        <?php echo $this->lang->line('purchase'); ?> <?php echo $this->lang->line('bill'); ?>
                    </div>
                    <div class="card-body text-center" style="min-height: 100px;">
                        <a href="<?php echo site_url('pharmacy/report/purchase'); ?>" class="btn btn-success">
                            <?php echo $this->lang->line('view'); ?> <?php echo $this->lang->line('purchase'); ?>
                        </a>
                    </div>
                </div>
            </div>
        <?php } ?>

        <?php if (has_permission(VIEW, 'pharmacy', 'report')) { ?>
            <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 mb-30">
                <div class="card text-white bg-gradient-danger">
                    <div class="card-header font-weight-bold font-18">
                        <i class="fa fa-trash"></i>
                        <?php echo $this->lang->line('wastage'); ?> <?php echo $this->lang->line('medicine'); ?>
                    </div>
                    <div class="card-body text-center" style="min-height: 100px;">
                        <a href="<?php echo site_url('pharmacy/report/wastage'); ?>" class="btn btn-success">
                            <?php echo $this->lang->line('view'); ?> <?php echo $this->lang->line('wastage'); ?>
                        </a>
                    </div>
                </div>
            </div>
        <?php } ?>

        <?php if (has_permission(VIEW, 'pharmacy', 'report')) { ?>
            <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 mb-30">
                <div class="card text-white bg-gradient-sunset">
                    <div class="card-header font-weight-bold font-18">
                        <i class="fa fa-undo"></i>
                        <?php echo $this->lang->line('refund'); ?> <?php echo $this->lang->line('bill'); ?>
                    </div>
                    <div class="card-body text-center" style="min-height: 100px;">
                        <a href="<?php echo site_url('pharmacy/report/refund'); ?>" class="btn btn-success">
                            <?php echo $this->lang->line('view'); ?> <?php echo $this->lang->line('refund'); ?>
                        </a>
                    </div>
                </div>
            </div>
        <?php } ?>

        <?php if (has_permission(VIEW, 'pharmacy', 'report')) { ?>
            <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 mb-30">
                <div class="card text-white bg-gradient-royston">
                    <div class="card-header font-weight-bold font-18">
                        <i class="fa fa-bar-chart"></i>
                        <?php echo $this->lang->line('stock'); ?> <?php echo $this->lang->line('medicine'); ?>
                    </div>
                    <div class="card-body text-center" style="min-height: 100px;">
                        <a href="<?php echo site_url('pharmacy/report/stock'); ?>" class="btn btn-success">
                            <?php echo $this->lang->line('view'); ?> <?php echo $this->lang->line('stock'); ?>
                        </a>
                    </div>
                </div>
            </div>
        <?php } ?>

        <?php if (has_permission(VIEW, 'pharmacy', 'report')) { ?>
            <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 mb-30">
                <div class="card text-white bg-gradient-honey">
                    <div class="card-header font-weight-bold font-18">
                        <i class="fa fa-medkit"></i>
                        <?php echo $this->lang->line('medicine'); ?> <?php echo $this->lang->line('sale'); ?>
                    </div>
                    <div class="card-body text-center" style="min-height: 100px;">
                        <a href="<?php echo site_url('pharmacy/report/medicine'); ?>" class="btn btn-success">
                            <?php echo $this->lang->line('view'); ?> <?php echo $this->lang->line('medicine'); ?>
                        </a>
                    </div>
                </div>
            </div>
        <?php } ?>

        <?php if (has_permission(VIEW, 'pharmacy', 'report')) { ?>
            <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 mb-30">
                <div class="card text-white bg-gradient-bunting">
                    <div class="card-header font-weight-bold font-18">
                        <i class="fa fa-user-md"></i>
                        <?php echo $this->lang->line('pharmacy'); ?> <?php echo $this->lang->line('profit'); ?>
                    </div>
                    <div class="card-body text-center" style="min-height: 100px;">
                        <a href="<?php echo site_url('pharmacy/report/profit'); ?>" class="btn btn-success">
                            <?php echo $this->lang->line('view'); ?> <?php echo $this->lang->line('profit'); ?>
                        </a>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->