<!DOCTYPE html>
<html>

<head>
	<title>Print Invoice</title>

	<style>
		body {
			font-family: monospace;
			font-size: 14px;
		}

		.page {
			width: 64%;
			margin: 0 auto;
		}

		@page {
			size: A4;
			margin: 0;
		}

		@media print {

			html,
			body {
				font-family: Arial, Helvetica, sans-serif;
			}

			.page {
				width: 64%;
				margin: 0 auto;
				border: initial;
				border-radius: initial;
				min-height: initial;
				box-shadow: initial;
				background: initial;
				page-break-after: always;
			}
		}

		.patient_copy {
			page-break-after: always;
			display: block;
			margin-top: 100px;
		}

		.title {
			width: 30%;
			font-size: 14px;
			font-weight: bold;
			border: 1px solid #333;
			padding: 5px;
			font-family: monospace;
			text-transform: uppercase;
			letter-spacing: 2px;
			border-radius: 3px;
			text-align: center;
			margin: 3px auto;
		}

		.paid {
			width: 25%;
			margin: 30px auto 0 auto;
			text-align: center;
			font-size: 25px;
			font-weight: bold;
			background: #eee;
			border: 1px solid #000;
			padding: 3px 10px;
			font-family: monospace;
			text-transform: uppercase;
			letter-spacing: 5px;
			border-radius: 3px;
		}

		.table {
			font-size: 14px;
			width: 100%;
			border-collapse: collapse;
		}

		.patient_table {
			width: 100%;
			text-align: left;
			border-collapse: collapse;
			margin-top: 15px;
		}

		.patient_table tbody td {
			color: #000;
			padding: 2px;
			vertical-align: top;
			border: 2px solid #000;
		}

		/* test_table */
		.test_table {
			margin-top: 10px;
			width: 100%;
			text-align: left;
			border-collapse: collapse;
			border: 1px solid #000;
		}

		.test_table thead th {
			color: #000;
			padding: 0px 4px;
			vertical-align: top;
			border: 1px solid #000;
		}

		.test_table tbody td {
			color: #000;
			padding: 0px 4px;
			vertical-align: top;
			border: 1px solid #000;
		}
	</style>
</head>

<body>
	<div class="page">
		<div class="patient_copy">
			<div class="title">Customer Copy</div>
			<!-- Patient Info Start-->
			<table class="table patient_table">
				<tr>
					<td style="width: 35%;">
						<span>Patient ID :</span>
						<span style="text-transform: uppercase; font-weight: bold;"><?php echo !empty($customer->patient_unique_id) ? $customer->patient_unique_id : ''; ?></span>
					</td>
					<td style="width: 23%;">
						<?php $var = !empty($customer->patient_unique_id) ? $customer->patient_unique_id : $invoice->id; ?>
						<img src="<?php echo site_url('opd/set_barcode/' . $var); ?>" alt="" height="30" width="100%">
					</td>
					<td style="width: 42%;">
						<span>Invoice No :</span>
						<span><?php echo $invoice->custom_invoice_id; ?></span>
					</td>
				</tr>
				<tr>
					<td colspan="2">
						<span>Name :</span>
						<span style="text-transform: uppercase; font-weight: bold;">
							<?php
							if ($invoice->walking == 1) {
								echo $this->lang->line('walking') . ' ' . $this->lang->line('customer');
							} elseif ($invoice->customer_id > 0) {
								echo $customer->name;
							} else {
								echo $invoice->customer_name;
							}
							?>
						</span>
					</td>
					<td>
						<span>Date :</span>
						<span><?php echo date('d/m/Y h:i A', strtotime($invoice->bill_date)); ?></span>
					</td>
				</tr>
				<tr>
					<td>
						<span>Age :</span>
						<span style="text-transform: uppercase; font-weight: bold;"><?php echo !empty($customer->dob) ? floor((time() - strtotime($customer->dob)) / 31556926) : ''; ?>Y</span>
					</td>
					<td>
						<span>Gender :</span>
						<span style="text-transform: capitalize; font-weight: bold;"><?php echo !empty($customer->gender) ? $this->lang->line($customer->gender) : ''; ?></span>
					</td>
					<td>
						<span>Contact No :</span>
						<span style="text-transform: uppercase; font-weight: bold;"><?php echo !empty($customer->phone) ? $customer->phone : ''; ?></span>
					</td>
				</tr>
			</table>
			<!-- Patient Info End-->

			<?php if (isset($details) & !empty($details)) { ?>
				<table class="test_table">
					<thead>
						<tr>
							<th>SL. No</th>
							<th>Medicine Name</th>
							<th>Batch No</th>
							<th>Quantity</th>
							<th>Rate</th>
							<th>Total</th>
						</tr>
					</thead>
					<tbody>
						<?php $count = 1; ?>
						<?php foreach ($details as $obj) { ?>
							<tr>
								<td><?php echo $count++; ?></td>
								<td><?php echo $obj->medicine_name; ?></td>
								<td><?php echo $obj->batch_no; ?></td>
								<td><?php echo $obj->quantity; ?></td>
								<td><?php echo $obj->rate; ?></td>
								<td><?php echo $obj->total_rate; ?></td>
							</tr>
						<?php } ?>
						<tr>
							<td rowspan="5" colspan="3">
								<div class="paid" style="margin-bottom: 0; padding-bottom: 0;">
									<?php if ($invoice->paid_status == 'paid') {
										echo 'Paid';
									} else {
										echo 'Due';
									} ?>
								</div>
								<p style="text-align: center; margin-bottom: 20px;"><b>In Word:</b> <span style="font-size: 12px;"><?php echo $this->numbertowords->convert_number($invoice->advanced); ?> Taka Only.</span></p>
							</td>
							<td colspan="2" align="right" style="padding-right: 10px;"><b>Item Total Tk.</b></td>
							<td><?php echo number_format($invoice->total_bill, 2); ?></td>
						</tr>
						<tr>
							<td colspan="2" align="right" style="padding-right: 10px;"><b>(-)Discount Tk.</b></td>
							<td><?php echo number_format($invoice->discount, 2); ?></td>
						</tr>
						<tr>
							<td colspan="2" align="right" style="padding-right: 10px;"><b>Net Payable Tk.</b></td>
							<td><?php echo number_format($invoice->net_payable, 2); ?></td>
						</tr>
						<tr>
							<td colspan="2" align="right" style="padding-right: 10px;"><b>Advance Tk.</b></td>
							<td><?php echo number_format($invoice->advanced, 2); ?></td>
						</tr>
						<tr>
							<td colspan="2" align="right" style="padding-right: 10px;"><b>Due Tk.</b></td>
							<td><?php echo number_format($invoice->due_amount, 2); ?></td>
						</tr>
					</tbody>
				</table>
			<?php } ?>
			<?php if ($invoice->note != NULL) { ?>
				<p style="margin-top:20px;">
					<b>Remark: </b>
					<?php echo $invoice->note; ?>
				</p>
			<?php } ?>
			<p style="margin-top:30px;">
				<span style="font-size: 14px; font-weight: bold;">Prepared By:</span>
				<?php echo $employee->name; ?>
			</p>
		</div>
	</div>
</body>

</html>