<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('stock'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage_stock'); ?>
        </h4>

        <div class="align-items-center">
            <?php if (has_permission(VIEW, 'pharmacy', 'purchase')) { ?>
                <a href="<?php echo site_url('pharmacy/purchase'); ?>" class="btn btn-xs btn-info">
                    <i class="fa fa-cart-plus font-12 mr-5"></i>
                    <?php echo $this->lang->line('purchase'); ?>
                </a>
            <?php } ?>
            <?php if (has_permission(VIEW, 'pharmacy', 'refund')) { ?>
                <a href="<?php echo site_url('pharmacy/refund'); ?>" class="btn btn-xs btn-success">
                    <i class="fa fa-undo font-12 mr-5"></i>
                    <?php echo $this->lang->line('refund'); ?>
                </a>
            <?php } ?>
            <?php if (has_permission(VIEW, 'pharmacy', 'sale')) { ?>
                <a href="<?php echo site_url('pharmacy/sale'); ?>" class="btn btn-xs btn-danger">
                    <i class="fa fa-balance-scale font-12 mr-5"></i>
                    <?php echo $this->lang->line('sale'); ?>
                </a>
            <?php } ?>
        </div>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <?php echo form_open_multipart(site_url('pharmacy/stock'), array('name' => 'search', 'id' => 'search', 'method' => 'get'), ''); ?>
                    <div class="form-row">
                        <div class="col-md-4 mb-10">
                            <label for="keyword"><?php echo $this->lang->line('keyword'); ?></label>
                            <input type="text" class="form-control" name="keyword" id="keyword" value="<?php echo isset($keyword) ?  $keyword : ''; ?>" placeholder="<?php echo $this->lang->line('keyword'); ?>">
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="type_id"><?php echo $this->lang->line('type'); ?></label>
                            <select class="form-control" name="type_id" id="type_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($types as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($type_id) && $type_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="category_id"><?php echo $this->lang->line('category'); ?></label>
                            <select class="form-control select2" name="category_id" id="category_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($categories as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($category_id) && $category_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="generic_id"><?php echo $this->lang->line('generic'); ?> <?php echo $this->lang->line('name'); ?></label>
                            <select class="form-control select2" name="generic_id" id="generic_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($generics as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($generic_id) && $generic_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="manufacturer_id"><?php echo $this->lang->line('manufacturer'); ?></label>
                            <select class="form-control select2" name="manufacturer_id" id="manufacturer_id" onchange="get_medicine(this.value)">
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($manufacturers as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($manufacturer_id) && $manufacturer_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="medicine_id"><?php echo $this->lang->line('medicine'); ?></label>
                            <select class="form-control select2" name="medicine_id" id="medicine_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('medicine'); ?></option>
                                <?php foreach ($medicines as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($medicine_id) && $medicine_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->medicine_name; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <button class="btn btn-gradient-primary mt-35" type="submit"><?php echo $this->lang->line('search'); ?></button>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>

        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(VIEW, 'pharmacy', 'stock')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-bar-chart font-30 mr-10"></i>
                            <?php echo $this->lang->line('stock'); ?> <?php echo $this->lang->line('list'); ?>
                        </h6>
                    <?php } ?>

                    <?php if (has_permission(VIEW, 'pharmacy', 'stock')) { ?>
                        <div class="align-items-center">
                            <a href="#" class="btn btn-xs btn-primary">
                                <i class="fa fa-download font-12 mr-5"></i>
                                <?php echo $this->lang->line('download'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>
                <div class="card-body">
                    <div class="table-wrap">
                        <div class="table-responsive">
                            <table class="table table-sm mb-0">
                                <thead>
                                    <tr>
                                        <th><?php echo $this->lang->line('sl_no'); ?></th>
                                        <th><?php echo $this->lang->line('medicine'); ?></th>
                                        <th><?php echo $this->lang->line('manufacturer'); ?></th>
                                        <th><?php echo $this->lang->line('purchase'); ?> <?php echo $this->lang->line('price'); ?></th>
                                        <th><?php echo $this->lang->line('sell'); ?> <?php echo $this->lang->line('price'); ?></th>
                                        <th><?php echo $this->lang->line('in_quantity'); ?></th>
                                        <th><?php echo $this->lang->line('sold_quantity'); ?></th>
                                        <th><?php echo $this->lang->line('refund'); ?> <?php echo $this->lang->line('quantity'); ?></th>
                                        <th><?php echo $this->lang->line('stock'); ?></th>
                                        <th><?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('purchase'); ?></th>
                                        <th><?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('sell'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $total_purchase_price = 0;
                                    $total_sell_price = 0;
                                    $total_in_quantity = 0;
                                    $total_sold_quantity = 0;
                                    $total_refund_quantity = 0;
                                    $total_stock_quantity = 0;
                                    $total_purchase = 0;
                                    $total_sell = 0;
                                    if (isset($stocks) && !empty($stocks)) { ?>
                                        <?php foreach ($stocks as $obj) {
                                            $sale = $this->stock->get_sale_medicine($obj->id);
                                            $refund = $this->stock->get_refund_medicine($obj->id);
                                            $total_purchase_price += $obj->purchase_price;
                                            $total_sell_price += $obj->sell_price;
                                            $total_in_quantity += $obj->total_in_quantity ?? 0;
                                            $total_sold_quantity += $sale->total_sold_quantity ?? 0;
                                            $total_refund_quantity += $refund->total_refund_quantity ?? 0;
                                            $total_stock_quantity += ($obj->total_in_quantity ?? 0) - ($sale->total_sold_quantity ?? 0);
                                            $total_purchase += ($obj->purchase_price * $obj->total_in_quantity);
                                            $total_sell += ($obj->sell_price * $total_sold_quantity);
                                        ?>
                                            <tr>
                                                <td><?php echo $sl_count; ?></td>
                                                <td>
                                                    <a href="<?php echo site_url('pharmacy/stock/detail/' . $obj->id); ?>">
                                                        <?php echo $obj->medicine_name; ?>
                                                    </a>
                                                </td>
                                                <td><?php echo $obj->manufacturer; ?></td>
                                                <td><?php echo $obj->purchase_price ?? 0; ?></td>
                                                <td><?php echo $obj->sell_price ?? 0; ?></td>
                                                <td><?php echo $obj->total_in_quantity ?? 0; ?></td>
                                                <td><?php echo $sale->total_sold_quantity ?? 0; ?></td>
                                                <td><?php echo $refund->total_refund_quantity ?? 0; ?></td>
                                                <td><?php echo number_format(((($obj->total_in_quantity ?? 0) - (@$sale->total_sold_quantity ?? 0)) + @$refund->total_refund_quantity), 0); ?></td>
                                                <td><?php echo number_format(($obj->purchase_price * ($obj->total_in_quantity ?? 0)), 2); ?></td>
                                                <td><?php echo number_format(($obj->sell_price * (@$sale->total_sold_quantity ?? 0)), 2); ?></td>
                                            </tr>
                                        <?php $sl_count++;
                                        } ?>
                                    <?php } else { ?>
                                        <tr class="text-center">
                                            <td colspan="11"><?php echo $this->lang->line('no_data_found'); ?></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                                <tfoot>
                                    <tr class="bg-transparent">
                                        <td colspan="3" class="text-right text-light">Total</td>
                                        <td class="text-center"><?php echo $total_purchase_price; ?></td>
                                        <td class="text-center"><?php echo $total_sell_price; ?></td>
                                        <td class="text-center"><?php echo $total_in_quantity; ?></td>
                                        <td class="text-center"><?php echo $total_sold_quantity; ?></td>
                                        <td class="text-center"><?php echo $total_refund_quantity; ?></td>
                                        <td class="text-center"><?php echo $total_stock_quantity; ?></td>
                                        <td class="text-center"><?php echo $total_purchase; ?></td>
                                        <td class="text-center"><?php echo $total_sell; ?></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <?php if ($this->pagination->create_links()) { ?>
                    <div class="card-footer justify-content-end">
                        <?php echo $this->pagination->create_links(); ?>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important;
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>
<script>
    $(".select2").select2();
</script>

<script>
    function get_medicine(manufacturer_id) {
        $.ajax({
            type: "POST",
            url: "<?php echo site_url('ajax/get_manufacturer_by_medicine'); ?>",
            data: {
                manufacturer_id: manufacturer_id
            },
            async: false,
            success: function(response) {
                if (response) {
                    $('#medicine_id').html(response);
                }
            }
        });
    };
</script>