<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Ipd.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Ipd
 * @description     : Manage IPD report.
 * @author          : South Bangla IT Zone Team
 * @url             : http://hms.sbitzone.com
 * @support         : rabibd.it@gmail.com
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class Ipd extends MY_Controller {

    public $data = array();

    function __construct() {
        parent::__construct();
        $this->load->model('Ipd_Model', 'ipd', true);

        $this->data['doctors'] = $this->ipd->get_doctor_list();
        $this->data['references'] = $this->ipd->get_list('employees', array('status' => 1));
        $this->data['employees'] = $this->ipd->get_employee_list();
        $this->data['reference_persons'] = $this->ipd->get_reference_person_list();
    }

    /*****************Function index**********************************
     * @type            : Function
     * @function name   : index
     * @description     : Load "Ipd Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function index() {

        check_permission(VIEW);

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('ipd') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/ipd/index', $this->data);
    }

    /*****************Function collection**********************************
     * @type            : Function
     * @function name   : collection
     * @description     : Load "Collection Ipd Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function collection() {

        check_permission(VIEW);

        if ($_GET) {
            $keyword = trim($this->input->get('keyword'));
            $type = $this->input->get('type');
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $doctor_id = $this->input->get('doctor_id');
            $reference_id = $this->input->get('reference_id');
            $created_by = $this->input->get('created_by');

            $this->data['collections'] = $this->ipd->get_collection_list($keyword, $type, $form_date, $to_date, $doctor_id, $reference_id, $created_by);
            $this->data['keyword'] = $keyword;
            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['reference_id'] = $reference_id;
            $this->data['created_by'] = $created_by;
        }

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('collection') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/ipd/collection', $this->data);
    }

    /*****************Function collection_pdf**********************************
     * @type            : Function
     * @function name   : collection_pdf
     * @description     : Load "Generate Collection Ipd Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function collection_pdf() {
        if ($_GET) {
            $keyword = $this->input->get('keyword');
            $type = $this->input->get('type');
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $doctor_id = $this->input->get('doctor_id');
            $reference_id = $this->input->get('reference_id');
            $created_by = $this->input->get('created_by');

            $this->data['collections'] = $this->ipd->get_collection_list($keyword, $type, $form_date, $to_date, $doctor_id, $reference_id, $created_by);
            $this->data['keyword'] = $keyword;
            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['reference_id'] = $reference_id;
            $this->data['created_by'] = $created_by;
            $this->data['createdby'] = $this->ipd->get_single('employees', array('user_id' => $created_by, 'status' => 1));
            $this->data['doctor'] = $this->ipd->get_single('employees', array('user_id' => $doctor_id, 'status' => 1));

            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'L'
            ]);
            $html =  $this->load->view('report/ipd/pdf/collection', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('collection_' . rand() . '.pdf', 'D');
        }
    }

    /*****************Function due**********************************
     * @type            : Function
     * @function name   : due
     * @description     : Load "Due Ipd Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function due() {

        check_permission(ADD);
        if ($_GET) {
            $keyword = $this->input->get('keyword');
            $type = $this->input->get('type');
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $doctor_id = $this->input->get('doctor_id');
            $reference_id = $this->input->get('reference_id');
            $created_by = $this->input->get('created_by');

            $this->data['dues'] = $this->ipd->get_due_list($keyword, $type, $form_date, $to_date, $doctor_id, $reference_id, $created_by);
            $this->data['keyword'] = $keyword;
            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['to_date'] = date('Y/m/d', strtotime($to_date));
            $this->data['doctor_id'] = $doctor_id;
            $this->data['reference_id'] = $reference_id;
            $this->data['created_by'] = $created_by;
        }

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('due') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/ipd/due', $this->data);
    }

    /*****************Function due_pdf**********************************
     * @type            : Function
     * @function name   : due_pdf
     * @description     : Load "Generate PDF Due Ipd Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function due_pdf() {

        check_permission(ADD);

        if ($_GET) {
            $keyword = $this->input->get('keyword');
            $type = $this->input->get('type');
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $doctor_id = $this->input->get('doctor_id');
            $reference_id = $this->input->get('reference_id');
            $created_by = $this->input->get('created_by');

            $this->data['dues'] = $this->ipd->get_due_list($keyword, $type, $form_date, $to_date, $doctor_id, $reference_id, $created_by);
            $this->data['keyword'] = $keyword;
            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['form_date'] = $form_date;
            $this->data['to_date'] = $to_date;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['reference_id'] = $reference_id;
            $this->data['created_by'] = $created_by;

            $this->data['createdby'] = $this->ipd->get_single('employees', array('user_id' => $created_by, 'status' => 1));
            $this->data['doctor'] = $this->ipd->get_single('employees', array('user_id' => $doctor_id, 'status' => 1));

            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'L'
            ]);
            $html =  $this->load->view('report/ipd/pdf/due', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('due_' . rand() . '.pdf', 'D');
        }
    }


    /*****************Function rejected**********************************
     * @type            : Function
     * @function name   : rejected
     * @description     : Load "Fefund Ipd Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function rejected() {

        check_permission(ADD);

        if ($_GET) {
            $keyword = trim($this->input->get('keyword'));
            $type = $this->input->get('type');
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $doctor_id = $this->input->get('doctor_id');
            $reference_id = $this->input->get('reference_id');
            $created_by = $this->input->get('created_by');

            $this->data['rejecteds'] = $this->ipd->get_rejected_list($keyword, $type, $form_date, $to_date, $doctor_id, $reference_id, $created_by);
            $this->data['keyword'] = $keyword;
            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['reference_id'] = $reference_id;
            $this->data['created_by'] = $created_by;
        }

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('rejected') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/ipd/rejected', $this->data);
    }

    /*****************Function rejected_pdf**********************************
     * @type            : Function
     * @function name   : rejected_pdf
     * @description     : Load "Generate PDF Refund Ipd Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function rejected_pdf() {

        check_permission(ADD);

        if ($_GET) {
            $keyword = trim($this->input->get('keyword'));
            $type = $this->input->get('type');
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $doctor_id = $this->input->get('doctor_id');
            $reference_id = $this->input->get('reference_id');
            $created_by = $this->input->get('created_by');

            $this->data['rejecteds'] = $this->ipd->get_rejected_list($keyword, $type, $form_date, $to_date, $doctor_id, $reference_id, $created_by);
            $this->data['keyword'] = $keyword;
            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['form_date'] = $form_date;
            $this->data['to_date'] = $to_date;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['reference_id'] = $reference_id;
            $this->data['created_by'] = $created_by;

            $this->data['createdby'] = $this->ipd->get_single('employees', array('user_id' => $created_by, 'status' => 1));
            $this->data['doctor'] = $this->ipd->get_single('employees', array('user_id' => $doctor_id, 'status' => 1));

            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'L'
            ]);
            $html =  $this->load->view('report/ipd/pdf/rejected', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('rejected_' . rand() . '.pdf', 'D');
        }
    }

    /*****************Function income**********************************
     * @type            : Function
     * @function name   : income
     * @description     : Load "Income Ipd Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function income() {

        check_permission(ADD);

        if ($_GET) {
            $keyword = trim($this->input->get('keyword'));
            $type = $this->input->get('type');
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $doctor_id = $this->input->get('doctor_id');
            $reference_id = $this->input->get('reference_id');
            $reference_person = $this->input->get('reference_person');
            $created_by = $this->input->get('created_by');

            $this->data['incomes'] = $this->ipd->get_income_list($keyword, $type, $form_date, $to_date, $doctor_id, $reference_id, $reference_person, $created_by);
            $this->data['keyword'] = $keyword;
            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['reference_id'] = $reference_id;
            $this->data['reference_person'] = $reference_person;
            $this->data['created_by'] = $created_by;
        }

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('income') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/ipd/income', $this->data);
    }

    /*****************Function income_pdf**********************************
     * @type            : Function
     * @function name   : income_pdf
     * @description     : Load "Generate PDF Income Ipd Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function income_pdf() {

        check_permission(ADD);

        if ($_GET) {
            $keyword = trim($this->input->get('keyword'));
            $type = $this->input->get('type');
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $doctor_id = $this->input->get('doctor_id');
            $reference_id = $this->input->get('reference_id');
            $reference_person = $this->input->get('reference_person');
            $created_by = $this->input->get('created_by');

            $this->data['incomes'] = $this->ipd->get_income_list($keyword, $type, $form_date, $to_date, $doctor_id, $reference_id, $reference_person, $created_by);
            $this->data['keyword'] = $keyword;
            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['form_date'] = $form_date;
            $this->data['to_date'] = $to_date;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['reference_id'] = $reference_id;
            $this->data['reference_person'] = $reference_person;
            $this->data['created_by'] = $created_by;

            $this->data['createdby'] = $this->ipd->get_single('employees', array('user_id' => $created_by, 'status' => 1));
            $this->data['doctor'] = $this->ipd->get_single('employees', array('user_id' => $doctor_id, 'status' => 1));
            $this->data['reference_person'] = $this->ipd->get_single('employees', array('user_id' => $reference_person, 'status' => 1));

            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'L'
            ]);
            $html =  $this->load->view('report/ipd/pdf/income', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('income_' . rand() . '.pdf', 'D');
        }
    }


    /*****************Function statement**********************************
     * @type            : Function
     * @function name   : statement
     * @description     : Load "Collection Statement Ipd Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function statement() {

        check_permission(ADD);

        if ($_GET) {
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $type = $this->input->get('type');
            $doctor_id = $this->input->get('doctor_id');
            $created_by = $this->input->get('created_by');

            $this->data['date'] = $date;
            $this->data['type'] = $type;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['created_by'] = $created_by;

            // IPD Start
            $ipd = $this->ipd->get_ipd_list($form_date, $to_date, $type, $doctor_id, $created_by);

            $total_bill = 0;
            $total_discount = 0;
            $total_net_payable = 0;
            $total_advanced = 0;
            $total_due_amount = 0;

            // rejected bill
            $total_rejected_bill = 0;
            $total_rejected_discount = 0;
            $total_rejected_net_payable = 0;
            $total_rejected_advanced = 0;
            $total_rejected_due_amount = 0;


            foreach ($ipd as $item) {
                if ($item->payment_status == 'complete') {
                    $total_bill += $item->total_bill;
                    $total_discount += $item->discount;
                    $total_net_payable += $item->net_payable;
                    $total_advanced += $item->advanced;
                    $total_due_amount += $item->due_amount;
                }
                if ($item->payment_status == 'rejected') {
                    $total_rejected_bill += $item->total_bill;
                    $total_rejected_discount += $item->discount;
                    $total_rejected_net_payable += $item->net_payable;
                    $total_rejected_advanced += $item->advanced;
                    $total_rejected_due_amount += $item->due_amount;
                }
            }

            $this->data['total_bill'] = $total_bill;
            $this->data['total_discount'] = $total_discount;
            $this->data['total_net_payable'] = $total_net_payable;
            $this->data['total_advanced'] = $total_advanced;
            $this->data['total_due_amount'] = $total_due_amount;

            // rejected bill

            $this->data['total_rejected_bill'] = $total_rejected_bill;
            $this->data['total_rejected_discount'] = $total_rejected_discount;
            $this->data['total_rejected_net_payable'] = $total_rejected_net_payable;
            $this->data['total_rejected_advanced'] = $total_rejected_advanced;
            $this->data['total_rejected_due_amount'] = $total_rejected_due_amount;
        }
        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('statement') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/ipd/statement', $this->data);
    }

    /*****************Function sales**********************************
     * @type            : Function
     * @function name   : sales
     * @description     : Load "Sales Statement Ipd Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function sales() {

        check_permission(ADD);

        if ($_GET) {
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $type = $this->input->get('type');
            $doctor_id = $this->input->get('doctor_id');
            $created_by = $this->input->get('created_by');

            $this->data['sales'] = $this->ipd->get_sale_list($form_date, $to_date, $type, $doctor_id, $created_by);
            $this->data['date'] = $date;
            $this->data['form_date'] = $form_date;
            $this->data['to_date'] = $to_date;
            $this->data['type'] = $type;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['created_by'] = $created_by;
        }

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('sales') . ' ' . $this->lang->line('statement') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/ipd/sales', $this->data);
    }

    /*****************Function sales_pdf**********************************
     * @type            : Function
     * @function name   : sales_pdf
     * @description     : Load "Generate PDF Sales Summary Ipd Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function sales_pdf() {

        check_permission(ADD);

        if ($_GET) {
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $type = $this->input->get('type');
            $doctor_id = $this->input->get('doctor_id');
            $created_by = $this->input->get('created_by');

            $this->data['sales'] = $this->ipd->get_sale_list($form_date, $to_date, $type, $doctor_id, $created_by);
            $this->data['date'] = $date;
            $this->data['form_date'] = $form_date;
            $this->data['to_date'] = $to_date;
            $this->data['type'] = $type;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['created_by'] = $created_by;

            $this->data['createdby'] = $this->ipd->get_single('employees', array('user_id' => $created_by, 'status' => 1));
            $this->data['doctor'] = $this->ipd->get_single('employees', array('user_id' => $doctor_id, 'status' => 1));

            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'L'
            ]);
            $html =  $this->load->view('report/ipd/pdf/sales', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('sales_summary_' . rand() . '.pdf', 'D');
        }
    }

    /*****************Function admitted**********************************
     * @type            : Function
     * @function name   : admitted
     * @description     : Load "Ipd admitted Patient Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function admitted() {

        check_permission(ADD);

        if ($_GET && $this->input->get('date')) {
            $keyword = trim($this->input->get('keyword'));
            $type = $this->input->get('type');
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $doctor_id = $this->input->get('doctor_id');
            $reference_id = $this->input->get('reference_id');
            $created_by = $this->input->get('created_by');

            $this->data['patients'] = $this->ipd->get_admitted_list($keyword, $type, $form_date, $to_date, $doctor_id, $reference_id, $created_by);
            $this->data['keyword'] = $keyword;
            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['reference_id'] = $reference_id;
            $this->data['created_by'] = $created_by;
        }
        if ($_GET && $this->input->get('date') == null) {
            $keyword = trim($this->input->get('keyword'));
            $type = $this->input->get('type');
            $form_date = null;
            $to_date = null;
            $doctor_id = $this->input->get('doctor_id');
            $reference_id = $this->input->get('reference_id');
            $created_by = $this->input->get('created_by');

            $this->data['patients'] = $this->ipd->get_admitted_list($keyword, $type, $form_date, $to_date, $doctor_id, $reference_id, $created_by);
            $this->data['keyword'] = $keyword;
            $this->data['type'] = $type;
            $this->data['date'] = null;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['reference_id'] = $reference_id;
            $this->data['created_by'] = $created_by;
        }

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('admitted') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/ipd/admitted', $this->data);
    }

    /*****************Function admitted_pdf**********************************
     * @type            : Function
     * @function name   : admitted_pdf
     * @description     : Load "Generate Ipd admitted Patietn Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function admitted_pdf() {
        if ($_GET) {
            $keyword = $this->input->get('keyword');
            $type = $this->input->get('type');
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $doctor_id = $this->input->get('doctor_id');
            $reference_id = $this->input->get('reference_id');
            $created_by = $this->input->get('created_by');

            $this->data['patients'] = $this->ipd->get_admitted_list($keyword, $type, $form_date, $to_date, $doctor_id, $reference_id, $created_by);
            $this->data['keyword'] = $keyword;
            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['form_date'] = $form_date;
            $this->data['to_date'] = $to_date;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['created_by'] = $created_by;


            $this->data['createdby'] = $this->ipd->get_single('employees', array('user_id' => $created_by, 'status' => 1));
            $this->data['doctor'] = $this->ipd->get_single('employees', array('user_id' => $doctor_id, 'status' => 1));

            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'L'
            ]);
            $html =  $this->load->view('report/ipd/pdf/admitted', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('admitted_patient_' . rand() . '.pdf', 'D');
        }
    }

    /*****************Function discharge**********************************
     * @type            : Function
     * @function name   : discharge
     * @description     : Load "Ipd discharge Patient Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function discharge() {

        check_permission(ADD);

        if ($_GET) {
            $keyword = trim($this->input->get('keyword'));
            $type = $this->input->get('type');
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $doctor_id = $this->input->get('doctor_id');
            $reference_id = $this->input->get('reference_id');
            $created_by = $this->input->get('created_by');

            $this->data['patients'] = $this->ipd->get_discharge_list($keyword, $type, $form_date, $to_date, $doctor_id, $reference_id, $created_by);
            $this->data['keyword'] = $keyword;
            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['reference_id'] = $reference_id;
            $this->data['created_by'] = $created_by;
        }

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('discharge') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/ipd/discharge', $this->data);
    }

    /*****************Function discharge_pdf**********************************
     * @type            : Function
     * @function name   : discharge_pdf
     * @description     : Load "Generate Ipd discharge Patietn Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function discharge_pdf() {
        if ($_GET) {
            $keyword = $this->input->get('keyword');
            $type = $this->input->get('type');
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $doctor_id = $this->input->get('doctor_id');
            $reference_id = $this->input->get('reference_id');
            $created_by = $this->input->get('created_by');

            $this->data['patients'] = $this->ipd->get_discharge_list($keyword, $type, $form_date, $to_date, $doctor_id, $reference_id, $created_by);
            $this->data['keyword'] = $keyword;
            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['form_date'] = $form_date;
            $this->data['to_date'] = $to_date;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['created_by'] = $created_by;


            $this->data['createdby'] = $this->ipd->get_single('employees', array('user_id' => $created_by, 'status' => 1));
            $this->data['doctor'] = $this->ipd->get_single('employees', array('user_id' => $doctor_id, 'status' => 1));

            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'L'
            ]);
            $html =  $this->load->view('report/ipd/pdf/discharge', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('discharge_patient_' . rand() . '.pdf', 'D');
        }
    }

    /*****************Function assistant**********************************
     * @type            : Function
     * @function name   : assistant
     * @description     : Load "Ipd Assistant Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function assistant() {

        check_permission(ADD);

        if ($_GET) {
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $doctor_id = $this->input->get('doctor_id');

            $this->data['assistants'] = $this->ipd->get_assistant_list($form_date, $to_date, $doctor_id);
            $this->data['date'] = $date;
            $this->data['doctor_id'] = $doctor_id;
        }

        $this->data['assistant_list'] = $this->ipd->get_list('assistants', array('status' => 1));
        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('assistant') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/ipd/assistant', $this->data);
    }

    /*****************Function assistant_pdf**********************************
     * @type            : Function
     * @function name   : assistant_pdf
     * @description     : Load "Generate Ipd Assistant Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function assistant_pdf() {

        if ($_GET) {
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $doctor_id = $this->input->get('doctor_id');

            $this->data['assistants'] = $this->ipd->get_assistant_list($form_date, $to_date, $doctor_id);
            $this->data['date'] = $date;
            $this->data['form_date'] = $form_date;
            $this->data['to_date'] = $to_date;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['doctor'] = $this->ipd->get_single('assistants', array('user_id' => $doctor_id, 'status' => 1));

            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'P'
            ]);
            $html =  $this->load->view('report/ipd/pdf/assistant', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('assistant_' . rand() . '.pdf', 'D');
        }
    }

    /*****************Function surgeon**********************************
     * @type            : Function
     * @function name   : surgeon
     * @description     : Load "Ipd Surgeon Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function surgeon() {

        check_permission(ADD);

        if ($_GET) {
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $doctor_id = $this->input->get('doctor_id');

            $this->data['surgeons'] = $this->ipd->get_surgeon_list($form_date, $to_date, $doctor_id);
            $this->data['date'] = $date;
            $this->data['doctor_id'] = $doctor_id;
        }

        $this->data['surgeon_list'] = $this->ipd->get_doctor_list();
        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('surgeon') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/ipd/surgeon', $this->data);
    }

    /*****************Function surgeon_pdf**********************************
     * @type            : Function
     * @function name   : surgeon_pdf
     * @description     : Load "Generate Ipd Surgeon Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function surgeon_pdf() {

        if ($_GET) {
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $doctor_id = $this->input->get('doctor_id');

            $this->data['surgeons'] = $this->ipd->get_surgeon_list($form_date, $to_date, $doctor_id);
            $this->data['date'] = $date;
            $this->data['form_date'] = $form_date;
            $this->data['to_date'] = $to_date;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['doctor'] = $this->ipd->get_single('employees', array('user_id' => $doctor_id, 'status' => 1));

            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'P'
            ]);
            $html =  $this->load->view('report/ipd/pdf/surgeon', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('surgeon_' . rand() . '.pdf', 'D');
        }
    }

    /*****************Function anesthesia**********************************
     * @type            : Function
     * @function name   : anesthesia
     * @description     : Load "Ipd Anesthesia Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function anesthesia() {

        check_permission(ADD);

        if ($_GET) {
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $doctor_id = $this->input->get('doctor_id');

            $this->data['anesthesias'] = $this->ipd->get_anesthesia_list($form_date, $to_date, $doctor_id);
            $this->data['date'] = $date;
            $this->data['doctor_id'] = $doctor_id;
        }

        $this->data['anesthesia_list'] = $this->ipd->get_list('anesthetists', array('status' => 1));
        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('anesthesia') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/ipd/anesthesia', $this->data);
    }

    /*****************Function anesthesia_pdf**********************************
     * @type            : Function
     * @function name   : anesthesia_pdf
     * @description     : Load "Generate Ipd Anesthesia Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function anesthesia_pdf() {

        if ($_GET) {
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $doctor_id = $this->input->get('doctor_id');

            $this->data['anesthesias'] = $this->ipd->get_anesthesia_list($form_date, $to_date, $doctor_id);
            $this->data['date'] = $date;
            $this->data['form_date'] = $form_date;
            $this->data['to_date'] = $to_date;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['doctor'] = $this->ipd->get_single('anesthetists', array('user_id' => $doctor_id, 'status' => 1));

            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'P'
            ]);
            $html =  $this->load->view('report/ipd/pdf/anesthesia', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('anesthesia_' . rand() . '.pdf', 'D');
        }
    }

    /*****************Function consultant**********************************
     * @type            : Function
     * @function name   : consultant
     * @description     : Load "Ipd Consultant Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function consultant() {

        check_permission(ADD);

        if ($_GET) {
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $doctor_id = $this->input->get('doctor_id');

            $this->data['consultants'] = $this->ipd->get_consultant_list($form_date, $to_date, $doctor_id);
            $this->data['date'] = $date;
            $this->data['doctor_id'] = $doctor_id;
        }

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('consultant') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/ipd/consultant', $this->data);
    }

    /*****************Function consultant_pdf**********************************
     * @type            : Function
     * @function name   : consultant_pdf
     * @description     : Load "Generate Ipd Consultant Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function consultant_pdf() {

        if ($_GET) {
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $doctor_id = $this->input->get('doctor_id');

            $this->data['consultants'] = $this->ipd->get_consultant_list($form_date, $to_date, $doctor_id);
            $this->data['date'] = $date;
            $this->data['form_date'] = $form_date;
            $this->data['to_date'] = $to_date;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['doctor'] = $this->ipd->get_single('employees', array('user_id' => $doctor_id, 'status' => 1));

            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'P'
            ]);
            $html =  $this->load->view('report/ipd/pdf/consultant', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('consultant_' . rand() . '.pdf', 'D');
        }
    }
}
