<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Mis.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Mis
 * @description     : Manage MIS report.
 * @author          : South Bangla IT Zone Team
 * @url             : http://hms.sbitzone.com
 * @support         : rabibd.it@gmail.com
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class Mis extends MY_Controller {

    public $data = array();

    function __construct() {
        parent::__construct();
        $this->load->model('Mis_Model', 'mis', true);

        $this->data['doctors'] = $this->mis->get_doctor_list();
        $this->data['references'] = $this->mis->get_list('employees', array('status' => 1));
        $this->data['employees'] = $this->mis->get_employee_list();
    }

    /*****************Function index**********************************
     * @type            : Function
     * @function name   : index
     * @description     : Load "Mis Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function index() {

        check_permission(VIEW);

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('mis') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/mis/index', $this->data);
    }

    /*****************Function credit**********************************
     * @type            : Function
     * @function name   : credit
     * @description     : Load "Hospital Credit Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function credit() {

        check_permission(VIEW);

        if ($_GET) {
            $type = $this->input->get('type');
            if (!empty($this->input->get('date'))) {
                $date = $this->input->get('date');
                $exp = explode('-', $date);
                $form_date = date('Y-m-d', strtotime($exp[0]));
                $to_date = date('Y-m-d', strtotime($exp[1]));
            } else {
                $date = null;
                $form_date = null;
                $to_date = null;
            }
            $reference_id = $this->input->get('reference_id');
            $created_by = $this->input->get('created_by');

            $this->data['opd_income'] = $this->mis->get_opd_income($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['ipd_income'] = $this->mis->get_ipd_income($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['diagnostic_income'] = $this->mis->get_diagnostic_income($type, $form_date, $to_date, $reference_id, $created_by);
            //$this->data['pharmacy_income'] = $this->mis->get_pharmacy_income($type, $form_date, $to_date, $created_by);
            $this->data['incomes'] = $this->mis->get_income($form_date, $to_date, $created_by);

            // Expense
            $this->data['opd_expense'] = $this->mis->get_opd_expense($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['ipd_expense'] = $this->mis->get_ipd_expense($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['diagnostic_expense'] = $this->mis->get_diagnostic_expense($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['surgeon_expense'] = $this->mis->get_surgeon_expense($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['anesthesia_expense'] = $this->mis->get_anesthesia_expense($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['assistant_expense'] = $this->mis->get_assistant_expense($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['expenditures'] = $this->mis->get_expenditure($form_date, $to_date, $created_by);

            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['form_date'] = $form_date;
            $this->data['to_date'] = $to_date;
            $this->data['reference_id'] = $reference_id;
            $this->data['created_by'] = $created_by;
        }

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('credit') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/mis/credit', $this->data);
    }

    /*****************Function credit_pdf**********************************
     * @type            : Function
     * @function name   : credit_pdf
     * @description     : Load "Generate Hospital Credit Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function credit_pdf() {

        check_permission(VIEW);

        if ($_GET) {
            $type = $this->input->get('type');
            if (!empty($this->input->get('date'))) {
                $date = $this->input->get('date');
                $exp = explode('-', $date);
                $form_date = date('Y-m-d', strtotime($exp[0]));
                $to_date = date('Y-m-d', strtotime($exp[1]));
            } else {
                $date = null;
                $form_date = null;
                $to_date = null;
            }
            $reference_id = $this->input->get('reference_id');
            $created_by = $this->input->get('created_by');

            $this->data['opd_income'] = $this->mis->get_opd_income($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['ipd_income'] = $this->mis->get_ipd_income($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['diagnostic_income'] = $this->mis->get_diagnostic_income($type, $form_date, $to_date, $reference_id, $created_by);
            //$this->data['pharmacy_income'] = $this->mis->get_pharmacy_income($type, $form_date, $to_date, $created_by);
            $this->data['incomes'] = $this->mis->get_income($form_date, $to_date, $created_by);

            // Expense
            $this->data['opd_expense'] = $this->mis->get_opd_expense($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['ipd_expense'] = $this->mis->get_ipd_expense($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['diagnostic_expense'] = $this->mis->get_diagnostic_expense($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['surgeon_expense'] = $this->mis->get_surgeon_expense($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['anesthesia_expense'] = $this->mis->get_anesthesia_expense($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['assistant_expense'] = $this->mis->get_assistant_expense($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['expenditures'] = $this->mis->get_expenditure($form_date, $to_date, $created_by);

            $this->data['created'] = $this->mis->get_single('employees', array('user_id' => $created_by, 'status' => 1));

            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['form_date'] = $form_date;
            $this->data['to_date'] = $to_date;
            $this->data['reference_id'] = $reference_id;
            $this->data['created_by'] = $created_by;

            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'L'
            ]);
            $html =  $this->load->view('report/mis/pdf/credit', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('credit_' . rand() . '.pdf', 'I');
        }
    }

    /*****************Function transaction**********************************
     * @type            : Function
     * @function name   : transaction
     * @description     : Load "Hospital Transaction Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function transaction() {

        check_permission(VIEW);

        if ($_GET) {
            $type = $this->input->get('type');
            if (!empty($this->input->get('date'))) {
                $date = $this->input->get('date');
                $exp = explode('-', $date);
                $form_date = date('Y-m-d', strtotime($exp[0]));
                $to_date = date('Y-m-d', strtotime($exp[1]));
            } else {
                $date = null;
                $form_date = null;
                $to_date = null;
            }
            $reference_id = $this->input->get('reference_id');
            $created_by = $this->input->get('created_by');

            $this->data['ipd_transaction'] = $this->mis->get_ipd_transaction($form_date, $to_date, $created_by);
            $this->data['diagnostic_transaction'] = $this->mis->get_diagnostic_transaction($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['opd_transaction'] = $this->mis->get_opd_transaction($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['pharmacy_income'] = $this->mis->get_pharmacy_income($type, $form_date, $to_date, $created_by);
            $this->data['incomes'] = $this->mis->get_income($form_date, $to_date, $created_by);

            // Expense
            $this->data['ipd_expense'] = $this->mis->get_ipd_expense($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['diagnostic_expense'] = $this->mis->get_diagnostic_expense($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['surgeon_expense'] = $this->mis->get_surgeon_expense($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['anesthesia_expense'] = $this->mis->get_anesthesia_expense($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['assistant_expense'] = $this->mis->get_assistant_expense($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['expenditures'] = $this->mis->get_expenditure($form_date, $to_date, $created_by);

            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['form_date'] = $form_date;
            $this->data['to_date'] = $to_date;
            $this->data['reference_id'] = $reference_id;
            $this->data['created_by'] = $created_by;
        }

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('transaction') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/mis/transaction', $this->data);
    }

    /*****************Function transaction_pdf**********************************
     * @type            : Function
     * @function name   : transaction_pdf
     * @description     : Load "Generate Hospital Transaction Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function transaction_pdf() {

        check_permission(VIEW);

        if ($_GET) {
            $type = $this->input->get('type');
            if (!empty($this->input->get('date'))) {
                $date = $this->input->get('date');
                $exp = explode('-', $date);
                $form_date = date('Y-m-d', strtotime($exp[0]));
                $to_date = date('Y-m-d', strtotime($exp[1]));
            } else {
                $date = null;
                $form_date = null;
                $to_date = null;
            }
            $reference_id = $this->input->get('reference_id');
            $created_by = $this->input->get('created_by');

            $this->data['ipd_transaction'] = $this->mis->get_ipd_transaction($form_date, $to_date, $created_by);
            $this->data['diagnostic_transaction'] = $this->mis->get_diagnostic_transaction($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['opd_transaction'] = $this->mis->get_opd_transaction($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['pharmacy_income'] = $this->mis->get_pharmacy_income($type, $form_date, $to_date, $created_by);
            $this->data['incomes'] = $this->mis->get_income($form_date, $to_date, $created_by);

            // Expense
            $this->data['ipd_expense'] = $this->mis->get_ipd_expense($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['diagnostic_expense'] = $this->mis->get_diagnostic_expense($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['surgeon_expense'] = $this->mis->get_surgeon_expense($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['anesthesia_expense'] = $this->mis->get_anesthesia_expense($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['assistant_expense'] = $this->mis->get_assistant_expense($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['expenditures'] = $this->mis->get_expenditure($form_date, $to_date, $created_by);

            $this->data['created'] = $this->mis->get_single('employees', array('user_id' => $created_by, 'status' => 1));

            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['form_date'] = $form_date;
            $this->data['to_date'] = $to_date;
            $this->data['reference_id'] = $reference_id;
            $this->data['created_by'] = $created_by;

            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'L'
            ]);
            $html =  $this->load->view('report/mis/pdf/transaction', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('transaction_' . rand() . '.pdf', 'I');
        }
    }

    /*****************Function transaction_detail**********************************
     * @type            : Function
     * @function name   : transaction
     * @description     : Load "Hospital Transaction Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function transaction_detail() {

        check_permission(VIEW);

        if ($_GET) {
            $type = $this->input->get('type');
            if (!empty($this->input->get('date'))) {
                $date = $this->input->get('date');
                $exp = explode('-', $date);
                $form_date = date('Y-m-d', strtotime($exp[0]));
                $to_date = date('Y-m-d', strtotime($exp[1]));
            } else {
                $date = null;
                $form_date = null;
                $to_date = null;
            }
            $reference_id = $this->input->get('reference_id');
            $created_by = $this->input->get('created_by');

            $this->data['diagnostic_transaction'] = $this->mis->get_diagnostic_transaction_detail($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['ipd_transaction'] = $this->mis->get_ipd_transaction_detail($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['opd_transaction'] = $this->mis->get_opd_transaction_detail($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['sd_diagnostic_payment'] = $this->mis->get_sd_diagnostic_payment_detail($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['sd_ipd_payment'] = $this->mis->get_sd_ipd_payment_detail($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['surgeon_payment'] = $this->mis->get_surgeon_payment_detail($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['anesthesia_payment'] = $this->mis->get_anesthesia_payment_detail($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['assistant_payment'] = $this->mis->get_assistant_payment_detail($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['other_income'] = $this->mis->get_other_income_detail($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['other_expense'] = $this->mis->get_other_expense_detail($type, $form_date, $to_date, $reference_id, $created_by);

            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['form_date'] = $form_date;
            $this->data['to_date'] = $to_date;
            $this->data['reference_id'] = $reference_id;
            $this->data['created_by'] = $created_by;
        }

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('transaction') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/mis/transaction-detail', $this->data);
    }

    /*****************Function transaction_detail_pdf**********************************
     * @type            : Function
     * @function name   : transaction_detail_pdf
     * @description     : Load "Generate Hospital Transaction Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function transaction_detail_pdf() {

        check_permission(VIEW);

        if ($_GET) {
            $type = $this->input->get('type');
            if (!empty($this->input->get('date'))) {
                $date = $this->input->get('date');
                $exp = explode('-', $date);
                $form_date = date('Y-m-d', strtotime($exp[0]));
                $to_date = date('Y-m-d', strtotime($exp[1]));
            } else {
                $date = null;
                $form_date = null;
                $to_date = null;
            }
            $reference_id = $this->input->get('reference_id');
            $created_by = $this->input->get('created_by');

            $this->data['diagnostic_transaction'] = $this->mis->get_diagnostic_transaction_detail($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['ipd_transaction'] = $this->mis->get_ipd_transaction_detail($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['opd_transaction'] = $this->mis->get_opd_transaction_detail($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['sd_diagnostic_payment'] = $this->mis->get_sd_diagnostic_payment_detail($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['sd_ipd_payment'] = $this->mis->get_sd_ipd_payment_detail($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['surgeon_payment'] = $this->mis->get_surgeon_payment_detail($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['anesthesia_payment'] = $this->mis->get_anesthesia_payment_detail($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['assistant_payment'] = $this->mis->get_assistant_payment_detail($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['other_income'] = $this->mis->get_other_income_detail($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['other_expense'] = $this->mis->get_other_expense_detail($type, $form_date, $to_date, $reference_id, $created_by);

            $this->data['created'] = $this->mis->get_single('employees', array('user_id' => $created_by, 'status' => 1));

            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['form_date'] = $form_date;
            $this->data['to_date'] = $to_date;
            $this->data['reference_id'] = $reference_id;
            $this->data['created_by'] = $created_by;

            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'L'
            ]);
            $html =  $this->load->view('report/mis/pdf/transaction-detail', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('transaction-detail_' . rand() . '.pdf', 'I');
        }
    }
}
