<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Opd.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Opd
 * @description     : Manage opd report.
 * @author          : South Bangla IT Zone Team
 * @url             : http://hms.sbitzone.com
 * @support         : rabibd.it@gmail.com
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class Opd extends MY_Controller {

    public $data = array();

    function __construct() {
        parent::__construct();
        $this->load->model('Opd_Model', 'opd', true);
    }

    /*****************Function index**********************************
     * @type            : Function
     * @function name   : index
     * @description     : Load "Opd Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function index() {

        check_permission(VIEW);

        if ($_GET) {
            $keyword = trim($this->input->get('keyword'));
            $type = $this->input->get('type');
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $doctor_id = $this->input->get('doctor_id');
            $reference_id = $this->input->get('reference_id');
            $reference_person = $this->input->get('reference_person');
            $created_by = $this->input->get('created_by');

            $this->data['opds'] = $this->opd->get_opd_list($keyword, $type, $form_date, $to_date, $doctor_id, $reference_id, $reference_person, $created_by);
            $this->data['keyword'] = $keyword;
            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['reference_id'] = $reference_id;
            $this->data['reference_person'] = $reference_person;
            $this->data['created_by'] = $created_by;
        }

        $this->data['doctors'] = $this->opd->get_doctor_list();
        $this->data['references'] = $this->opd->get_list('employees', array('status' => 1));
        $this->data['employees'] = $this->opd->get_employee_list();
        $this->data['reference_persons'] = $this->opd->get_reference_person_list();
        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('opd') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/opd/index', $this->data);
    }

    public function pdf() {
        if ($_GET) {
            $keyword = trim($this->input->get('keyword'));
            $type = $this->input->get('type');
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $doctor_id = $this->input->get('doctor_id');
            $reference_id = $this->input->get('reference_id');
            $reference_person = $this->input->get('reference_person');
            $created_by = $this->input->get('created_by');

            $this->data['opds'] = $this->opd->get_opd_list($keyword, $type, $form_date, $to_date, $doctor_id, $reference_id, $reference_person, $created_by);
            $this->data['form_date'] = $form_date;
            $this->data['reference_person'] = $this->opd->get_single('employees', array('user_id' => $reference_person));
            $this->data['doctor'] = $this->opd->get_single_doctor($doctor_id);

            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'L'
            ]);
            $html =  $this->load->view('report/opd/pdf', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('opd_' . rand() . '.pdf', 'D');
        }
    }
}
