<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Payment.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Payment
 * @description     : Manage payment report.
 * @author          : South Bangla IT Zone Team
 * @url             : http://hms.sbitzone.com
 * @support         : rabibd.it@gmail.com
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class Payment extends MY_Controller {

    public $data = array();

    function __construct() {
        parent::__construct();
        $this->load->model('Payment_Model', 'payment', true);
    }

    /*****************Function index**********************************
     * @type            : Function
     * @function name   : index
     * @description     : Load "Payment Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function index() {

        check_permission(VIEW);

        if ($_GET && $this->input->get('invoice_type')) {
            $invoice_type = $this->input->get('invoice_type');
            $payment_type = $this->input->get('payment_type');
            if ($this->input->get('date')) {
                $date = $this->input->get('date');
                $exp = explode('-', $date);
                $form_date = date('Y-m-d', strtotime($exp[0]));
                $to_date = date('Y-m-d', strtotime($exp[1]));
            } else {
                $date = null;
                $form_date = null;
                $to_date = null;
            }
            $keyword = trim($this->input->get('keyword'));
            $doctor_id = $this->input->get('doctor_id');
            $reference_id = $this->input->get('reference_id');
            $created_by = $this->input->get('created_by');

            $this->data['payments'] = $this->payment->get_payment_list($invoice_type, $payment_type, $form_date, $to_date, $keyword, $doctor_id, $reference_id, $created_by);
            $this->data['invoice_type'] = $invoice_type;
            $this->data['payment_type'] = $payment_type;
            $this->data['date'] = $date;
            $this->data['keyword'] = $keyword;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['reference_id'] = $reference_id;
            $this->data['created_by'] = $created_by;
        }

        $this->data['doctors'] = $this->payment->get_doctor_list();
        $this->data['references'] = $this->payment->get_list('employees', array('status' => 1));
        $this->data['employees'] = $this->payment->get_employee_list();
        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('payment') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/payment/index', $this->data);
    }

    public function pdf() {

        if ($_GET && $this->input->get('invoice_type')) {
            $invoice_type = $this->input->get('invoice_type');
            $payment_type = $this->input->get('payment_type');
            if ($this->input->get('date')) {
                $date = $this->input->get('date');
                $exp = explode('-', $date);
                $form_date = date('Y-m-d', strtotime($exp[0]));
                $to_date = date('Y-m-d', strtotime($exp[1]));
            } else {
                $date = null;
                $form_date = null;
                $to_date = null;
            }
            $keyword = trim($this->input->get('keyword'));
            $doctor_id = $this->input->get('doctor_id');
            $reference_id = $this->input->get('reference_id');
            $created_by = $this->input->get('created_by');

            $this->data['payments'] = $this->payment->get_payment_list($invoice_type, $payment_type, $form_date, $to_date, $keyword, $doctor_id, $reference_id, $created_by);
            $this->data['reference'] = $this->payment->get_single_reference($reference_id);
            $this->data['invoice_type'] = $invoice_type;
            $this->data['payment_type'] = $payment_type;
            $this->data['date'] = $date;
            $this->data['keyword'] = $keyword;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['reference_id'] = $reference_id;
            $this->data['created_by'] = $created_by;
            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'L'
            ]);
            $html =  $this->load->view('report/payment/pdf', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('payment_' . date('Y-m-d') . '.pdf', 'D');
        }
    }
}
