<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Billing_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }
    public function get_doctor_list() {
        $this->db->select('C.*, E.name, E.phone, E.user_id');
        $this->db->from('doctor_charges AS C');
        $this->db->join('employees AS E', 'E.user_id = C.doctor_id', 'left');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('U.role_id', DOCTOR);
        $this->db->where('E.status', 1);
        $this->db->order_by('E.id', 'ASC');
        return $this->db->get()->result();
    }

    public function get_employee_list() {
        $this->db->select('E.*');
        $this->db->from('employees AS E');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('E.status', '1');
        if ($this->session->userdata('role_id') == SUPER_ADMIN) {
            $this->db->where_in('U.role_id', array(SUPER_ADMIN, ADMIN, ACCOUNTANT, RECEPTIONIST));
        } else {
            $this->db->where_in('U.role_id', array(ADMIN, ACCOUNTANT, RECEPTIONIST));
        }
        $this->db->order_by('E.id ', 'DESC');
        return $this->db->get()->result();
    }

    public function get_reference_person_list() {
        $this->db->select('E.*');
        $this->db->from('employees AS E');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('E.commission_type', 'emp');
        $this->db->where('E.status', '1');
        $this->db->order_by('E.id ', 'DESC');
        return $this->db->get()->result();
    }

    public function get_single_reference($commission_user_id) {
        $this->db->select('I.*, E.name as commission, D.name as designation');
        $this->db->from('invoices AS I');
        $this->db->join('employees AS E', 'E.user_id = I.commission_user_id', 'left');
        $this->db->join('designations AS D', 'D.id = E.designation_id', 'left');
        if ($commission_user_id) {
            $this->db->where('I.commission_user_id', $commission_user_id);
        }
        return $this->db->get()->row();
    }

    public function get_collection_list($collection_type, $keyword, $form_date, $to_date, $doctor_id, $reference_id, $created_by) {
        $this->db->select('IP.*, I.custom_invoice_id, I.bill_date, I.self, I.ref_dr_id, I.ref_dr_name, I.total_bill, P.patient_unique_id, P.name as patient, P.phone, D.name as doctor, R.name as reference, C.name as created_by');
        $this->db->from('invoice_payments AS IP');
        $this->db->join('invoices AS I', 'I.id = IP.invoice_id', 'left');
        $this->db->join('patients AS P', 'P.user_id = I.patient_id', 'left');
        $this->db->join('employees AS D', 'D.user_id = I.ref_dr_id', 'left');
        $this->db->join('employees AS R', 'R.user_id = I.commission_user_id', 'left');
        $this->db->join('employees AS C', 'C.user_id = IP.created_by', 'left');
        if ($collection_type == 3) {
            $this->db->where('I.commission_user_id >', 0);
        }
        if ($collection_type == 4) {
            $this->db->group_start();
            $this->db->where('I.commission_user_id', 0);
            $this->db->or_where('I.commission_user_id', NULL);
            $this->db->or_where('I.commission_user_id', '');
            $this->db->group_end();
        }
        if ($collection_type == 1 || $collection_type == 2) {
            $this->db->where('IP.collection_type', $collection_type);
        }
        if ($keyword) {
            $this->db->like('P.patient_unique_id', $keyword);
            $this->db->or_like('P.name', $keyword, 'both');
            $this->db->or_like('P.phone', $keyword, 'both');
            $this->db->or_like('P.address', $keyword, 'both');
            $this->db->or_like('D.name', $keyword, 'both');
            $this->db->or_like('R.name', $keyword, 'both');
        }
        if ($form_date && $to_date) {
            $this->db->where("DATE(IP.payment_date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($doctor_id) {
            $this->db->where('I.ref_dr_id', $doctor_id);
        }
        if ($reference_id) {
            $this->db->where('I.commission_user_id', $reference_id);
        }
        if ($created_by) {
            $this->db->where('IP.created_by', $created_by);
        }
        $this->db->where('I.payment_status', 'complete');
        $this->db->order_by('IP.id', 'ASC');
        return $this->db->get()->result();
    }

    public function get_due_list($keyword, $type, $form_date, $to_date, $doctor_id, $reference_id, $created_by) {
        $this->db->select('IP.*, I.custom_invoice_id, I.due_amount, I.bill_date, P.patient_unique_id, P.name as patient, P.phone, D.name as doctor, R.name as reference, C.name as created_by');
        $this->db->from('invoice_payments AS IP');
        $this->db->join('invoices AS I', 'I.id = IP.invoice_id', 'left');
        $this->db->join('patients AS P', 'P.user_id = I.patient_id', 'left');
        $this->db->join('employees AS D', 'D.user_id = I.ref_dr_id', 'left');
        $this->db->join('employees AS R', 'R.user_id = I.commission_user_id', 'left');
        $this->db->join('employees AS C', 'C.user_id = I.created_by', 'left');
        if ($keyword) {
            $this->db->like('P.patient_unique_id', $keyword);
            $this->db->or_like('P.name', $keyword, 'both');
            $this->db->or_like('P.phone', $keyword, 'both');
            $this->db->or_like('P.address', $keyword, 'both');
            $this->db->or_like('D.name', $keyword, 'both');
            $this->db->or_like('R.name', $keyword, 'both');
        }
        if ($type == 1) {
            $this->db->group_start();
            $this->db->where('I.commission_user_id', 0);
            $this->db->or_where('I.commission_user_id', NULL);
            $this->db->or_where('I.commission_user_id', '');
            $this->db->group_end();
        }
        if ($type == 2) {
            $this->db->where('I.commission_user_id >', 0);
        }
        if ($type == 3) {
            $this->db->where('I.is_ipd', 1);
        }
        if ($type == 4) {
            $this->db->where('I.is_ipd', 0);
        }
        if ($form_date && $to_date) {
            $this->db->where("DATE(IP.payment_date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($doctor_id) {
            $this->db->where('I.ref_dr_id', $doctor_id);
        }
        if ($reference_id) {
            $this->db->where('I.commission_user_id', $reference_id);
        }
        if ($created_by) {
            $this->db->where('IP.created_by', $created_by);
        }
        $this->db->where('I.payment_status', 'complete');
        $this->db->where('I.paid_status', 'unpaid');
        $this->db->group_by('I.id');
        $this->db->order_by('IP.id', 'ASC');
        return $this->db->get()->result();
    }

    public function get_rejected_list($keyword, $type, $form_date, $to_date, $doctor_id, $reference_id, $created_by, $rejected_by) {
        $this->db->select('I.*, P.patient_unique_id, P.name as patient, P.phone, D.name as doctor, R.name as reference, C.name as created_by, M.name as rejected_by');
        $this->db->from('invoices AS I');
        $this->db->join('patients AS P', 'P.user_id = I.patient_id', 'left');
        $this->db->join('employees AS D', 'D.user_id = I.ref_dr_id', 'left');
        $this->db->join('employees AS R', 'R.user_id = I.commission_user_id', 'left');
        $this->db->join('employees AS C', 'C.user_id = I.created_by', 'left');
        $this->db->join('employees AS M', 'M.user_id = I.modified_by', 'left');
        if ($keyword) {
            $this->db->like('P.patient_unique_id', $keyword);
            $this->db->or_like('P.name', $keyword, 'both');
            $this->db->or_like('P.phone', $keyword, 'both');
            $this->db->or_like('P.address', $keyword, 'both');
            $this->db->or_like('D.name', $keyword, 'both');
            $this->db->or_like('R.name', $keyword, 'both');
        }
        if ($type == 1) {
            $this->db->group_start();
            $this->db->where('I.commission_user_id', 0);
            $this->db->or_where('I.commission_user_id', NULL);
            $this->db->or_where('I.commission_user_id', '');
            $this->db->group_end();
        }
        if ($type == 2) {
            $this->db->where('I.commission_user_id >', 0);
        }
        if ($form_date && $to_date) {
            $this->db->where("DATE(I.bill_date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($doctor_id) {
            $this->db->where('I.ref_dr_id', $doctor_id);
        }
        if ($reference_id) {
            $this->db->where('I.commission_user_id', $reference_id);
        }
        if ($created_by) {
            $this->db->where('I.created_by', $created_by);
        }
        if ($rejected_by) {
            $this->db->where('I.modified_by', $rejected_by);
        }
        $this->db->where('I.payment_status', 'rejected');
        $this->db->order_by('I.id', 'ASC');
        return $this->db->get()->result();
    }

    public function get_income_list($keyword, $type, $form_date, $to_date, $doctor_id, $reference_id, $reference_person, $created_by) {
        $this->db->select('I.*, P.patient_unique_id, P.name as patient, P.phone, D.name as doctor, R.name as reference');
        $this->db->from('invoices AS I');
        $this->db->join('patients AS P', 'P.user_id = I.patient_id', 'left');
        $this->db->join('employees AS D', 'D.user_id = I.ref_dr_id', 'left');
        $this->db->join('employees AS R', 'R.user_id = I.commission_user_id', 'left');
        if ($keyword) {
            $this->db->like('P.patient_unique_id', $keyword);
            $this->db->or_like('P.name', $keyword, 'both');
            $this->db->or_like('P.phone', $keyword, 'both');
            $this->db->or_like('P.address', $keyword, 'both');
            $this->db->or_like('D.name', $keyword, 'both');
            $this->db->or_like('R.name', $keyword, 'both');
        }
        if ($type == 1) {
            $this->db->group_start();
            $this->db->where('I.commission_user_id', 0);
            $this->db->or_where('I.commission_user_id', NULL);
            $this->db->or_where('I.commission_user_id', '');
            $this->db->group_end();
        }
        if ($type == 2) {
            $this->db->where('I.commission_user_id >', 0);
        }
        if ($form_date && $to_date) {
            $this->db->where("DATE(I.bill_date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($doctor_id) {
            $this->db->where('I.ref_dr_id', $doctor_id);
        }
        if ($reference_id) {
            $this->db->where('I.commission_user_id', $reference_id);
        }
        if ($reference_person) {
            $this->db->where('I.reference_person', $reference_person);
        }
        if ($created_by) {
            $this->db->where('I.created_by', $created_by);
        }
        $this->db->where('I.payment_status', 'complete');
        $this->db->order_by('I.id', 'ASC');
        return $this->db->get()->result();
    }

    public function get_patient_investigation_list($keyword, $type, $form_date, $to_date, $doctor_id, $reference_id, $created_by) {
        $this->db->select('I.*, P.patient_unique_id, P.name as patient, P.phone, D.name as doctor, R.id as reference_id, R.name as reference');
        $this->db->from('invoices AS I');
        $this->db->join('patients AS P', 'P.user_id = I.patient_id', 'left');
        $this->db->join('employees AS D', 'D.user_id = I.ref_dr_id', 'left');
        $this->db->join('employees AS R', 'R.user_id = I.commission_user_id', 'left');
        if ($keyword) {
            $this->db->like('P.patient_unique_id', $keyword);
            $this->db->or_like('P.name', $keyword, 'both');
            $this->db->or_like('P.phone', $keyword, 'both');
            $this->db->or_like('P.address', $keyword, 'both');
            $this->db->or_like('D.name', $keyword, 'both');
            $this->db->or_like('R.name', $keyword, 'both');
        }
        if ($type == 1) {
            $this->db->group_start();
            $this->db->where('I.commission_user_id', 0);
            $this->db->or_where('I.commission_user_id', NULL);
            $this->db->or_where('I.commission_user_id', '');
            $this->db->group_end();
        }
        if ($type == 2) {
            $this->db->where('I.commission_user_id >', 0);
        }
        if ($form_date && $to_date) {
            $this->db->where("DATE(I.bill_date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($doctor_id) {
            $this->db->where('I.ref_dr_id', $doctor_id);
        }
        if ($reference_id) {
            $this->db->where('I.commission_user_id', $reference_id);
        }
        if ($created_by) {
            $this->db->where('I.created_by', $created_by);
        }
        $this->db->where('I.payment_status', 'complete');
        $this->db->order_by('I.id', 'ASC');
        return $this->db->get()->result();
    }

    public function get_patient_test_list($invoice_id, $patient_id) {
        $this->db->select('ID.*, T.name as test_name');
        $this->db->from('invoice_details AS ID');
        $this->db->join('invoices AS I', 'I.id = ID.invoice_id', 'left');
        $this->db->join('diagnostic_tests AS T', 'T.id = ID.investagation_id', 'left');
        $this->db->where('I.id', $invoice_id);
        $this->db->where('I.patient_id', $patient_id);
        $this->db->where('I.payment_status', 'complete');
        return $this->db->get()->result();
    }

    public function get_summary_list($form_date, $to_date, $type, $doctor_id, $created_by) {
        $this->db->select('IP.*');
        $this->db->from('invoice_payments AS IP');
        $this->db->join('invoices AS I', 'I.id = IP.invoice_id', 'left');
        if ($form_date && $to_date) {
            $this->db->where("DATE(IP.payment_date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($type == 1) {
            $this->db->group_start();
            $this->db->where('I.commission_user_id', 0);
            $this->db->or_where('I.commission_user_id', NULL);
            $this->db->or_where('I.commission_user_id', '');
            $this->db->group_end();
        }
        if ($type == 2) {
            $this->db->where('I.commission_user_id >', 0);
        }
        if ($doctor_id) {
            $this->db->where('I.ref_dr_id', $doctor_id);
        }
        if ($created_by) {
            $this->db->where('IP.created_by', $created_by);
        }
        $this->db->where('I.payment_status', 'complete');
        return $this->db->get()->result();
    }

    public function get_opd_summary_list($form_date, $to_date, $type, $doctor_id, $created_by) {
        $this->db->select('OP.*, SUM(OP.doctor_charge) as total_doctor_charge');
        $this->db->from('opd_patients AS OP');
        if ($form_date && $to_date) {
            $this->db->where("DATE(OP.appointment_date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($type == 1) {
            $this->db->group_start();
            $this->db->where('OP.reference_id', 0);
            $this->db->or_where('OP.reference_id', NULL);
            $this->db->or_where('OP.reference_id', '');
            $this->db->group_end();
        }
        if ($type == 2) {
            $this->db->where('OP.reference_id >', 0);
        }
        if ($doctor_id) {
            $this->db->where('OP.doctor_id', $doctor_id);
        }
        if ($created_by) {
            $this->db->where('OP.created_by', $created_by);
        }
        $this->db->where('OP.payment_status', 'complete');
        return $this->db->get()->row();
    }

    public function get_opd_statement_list($form_date, $to_date, $type, $doctor_id, $created_by) {
        $this->db->select('OP.*');
        $this->db->from('opd_patients AS OP');
        if ($form_date && $to_date) {
            $this->db->where("DATE(OP.appointment_date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($type == 1) {
            $this->db->group_start();
            $this->db->where('OP.reference_id', 0);
            $this->db->or_where('OP.reference_id', NULL);
            $this->db->or_where('OP.reference_id', '');
            $this->db->group_end();
        }
        if ($type == 2) {
            $this->db->where('OP.reference_id >', 0);
        }
        if ($doctor_id) {
            $this->db->where('OP.doctor_id', $doctor_id);
        }
        if ($created_by) {
            $this->db->where('OP.created_by', $created_by);
        }
        return $this->db->get()->result();
    }

    public function get_investigation_list($form_date, $to_date, $type, $doctor_id, $created_by) {
        $this->db->select('I.*');
        $this->db->from('invoices AS I');
        if ($form_date && $to_date) {
            $this->db->where("DATE(I.bill_date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($type == 1) {
            $this->db->group_start();
            $this->db->where('I.commission_user_id', 0);
            $this->db->or_where('I.commission_user_id', NULL);
            $this->db->or_where('I.commission_user_id', '');
            $this->db->group_end();
        }
        if ($type == 2) {
            $this->db->where('I.commission_user_id >', 0);
        }
        if ($doctor_id) {
            $this->db->where('I.ref_dr_id', $doctor_id);
        }
        if ($created_by) {
            $this->db->where('I.created_by', $created_by);
        }
        return $this->db->get()->result();
    }

    public function get_investigation_payment_list($form_date, $to_date, $type, $doctor_id, $created_by) {
        $this->db->select('IP.*, I.payment_status');
        $this->db->from('invoice_payments AS IP');
        $this->db->join('invoices AS I', 'I.id = IP.invoice_id', 'left');
        if ($form_date && $to_date) {
            $this->db->where("DATE(IP.payment_date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($type == 1) {
            $this->db->group_start();
            $this->db->where('I.commission_user_id', 0);
            $this->db->or_where('I.commission_user_id', NULL);
            $this->db->or_where('I.commission_user_id', '');
            $this->db->group_end();
        }
        if ($type == 2) {
            $this->db->where('I.commission_user_id >', 0);
        }
        if ($doctor_id) {
            $this->db->where('I.ref_dr_id', $doctor_id);
        }
        if ($created_by) {
            $this->db->where('IP.created_by', $created_by);
        }
        return $this->db->get()->result();
    }

    public function get_sale_list($form_date, $to_date, $type, $doctor_id, $created_by) {
        $this->db->select('I.*, 
        SUM(I.total_bill) as total_bill_amount, 
        SUM(I.special_discount) as total_special_discount, 
        SUM(I.discount) as total_discount, 
        SUM(I.net_payable) as total_net_payable, 
        SUM(I.advanced) as total_advanced,
        SUM(I.due_amount) as total_due_amount');
        $this->db->from('invoices AS I');
        if ($form_date && $to_date) {
            $this->db->where("DATE(I.bill_date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($type == 1) {
            $this->db->group_start();
            $this->db->where('I.commission_user_id', 0);
            $this->db->or_where('I.commission_user_id', NULL);
            $this->db->or_where('I.commission_user_id', '');
            $this->db->group_end();
        }
        if ($type == 2) {
            $this->db->where('I.commission_user_id >', 0);
        }
        if ($doctor_id) {
            $this->db->where('I.ref_dr_id', $doctor_id);
        }
        if ($created_by) {
            $this->db->where('I.created_by', $created_by);
        }
        $this->db->where('I.payment_status', 'complete');
        $this->db->group_by('DATE(I.bill_date)');
        $this->db->order_by('DATE(I.bill_date)', 'ASC');
        return $this->db->get()->result();
    }

    public function get_test_list($keyword, $department_id, $group_id) {
        $this->db->select('T.*, D.name as department, G.name as group');
        $this->db->from('diagnostic_tests AS T');
        $this->db->join('diagnostic_departments AS D', 'D.id = T.department_id', 'left');
        $this->db->join('diagnostic_groups AS G', 'D.id = T.group_id', 'left');
        if ($keyword) {
            $this->db->like('T.code', $keyword);
            $this->db->or_like('T.name', $keyword, 'both');
            $this->db->or_like('D.name', $keyword, 'both');
            $this->db->or_like('G.name', $keyword, 'both');
        }
        if ($department_id) {
            $this->db->where('T.department_id', $department_id);
        }
        if ($group_id) {
            $this->db->where('T.group_id', $group_id);
        }
        $this->db->group_by('T.id');
        $this->db->order_by('T.id', 'ASC');
        return $this->db->get()->result();
    }

    public function count_all_invoice_details($investagation_id, $form_date, $to_date, $type, $doctor_id, $reference_id, $created_by) {
        $this->db->select('ID.*, COUNT(ID.investagation_id) as total_test, SUM(ID.total_rate) as total, SUM(ID.total_discount) as discount');
        $this->db->from('invoice_details AS ID');
        $this->db->join('invoices AS I', 'I.id = ID.invoice_id', 'left');
        if ($form_date && $to_date) {
            $this->db->where("DATE(ID.created_at) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($type == 1) {
            $this->db->group_start();
            $this->db->where('I.commission_user_id', 0);
            $this->db->or_where('I.commission_user_id', NULL);
            $this->db->or_where('I.commission_user_id', '');
            $this->db->group_end();
        }
        if ($type == 2) {
            $this->db->where('I.commission_user_id >', 0);
        }
        if ($doctor_id) {
            $this->db->where('I.ref_dr_id', $doctor_id);
        }
        if ($reference_id) {
            $this->db->where('I.commission_user_id', $reference_id);
        }
        if ($created_by) {
            $this->db->where('ID.created_by', $created_by);
        }
        $this->db->where('ID.investagation_id', $investagation_id);
        $this->db->where('I.payment_status', 'complete');
        return $this->db->get()->row();
    }

    public function get_authorized_list($keyword, $type, $form_date, $to_date, $doctor_id, $reference_id, $created_by) {
        $this->db->select('I.*, P.patient_unique_id, P.name as patient, P.phone, D.name as doctor, R.name as reference, C.name as created_by, A.name as authorized_person');
        $this->db->from('invoices AS I');
        $this->db->join('patients AS P', 'P.user_id = I.patient_id', 'left');
        $this->db->join('employees AS D', 'D.user_id = I.ref_dr_id', 'left');
        $this->db->join('employees AS R', 'R.user_id = I.commission_user_id', 'left');
        $this->db->join('employees AS C', 'C.user_id = I.created_by', 'left');
        $this->db->join('employees AS A', 'A.user_id = I.authorized_person', 'left');
        if ($keyword) {
            $this->db->like('P.patient_unique_id', $keyword);
            $this->db->or_like('P.name', $keyword, 'both');
            $this->db->or_like('P.phone', $keyword, 'both');
            $this->db->or_like('P.address', $keyword, 'both');
            $this->db->or_like('D.name', $keyword, 'both');
            $this->db->or_like('R.name', $keyword, 'both');
        }
        if ($type == 1) {
            $this->db->group_start();
            $this->db->where('I.commission_user_id', 0);
            $this->db->or_where('I.commission_user_id', NULL);
            $this->db->or_where('I.commission_user_id', '');
            $this->db->group_end();
        }
        if ($type == 2) {
            $this->db->where('I.commission_user_id >', 0);
        }
        if ($form_date && $to_date) {
            $this->db->where("DATE(I.bill_date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($doctor_id) {
            $this->db->where('I.ref_dr_id', $doctor_id);
        }
        if ($reference_id) {
            $this->db->where('I.commission_user_id', $reference_id);
        }
        if ($created_by) {
            $this->db->where('I.created_by', $created_by);
        }
        $this->db->where('I.payment_status', 'complete');
        $this->db->where('I.paid_status', 'paid');
        $this->db->where('I.authorized_person >', '0');
        $this->db->order_by('I.id', 'ASC');
        return $this->db->get()->result();
    }

    public function get_employee_evaluation_list($form_date, $to_date, $reference_person) {
        $this->db->select('I.*, E.name as employee, E.phone, E.joining_date, E.blood_group, D.name as designation');
        $this->db->from('invoices AS I');
        $this->db->join('employees AS E', 'E.user_id = I.reference_person', 'left');
        $this->db->join('designations AS D', 'D.id = E.designation_id', 'left');
        if ($form_date && $to_date) {
            $this->db->where("DATE(I.bill_date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($reference_person) {
            $this->db->select('I.*, P.patient_unique_id, P.name as patient, P.phone, DC.name as doctor, R.name as reference, C.name as created_by');
            $this->db->join('patients AS P', 'P.user_id = I.patient_id', 'left');
            $this->db->join('employees AS DC', 'DC.user_id = I.ref_dr_id', 'left');
            $this->db->join('employees AS R', 'R.user_id = I.commission_user_id', 'left');
            $this->db->join('employees AS C', 'C.user_id = I.created_by', 'left');
            $this->db->where('I.reference_person', $reference_person);
        } else {
            $this->db->select('SUM(I.advanced) as total');
            $this->db->where('I.reference_person >', '0');
            $this->db->group_by('I.reference_person');
            $this->db->order_by('total', 'DESC');
        }
        $this->db->where('I.payment_status', 'complete');
        $this->db->where('I.paid_status', 'paid');
        return $this->db->get()->result();
    }
}
