<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Ipd_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }
    public function get_doctor_list() {
        $this->db->select('C.*, E.name, E.phone, E.user_id');
        $this->db->from('doctor_charges AS C');
        $this->db->join('employees AS E', 'E.user_id = C.doctor_id', 'left');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('U.role_id', DOCTOR);
        $this->db->where('E.status', 1);
        $this->db->order_by('E.id', 'ASC');
        return $this->db->get()->result();
    }

    public function get_employee_list() {
        $this->db->select('E.*');
        $this->db->from('employees AS E');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('E.status', '1');
        if ($this->session->userdata('role_id') == SUPER_ADMIN) {
            $this->db->where_in('U.role_id', array(SUPER_ADMIN, ADMIN, ACCOUNTANT, RECEPTIONIST));
        } else {
            $this->db->where_in('U.role_id', array(ADMIN, ACCOUNTANT, RECEPTIONIST));
        }
        $this->db->order_by('E.id ', 'DESC');
        return $this->db->get()->result();
    }

    public function get_reference_person_list() {
        $this->db->select('E.*');
        $this->db->from('employees AS E');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('E.commission_type', 'emp');
        $this->db->where('E.status', '1');
        $this->db->order_by('E.id ', 'DESC');
        return $this->db->get()->result();
    }

    public function get_single_reference($commission_user_id) {
        $this->db->select('I.*, E.name as commission, D.name as designation');
        $this->db->from('invoices AS I');
        $this->db->join('employees AS E', 'E.user_id = I.commission_user_id', 'left');
        $this->db->join('designations AS D', 'D.id = E.designation_id', 'left');
        if ($commission_user_id) {
            $this->db->where('I.commission_user_id', $commission_user_id);
        }
        return $this->db->get()->row();
    }

    public function get_collection_list($keyword, $type, $form_date, $to_date, $doctor_id, $reference_id, $created_by) {
        $this->db->select('AP.*, P.patient_unique_id, P.name as patient, P.phone, D.name as doctor, R.name as reference, C.name as created_by');
        $this->db->from('ipd_advance_payments AS AP');
        $this->db->join('ipd_patients AS IP', 'IP.id = AP.ipd_id', 'left');
        $this->db->join('patients AS P', 'P.user_id = AP.patient_id', 'left');
        $this->db->join('employees AS D', 'D.user_id = IP.doctor_id', 'left');
        $this->db->join('employees AS R', 'R.user_id = IP.reference_id', 'left');
        $this->db->join('employees AS C', 'C.user_id = AP.created_by', 'left');
        if ($keyword) {
            $this->db->like('P.patient_unique_id', $keyword);
            $this->db->or_like('P.name', $keyword, 'both');
            $this->db->or_like('P.phone', $keyword, 'both');
            $this->db->or_like('D.name', $keyword, 'both');
            $this->db->or_like('R.name', $keyword, 'both');
        }
        if ($type == 1) {
            $this->db->group_start();
            $this->db->where('IP.reference_id', 0);
            $this->db->or_where('IP.reference_id', NULL);
            $this->db->or_where('IP.reference_id', '');
            $this->db->group_end();
        }
        if ($type == 2) {
            $this->db->where('IP.reference_id >', 0);
        }
        if ($form_date && $to_date) {
            $this->db->where("DATE(AP.payment_date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($doctor_id) {
            $this->db->where('IP.doctor_id', $doctor_id);
        }
        if ($reference_id) {
            $this->db->where('IP.reference_id', $reference_id);
        }
        if ($created_by) {
            $this->db->where('AP.created_by', $created_by);
        }
        $this->db->where('AP.payment_status', 'complete');
        $this->db->order_by('AP.id', 'ASC');
        return $this->db->get()->result();
    }

    public function get_due_list($keyword, $type, $form_date, $to_date, $doctor_id, $reference_id, $created_by) {
        $this->db->select('I.*, P.patient_unique_id, P.name as patient, P.phone, D.name as doctor, R.name as reference, C.name as created_by');
        $this->db->from('ipd_invoices AS I');
        $this->db->join('patients AS P', 'P.user_id = I.patient_id', 'left');
        $this->db->join('ipd_patients AS IP', 'IP.id = I.ipd_id', 'left');
        $this->db->join('employees AS D', 'D.user_id = IP.doctor_id', 'left');
        $this->db->join('employees AS R', 'R.user_id = IP.reference_id', 'left');
        $this->db->join('employees AS C', 'C.user_id = I.created_by', 'left');
        if ($keyword) {
            $this->db->like('P.patient_unique_id', $keyword);
            $this->db->or_like('P.name', $keyword, 'both');
            $this->db->or_like('P.phone', $keyword, 'both');
        }
        if ($type == 1) {
            $this->db->group_start();
            $this->db->where('I.commission_user_id', 0);
            $this->db->or_where('I.commission_user_id', NULL);
            $this->db->or_where('I.commission_user_id', '');
            $this->db->group_end();
        }
        if ($type == 2) {
            $this->db->where('I.commission_user_id >', 0);
        }
        if ($form_date && $to_date) {
            $this->db->where("DATE(I.bill_date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($doctor_id) {
            $this->db->where('IP.doctor_id', $doctor_id);
        }
        if ($reference_id) {
            $this->db->where('IP.reference_id', $reference_id);
        }
        if ($created_by) {
            $this->db->where('I.created_by', $created_by);
        }
        $this->db->where('I.paid_status', 'unpaid');
        $this->db->where('I.payment_status', 'complete');
        $this->db->order_by('I.id', 'ASC');
        return $this->db->get()->result();
    }

    public function get_rejected_list($keyword, $type, $form_date, $to_date, $doctor_id, $reference_id, $created_by) {
        $this->db->select('I.*, P.patient_unique_id, P.name as patient, P.phone, D.name as doctor, R.name as reference, C.name as created_by');
        $this->db->from('ipd_invoices AS I');
        $this->db->join('ipd_patients AS IP', 'IP.id = I.ipd_id', 'left');
        $this->db->join('patients AS P', 'P.user_id = I.patient_id', 'left');
        $this->db->join('employees AS D', 'D.user_id = IP.doctor_id', 'left');
        $this->db->join('employees AS R', 'R.user_id = I.commission_user_id', 'left');
        $this->db->join('employees AS C', 'C.user_id = I.created_by', 'left');
        if ($keyword) {
            $this->db->like('P.patient_unique_id', $keyword);
            $this->db->or_like('P.name', $keyword, 'both');
            $this->db->or_like('P.phone', $keyword, 'both');
            $this->db->or_like('P.address', $keyword, 'both');
            $this->db->or_like('D.name', $keyword, 'both');
            $this->db->or_like('R.name', $keyword, 'both');
        }
        if ($type == 1) {
            $this->db->group_start();
            $this->db->where('I.commission_user_id', 0);
            $this->db->or_where('I.commission_user_id', NULL);
            $this->db->or_where('I.commission_user_id', '');
            $this->db->group_end();
        }
        if ($type == 2) {
            $this->db->where('I.commission_user_id >', 0);
        }
        if ($form_date && $to_date) {
            $this->db->where("DATE(I.bill_date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($doctor_id) {
            $this->db->where('IP.doctor_id', $doctor_id);
        }
        if ($reference_id) {
            $this->db->where('I.commission_user_id', $reference_id);
        }
        if ($created_by) {
            $this->db->where('I.created_by', $created_by);
        }
        $this->db->where('I.payment_status', 'rejected');
        $this->db->order_by('I.id', 'ASC');
        return $this->db->get()->result();
    }

    public function get_income_list($keyword, $type, $form_date, $to_date, $doctor_id, $reference_id, $reference_person, $created_by) {
        $this->db->select('I.*, P.patient_unique_id, P.name as patient, P.phone, D.name as doctor, R.name as reference');
        $this->db->from('ipd_invoices AS I');
        $this->db->join('ipd_patients AS IP', 'IP.id = I.ipd_id', 'left');
        $this->db->join('patients AS P', 'P.user_id = I.patient_id', 'left');
        $this->db->join('employees AS D', 'D.user_id = IP.doctor_id', 'left');
        $this->db->join('employees AS R', 'R.user_id = I.commission_user_id', 'left');
        if ($keyword) {
            $this->db->like('P.patient_unique_id', $keyword);
            $this->db->or_like('P.name', $keyword, 'both');
            $this->db->or_like('P.phone', $keyword, 'both');
            $this->db->or_like('P.address', $keyword, 'both');
            $this->db->or_like('D.name', $keyword, 'both');
            $this->db->or_like('R.name', $keyword, 'both');
        }
        if ($type == 1) {
            $this->db->group_start();
            $this->db->where('I.commission_user_id', 0);
            $this->db->or_where('I.commission_user_id', NULL);
            $this->db->or_where('I.commission_user_id', '');
            $this->db->group_end();
        }
        if ($type == 2) {
            $this->db->where('I.commission_user_id >', 0);
        }
        if ($form_date && $to_date) {
            $this->db->where("DATE(I.bill_date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($doctor_id) {
            $this->db->where('IP.doctor_id', $doctor_id);
        }
        if ($reference_id) {
            $this->db->where('I.commission_user_id', $reference_id);
        }
        if ($reference_person) {
            $this->db->where('I.reference_person', $reference_person);
        }
        if ($created_by) {
            $this->db->where('I.created_by', $created_by);
        }
        $this->db->where('I.payment_status', 'complete');
        $this->db->order_by('I.id', 'ASC');
        return $this->db->get()->result();
    }

    public function get_ipd_list($form_date, $to_date, $type, $doctor_id, $created_by) {
        $this->db->select('I.*');
        $this->db->from('ipd_invoices AS I');
        $this->db->join('ipd_patients AS IP', 'IP.id = I.ipd_id', 'left');
        if ($form_date && $to_date) {
            $this->db->where("DATE(I.bill_date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($type == 1) {
            $this->db->group_start();
            $this->db->where('I.commission_user_id', 0);
            $this->db->or_where('I.commission_user_id', NULL);
            $this->db->or_where('I.commission_user_id', '');
            $this->db->group_end();
        }
        if ($type == 2) {
            $this->db->where('I.commission_user_id >', 0);
        }
        if ($doctor_id) {
            $this->db->where('IP.doctor_id', $doctor_id);
        }
        if ($created_by) {
            $this->db->where('I.created_by', $created_by);
        }
        return $this->db->get()->result();
    }

    public function get_sale_list($form_date, $to_date, $type, $doctor_id, $created_by) {
        $this->db->select('I.*, 
        SUM(I.total_bill) as total_bill_amount, 
        SUM(I.discount) as total_discount, 
        SUM(I.net_payable) as total_net_payable, 
        SUM(I.advanced) as total_advanced,
        SUM(I.due_amount) as total_due_amount');
        $this->db->from('ipd_invoices AS I');
        $this->db->join('ipd_patients AS IP', 'IP.id = I.ipd_id', 'left');
        if ($form_date && $to_date) {
            $this->db->where("DATE(I.bill_date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($type == 1) {
            $this->db->group_start();
            $this->db->where('I.commission_user_id', 0);
            $this->db->or_where('I.commission_user_id', NULL);
            $this->db->or_where('I.commission_user_id', '');
            $this->db->group_end();
        }
        if ($type == 2) {
            $this->db->where('I.commission_user_id >', 0);
        }
        if ($doctor_id) {
            $this->db->where('IP.doctor_id', $doctor_id);
        }
        if ($created_by) {
            $this->db->where('I.created_by', $created_by);
        }
        $this->db->where('I.payment_status', 'complete');
        $this->db->group_by('DATE(I.bill_date)');
        $this->db->order_by('DATE(I.bill_date)', 'ASC');
        return $this->db->get()->result();
    }

    public function get_admitted_list($keyword, $type, $form_date, $to_date, $doctor_id, $reference_id, $created_by) {
        $this->db->select('IP.*, P.patient_unique_id, P.name as patient, P.phone,P.address, BG.name as ward, B.name as bed, D.name as doctor, R.name as reference, C.name as created_by');
        $this->db->from('ipd_patients AS IP');
        $this->db->join('patients AS P', 'P.user_id = IP.patient_id', 'left');
        $this->db->join('bed_groups AS BG', 'BG.id = IP.bed_group_id', 'left');
        $this->db->join('beds AS B', 'B.id = IP.bed_id', 'left');
        $this->db->join('employees AS D', 'D.user_id = IP.doctor_id', 'left');
        $this->db->join('employees AS R', 'R.user_id = IP.reference_id', 'left');
        $this->db->join('employees AS C', 'C.user_id = IP.created_by', 'left');
        if ($keyword) {
            $this->db->like('P.patient_unique_id', $keyword);
            $this->db->or_like('P.name', $keyword, 'both');
            $this->db->or_like('P.phone', $keyword, 'both');
            $this->db->or_like('D.name', $keyword, 'both');
            $this->db->or_like('R.name', $keyword, 'both');
        }
        if ($type == 1) {
            $this->db->group_start();
            $this->db->where('IP.reference_id', 0);
            $this->db->or_where('IP.reference_id', NULL);
            $this->db->or_where('IP.reference_id', '');
            $this->db->group_end();
        }
        if ($type == 2) {
            $this->db->where('IP.reference_id >', 0);
        }
        if ($form_date && $to_date) {
            $this->db->where("DATE(IP.admission_date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($doctor_id) {
            $this->db->where('IP.doctor_id', $doctor_id);
        }
        if ($reference_id) {
            $this->db->where('IP.reference_id', $reference_id);
        }
        if ($created_by) {
            $this->db->where('IP.created_by', $created_by);
        }
        $this->db->where('IP.bed_empty', '0');
        $this->db->order_by('IP.admission_date', 'ASC');
        return $this->db->get()->result();
    }

    public function get_discharge_list($keyword, $type, $form_date, $to_date, $doctor_id, $reference_id, $created_by) {
        $this->db->select('IP.*, P.patient_unique_id, P.name as patient, P.phone,P.address, BG.name as ward, B.name as bed, D.name as doctor, R.name as reference, C.name as created_by');
        $this->db->from('ipd_patients AS IP');
        $this->db->join('patients AS P', 'P.user_id = IP.patient_id', 'left');
        $this->db->join('bed_groups AS BG', 'BG.id = IP.bed_group_id', 'left');
        $this->db->join('beds AS B', 'B.id = IP.bed_id', 'left');
        $this->db->join('employees AS D', 'D.user_id = IP.doctor_id', 'left');
        $this->db->join('employees AS R', 'R.user_id = IP.reference_id', 'left');
        $this->db->join('employees AS C', 'C.user_id = IP.created_by', 'left');
        if ($keyword) {
            $this->db->like('P.patient_unique_id', $keyword);
            $this->db->or_like('P.name', $keyword, 'both');
            $this->db->or_like('P.phone', $keyword, 'both');
            $this->db->or_like('D.name', $keyword, 'both');
            $this->db->or_like('R.name', $keyword, 'both');
        }
        if ($type == 1) {
            $this->db->group_start();
            $this->db->where('IP.reference_id', 0);
            $this->db->or_where('IP.reference_id', NULL);
            $this->db->or_where('IP.reference_id', '');
            $this->db->group_end();
        }
        if ($type == 2) {
            $this->db->where('IP.reference_id >', 0);
        }
        if ($form_date && $to_date) {
            $this->db->where("DATE(IP.discharged_date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($doctor_id) {
            $this->db->where('IP.doctor_id', $doctor_id);
        }
        if ($reference_id) {
            $this->db->where('IP.reference_id', $reference_id);
        }
        if ($created_by) {
            $this->db->where('IP.created_by', $created_by);
        }
        $this->db->where('IP.discharged', '1');
        $this->db->order_by('IP.discharged_date', 'ASC');
        return $this->db->get()->result();
    }

    public function get_surgeon_list($form_date, $to_date, $doctor_id) {
        $this->db->select('IS.*, COUNT(IS.id) as total_quantity, SUM(IS.charge) as total_charge, P.patient_unique_id, P.name as patient, IP.admission_date, D.name as doctor');
        $this->db->from('ipd_surgeons AS IS');
        $this->db->join('patients AS P', 'P.user_id = IS.patient_id', 'left');
        $this->db->join('ipd_patients AS IP', 'IP.id = IS.ipd_id', 'left');
        $this->db->join('employees AS D', 'D.user_id = IS.doctor_id', 'left');
        if ($form_date && $to_date) {
            $this->db->where("DATE(IS.date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($doctor_id) {
            $this->db->where('IS.doctor_id', $doctor_id);
        }
        $this->db->where('IS.surgeon_status', 'complete');
        $this->db->group_by('IS.ipd_id');
        $this->db->order_by('IS.date', 'ASC');
        return $this->db->get()->result();
    }

    public function get_anesthesia_list($form_date, $to_date, $doctor_id) {
        $this->db->select('IA.*, COUNT(IA.id) as total_quantity, SUM(IA.charge) as total_charge, P.patient_unique_id, P.name as patient, IP.admission_date, D.name as doctor');
        $this->db->from('ipd_anesthesias AS IA');
        $this->db->join('patients AS P', 'P.user_id = IA.patient_id', 'left');
        $this->db->join('ipd_patients AS IP', 'IP.id = IA.ipd_id', 'left');
        $this->db->join('anesthetists AS D', 'D.user_id = IA.doctor_id', 'left');
        if ($form_date && $to_date) {
            $this->db->where("DATE(IA.date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($doctor_id) {
            $this->db->where('IA.doctor_id', $doctor_id);
        }
        $this->db->where('IA.anesthesia_status', 'complete');
        $this->db->group_by('IA.ipd_id');
        $this->db->order_by('IA.date', 'ASC');
        return $this->db->get()->result();
    }

    public function get_assistant_list($form_date, $to_date, $doctor_id) {
        $this->db->select('IA.*, COUNT(IA.id) as total_quantity, SUM(IA.charge) as total_charge, P.patient_unique_id, P.name as patient, IP.admission_date, D.name as doctor');
        $this->db->from('ipd_assistants AS IA');
        $this->db->join('patients AS P', 'P.user_id = IA.patient_id', 'left');
        $this->db->join('ipd_patients AS IP', 'IP.id = IA.ipd_id', 'left');
        $this->db->join('assistants AS D', 'D.user_id = IA.doctor_id', 'left');
        if ($form_date && $to_date) {
            $this->db->where("DATE(IA.date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($doctor_id) {
            $this->db->where('IA.doctor_id', $doctor_id);
        }
        $this->db->where('IA.assistant_status', 'complete');
        $this->db->group_by('IA.ipd_id');
        $this->db->order_by('IA.date', 'ASC');
        return $this->db->get()->result();
    }

    public function get_consultant_list($form_date, $to_date, $doctor_id) {
        $this->db->select('C.*, SUM(C.quantity) as total_quantity, SUM(C.charge) as total_charge, P.patient_unique_id, P.name as patient, IP.admission_date, D.name as doctor');
        $this->db->from('ipd_consultant_visits AS C');
        $this->db->join('patients AS P', 'P.user_id = C.patient_id', 'left');
        $this->db->join('ipd_patients AS IP', 'IP.id = C.ipd_id', 'left');
        $this->db->join('employees AS D', 'D.user_id = C.doctor_id', 'left');
        if ($form_date && $to_date) {
            $this->db->where("DATE(C.visit_date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($doctor_id) {
            $this->db->where('C.doctor_id', $doctor_id);
        }
        $this->db->where('C.visit_status', 'complete');
        $this->db->group_by('C.ipd_id');
        $this->db->order_by('C.visit_date', 'ASC');
        return $this->db->get()->result();
    }
}
