<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Marketing_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }
    public function get_doctor_list() {
        $this->db->select('C.*, E.name, E.phone, E.user_id');
        $this->db->from('doctor_charges AS C');
        $this->db->join('employees AS E', 'E.user_id = C.doctor_id', 'left');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('U.role_id', DOCTOR);
        $this->db->where('E.status', 1);
        $this->db->order_by('E.id', 'ASC');
        return $this->db->get()->result();
    }
    public function get_employee_list() {
        $this->db->select('E.*');
        $this->db->from('employees AS E');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('E.status', '1');
        if ($this->session->userdata('role_id') == SUPER_ADMIN) {
            $this->db->where_in('U.role_id', array(SUPER_ADMIN, ADMIN, ACCOUNTANT, RECEPTIONIST, MARKETING));
        } else {
            $this->db->where_in('U.role_id', array(ADMIN, ACCOUNTANT, RECEPTIONIST, MARKETING));
        }
        $this->db->order_by('E.id ', 'DESC');
        return $this->db->get()->result();
    }
    public function get_marketing_list($type, $keyword, $form_date, $to_date, $doctor_id, $reference_id, $created_by) {
        $this->db->select('A.*, D.name as doctor, R.name as reference');
        $this->db->from('appointments AS A');
        if ($type == 'test') {
            $this->db->select('I.net_payable');
            $this->db->join('invoices AS I', 'I.patient_id = A.patient_id', 'left');
            $this->db->where('I.payment_status', 'complete');
        } elseif ($type == 'opd') {
            $this->db->select('OP.doctor_charge');
            $this->db->join('opd_patients AS OP', 'OP.appointment_id = A.id', 'left');
            $this->db->where('OP.payment_status', 'complete');
        } else {
            $this->db->select('IP.net_payable');
            $this->db->join('ipd_invoices AS IP', 'IP.patient_id = A.patient_id', 'left');
            $this->db->where('IP.payment_status', 'complete');
        }
        $this->db->join('employees AS D', 'D.user_id = A.doctor_id', 'left');
        $this->db->join('employees AS R', 'R.user_id = A.reference_id', 'left');
        if ($keyword) {
            $this->db->like('A.phone', $keyword);
            $this->db->or_like('A.name', $keyword, 'both');
            $this->db->or_like('D.name', $keyword, 'both');
            $this->db->or_like('R.name', $keyword, 'both');
        }
        if ($form_date && $to_date) {
            $this->db->where("DATE(A.date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($doctor_id) {
            $this->db->where('A.doctor_id', $doctor_id);
        }
        if ($reference_id) {
            $this->db->where('A.reference_id', $reference_id);
        }
        if ($created_by) {
            $this->db->where('A.created_by', $created_by);
        }
        $this->db->order_by('A.id', 'ASC');
        return $this->db->get()->result();
    }

    public function get_single_doctor($doctor_id) {
        $this->db->select('A.*, E.name as doctor, E.specialist');
        $this->db->from('appointments AS A');
        $this->db->join('employees AS E', 'E.user_id = A.doctor_id', 'left');
        if ($doctor_id) {
            $this->db->where('A.doctor_id', $doctor_id);
        }
        return $this->db->get()->row();
    }

    public function get_single_employee($user_id) {
        $this->db->select('A.*, E.name as employee, D.name as designation');
        $this->db->from('appointments AS A');
        $this->db->join('employees AS E', 'E.user_id = A.created_by', 'left');
        $this->db->join('designations AS D', 'D.id = E.designation_id', 'left');
        if ($user_id) {
            $this->db->where('A.created_by', $user_id);
        }
        return $this->db->get()->row();
    }
}
