<!DOCTYPE html>
<html>

<head>
    <title>Appointment</title>
    <style>
        body {
            font-family: "Time New Roman";
            font-size: 13px;
        }

        .page {
            width: 100%;
            margin: 0 auto;
        }

        .main_body {
            /* page-break-after: always; */
            display: block;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
        }

        .info_table {
            margin-top: 20px;
        }

        .content {
            margin-top: 20px;
        }

        .table_content thead th {
            padding: 0;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
        }

        .table_content tbody td {
            padding: 0 2px;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
        }

        .footer {
            margin-top: 100px;
        }
    </style>
</head>

<body>
    <div class="page">
        <div class="main_body">
            <table class="table" style="text-align: center;">
                <tbody>
                    <tr>
                        <td>
                            <h2 style="margin-bottom: 0; font-size: 28px;"><?php echo $this->global_setting->brand_title; ?></h2>
                        </td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->address; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->email; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->phone; ?></b></td>
                    </tr>
                </tbody>
            </table>

            <!-- Content Start-->

            <div class="info_table">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="70%" align="left">
                                <?php if ($this->input->get('doctor_id')) { ?>
                                    <b>Consultant:</b>
                                    <span style="font-size: 12px; margin: 0; padding: 0;"><?php echo $doctor->doctor; ?>, <?php echo $doctor->specialist; ?></span>
                                <?php } else { ?>
                                    <b>All:</b>
                                <?php } ?>
                            </td>
                            <td width="30%" align="right">
                                <b>Date:</b>
                                <span style="font-size: 12px;"><?php echo date('d/m/Y h:i A'); ?></span>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <!-- Content Start-->
            <div class="content">
                <table class="table table_content">
                    <thead>
                        <tr>
                            <th style="width: 8%;">SL No</th>
                            <th style="width: 16%;">Appointment No</th>
                            <th style="width: 20%;">Patient Name</th>
                            <th style="width: 9%;">Gender</th>
                            <th style="width: 13%;">Phone</th>
                            <th style="width: 13%;">Address</th>
                            <th style="width: 21%;">Created</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $count = 1;
                        foreach ($appointments as $obj) { ?>
                            <tr>
                                <td align="center"><?php echo $count++; ?></td>
                                <td align="center"><?php echo $obj->appointment_no; ?></td>
                                <td style="padding-left: 1px;"><?php echo $obj->name; ?></td>
                                <td align="center"><?php echo $this->lang->line($obj->gender); ?></td>
                                <td align="center"><?php echo $obj->phone; ?></td>
                                <td style="padding-left: 1px;"><?php echo $obj->address; ?></td>
                                <td style="padding-left: 1px;"><?php echo date('d/m/Y h:i A', strtotime($obj->created_at)); ?></td>
                            </tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
            <!-- Content End -->
            <!-- Footer -->
            <div class="footer">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="70%">
                                <p style="margin-left: 10%;">
                                    <b>Prepared By:</b>
                                    <?php echo $this->session->userdata('name'); ?>
                                </p>
                            </td>
                            <td width="30%" align="center">
                                <p style="border-top: 1px dashed red; width: 30%; margin: 5px auto;"></p>
                                <b>Signature</b>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</body>

</html>