<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('report'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('employee'); ?> <?php echo $this->lang->line('report'); ?>
        </h4>
        <div class="d-flex">
            <?php echo $this->load->view('header'); ?>
        </div>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <?php echo form_open_multipart(site_url('report/billing/employee'), array('name' => 'search', 'id' => 'search', 'method' => 'get'), ''); ?>
                    <div class="form-row">
                        <div class="col-md-3 mb-10">
                            <label for="date"><?php echo $this->lang->line('date'); ?></label>
                            <input type="text" class="form-control" name="date" id="range" value="<?php echo isset($date) ?  $date : ''; ?>" placeholder="<?php echo $this->lang->line('date'); ?>">
                        </div>
                        <div class="col-md-5 mb-10">
                            <label for="reference_person"><?php echo $this->lang->line('reference'); ?> <?php echo $this->lang->line('employee'); ?></label>
                            <select class="form-control custom-select select2" name="reference_person" id="reference_person">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('employee'); ?></option>
                                <?php foreach ($reference_persons as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo isset($reference_person) && $reference_person == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-1">
                            <button class="btn btn-gradient-primary mt-35" type="submit"><?php echo $this->lang->line('search'); ?></button>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>

        <?php if (isset($date) && !empty($date)) { ?>
            <!-- Report Details -->
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <?php if (has_permission(VIEW, 'report', 'billing')) { ?>
                            <h6 class="card-header d-flex align-items-center">
                                <i class="fa fa-money font-30 mr-10"></i>
                                <?php echo $this->lang->line('employees'); ?> <?php echo $this->lang->line('report'); ?>
                            </h6>
                        <?php } ?>
                        <div class="button-list">
                            <a href="<?php echo site_url('report/billing/employee_pdf/?date=' . $date . '&reference_person=' . $reference_person); ?>" class="btn btn-success btn-xs">
                                <i class="fa fa-download"></i> <?php echo $this->lang->line('pdf'); ?> <?php echo $this->lang->line('generate'); ?>
                            </a>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-wrap">
                            <div class="table-responsive">
                                <table class="table table-sm mb-0">
                                    <thead>
                                        <tr>
                                            <?php if ($reference_person) { ?>
                                                <th><?php echo $this->lang->line('sl_no'); ?></th>
                                                <th><?php echo $this->lang->line('invoice_no'); ?></th>
                                                <th><?php echo $this->lang->line('date'); ?></th>
                                                <th><?php echo $this->lang->line('patient_id'); ?></th>
                                                <th><?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('name'); ?></th>
                                                <th><?php echo $this->lang->line('doctor'); ?></th>
                                                <th><?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('bill'); ?></th>
                                                <th><?php echo $this->lang->line('discount'); ?></th>
                                                <th><?php echo $this->lang->line('advanced'); ?></th>
                                                <th><?php echo $this->lang->line('due'); ?></th>
                                                <th><?php echo $this->lang->line('total'); ?></th>
                                            <?php } else { ?>
                                                <th><?php echo $this->lang->line('sl_no'); ?></th>
                                                <th><?php echo $this->lang->line('name'); ?></th>
                                                <th><?php echo $this->lang->line('designation'); ?></th>
                                                <th><?php echo $this->lang->line('phone'); ?></th>
                                                <th><?php echo $this->lang->line('blood_group'); ?></th>
                                                <th><?php echo $this->lang->line('join_date'); ?></th>
                                                <th><?php echo $this->lang->line('total'); ?></th>
                                            <?php } ?>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count = 1;
                                        $total = 0;
                                        if (isset($employees) && !empty($employees)) { ?>
                                            <?php foreach ($employees as $obj) {
                                                $total += $reference_person ? 1 : $obj->total;
                                            ?>
                                                <tr>
                                                    <?php if ($reference_person) { ?>
                                                        <td><?php echo $count++; ?></td>
                                                        <td><?php echo $obj->custom_invoice_id; ?></td>
                                                        <td><?php echo date('d/m/Y h:i A', strtotime($obj->bill_date)); ?></td>
                                                        <td><?php echo $obj->patient_unique_id; ?></td>
                                                        <td><?php echo $obj->patient; ?></td>
                                                        <td><?php echo $obj->doctor; ?></td>
                                                        <td><?php echo $obj->total_bill; ?></td>
                                                        <td><?php echo $obj->discount; ?></td>
                                                        <td><?php echo $obj->advanced; ?></td>
                                                        <td><?php echo $obj->due_amount; ?></td>
                                                        <td>1</td>
                                                    <?php } else { ?>
                                                        <td><?php echo $count++; ?></td>
                                                        <td><?php echo $obj->employee; ?></td>
                                                        <td><?php echo $obj->designation; ?></td>
                                                        <td><?php echo $obj->phone; ?></td>
                                                        <td><?php echo $obj->blood_group ? $this->lang->line($obj->blood_group) : ''; ?></td>
                                                        <td><?php echo $obj->joining_date ? date('M d, Y', strtotime($obj->joining_date)) : ''; ?></td>
                                                        <td><?php echo $obj->total; ?></td>
                                                    <?php } ?>
                                                </tr>
                                            <?php } ?>
                                        <?php } ?>
                                    </tbody>
                                    <tfoot class="border-bottom border-1">
                                        <tr>
                                            <?php if ($reference_person) { ?>
                                                <th colspan="10" class="text-right font-weight-600">Grand Total</th>
                                            <?php } else { ?>
                                                <th colspan="6" class="text-right font-weight-600">Grand Total</th>
                                            <?php } ?>
                                            <th class="text-right font-weight-600"><?php echo number_format($total, 2); ?></th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->


<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important;
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>
<script>
    $(".select2").select2();
    $('#range').daterangepicker({
        startDate: new Date(),
        endDate: moment(),
        showDropdowns: true,
        minYear: 1901,
        locale: {
            format: 'YYYY/MM/DD',
        },
        ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Tomorrow': [moment().subtract(-1, 'days'), moment().subtract(-1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'This Year': [moment().startOf('year'), moment().endOf('year')],
            'Last Year': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')]
        }
    });
</script>