<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('report'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('diagnostic'); ?> <?php echo $this->lang->line('report'); ?>
        </h4>
        <div class="d-flex">
            <?php if (has_permission(VIEW, 'report', 'billing')) { ?>
                <a href="<?php echo site_url('report/opd'); ?>" class="btn btn-primary btn-sm mr-15"><?php echo $this->lang->line('opd'); ?> <?php echo $this->lang->line('report'); ?></a>
            <?php } ?>
            <?php if (has_permission(VIEW, 'report', 'billing')) { ?>
                <a href="<?php echo site_url('report/billing'); ?>" class="btn btn-success btn-sm mr-15"><?php echo $this->lang->line('billing'); ?> <?php echo $this->lang->line('report'); ?></a>
            <?php } ?>
        </div>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <?php echo form_open_multipart(site_url('report/diagnostic'), array('name' => 'search', 'id' => 'search', 'method' => 'get'), ''); ?>
                    <div class="form-row">
                        <div class="col-md-3 mb-10">
                            <label for="keyword"><?php echo $this->lang->line('keyword'); ?></label>
                            <input type="text" class="form-control" name="keyword" id="keyword" value="<?php echo isset($keyword) ?  $keyword : ''; ?>" placeholder="<?php echo $this->lang->line('keyword'); ?>">
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="special_discount"><?php echo $this->lang->line('special'); ?> <?php echo $this->lang->line('discount'); ?></label>
                            <select class="form-control custom-select select2" name="special_discount" id="special_discount">
                                <option value="" selected><?php echo $this->lang->line('select'); ?></option>
                                <option value="yes" <?php echo isset($special_discount) && $special_discount == 'yes' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('yes'); ?></option>
                                <option value="no" <?php echo isset($special_discount) && $special_discount == 'no' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('no'); ?></option>
                            </select>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="department_id"><?php echo $this->lang->line('department'); ?></label>
                            <select class="form-control custom-select select2" name="department_id" id="department_id" onchange="get_group(this.value)">
                                <option value="" selected><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($departments as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($department_id) && $department_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="group_id"><?php echo $this->lang->line('group'); ?></label>
                            <select class="form-control custom-select select2" name="group_id" id="group_id">
                                <option value="" selected><?php echo $this->lang->line('select'); ?></option>
                            </select>
                        </div>
                        <div class="col-md-1">
                            <button class="btn btn-gradient-primary mt-35" type="submit"><?php echo $this->lang->line('search'); ?></button>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>

        <?php if (isset($diagnostics) && !empty($diagnostics)) { ?>
            <!-- Report Details -->
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <?php if (has_permission(VIEW, 'report', 'diagnostic')) { ?>
                            <h6 class="card-header d-flex align-items-center">
                                <i class="fa fa-user font-30 mr-10"></i>
                                <?php echo $this->lang->line('diagnostic'); ?> <?php echo $this->lang->line('report'); ?>
                            </h6>
                        <?php } ?>
                        <div class="button-list">
                            <a href="<?php echo site_url('report/diagnostic/pdf/?keyword=' . $keyword . '&special_discount=' . $special_discount . '&department_id=' . $department_id . '&group_id=' . $group_id); ?>" class="btn btn-success btn-xs">
                                <i class="fa fa-download"></i> <?php echo $this->lang->line('pdf'); ?> <?php echo $this->lang->line('generate'); ?>
                            </a>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-wrap">
                            <div class="table-responsive">
                                <table class="table table-sm mb-0">
                                    <thead>
                                        <tr>
                                            <th><?php echo $this->lang->line('sl_no'); ?></th>
                                            <th><?php echo $this->lang->line('department'); ?></th>
                                            <th><?php echo $this->lang->line('group'); ?></th>
                                            <th><?php echo $this->lang->line('test'); ?> <?php echo $this->lang->line('name'); ?></th>
                                            <th><?php echo $this->lang->line('room_no'); ?></th>
                                            <th><?php echo $this->lang->line('rate'); ?></th>
                                            <th><?php echo $this->lang->line('discount'); ?></th>
                                            <th><?php echo $this->lang->line('mbbs'); ?></th>
                                            <th><?php echo $this->lang->line('vd'); ?></th>
                                            <th><?php echo $this->lang->line('emp'); ?></th>
                                            <th><?php echo $this->lang->line('corporate'); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count = 1;
                                        $total_rate = 0;
                                        $total_mbbs = 0;
                                        $total_vd = 0;
                                        $total_emp = 0;
                                        $total_corporate = 0;
                                        $total_special_discount = 0;
                                        if (isset($diagnostics) && !empty($diagnostics)) { ?>
                                            <?php foreach ($diagnostics as $obj) {
                                                $total_rate += $obj->rate;
                                                $total_mbbs += $obj->mbbs;
                                                $total_vd += $obj->vd;
                                                $total_emp += $obj->emp;
                                                $total_corporate += $obj->corporate;
                                                $total_special_discount += $obj->special_discount;
                                            ?>
                                                <tr>
                                                    <td><?php echo $count++; ?></td>
                                                    <td><?php echo $obj->department; ?></td>
                                                    <td><?php echo $obj->group; ?></td>
                                                    <td><?php echo $obj->name; ?></td>
                                                    <td><?php echo $obj->room_no; ?></td>
                                                    <td><?php echo $obj->rate; ?></td>
                                                    <td><?php echo $obj->special_discount; ?></td>
                                                    <td><?php echo $obj->mbbs; ?></td>
                                                    <td><?php echo $obj->vd; ?></td>
                                                    <td><?php echo $obj->emp; ?></td>
                                                    <td><?php echo $obj->corporate; ?></td>
                                                </tr>
                                            <?php } ?>
                                            <tr class="bg-transparent">
                                                <td colspan="9" class="text-right text-light">Total Rate</td>
                                                <td colspan="2" class="text-right"><?php echo $this->global_setting->currency_symbol; ?> <?php echo number_format($total_rate, 2); ?></td>
                                            </tr>
                                            <tr class="bg-transparent">
                                                <td colspan="9" class="text-right text-light">Total Special Discount</td>
                                                <td colspan="2" class="text-right"><?php echo $this->global_setting->currency_symbol; ?> <?php echo number_format($total_special_discount, 2); ?></td>
                                            </tr>
                                            <tr class="bg-transparent">
                                                <td colspan="9" class="text-right text-light border-top-0">Total MBBS</td>
                                                <td colspan="2" class="text-right border-top-0"><?php echo $this->global_setting->currency_symbol; ?> <?php echo number_format($total_mbbs, 2); ?></td>
                                            </tr>
                                            <tr class="bg-transparent">
                                                <td colspan="9" class="text-right text-light border-top-0">Total V.D</td>
                                                <td colspan="2" class="text-right border-top-0"><?php echo $this->global_setting->currency_symbol; ?> <?php echo number_format($total_vd, 2); ?></td>
                                            </tr>
                                            <tr class="bg-transparent">
                                                <td colspan="9" class="text-right text-light border-top-0">Total EMP</td>
                                                <td colspan="2" class="text-right border-top-0"><?php echo $this->global_setting->currency_symbol; ?> <?php echo number_format($total_emp, 2); ?></td>
                                            </tr>
                                            <tr class="bg-transparent">
                                                <td colspan="9" class="text-right text-light border-top-0">Total Corporate</td>
                                                <td colspan="2" class="text-right border-top-0"><?php echo $this->global_setting->currency_symbol; ?> <?php echo number_format($total_corporate, 2); ?></td>
                                            </tr>
                                        <?php } else { ?>
                                            <tr class="text-center">
                                                <td colspan="11"><?php echo $this->lang->line('no_data_found'); ?></td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                    <tfoot class="border-bottom border-1">
                                        <tr>
                                            <th colspan="9" class="text-right font-weight-600">Total Amount</th>
                                            <th colspan="2" class="text-right font-weight-600"><?php echo $this->global_setting->currency_symbol; ?> <?php echo number_format($total_rate, 2); ?></th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important;
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>
<script>
    $(".select2").select2();

    function get_group(department_id) {
        $.ajax({
            type: "POST",
            url: "<?php echo site_url('ajax/get_department_by_diagnostic_group'); ?>",
            data: {
                department_id: department_id
            },
            async: false,
            success: function(response) {
                if (response) {
                    $('#group_id').html(response);
                }
            }
        });
    };
</script>