<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('report'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('marketing'); ?> <?php echo $this->lang->line('report'); ?>
        </h4>
        <div class="d-flex">
            <?php if (has_permission(VIEW, 'report', 'opd')) { ?>
                <a href="<?php echo site_url('report/opd'); ?>" class="btn btn-primary btn-sm mr-15"><?php echo $this->lang->line('opd'); ?> <?php echo $this->lang->line('report'); ?></a>
            <?php } ?>
            <?php if (has_permission(VIEW, 'report', 'billing')) { ?>
                <a href="<?php echo site_url('report/billing'); ?>" class="btn btn-success btn-sm mr-15"><?php echo $this->lang->line('billing'); ?> <?php echo $this->lang->line('report'); ?></a>
            <?php } ?>
        </div>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <?php echo form_open_multipart(site_url('report/marketing'), array('name' => 'search', 'id' => 'search', 'method' => 'get'), ''); ?>
                    <div class="form-row">
                        <div class="col-md-2 mb-10">
                            <label for="type"><?php echo $this->lang->line('type'); ?></label>
                            <select class="form-control custom-select select2" name="type" id="type">
                                <option value="test" <?php echo isset($type) && $type == 'test' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('test'); ?></option>
                                <option value="opd" <?php echo isset($type) && $type == 'opd' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('opd'); ?></option>
                                <option value="ipd" <?php echo isset($type) && $type == 'ipd' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('ipd'); ?></option>
                            </select>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="keyword"><?php echo $this->lang->line('keyword'); ?></label>
                            <input type="text" class="form-control" name="keyword" id="keyword" value="<?php echo isset($keyword) ?  $keyword : ''; ?>" placeholder="<?php echo $this->lang->line('keyword'); ?>">
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="date"><?php echo $this->lang->line('date'); ?></label>
                            <input type="text" class="form-control" name="date" id="range" value="<?php echo isset($date) ?  $date : ''; ?>" placeholder="<?php echo $this->lang->line('date'); ?>">
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="doctor_id"><?php echo $this->lang->line('doctor'); ?></label>
                            <select class="form-control custom-select select2" name="doctor_id" id="doctor_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('doctor'); ?></option>
                                <?php foreach ($doctors as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo isset($doctor_id) && $doctor_id == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="reference_id"><?php echo $this->lang->line('reference'); ?></label>
                            <select class="form-control custom-select select2" name="reference_id" id="reference_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('reference'); ?></option>
                                <?php foreach ($references as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo isset($reference_id) && $reference_id == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                <?php } ?>
                            </select>
                        </div>
                        <?php if ($this->session->userdata('role_id') != MARKETING) { ?>
                            <div class="col-md-4 mb-10">
                                <label for="created_by"><?php echo $this->lang->line('created_by'); ?></label>
                                <select class="form-control custom-select select2" name="created_by" id="created_by">
                                    <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('employee'); ?></option>
                                    <?php foreach ($employees as $obj) { ?>
                                        <option value="<?php echo $obj->user_id; ?>" <?php echo isset($created_by) && $created_by == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                    <?php } ?>
                                </select>
                            </div>
                        <?php } else { ?>
                            <input type="hidden" name="created_by" value="<?php echo $this->session->userdata('user_id'); ?>">
                        <?php }  ?>
                        <div class="col-md-4">
                            <button class="btn btn-gradient-primary mt-35" type="submit"><?php echo $this->lang->line('search'); ?></button>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>

        <?php if (isset($marketings) && !empty($marketings)) { ?>
            <!-- Report Details -->
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <?php if (has_permission(VIEW, 'report', 'marketing')) { ?>
                            <h6 class="card-header d-flex align-items-center">
                                <i class="fa fa-user font-30 mr-10"></i>
                                <?php echo $this->lang->line('marketing'); ?> <?php echo $this->lang->line('report'); ?>
                            </h6>
                        <?php } ?>
                        <div class="button-list">
                            <a href="<?php echo site_url('report/marketing/pdf/?type=' . $type . '&keyword=' . $keyword . '&date=' . $date . '&doctor_id=' . $doctor_id . '&reference_id=' . $reference_id . '&created_by=' . $created_by); ?>" class="btn btn-success btn-xs">
                                <i class="fa fa-download"></i> <?php echo $this->lang->line('pdf'); ?> <?php echo $this->lang->line('generate'); ?>
                            </a>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-wrap">
                            <div class="table-responsive">
                                <table class="table table-sm mb-0">
                                    <thead>
                                        <tr>
                                            <th><?php echo $this->lang->line('sl_no'); ?></th>
                                            <th><?php echo $this->lang->line('appointment_no'); ?></th>
                                            <th><?php echo $this->lang->line('date'); ?></th>
                                            <th><?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('name'); ?></th>
                                            <th><?php echo $this->lang->line('phone'); ?></th>
                                            <th><?php echo $this->lang->line('address'); ?></th>
                                            <th><?php echo $this->lang->line('doctor'); ?></th>
                                            <th><?php echo $this->lang->line('reference'); ?></th>
                                            <?php if ($type == 'opd') { ?>
                                                <th><?php echo $this->lang->line('opd'); ?></th>
                                            <?php } ?>

                                            <?php if ($type == 'ipd') { ?>
                                                <th><?php echo $this->lang->line('ipd'); ?></th>
                                            <?php } ?>

                                            <?php if ($type == 'test') { ?>
                                                <th><?php echo $this->lang->line('billing'); ?></th>
                                            <?php } ?>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count = 1;
                                        $total_opd_amount = 0;
                                        $total_ipd_amount = 0;
                                        $total_test_amount = 0;
                                        if (isset($marketings) && !empty($marketings)) { ?>
                                            <?php foreach ($marketings as $obj) {
                                                if ($type == 'opd') {
                                                    $total_opd_amount += $obj->doctor_charge;
                                                } elseif ($type == 'ipd') {
                                                    $total_ipd_amount += $obj->net_payable;
                                                } else {
                                                    $total_test_amount += $obj->net_payable;
                                                }
                                            ?>
                                                <tr>
                                                    <td><?php echo $count++; ?></td>
                                                    <td><?php echo $obj->appointment_no; ?></td>
                                                    <td><?php echo date('d F, Y', strtotime($obj->date)); ?></td>
                                                    <td><?php echo $obj->name; ?></td>
                                                    <td><?php echo $obj->phone; ?></td>
                                                    <td><?php echo $obj->address; ?></td>
                                                    <td><?php echo $obj->doctor; ?></td>
                                                    <td><?php echo $obj->reference; ?></td>
                                                    <?php if ($type == 'opd') { ?>
                                                        <td><?php echo $obj->doctor_charge; ?></td>
                                                    <?php } ?>

                                                    <?php if ($type == 'ipd') { ?>
                                                        <td><?php echo $obj->net_payable; ?></td>
                                                    <?php } ?>

                                                    <?php if ($type == 'test') { ?>
                                                        <td><?php echo $obj->net_payable; ?></td>
                                                    <?php } ?>
                                                </tr>
                                            <?php } ?>

                                            <?php if ($type == 'opd') { ?>
                                                <tr class="bg-transparent">
                                                    <td colspan="7" class="text-right text-light">Total OPD Amount</td>
                                                    <td colspan="2" class="text-right"><?php echo $this->global_setting->currency_symbol; ?> <?php echo number_format($total_opd_amount, 2); ?></td>
                                                </tr>
                                            <?php } ?>

                                            <?php if ($type == 'ipd') { ?>
                                                <tr class="bg-transparent">
                                                    <td colspan="7" class="text-right text-light border-top-0">Total IPD Amount</td>
                                                    <td colspan="2" class="text-right border-top-0"><?php echo $this->global_setting->currency_symbol; ?> <?php echo number_format($total_ipd_amount, 2); ?></td>
                                                </tr>
                                            <?php } ?>

                                            <?php if ($type == 'test') { ?>
                                                <tr class="bg-transparent">
                                                    <td colspan="7" class="text-right text-light border-top-0">Total Test Amount</td>
                                                    <td colspan="2" class="text-right border-top-0"><?php echo $this->global_setting->currency_symbol; ?> <?php echo number_format($total_test_amount, 2); ?></td>
                                                </tr>
                                            <?php } ?>
                                        <?php } else { ?>
                                            <tr class="text-center">
                                                <td colspan="9"><?php echo $this->lang->line('no_data_found'); ?></td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                    <tfoot class="border-bottom border-1">
                                        <tr>
                                            <th colspan="7" class="text-right font-weight-600">Total Amount</th>
                                            <th colspan="2" class="text-right font-weight-600"><?php echo $this->global_setting->currency_symbol; ?> <?php echo number_format(($total_opd_amount + $total_ipd_amount + $total_test_amount), 2); ?></th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->


<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important;
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>
<script>
    $(".select2").select2();
    $('#range').daterangepicker({
        startDate: new Date(),
        endDate: moment(),
        showDropdowns: true,
        minYear: 1901,
        locale: {
            format: 'YYYY/MM/DD',
        },
        ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Tomorrow': [moment().subtract(-1, 'days'), moment().subtract(-1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'This Year': [moment().startOf('year'), moment().endOf('year')],
            'Last Year': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')]
        }
    });
</script>