<!DOCTYPE html>
<html>

<head>
    <title>Hospital Transaction</title>
    <style>
        body {
            font-family: "Time New Roman";
            font-size: 13px;
        }

        .page {
            width: 100%;
            margin: 0 auto;
        }

        .main_body {
            width: 100%;
            display: block;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
        }

        .info_table {
            margin-top: 20px;
        }

        .content {
            margin-top: 20px;
        }

        .table_content thead th {
            padding: 0;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
            padding: 0 2px;
        }

        .table_content tfoot th {
            padding: 0;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
            padding: 0 2px;
        }

        .table_content tbody td {
            padding: 0 2px;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
        }

        .total {
            margin-top: 20px;
        }

        .total_table tbody td {
            padding: 2px 2px;
            vertical-align: middle;
            border: 2px solid #000;
            font-size: 12px;
        }

        .footer {
            margin-top: 100px;
        }
    </style>
</head>

<body>
    <div class="page">
        <div class="main_body">
            <table class="table" style="text-align: center;">
                <tbody>
                    <tr>
                        <td>
                            <h2 style="margin-bottom: 0; font-size: 28px;"><?php echo $this->global_setting->brand_title; ?></h2>
                        </td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->address; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->email; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->phone; ?></b></td>
                    </tr>
                </tbody>
            </table>

            <!-- Content Start-->
            <h2 align="center">TRANSACTION DETAILS REPORT</h2>
            <div class="info_table">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="50%" align="left">
                                <?php if (isset($created_by) && !empty($created_by)) { ?>
                                    <b>Created By:</b>
                                    <span style="font-size: 12px; margin: 0; padding: 0;">
                                        <?php echo $created->name; ?>, <?php echo $created->phone; ?>
                                    </span>
                                <?php } else { ?>
                                    <b>Report:</b>
                                    <span style="font-size: 12px; margin: 0; padding: 0;">
                                        All
                                    </span>
                                <?php } ?>
                            </td>
                            <td width="25%" align="left">
                                <b>Date:</b>
                                <span style="font-size: 12px;">
                                    <?php echo date('M d, Y', strtotime($form_date)); ?> -
                                    <?php echo date('M d, Y', strtotime($to_date)); ?>
                                </span>
                            </td>
                            <td width="25%" align="right">
                                <b>Print Time:</b>
                                <span style="font-size: 12px;"><?php echo date('M d, Y h:ia'); ?></span>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <!-- Content Start-->
            <div class="content">
                <table class="table table_content">
                    <thead>
                        <tr>
                            <th>SL No.</th>
                            <th>Invoice ID</th>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Type</th>
                            <th>Tr. Type</th>
                            <th>Amount</th>
                            <th>Remark</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $sl = 1;
                        $total_income_diagnostic_transaction = 0;
                        $total_income_ipd_transaction = 0;
                        $total_income_opd_transaction = 0;


                        $total_expense_sd_diagnostic_payment = 0;
                        $total_expense_sd_ipd_payment = 0;
                        $total_expense_surgeon_payment = 0;
                        $total_expense_anesthesia_payment = 0;
                        $total_expense_assistant_payment = 0;
                        $total_other_income = 0;
                        $total_other_expense = 0;


                        if (isset($diagnostic_transaction) && !empty($diagnostic_transaction)) { ?>
                            <?php foreach ($diagnostic_transaction as $obj) {
                                $total_income_diagnostic_transaction +=  $obj->advanced;
                            ?>
                                <tr>
                                    <td><?php echo $sl++; ?></td>
                                    <td><?php echo $obj->custom_invoice_id; ?></td>
                                    <td><?php echo $obj->patient_unique_id; ?></td>
                                    <td><?php echo $obj->patient; ?></td>
                                    <td>Diagnostic</td>
                                    <td>Income</td>
                                    <td><?php echo $obj->advanced; ?></td>
                                    <td><?php echo $obj->note; ?></td>
                                </tr>
                            <?php } ?>
                        <?php } ?>


                        <!-- IPD Transaction -->
                        <?php if (isset($ipd_transaction) && !empty($ipd_transaction)) { ?>
                            <?php foreach ($ipd_transaction as $obj) {
                                $total_income_ipd_transaction +=  $obj->amount;
                            ?>
                                <tr>
                                    <td><?php echo $sl++; ?></td>
                                    <td><?php echo $obj->custom_invoice_id; ?></td>
                                    <td><?php echo $obj->patient_unique_id; ?></td>
                                    <td><?php echo $obj->patient; ?></td>
                                    <td>IPD</td>
                                    <td>Income</td>
                                    <td><?php echo $obj->amount; ?></td>
                                    <td><?php echo $obj->note; ?></td>
                                </tr>
                            <?php } ?>
                        <?php } ?>

                        <!-- OPD Transaction -->
                        <?php if (isset($opd_transaction) && !empty($opd_transaction)) { ?>
                            <?php foreach ($opd_transaction as $obj) {
                                $total_income_opd_transaction +=  $obj->doctor_charge;
                            ?>
                                <tr>
                                    <td><?php echo $sl++; ?></td>
                                    <td><?php echo $obj->custom_invoice_id; ?></td>
                                    <td><?php echo $obj->patient_unique_id; ?></td>
                                    <td><?php echo $obj->patient; ?></td>
                                    <td>OPD</td>
                                    <td>Income</td>
                                    <td><?php echo $obj->doctor_charge; ?></td>
                                    <td><?php echo $obj->note; ?></td>
                                </tr>
                            <?php } ?>
                        <?php } ?>

                        <!-- SD Payment Transaction -->
                        <?php if (isset($sd_diagnostic_payment) && !empty($sd_diagnostic_payment)) { ?>
                            <?php foreach ($sd_diagnostic_payment as $obj) {
                                $total_expense_sd_diagnostic_payment +=  $obj->payable_amount;
                            ?>
                                <tr>
                                    <td><?php echo $sl++; ?></td>
                                    <td><?php echo $obj->custom_invoice_id; ?></td>
                                    <td><?php echo $obj->sd_id; ?></td>
                                    <td><?php echo $obj->sd_name; ?></td>
                                    <td>SD Comm.</td>
                                    <td>Expense</td>
                                    <td><?php echo $obj->payable_amount; ?></td>
                                    <td><?php echo $obj->note; ?></td>
                                </tr>
                            <?php } ?>
                        <?php } ?>

                        <!-- IPD Payment Transaction -->
                        <?php if (isset($sd_ipd_payment) && !empty($sd_ipd_payment)) { ?>
                            <?php foreach ($sd_ipd_payment as $obj) {
                                $total_expense_sd_ipd_payment +=  $obj->payable_amount;
                            ?>
                                <tr>
                                    <td><?php echo $sl++; ?></td>
                                    <td><?php echo $obj->custom_invoice_id; ?></td>
                                    <td><?php echo $obj->sd_id; ?></td>
                                    <td><?php echo $obj->sd_name; ?></td>
                                    <td>IPD Comm.</td>
                                    <td>Expense</td>
                                    <td><?php echo $obj->payable_amount; ?></td>
                                    <td><?php echo $obj->note; ?></td>
                                </tr>
                            <?php } ?>
                        <?php } ?>

                        <!-- Surgeon Payment Transaction -->
                        <?php if (isset($surgeon_payment) && !empty($surgeon_payment)) { ?>
                            <?php foreach ($surgeon_payment as $obj) {
                                $total_expense_surgeon_payment +=  $obj->payable_amount;
                            ?>
                                <tr>
                                    <td><?php echo $sl++; ?></td>
                                    <td><?php echo $obj->custom_invoice_id; ?></td>
                                    <td><?php echo $obj->surgeon_id; ?></td>
                                    <td><?php echo $obj->surgeon_name; ?></td>
                                    <td>Surgeon</td>
                                    <td>Expense</td>
                                    <td><?php echo $obj->payable_amount; ?></td>
                                    <td><?php echo $obj->note; ?></td>
                                </tr>
                            <?php } ?>
                        <?php } ?>

                        <!-- Anesthesia Payment Transaction -->
                        <?php if (isset($anesthesia_payment) && !empty($anesthesia_payment)) { ?>
                            <?php foreach ($anesthesia_payment as $obj) {
                                $total_expense_anesthesia_payment +=  $obj->payable_amount;
                            ?>
                                <tr>
                                    <td><?php echo $sl++; ?></td>
                                    <td><?php echo $obj->custom_invoice_id; ?></td>
                                    <td><?php echo $obj->anesthesia_id; ?></td>
                                    <td><?php echo $obj->anesthesia_name; ?></td>
                                    <td>Anesthesia</td>
                                    <td>Expense</td>
                                    <td><?php echo $obj->payable_amount; ?></td>
                                    <td><?php echo $obj->note; ?></td>
                                </tr>
                            <?php } ?>
                        <?php } ?>

                        <!-- Assistant Payment Transaction -->
                        <?php if (isset($assistant_payment) && !empty($assistant_payment)) { ?>
                            <?php foreach ($assistant_payment as $obj) {
                                $total_expense_assistant_payment +=  $obj->payable_amount;
                            ?>
                                <tr>
                                    <td><?php echo $sl++; ?></td>
                                    <td><?php echo $obj->custom_invoice_id; ?></td>
                                    <td><?php echo $obj->assistant_id; ?></td>
                                    <td><?php echo $obj->assistant_name; ?></td>
                                    <td>Assistant</td>
                                    <td>Expense</td>
                                    <td><?php echo $obj->payable_amount; ?></td>
                                    <td><?php echo $obj->note; ?></td>
                                </tr>
                            <?php } ?>
                        <?php } ?>

                        <!-- Other Income Transaction -->
                        <?php if (isset($other_income) && !empty($other_income)) { ?>
                            <?php foreach ($other_income as $obj) {
                                $total_other_income +=  $obj->amount;
                            ?>
                                <tr>
                                    <td><?php echo $sl++; ?></td>
                                    <td><?php echo $obj->custom_invoice_id; ?></td>
                                    <td></td>
                                    <td><?php echo $obj->income_head; ?></td>
                                    <td>Other</td>
                                    <td>Income</td>
                                    <td><?php echo $obj->amount; ?></td>
                                    <td><?php echo $obj->note; ?></td>
                                </tr>
                            <?php } ?>
                        <?php } ?>

                        <!-- Other Expense Transaction -->
                        <?php if (isset($other_expense) && !empty($other_expense)) { ?>
                            <?php foreach ($other_expense as $obj) {
                                $total_other_expense +=  $obj->amount;
                            ?>
                                <tr>
                                    <td><?php echo $sl++; ?></td>
                                    <td><?php echo $obj->custom_invoice_id; ?></td>
                                    <td></td>
                                    <td><?php echo $obj->expense_head; ?></td>
                                    <td>Other</td>
                                    <td>Expense</td>
                                    <td><?php echo $obj->amount; ?></td>
                                    <td><?php echo $obj->note; ?></td>
                                </tr>
                            <?php } ?>
                        <?php } ?>
                    </tbody>
                </table>


                <table class="table table_content" style="width: 60%; margin: 20px auto;">
                    <thead>
                        <tr>
                            <th class="text-right font-weight-600">Total Hospital Income</th>
                            <th class="text-left font-weight-600">
                                <?php $total_grand_income = ($total_income_diagnostic_transaction + $total_income_ipd_transaction + $total_income_opd_transaction + $total_other_income); ?>
                                <?php echo number_format(($total_grand_income), 2);
                                ?>
                            </th>
                        </tr>
                        <tr>
                            <th>Total Hospital Expense</th>
                            <th>
                                <?php $total_grand_expense = ($total_expense_sd_diagnostic_payment + $total_expense_sd_ipd_payment + $total_expense_surgeon_payment + $total_expense_anesthesia_payment + $total_expense_assistant_payment + $total_other_expense); ?>
                                <?php echo number_format(($total_grand_expense), 2);
                                ?>
                            </th>
                        </tr>
                        <tr>
                            <th>Total Hospital Balance</th>
                            <th>
                                <?php echo number_format(($total_grand_income - $total_grand_expense), 2);
                                ?>
                            </th>
                        </tr>
                    </thead>
                </table>
            </div>
            <!-- Content End -->

            <!-- Footer -->
            <div class="footer">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="70%">
                                <p style="margin-left: 10%;">
                                    <b>Printed By:</b>
                                    <?php echo $this->session->userdata('name'); ?>
                                </p>
                            </td>
                            <td width="30%" align="center">
                                <p style="border-top: 1px dashed red; width: 30%; margin: 5px auto;"></p>
                                <b>Signature</b>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</body>

</html>