<!DOCTYPE html>
<html>

<head>
    <title>Payment</title>
    <style>
        body {
            font-family: monospace;
            font-size: 13px;
        }

        .page {
            width: 100%;
            margin: 0 auto;
        }

        .main_body {
            display: block;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
        }

        .info_table {
            margin-top: 20px;
        }

        .content {
            margin-top: 20px;
        }

        .table_content thead th {
            padding: 0;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
        }

        .table_content tbody td {
            padding: 0;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
            width: fit-content;
        }

        .table_content tfoot th {
            padding: 0;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
        }

        .total {
            margin-top: 20px;
        }

        .total_table tbody td {
            padding: 2px 2px;
            vertical-align: middle;
            border: 2px solid #000;
            font-size: 12px;
        }

        .footer {
            margin-top: 100px;
        }

        .text-right {
            text-align: right;
        }

        .font-weight-600 {
            font-weight: 600;
        }

        .summary {
            margin: 30px auto 0 auto;
        }

        .summary tbody th {
            padding: 2px 2px;
            vertical-align: middle;
            border: 2px solid #000;
            font-size: 13px;
        }
    </style>
</head>

<body>
    <div class="page">
        <div class="main_body">
            <table class="table" style="text-align: center;">
                <tbody>
                    <tr>
                        <td>
                            <h2 style="margin-bottom: 0; font-size: 28px;"><?php echo $this->global_setting->brand_title; ?></h2>
                        </td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->address; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->email; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->phone; ?></b></td>
                    </tr>
                </tbody>
            </table>

            <!-- Content Start-->

            <div class="info_table">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="80%" align="left">
                                <?php if ($this->input->get('reference_id')) { ?>
                                    <b>Reference:</b>
                                    <span style="font-size: 12px; margin: 0; padding: 0;">
                                        <?php echo $reference->commission; ?>, <?php echo $reference->designation; ?>
                                    </span>
                                <?php } else { ?>
                                    <b>All</b>
                                <?php } ?>
                            </td>
                            <td width="20%" align="right">
                                <b>Print Date:</b>
                                <span style="font-size: 12px;"><?php echo date('d/m/Y h:i A'); ?></span>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <!-- Content Start-->
            <div class="content">
                <style>
                    .table_content th {
                        padding: 0px 3px;
                    }
                </style>
                <table class="table table_content">
                    <thead>
                        <?php if ($invoice_type == 'all') { ?>
                            <tr>
                                <th><?php echo $this->lang->line('sl_no'); ?></th>
                                <th><?php echo $this->lang->line('type'); ?></th>
                                <th><?php echo $this->lang->line('patient_id'); ?></th>
                                <th><?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('name'); ?></th>
                                <th><?php echo $this->lang->line('payment_to'); ?></th>
                                <th><?php echo $this->lang->line('amount'); ?></th>
                                <th><?php echo $this->lang->line('payment'); ?></th>
                                <th><?php echo $this->lang->line('payment'); ?> <?php echo $this->lang->line('date'); ?></th>
                                <th><?php echo $this->lang->line('created_by'); ?></th>
                            </tr>
                        <?php } else { ?>
                            <tr>
                                <th><?php echo $this->lang->line('invoice_no'); ?></th>
                                <th><?php echo $this->lang->line('type'); ?></th>
                                <?php if ($invoice_type != 'investigation' && $payment_type != 'multiple') { ?>
                                    <th><?php echo $this->lang->line('patient_id'); ?></th>
                                    <th><?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('name'); ?></th>
                                <?php } ?>
                                <th><?php echo $this->lang->line('payment_to'); ?></th>
                                <th><?php echo $this->lang->line('amount'); ?></th>
                                <th><?php echo $this->lang->line('payment'); ?></th>
                                <th><?php echo $this->lang->line('payment'); ?> <?php echo $this->lang->line('date'); ?></th>
                                <th><?php echo $this->lang->line('created_by'); ?></th>
                            </tr>
                        <?php } ?>
                    </thead>
                    <tbody>
                        <?php $sl = 1;
                        foreach ($payments as $obj) { ?>
                            <?php if ($invoice_type == 'all') { ?>
                                <tr>
                                    <td><?php echo $sl++; ?></td>
                                    <td><?php echo $this->lang->line($obj->invoice_type); ?></td>
                                    <td><?php echo $obj->patient_unique_id; ?></td>
                                    <td><?php echo $obj->patient; ?></td>
                                    <td>
                                        <?php if ($obj->doctor) {
                                            echo $obj->doctor;
                                        } elseif ($obj->anesthetist) {
                                            echo $obj->anesthetist;
                                        } else {
                                            echo $obj->assistant;
                                        }
                                        ?>
                                    </td>
                                    <td><?php echo $obj->commission_amount; ?></td>
                                    <td><?php echo $obj->payable_amount; ?></td>
                                    <td><?php echo date('M d, Y h:iA', strtotime($obj->date)); ?></td>
                                    <td><?php echo $obj->created_by; ?></td>
                                </tr>
                            <?php } else { ?>
                                <tr>
                                    <td><?php echo $obj->custom_invoice_id; ?></td>
                                    <td><?php echo $this->lang->line($obj->invoice_type); ?></td>
                                    <?php if ($invoice_type != 'investigation' && $payment_type != 'multiple') { ?>
                                        <td><?php echo $obj->patient_unique_id; ?></td>
                                        <td><?php echo $obj->patient; ?></td>
                                    <?php } ?>
                                    <td>
                                        <?php if ($obj->doctor) {
                                            echo $obj->doctor;
                                        } elseif ($obj->anesthetist) {
                                            echo $obj->anesthetist;
                                        } else {
                                            echo $obj->assistant;
                                        }
                                        ?>
                                    </td>
                                    <?php if ($invoice_type == 'investigation' && $payment_type == 'multiple') { ?>
                                        <td><?php echo $obj->total_commission_amount; ?></td>
                                        <td><?php echo $obj->total_payable_commission; ?></td>
                                    <?php } else { ?>
                                        <td><?php echo $obj->commission_amount; ?></td>
                                        <td><?php echo $obj->payable_amount; ?></td>
                                    <?php } ?>
                                    <td><?php echo date('M d, Y h:iA', strtotime($obj->date)); ?></td>
                                    <td><?php echo $obj->created_by; ?></td>
                                </tr>
                            <?php } ?>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
            <!-- Content End -->
            <!-- Footer -->
            <div class="footer">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="70%">
                                <p style="margin-left: 10%;">
                                    <b>Prepared By:</b>
                                    <?php echo $this->session->userdata('name'); ?>
                                </p>
                            </td>
                            <td width="30%" align="center">
                                <p style="border-top: 1px dashed red; width: 30%; margin: 5px auto;"></p>
                                <b>Signature</b>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</body>

</html>