<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('permission'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('permission'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <?php $this->load->view('setting/left-side'); ?>
        <!-- col-xl-8 -->
        <div class="col-lg-9">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(EDIT, 'setting', 'custom')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-key font-30 mr-10"></i>
                            <?php echo $this->lang->line('edit'); ?> <?php echo $this->lang->line('permission'); ?>
                        </h6>
                    <?php } ?>
                    <?php if (has_permission(VIEW, 'setting', 'custom')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('setting/custom'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-list"></i>
                                <?php echo $this->lang->line('permission'); ?> <?php echo $this->lang->line('list'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>
                <?php echo form_open_multipart(site_url('setting/custom/edit/' . $permission->id), array('name' => 'edit', 'id' => 'edit', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                <div class="card-body">
                    <div class="form-row">
                        <div class="col-md-4 mb-10">
                            <label for="role_id"><?php echo $this->lang->line('role'); ?> <?php echo $this->lang->line('name'); ?> <span class="required">*</span></label>
                            <select class="form-control custom-select select2" name="role_id" id="role_id" required onchange="get_user_by_role(this.value, '', '');">
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($roles as $obj) { ?>
                                    <?php if ($this->session->userdata('role_id') != SUPER_ADMIN) { ?>
                                        <?php if (in_array($obj->id, array(SUPER_ADMIN))) {
                                            continue;
                                        } ?>
                                    <?php } ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($permission->role_id) && $permission->role_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-5 mb-10">
                            <label for="user_id"><?php echo $this->lang->line('user'); ?> <span class="required">*</span></label>
                            <select class="form-control custom-select select2" name="user_id" id="user_id" required>
                                <option value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($users as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo isset($permission->user_id) && $permission->user_id == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="permission_type"><?php echo $this->lang->line('type'); ?> <span class="required">*</span></label>
                            <select class="form-control custom-select" name="permission_type" id="permission_type" required>
                                <option value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php $permissions = get_custom_permission_type(); ?>
                                <?php foreach ($permissions as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($permission->permission_type) && $permission->permission_type == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                <?php } ?>
                            </select>
                            <small id="permission_type" class="form-text text-muted">
                                <?php echo form_error('permission_type'); ?>
                            </small>
                        </div>
                        <div class="col-md-8 mb-10">
                            <label for="note"><?php echo $this->lang->line('remark'); ?></label>
                            <input type="text" class="form-control" name="note" id="note" value="<?php echo isset($permission->note) ?  $permission->note : ''; ?>" placeholder="<?php echo $this->lang->line('remark'); ?>">
                        </div>
                        <div class="col-md-4 mb-10">
                            <div class="custom-control custom-checkbox checkbox-primary mt-40">
                                <input type="checkbox" class="custom-control-input" name="permissions_status" id="permissions_status" value="1" <?php echo $permission->permissions_status ? 'checked' : ''; ?>>
                                <label class="custom-control-label" for="permissions_status"><?php echo $this->lang->line('status'); ?></label>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <div class="card-footer pt-0">
                    <div class="button-list">
                        <input type="hidden" name="id" value="<?php echo $permission->id; ?>">
                        <a class="btn btn-gradient-danger" href="<?php echo site_url('setting/custom'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                        <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('update'); ?></button>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important;
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>

<script>
    $(".select2").select2();

    <?php if (isset($role_id)) { ?>
        get_user_by_role('<?php echo $role_id;  ?>', '<?php echo $user_id; ?>');
    <?php } ?>

    function get_user_by_role(role_id, user_id) {
        $.ajax({
            type: "POST",
            url: "<?php echo site_url('ajax/get_user_by_role'); ?>",
            data: {
                role_id: role_id,
                user_id: user_id
            },
            async: false,
            success: function(response) {
                if (response) {
                    $('#user_id').html(response);
                }
            }
        });
    }
</script>