<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('setting'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('general'); ?> <?php echo $this->lang->line('setting'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <?php $this->load->view('setting/left-side'); ?>
        <!-- col-xl-8 -->
        <div class="col-lg-9">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <h6 class="card-header d-flex align-items-center">
                        <i class="fa fa-cog font-30 mr-10"></i>
                        <?php echo $this->lang->line('general'); ?> <?php echo $this->lang->line('setting'); ?>
                    </h6>
                    <div class="align-items-center">
                        <a href="<?php echo site_url('dashboard'); ?>" class="btn btn-xs btn-primary">
                            <i class="fa fa-dashboard"></i>
                            <?php echo $this->lang->line('dashboard'); ?>
                        </a>
                    </div>
                </div>
                <?php $action = isset($setting) ? 'edit' : 'add'; ?>
                <?php echo form_open_multipart(site_url('setting/' . $action), array('name' => 'setting', 'id' => 'setting', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                <input type="hidden" value="<?php echo isset($setting) ? $setting->id : ''; ?>" name="id" />
                <div class="card-body">
                    <div class="form-row">
                        <div class="col-md-4 mb-10">
                            <label for="brand_name"><?php echo $this->lang->line('brand'); ?> <?php echo $this->lang->line('name'); ?></label>
                            <input type="text" class="form-control" name="brand_name" id="brand_name" value="<?php echo isset($setting) ?  $setting->brand_name : ''; ?>" placeholder="<?php echo $this->lang->line('brand'); ?> <?php echo $this->lang->line('name'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo form_error('brand_name'); ?>
                            </div>
                        </div>
                        <div class="col-md-5 mb-10">
                            <label for="brand_title"><?php echo $this->lang->line('brand'); ?> <?php echo $this->lang->line('title'); ?></label>
                            <input type="text" class="form-control" name="brand_title" id="brand_title" value="<?php echo isset($setting) ?  $setting->brand_title : ''; ?>" placeholder="<?php echo $this->lang->line('brand'); ?> <?php echo $this->lang->line('title'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo form_error('brand_title'); ?>
                            </div>
                        </div>

                        <div class="col-md-3 mb-10">
                            <label for="default_time_zone"><?php echo $this->lang->line('default_time_zone'); ?></label>
                            <?php $timezones = get_timezones(); ?>
                            <select class="form-control custom-select d-block w-100" name="time_zone" required>
                                <option value="">--<?php echo $this->lang->line('select'); ?>--</option>
                                <?php foreach ($timezones as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($setting) && $setting->time_zone == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?> </option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo form_error('time_zone'); ?>
                            </div>
                        </div>

                        <div class="col-md-3 mb-10">
                            <label for="date_format"><?php echo $this->lang->line('date_format'); ?></label>
                            <?php $dates = get_date_format(); ?>
                            <select class="form-control custom-select d-block w-100" name="date_format" required>
                                <option value="">--<?php echo $this->lang->line('select'); ?>--</option>
                                <?php foreach ($dates as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($setting) && $setting->date_format == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?> </option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo form_error('date_format'); ?>
                            </div>
                        </div>

                        <div class="col-md-3 mb-10">
                            <label for="time_format"><?php echo $this->lang->line('time_format'); ?></label>
                            <?php $times = get_time_format(); ?>
                            <select class="form-control custom-select d-block w-100" name="time_format" required>
                                <option value="">--<?php echo $this->lang->line('select'); ?>--</option>
                                <?php foreach ($times as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($setting) && $setting->time_format == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?> </option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo form_error('time_format'); ?>
                            </div>
                        </div>
                        
                        <div class="col-md-3 mb-10">
                            <label for="is_manager_discount"><?php echo $this->lang->line('manager'); ?> <?php echo $this->lang->line('discount'); ?></label>
                            <input min="0" type="number" class="form-control" name="is_manager_discount" id="is_manager_discount" value="<?php echo isset($setting) ?  $setting->is_manager_discount : ''; ?>" placeholder="<?php echo $this->lang->line('manager'); ?> <?php echo $this->lang->line('discount'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo form_error('is_manager_discount'); ?>
                            </div>
                        </div>
                        
                        <div class="col-md-3 mb-10">
                            <label for="is_discount"><?php echo $this->lang->line('discount'); ?></label>
                            <input type="number" class="form-control" name="is_discount" id="is_discount" value="<?php echo isset($setting) ?  $setting->is_discount : ''; ?>" placeholder="<?php echo $this->lang->line('discount'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo form_error('is_discount'); ?>
                            </div>
                        </div>

                        <div class="col-md-4 mb-10">
                            <label for="phone"><?php echo $this->lang->line('phone'); ?></label>
                            <input type="text" class="form-control" name="phone" id="phone" value="<?php echo isset($setting) ?  $setting->phone : ''; ?>" placeholder="<?php echo $this->lang->line('phone'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo form_error('phone'); ?>
                            </div>
                        </div>

                        <div class="col-md-4 mb-10">
                            <label for="email"><?php echo $this->lang->line('email'); ?></label>
                            <input type="text" class="form-control" name="email" id="email" value="<?php echo isset($setting) ?  $setting->email : ''; ?>" placeholder="<?php echo $this->lang->line('email'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo form_error('email'); ?>
                            </div>
                        </div>

                        <div class="col-md-4 mb-10">
                            <label for="fax"><?php echo $this->lang->line('fax'); ?></label>
                            <input type="text" class="form-control" name="fax" id="fax" value="<?php echo isset($setting) ?  $setting->fax : ''; ?>" placeholder="<?php echo $this->lang->line('fax'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo form_error('fax'); ?>
                            </div>
                        </div>

                        <div class="col-md-3 mb-10">
                            <label for="currency"><?php echo $this->lang->line('currency'); ?></label>
                            <input type="text" class="form-control" name="currency" id="currency" value="<?php echo isset($setting) ?  $setting->currency : ''; ?>" placeholder="<?php echo $this->lang->line('currency'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo form_error('currency'); ?>
                            </div>
                        </div>

                        <div class="col-md-3 mb-10">
                            <label for="currency_symbol"><?php echo $this->lang->line('currency_symbol'); ?></label>
                            <input type="text" class="form-control" name="currency_symbol" id="currency_symbol" value="<?php echo isset($setting) ?  $setting->currency_symbol : ''; ?>" placeholder="<?php echo $this->lang->line('currency_symbol'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo form_error('currency_symbol'); ?>
                            </div>
                        </div>

                        <div class="col-md-3 mb-10">
                            <label for="lat"><?php echo $this->lang->line('lat'); ?></label>
                            <input type="text" class="form-control" name="lat" id="lat" value="<?php echo isset($setting) ?  $setting->lat : ''; ?>" placeholder="<?php echo $this->lang->line('lat'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo form_error('lat'); ?>
                            </div>
                        </div>

                        <div class="col-md-3 mb-10">
                            <label for="lng"><?php echo $this->lang->line('lng'); ?></label>
                            <input type="text" class="form-control" name="lng" id="lng" value="<?php echo isset($setting) ?  $setting->lng : ''; ?>" placeholder="<?php echo $this->lang->line('lng'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo form_error('lng'); ?>
                            </div>
                        </div>

                        <div class="col-md-4 mb-10">
                            <label for="facebook_url"><?php echo $this->lang->line('facebook_url'); ?></label>
                            <input type="text" class="form-control" name="facebook_url" id="facebook_url" value="<?php echo isset($setting) ?  $setting->facebook_url : ''; ?>" placeholder="<?php echo $this->lang->line('facebook_url'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo form_error('facebook_url'); ?>
                            </div>
                        </div>

                        <div class="col-md-4 mb-10">
                            <label for="twitter_url"><?php echo $this->lang->line('twitter_url'); ?></label>
                            <input type="text" class="form-control" name="twitter_url" id="twitter_url" value="<?php echo isset($setting) ?  $setting->twitter_url : ''; ?>" placeholder="<?php echo $this->lang->line('twitter_url'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo form_error('twitter_url'); ?>
                            </div>
                        </div>

                        <div class="col-md-4 mb-10">
                            <label for="linkedin_url"><?php echo $this->lang->line('linkedin_url'); ?></label>
                            <input type="text" class="form-control" name="linkedin_url" id="linkedin_url" value="<?php echo isset($setting) ?  $setting->linkedin_url : ''; ?>" placeholder="<?php echo $this->lang->line('linkedin_url'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo form_error('linkedin_url'); ?>
                            </div>
                        </div>

                        <div class="col-md-4 mb-10">
                            <label for="youtube_url"><?php echo $this->lang->line('youtube_url'); ?></label>
                            <input type="text" class="form-control" name="youtube_url" id="youtube_url" value="<?php echo isset($setting) ?  $setting->youtube_url : ''; ?>" placeholder="<?php echo $this->lang->line('youtube_url'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo form_error('youtube_url'); ?>
                            </div>
                        </div>

                        <div class="col-md-4 mb-10">
                            <label for="instagram_url"><?php echo $this->lang->line('instagram_url'); ?></label>
                            <input type="text" class="form-control" name="instagram_url" id="instagram_url" value="<?php echo isset($setting) ?  $setting->instagram_url : ''; ?>" placeholder="<?php echo $this->lang->line('instagram_url'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo form_error('instagram_url'); ?>
                            </div>
                        </div>

                        <div class="col-md-4 mb-10">
                            <label for="skype"><?php echo $this->lang->line('skype'); ?></label>
                            <input type="text" class="form-control" name="skype" id="skype" value="<?php echo isset($setting) ?  $setting->skype : ''; ?>" placeholder="<?php echo $this->lang->line('skype'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo form_error('skype'); ?>
                            </div>
                        </div>

                        <div class="col-md-12 mb-10">
                            <label for="address"><?php echo $this->lang->line('address'); ?></label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('address'); ?></span>
                                </div>
                                <textarea class="form-control" name="address" id="address" aria-label="<?php echo $this->lang->line('address'); ?>"><?php echo isset($setting) ?  $setting->address : ''; ?></textarea>
                            </div>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo form_error('address'); ?>
                            </div>
                        </div>

                        <div class="col-md-8 mb-10">
                            <label for="brand_logo"><?php echo $this->lang->line('logo'); ?></label>
                            <div class="fileinput fileinput-new input-group" data-provides="fileinput">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('upload'); ?></span>
                                </div>
                                <div class="form-control text-truncate" data-trigger="fileinput"><i class="glyphicon glyphicon-file fileinput-exists"></i> <span class="fileinput-filename"></span></div>
                                <span class="input-group-append">
                                    <span class=" btn btn-primary btn-file"><span class="fileinput-new">Select file</span><span class="fileinput-exists">Change</span>
                                        <input name="brand_logo" id="brand_logo" type="file">
                                    </span>
                                    <a href="#" class="btn btn-secondary fileinput-exists" data-dismiss="fileinput">Remove</a>
                                </span>
                            </div>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo form_error('brand_logo'); ?>
                            </div>
                        </div>

                        <div class="col-md-4 mb-10">
                            <?php if (isset($setting) && $setting->brand_logo) { ?>
                                <div class="avatar mr-10 mt-10 ml-10">
                                    <input name="brand_logo_prev" value="<?php echo isset($setting) ? $setting->brand_logo : ''; ?>" type="hidden">
                                    <img class="avatar-img rounded" src="<?php echo UPLOAD_PATH; ?>logo/<?php echo $setting->brand_logo; ?>" alt="" />
                                </div>
                            <?php } else { ?>
                                <div class="avatar mr-10 mt-10 ml-10">
                                    <img class="avatar-img rounded" src="<?php echo IMG_URL; ?>logo.png" alt="user">
                                </div>
                            <?php } ?>
                        </div>


                        <div class="col-md-8 mb-10">
                            <label for="favicon"><?php echo $this->lang->line('favicon'); ?></label>
                            <div class="fileinput fileinput-new input-group" data-provides="fileinput">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('upload'); ?></span>
                                </div>
                                <div class="form-control text-truncate" data-trigger="fileinput"><i class="glyphicon glyphicon-file fileinput-exists"></i> <span class="fileinput-filename"></span></div>
                                <span class="input-group-append">
                                    <span class=" btn btn-primary btn-file"><span class="fileinput-new">Select file</span><span class="fileinput-exists">Change</span>
                                        <input name="favicon" id="favicon" type="file">
                                    </span>
                                    <a href="#" class="btn btn-secondary fileinput-exists" data-dismiss="fileinput">Remove</a>
                                </span>
                            </div>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo form_error('favicon'); ?>
                            </div>
                        </div>

                        <div class="col-md-4 mb-10">
                            <?php if (isset($setting) && $setting->favicon) { ?>
                                <div class="avatar mr-10 mt-10 ml-10">
                                    <input name="favicon_prev" value="<?php echo isset($setting) ? $setting->favicon : ''; ?>" type="hidden">
                                    <img class="avatar-img rounded" src="<?php echo UPLOAD_PATH; ?>icon/<?php echo $setting->favicon; ?>" alt="" />
                                </div>
                            <?php } else { ?>
                                <div class="avatar mr-10 mt-10 ml-10">
                                    <img class="avatar-img rounded" src="<?php echo IMG_URL; ?>logo.png" alt="user">
                                </div>
                            <?php } ?>
                        </div>

                        <div class="col-md-12 mb-10">
                            <label for="brand_footer"><?php echo $this->lang->line('brand_footer'); ?></label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('brand'); ?> <?php echo $this->lang->line('footer'); ?></span>
                                </div>
                                <textarea class="form-control" name="brand_footer" id="brand_footer" aria-label="<?php echo $this->lang->line('brand'); ?> <?php echo $this->lang->line('footer'); ?>"><?php echo isset($setting) ?  $setting->brand_footer : ''; ?></textarea>
                            </div>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo form_error('brand_footer'); ?>
                            </div>
                        </div>
                        
                        <div class="col-md-8 mb-10">
                            <label for="video_thumbnail"><?php echo $this->lang->line('video'); ?> <?php echo $this->lang->line('thumbnail'); ?></label>
                            <div class="fileinput fileinput-new input-group" data-provides="fileinput">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('upload'); ?></span>
                                </div>
                                <div class="form-control text-truncate" data-trigger="fileinput"><i class="glyphicon glyphicon-file fileinput-exists"></i> <span class="fileinput-filename"></span></div>
                                <span class="input-group-append">
                                    <span class=" btn btn-primary btn-file"><span class="fileinput-new">Select file</span><span class="fileinput-exists">Change</span>
                                        <input name="video_thumbnail" id="video_thumbnail" type="file">
                                    </span>
                                    <a href="#" class="btn btn-secondary fileinput-exists" data-dismiss="fileinput">Remove</a>
                                </span>
                            </div>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo form_error('favicon'); ?>
                            </div>
                        </div>
                        <div class="col-md-4 mb-10">
                            <?php if (isset($setting) && $setting->video_thumbnail) { ?>
                                <div class="avatar mr-10 mt-10 ml-10">
                                    <input name="video_thumbnail_prev" value="<?php echo isset($setting) ? $setting->video_thumbnail : ''; ?>" type="hidden">
                                    <img class="avatar-img rounded" src="<?php echo UPLOAD_PATH; ?>logo/<?php echo $setting->video_thumbnail; ?>" alt="" />
                                </div>
                            <?php } ?>
                        </div>

                        <div class="col-md-12 mb-10">
                            <label for="video_url"><?php echo $this->lang->line('video'); ?> <?php echo $this->lang->line('url'); ?></label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('video'); ?> <?php echo $this->lang->line('url'); ?></span>
                                </div>
                                <textarea class="form-control" name="video_url" id="video_url" aria-label="<?php echo $this->lang->line('video'); ?> <?php echo $this->lang->line('url'); ?>"><?php echo isset($setting) ?  $setting->video_url : ''; ?></textarea>
                            </div>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo form_error('video_url'); ?>
                            </div>
                        </div>
                        
                        <div class="col-md-12 mb-10">
                            <label for="map"><?php echo $this->lang->line('map'); ?></label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('map'); ?></span>
                                </div>
                                <textarea class="form-control" name="map" id="map" aria-label="<?php echo $this->lang->line('map'); ?>"><?php echo isset($setting) ?  $setting->map : ''; ?></textarea>
                            </div>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo form_error('map'); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <div class="card-footer pt-0">
                    <div class="button-list">
                        <a class="btn btn-gradient-danger" href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                        <button class="btn btn-gradient-primary" type="submit"><?php echo $action == 'add' ? $this->lang->line('submit') : $this->lang->line('update'); ?></button>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->