<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('operation'); ?> <?php echo $this->lang->line('setting'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage_operation'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <?php $this->load->view('setting/left-side'); ?>
        <!-- col-xl-8 -->
        <div class="col-lg-9">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(ADD, 'setting', 'operation')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-opera font-30 mr-10"></i>
                            <?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('operation'); ?>
                        </h6>
                    <?php } ?>
                    <?php if (has_permission(VIEW, 'setting', 'operation')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('setting/operation'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-list"></i>
                                <?php echo $this->lang->line('operation'); ?> <?php echo $this->lang->line('list'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>

                <?php echo form_open_multipart(site_url('setting/operation/add'), array('name' => 'add', 'id' => 'add', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                <div class="card-body">
                    <div class="form-row">
                        <div class="col-md-4 mb-10">
                            <label for="module_name"><?php echo $this->lang->line('module'); ?> <?php echo $this->lang->line('name'); ?></label>
                            <select class="form-control custom-select" name="module_id" id="module_id" required>
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($modules as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($module_id) && $module_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->module_name; ?></option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo form_error('module_name'); ?>
                            </div>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="operation_name"><?php echo $this->lang->line('operation'); ?> <?php echo $this->lang->line('name'); ?></label>
                            <input type="text" class="form-control" name="operation_name" id="operation_name" value="<?php echo isset($operation_name) ?  $operation_name : ''; ?>" placeholder="<?php echo $this->lang->line('operation'); ?> <?php echo $this->lang->line('name'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo form_error('operation_name'); ?>
                            </div>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="operation_slug"><?php echo $this->lang->line('operation'); ?> <?php echo $this->lang->line('slug'); ?></label>
                            <input type="text" class="form-control" name="operation_slug" id="operation_slug" value="<?php echo isset($operation_slug) ?  $operation_slug : ''; ?>" placeholder="<?php echo $this->lang->line('operation'); ?> <?php echo $this->lang->line('slug'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo form_error('operation_slug'); ?>
                            </div>
                        </div>
                        <div class="col-md-3 mt-10">
                            <div class="custom-control custom-checkbox checkbox-primary">
                                <input type="checkbox" class="custom-control-input" name="is_view_vissible" id="is_view_vissible" value="1" checked>
                                <label class="custom-control-label" for="is_view_vissible"><?php echo $this->lang->line('is_view_vissible'); ?></label>
                            </div>
                        </div>
                        <div class="col-md-3 mt-10">
                            <div class="custom-control custom-checkbox checkbox-teal">
                                <input type="checkbox" class="custom-control-input" name="is_add_vissible" id="is_add_vissible" value="1" checked>
                                <label class="custom-control-label" for="is_add_vissible"><?php echo $this->lang->line('is_add_vissible'); ?></label>
                            </div>
                        </div>
                        <div class="col-md-3 mt-10">
                            <div class="custom-control custom-checkbox checkbox-cyan">
                                <input type="checkbox" class="custom-control-input" name="is_edit_vissible" id="is_edit_vissible" value="1" checked>
                                <label class="custom-control-label" for="is_edit_vissible"><?php echo $this->lang->line('is_edit_vissible'); ?></label>
                            </div>
                        </div>
                        <div class="col-md-3 mt-10">
                            <div class="custom-control custom-checkbox checkbox-pink">
                                <input type="checkbox" class="custom-control-input" name="is_delete_vissible" id="is_delete_vissible" value="1" checked>
                                <label class="custom-control-label" for="is_delete_vissible"><?php echo $this->lang->line('is_delete_vissible'); ?></label>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <div class="card-footer pt-0">
                    <div class="button-list">
                        <a class="btn btn-gradient-danger" href="<?php echo site_url('setting/operation'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                        <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('submit'); ?></button>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->